<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Typography settings.
 *
 * @return array
 */

$category = _x('Typography', 'Admin - Theme Options', 'uicore-framework');
$slug = 'typography';

return [
    self::add_typography([
        'id'    => 23,
        'index' => 'h1',
        'adv'   => false,
        'name'  => _x('H1', 'Admin - Theme Options', 'uicore-framework'),
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '72', 'unit' => 'px'],
                't' => ['value' => '60', 'unit' => 'px'],
                'm' => ['value' => '40', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.2', 'unit' => 'em'],
                't' => ['value' => '1.2', 'unit' => 'em'],
                'm' => ['value' => '1.2', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't'  => 'None',
            'st' => '600',
            'c'  => 'Headline',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'category' => $category,
        'category_slug' => $slug,
        'desc'  => _x('Set Heading 1 options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags'  => _x('h1 H1', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 24,
        'index' => 'h2',
        'adv' => false,
        'name' => _x('H2', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'f' => 'Secondary',
            's' => [
                'd' => ['value' => '48', 'unit' => 'px'],
                't' => ['value' => '34', 'unit' => 'px'],
                'm' => ['value' => '26', 'unit' => 'px'],
            ],
            'h' => [
                'd'=> ['value' => '1.175', 'unit' => 'em'],
                't' => ['value' => '1.175', 'unit' => 'em'],
                'm' => ['value' => '1.175', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '700',
            'c' => 'Headline',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'desc' => _x('Set Heading 2 options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('h2 H2', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 25,
        'index' => 'h3',
        'adv' => false,
        'name' => _x('H3', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '24', 'unit' => 'px'],
                't' => ['value' => '21', 'unit' => 'px'],
                'm' => ['value' => '20', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.2', 'unit' => 'em'],
                't' => ['value' => '1.2', 'unit' => 'em'],
                'm' => ['value' => '1.2', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'desc' => _x('Set Heading 3 options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('h3 H3', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 26,
        'index' => 'h4',
        'adv' => false,
        'name' => _x('H4', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '21', 'unit' => 'px'],
                't' => ['value' => '18', 'unit' => 'px'],
                'm' => ['value' => '16', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.42', 'unit' => 'em'],
                't' => ['value' => '1.42', 'unit' => 'em'],
                'm' => ['value' => '1.42', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'desc' => _x('Set Heading 4 options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('h4 H4', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 27,
        'index' => 'h5',
        'adv' => false,
        'name' => _x('H5', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '16', 'unit' => 'px'],
                't' => ['value' => '15', 'unit' => 'px'],
                'm' => ['value' => '14', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.187', 'unit' => 'em'],
                't' => ['value' => '1.187', 'unit' => 'em'],
                'm' => ['value' => '1.187', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.015', 'unit' => 'em'],
                't' => ['value' => '-0.015', 'unit' => 'em'],
                'm' => ['value' => '-0.015', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Accent',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'desc' => _x('Set Heading 5 options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('h5 H5', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 28,
        'index' => 'h6',
        'adv' => false,
        'name' => _x('H6', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '14', 'unit' => 'px'],
                't' => ['value' => '13', 'unit' => 'px'],
                'm' => ['value' => '12', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.2', 'unit' => 'em'],
                't' => ['value' => '1.2', 'unit' => 'em'],
                'm' => ['value' => '1.2', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't' => 'Uppercase',
            'st' => '600',
            'c' => 'Headline',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'desc' => _x('Set Heading 6 options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('h6 H6', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 29,
        'index' => 'p',
        'adv' => false,
        'name' => _x('Body', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'f' => 'Text',
            's' => [
                'd' => ['value' => '16', 'unit' => 'px'],
                't' => ['value' => '15', 'unit' => 'px'],
                'm' => ['value' => '14', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.875', 'unit' => 'em'],
                't' => ['value' => '1.875', 'unit' => 'em'],
                'm' => ['value' => '1.875', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '0', 'unit' => 'em'],
                't' => ['value' => '0', 'unit' => 'em'],
                'm' => ['value' => '0', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => 'regular',
            'c' => 'Body',
        ],
        'module' => 'frontend',
        'hover'  => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color'  => true,
        'desc' => _x('Set <body> and <p> options.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('body paragraph', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_color2([
        'id' => 326,
        'adv' => true,
        'index' => 'link_color',
        'name' => _x('Links Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the global links color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $slug,
        'default' => [
            'm' => 'Primary',
			'h' => 'Secondary',
        ],
        'module' => 'frontend',
        'responsive' => true,
        'tags' => _x('link color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
];