jQuery(function($) {

    let
        $discounts_list = $('#bookly-discounts'),
        $check_all_button = $('#bookly-check-all'),
        $delete_button = $('#bookly-delete'),
        columns = [],
        order = []
    ;

    /**
     * Init table columns.
     */
    $.each(BooklyDiscountsL10n.datatables.discounts.settings.columns, function(column, show) {
        if (show) {
            switch (column) {
                case 'enabled' :
                    columns.push({
                        data: column,
                        render: function(data, type, row, meta) {
                            return '<span class="badge ' + (row.enabled == 1 ? 'badge-success' : 'badge-info') + '">' + BooklyDiscountsL10n.state[data] + '</span>';
                        }
                    });
                    break;
                case 'date_start':
                    columns.push({
                        data: column,
                        render: function(data, type, row, meta) {
                            return row.date_start_formatted;
                        }
                    });
                    break;
                case 'date_end':
                    columns.push({
                        data: column,
                        render: function(data, type, row, meta) {
                            return row.date_end_formatted;
                        }
                    });
                    break;
                case 'services':
                    columns.push({
                        data: column,
                        render: function(data, type, row, meta) {
                            if (row.type !== 'nop') {
                                return '';
                            } else if (data == 0) {
                                return BooklyDiscountsL10n.services.nothingSelected;
                            } else if (data == 1) {
                                return $.fn.dataTable.render.text().display(BooklyDiscountsL10n.services.collection[row.service_id].title);
                            } else {
                                if (data == BooklyDiscountsL10n.services.count) {
                                    return BooklyDiscountsL10n.services.allSelected;
                                } else {
                                    return data + '/' + BooklyDiscountsL10n.services.count;
                                }
                            }
                        }
                    });
                    break;
                default:
                    columns.push({data: column, render: $.fn.dataTable.render.text()});
                    break;
            }
        }
    });
    columns.push({
        data: null,
        responsivePriority: 1,
        orderable: false,
        className: "text-right",
        render: function(data, type, row, meta) {
            return '<button type="button" class="btn btn-default"><i class="far fa-fw fa-edit mr-lg-1"></i><span class="d-none d-lg-inline">' + BooklyDiscountsL10n.edit + '…</span></button>';
        }
    });
    columns.push({
        data: null,
        responsivePriority: 1,
        orderable: false,
        render: function(data, type, row, meta) {
            return '<div class="custom-control custom-checkbox">' +
                '<input value="' + row.id + '" id="bookly-dt-' + row.id + '" type="checkbox" class="custom-control-input">' +
                '<label for="bookly-dt-' + row.id + '" class="custom-control-label"></label>' +
                '</div>';
        }
    });

    columns[0].responsivePriority = 0;

    $.each(BooklyDiscountsL10n.datatables.discounts.settings.order, function(_, value) {
        const index = columns.findIndex(function(c) {
            return c.data === value.column;
        });
        if (index !== -1) {
            order.push([index, value.order]);
        }
    });

    /**
     * Init DataTables.
     */
    var dt = $discounts_list.DataTable({
        paging: false,
        info: false,
        searching: false,
        processing: true,
        responsive: true,
        ajax: {
            url: ajaxurl,
            data: {action: 'bookly_discounts_get_discounts', csrf_token: BooklyDiscountsL10n.csrfToken}
        },
        order: order,
        columns: columns,
        language: {
            zeroRecords: BooklyDiscountsL10n.zeroRecords,
            processing: BooklyDiscountsL10n.processing,
            emptyTable: BooklyDiscountsL10n.emptyTable,
            loadingRecords: BooklyDiscountsL10n.loadingRecords
        },
        layout: {
            bottomStart: 'paging',
            bottomEnd: null
        }
    });

    /**
     * Save order.
     */
    dt.on('order', function() {
        let order = [];
        dt.order().forEach(function(data) {
            order.push({
                column: columns[data[0]].data,
                order: data[1]
            });
        });
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'bookly_update_table_order',
                table: 'discounts',
                csrf_token: BooklyDiscountsL10n.csrfToken,
                order: order
            },
            dataType: 'json'
        });
    });

    /**
     * Select all discounts.
     */
    $check_all_button.on('change', function() {
        $discounts_list.find('tbody input:checkbox').prop('checked', this.checked);
    });

    /**
     * On discount select.
     */
    $discounts_list.on('change', 'tbody input:checkbox', function() {
        $check_all_button.prop('checked', $discounts_list.find('tbody input:not(:checked)').length == 0);
    });

    /**
     * Delete discounts.
     */
    $delete_button.on('click', function() {
        if (confirm(BooklyDiscountsL10n.are_you_sure)) {
            var ladda = Ladda.create(this),
                data = [],
                $checkboxes = $('tbody input:checked', $discounts_list);
            ladda.start();

            $checkboxes.each(function() {
                data.push(this.value);
            });

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'bookly_discounts_delete_discounts',
                    csrf_token: BooklyDiscountsL10n.csrfToken,
                    discounts: data
                },
                dataType: 'json',
                success: function(response) {
                    ladda.stop();
                    if (response.success) {
                        dt.rows($checkboxes.closest('td')).remove().draw();
                    } else {
                        alert(response.data.message);
                    }
                }
            });
        }
    });
});