<?php
namespace BooklyFiles\Backend\Components\Dialogs\Customer;

use Bookly\Lib as BooklyLib;
use BooklyFiles\Lib\Entities;

class Ajax extends BooklyLib\Base\Ajax
{
    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array( '_default' => 'supervisor' );
    }

    /**
     * Disconnect file from Customer.
     */
    public static function deleteCustomerInformationField()
    {
        $slug = self::parameter( 'slug' );
        $request = self::getRequest();
        if ( $request->has( 'customer_id' ) && BooklyLib\Utils\Common::isCurrentUserCustomer() ) {
            $customer_id = self::parameter( 'customer_id' );
        } else {
            $customer_id = BooklyLib\Entities\Customer::query()
                ->where( 'wp_user_id', get_current_user_id() )
                ->fetchVar( 'id' );
        }

        $file = new Entities\Files();
        if ( $file->loadBy( compact( 'slug' ) ) ) {
            $file->deleteWithFile();
            if ( $customer_id ) {
                $customer = BooklyLib\Entities\Customer::find( $customer_id );
                $info_fields = json_decode( $customer->getInfoFields(), true );
                foreach ( $info_fields as &$field ) {
                    if ( isset( $field['value'] ) && $field['value'] === $slug ) {
                        $field['value'] = '';
                        break;
                    }
                }

                $customer->setInfoFields( json_encode( $info_fields ) )->save();
            }
        }
        wp_send_json_success();
    }
}