<?php
namespace BooklyFiles\Lib\Entities\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\Entities\Proxy;
use BooklyFiles\Lib;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function postDeleteCustomer( BooklyLib\Entities\Customer $customer )
    {
        if ( $customer->getInfoFields() != '[]' ) {
            $fields = json_decode( $customer->getInfoFields(), true );
            $fields_with_file = Lib\ProxyProviders\Local::getCIIds();
            foreach ( $fields as $field ) {
                if ( in_array( $field['id'], $fields_with_file ) ) {
                    $file = new Lib\Entities\Files();
                    if ( $field['value'] && $file->loadBy( array( 'slug' => $field['value'] ) ) ) {
                        $file->deleteWithFile();
                    }
                }
            }
        }
    }
}