<?php
namespace BooklyGroupBooking\Lib;

use Bookly\Lib as BooklyLib;

class Updater extends BooklyLib\Base\Updater
{
    public function update_3_2()
    {
        $new_pc_key = 'bookly_group_booking_purchase_code';
        $old_pc_key = 'bookly_group_booking_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_1_5()
    {
        delete_option( 'bookly_group_booking_enabled' );
    }

    public function update_1_1()
    {
        add_option( 'bookly_group_booking_app_show_nop', '0' );
        add_option( 'bookly_group_booking_nop_format', 'busy' );
    }
}