<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly
use Bookly\Lib as BooklyLib;

$action = admin_url( 'admin-ajax.php?action=bookly_invoices_download_invoices&csrf_token=' . BooklyLib\Utils\Common::getCsrfToken() );
?>
<div id="bookly-download-invoices" class="bookly-dropdown bookly-dropup mr-2" data-action="<?php echo esc_attr( $action ); ?>">
    <button class="bookly-js-product-price-dropdown btn btn-default bookly-dropdown-toggle align-items-center" type="button" data-toggle="bookly-dropdown">
        <i class="far fa-fw fa-file-pdf mr-lg-1"></i> <span class="d-none d-lg-inline"><?php esc_html_e( 'Download invoices', 'bookly' ); ?></span>
    </button>
    <ul class="bookly-dropdown-menu bookly-dropdown-menu-compact bookly-dropdown-menu-right shadow overflow-hidden">
        <li class="bookly-dropdown-item bookly-js-download-selected-invoices">
            <span><?php esc_html_e( 'Download selected invoices', 'bookly' ); ?></span>
        </li>
        <li class="bookly-dropdown-item bookly-js-download-all-invoices">
            <span><?php esc_html_e( 'Download filtered invoices', 'bookly' ); ?></span>
        </li>
    </ul>
</div>