<?php
namespace BooklyLocations\Backend\Components\Dialogs\Staff\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Backend\Components\Dialogs\Staff\Proxy;
use BooklyLocations\Lib\Entities;

class Shared extends Proxy\Shared
{
    /**
     * @inheriDoc
     */
    public static function duplicateStaff( $original_staff_id, $new_staff )
    {
        /** @var Entities\StaffLocation[] $staff_locations */
        $staff_locations = Entities\StaffLocation::query()
            ->where( 'staff_id', $original_staff_id )
            ->find();

        foreach ( $staff_locations as $staff_location ) {
            $new_staff_location = new Entities\StaffLocation();
            $new_staff_location
                ->setStaffId( $new_staff->getId() )
                ->setLocationId( $staff_location->getLocationId() )
                ->setCustomServices( $staff_location->getCustomServices() )
                ->setCustomSchedule( $staff_location->getCustomSchedule() )
                ->setCustomSpecialDays( $staff_location->getCustomSpecialDays() )
                ->save();
        }

        return $original_staff_id;
    }
}