<?php
namespace BooklyServiceSchedule\Lib\ProxyProviders;

use Bookly\Lib as BooklyLib;
use BooklyServiceSchedule\Lib;
use BooklyServiceSchedule\Backend\Modules\Services\ProxyProviders\Shared;

abstract class Local extends BooklyLib\Proxy\ServiceSchedule
{
    /**
     * @inheritDoc
     */
    public static function getSchedule( $service_id )
    {
        $schedule = Lib\Entities\ServiceScheduleDay::query( 'sd' )
            ->select( 'sd.start_time, sd.end_time, sd.day_index,
                sb.start_time AS break_start,
                sb.end_time AS break_end' )
            ->leftJoin( 'ServiceScheduleBreak', 'sb', 'sb.service_schedule_day_id = sd.id', 'BooklyServiceSchedule\Lib\Entities' )
            ->where( 'sd.service_id', $service_id )
            ->whereNot( 'sd.start_time', null )
            ->fetchArray();

        if ( $schedule || Lib\Entities\ServiceScheduleDay::query()->where( 'service_id', $service_id )->count() ) {
            return $schedule;
        }

        Shared::serviceCreated( BooklyLib\Entities\Service::find( $service_id ) );

        return self::getSchedule( $service_id );
    }

    /**
     * @inheritDoc
     */
    public static function getWeeklySchedule( array $service_ids )
    {
        $weekly_schedule = array();
        $res = Lib\Entities\ServiceScheduleDay::query()
            ->select( 'r.day_index, MIN(r.start_time) AS min_time, MAX(r.end_time) AS max_time' )
            ->whereIn( 'r.service_id', $service_ids )
            ->whereNot( 'r.start_time', null )
            ->groupBy( 'day_index' )
            ->fetchArray();

        foreach ( $res as $row ) {
            $weekly_schedule[ $row['day_index'] ] = array(
                'start_time' => BooklyLib\Slots\TimePoint::fromStr( $row['min_time'] ),
                'end_time' => BooklyLib\Slots\TimePoint::fromStr( $row['max_time'] ),
            );
        }

        return $weekly_schedule;
    }
}