<?php
namespace BooklyStaffCabinet\Frontend\Modules\Appointments;

use Bookly\Lib as BooklyLib;
use BooklyStaffCabinet\Lib;
use BooklyStaffCabinet\Frontend\Components as FrontendComponents;
use Bookly\Backend\Modules\Appointments\Proxy;

class ShortCode extends BooklyLib\Base\ShortCode
{
    public static $code = 'bookly-staff-appointments';

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        self::enqueueStyles( array(
            'alias' => array( 'bookly-backend-globals', ),
        ) );
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        // Disable emoji in IE11
        if ( array_key_exists( 'HTTP_USER_AGENT', $_SERVER ) && strpos( $_SERVER['HTTP_USER_AGENT'], 'Trident/7.0' ) !== false ) {
            BooklyLib\Utils\Common::disableEmoji();
        }

        self::enqueueScripts( array(
            'bookly' => array( 'frontend/resources/js/intlTelInput.min.js' => array( 'bookly-backend-globals' ) ),
            'module' => array( 'js/staff-cabinet-appointments.js' => array( 'bookly-intlTelInput.min.js' ) ),
        ) );
        $datatables = BooklyLib\Utils\Tables::getSettings( BooklyLib\Utils\Tables::APPOINTMENTS );
        if ( isset( $datatables[ BooklyLib\Utils\Tables::APPOINTMENTS ]['settings']['filter'] ) ) {
            unset( $datatables[ BooklyLib\Utils\Tables::APPOINTMENTS ]['settings']['filter']['staff'], $datatables[ BooklyLib\Utils\Tables::APPOINTMENTS ]['settings']['filter']['customer'] );
        }

        wp_localize_script( 'bookly-staff-cabinet-appointments.js', 'BooklySCAppointmentsL10n',
            array(
                'datePicker' => BooklyLib\Utils\DateTime::datePickerOptions(),
                'dateRange' => BooklyLib\Utils\DateTime::dateRangeOptions( array( 'anyTime' => __( 'Any time', 'bookly' ), 'createdAtAnyTime' => __( 'Created at any time', 'bookly' ), ) ),
                'are_you_sure' => __( 'Are you sure?', 'bookly' ),
                'zeroRecords' => __( 'No appointments for selected period.', 'bookly' ),
                'processing' => __( 'Processing', 'bookly' ) . '…',
                'emptyTable' => __( 'No data available in table', 'bookly' ),
                'loadingRecords' => __( 'Loading...', 'bookly' ),
                'edit' => __( 'Edit', 'bookly' ),
                'no_result_found' => __( 'No results found', 'bookly' ),
                'searching' => __( 'Searching', 'bookly' ),
                'attachments' => __( 'Attachments', 'bookly' ),
                'tasks' => array(
                    'enabled' => BooklyLib\Config::tasksActive(),
                    'title' => Proxy\Tasks::getFilterText(),
                ),
                'datatables' => $datatables,
            )
        );
    }

    /**
     * Render Appointments shortcode.
     *
     * @param array $attributes
     * @return string
     */
    public static function render( $attributes )
    {
        // Disable caching.
        BooklyLib\Utils\Common::noCache();

        if ( is_user_logged_in() && $staff = BooklyLib\Entities\Staff::query()->select( 'id, visibility' )->where( 'wp_user_id', get_current_user_id() )->fetchRow() ) {
            \BooklyPro\Backend\Components\License\Components::renderLicenseNotice( false );
            if ( $staff['visibility'] == 'archive' ) {
                return FrontendComponents\Notice\Permission::generateAccountDisabled();
            }
            $datatables = BooklyLib\Utils\Tables::getSettings( BooklyLib\Utils\Tables::APPOINTMENTS );
            $services = BooklyLib\Entities\Service::query( 's' )->select( 's.id, s.title' )->where( 'type', BooklyLib\Entities\Service::TYPE_SIMPLE )->fetchArray();
            $customers = BooklyLib\Entities\Customer::query()->count() < BooklyLib\Entities\Customer::REMOTE_LIMIT
                ? array_map( function( $row ) {
                    unset( $row['id'] );

                    return $row;
                }, BooklyLib\Entities\Customer::query( 'c' )->select( 'c.id, c.full_name, c.email, c.phone' )->indexBy( 'id' )->fetchArray() )
                : false;
            $hide = array_key_exists( 'hide', $attributes )
                ? explode( ',', $attributes['hide'] )
                : array();

            return \BooklyPro\Lib\Config::graceExpired()
                ? null
                : self::renderTemplate( 'short_code', array(
                    'wrapper' => uniqid( 'appointments-' ),
                    'datatables' => $datatables,
                    'services' => $services,
                    'customers' => $customers,
                    'hide' => $hide,
                    'read_only' => (bool) ( array_key_exists( 'read-only', (array) $attributes ) ? $attributes['read-only'] : false ),
                ), false );
        }

        return FrontendComponents\Notice\Permission::generate();
    }
}