<?php
namespace BooklyStripe\Lib;

class Updater extends \Bookly\Lib\Base\Updater
{
    public function update_4_8()
    {
        $new_pc_key = 'bookly_stripe_purchase_code';
        $old_pc_key = 'bookly_stripe_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_1_7()
    {
        add_option( 'bookly_stripe_timeout', '0' );
        foreach ( get_users( 'role=administrator' ) as $user ) {
            add_user_meta( $user->ID, 'bookly_show_stripe_sca_update_notice', '1' );
        }
    }

    public function update_1_1()
    {
        add_option( 'bookly_stripe_increase', '0' );
        add_option( 'bookly_stripe_addition', '0' );
    }
}