<?php
namespace Creativemasking\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class BWDMEmasking extends Widget_Base {

	public function get_name() {
		return esc_html__( 'NameMaskingEffects', 'bwd-masking-effects' );
	}

	public function get_title() {
		return esc_html__( 'BWD Masking Effects', 'elementor' );
	}

	public function get_icon() {
		return 'bwdme-masking-icon eicon-theme-style';
	}

	public function get_categories() {
		return [ 'bwd-masking-effects-category' ];
	}

	public function get_script_depends() {
		return [ 'bwd-masking-effects-category' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'bwdme_masking_content_section',
			[
				'label' => esc_html__( 'Masking Content', 'bwd-masking-effects' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'bwdme_style_selection',
			[
				'label' => esc_html__( 'Masking Styles', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'bwdme-masking1',
				'options' => [
					'bwdme-masking1' => esc_html__( 'Style 1', 'bwd-masking-effects' ),
					'bwdme-masking2' => esc_html__( 'Style 2', 'bwd-masking-effects' ),
					'bwdme-masking3' => esc_html__( 'Style 3', 'bwd-masking-effects' ),
					'bwdme-masking4' => esc_html__( 'Style 4', 'bwd-masking-effects' ),
					'bwdme-masking5' => esc_html__( 'Style 5', 'bwd-masking-effects' ),
					'bwdme-masking6' => esc_html__( 'Style 6', 'bwd-masking-effects' ),
					'bwdme-masking7' => esc_html__( 'Style 7', 'bwd-masking-effects' ),
					'bwdme-masking8' => esc_html__( 'Style 8', 'bwd-masking-effects' ),
					'bwdme-masking9' => esc_html__( 'Style 9', 'bwd-masking-effects' ),
					'bwdme-masking10' => esc_html__( 'Style 10', 'bwd-masking-effects' ),
					'bwdme-masking11' => esc_html__( 'Style 11', 'bwd-masking-effects' ),
					'bwdme-masking12' => esc_html__( 'Style 12', 'bwd-masking-effects' ),
					'bwdme-masking13' => esc_html__( 'Style 13', 'bwd-masking-effects' ),
					'bwdme-masking14' => esc_html__( 'Style 14', 'bwd-masking-effects' ),
					'bwdme-masking15' => esc_html__( 'Style 15', 'bwd-masking-effects' ),
					'bwdme-masking16' => esc_html__( 'Style 16', 'bwd-masking-effects' ),
					'bwdme-masking17' => esc_html__( 'Style 17', 'bwd-masking-effects' ),
					'bwdme-masking18' => esc_html__( 'Style 18', 'bwd-masking-effects' ),
					'bwdme-masking19' => esc_html__( 'Style 19', 'bwd-masking-effects' ),
					'bwdme-masking20' => esc_html__( 'Style 20', 'bwd-masking-effects' ),
					'bwdme-masking21' => esc_html__( 'Style 21', 'bwd-masking-effects' ),
					'bwdme-masking22' => esc_html__( 'Style 22', 'bwd-masking-effects' ),
					'bwdme-masking23' => esc_html__( 'Style 23', 'bwd-masking-effects' ),
					'bwdme-masking24' => esc_html__( 'Style 24', 'bwd-masking-effects' ),
					'bwdme-masking25' => esc_html__( 'Style 25', 'bwd-masking-effects' ),
					'bwdme-masking26' => esc_html__( 'Style 26', 'bwd-masking-effects' ),
					'bwdme-masking27' => esc_html__( 'Style 27', 'bwd-masking-effects' ),
					'bwdme-masking28' => esc_html__( 'Style 28', 'bwd-masking-effects' ),
					'bwdme-masking29' => esc_html__( 'Style 29', 'bwd-masking-effects' ),
					'bwdme-masking30' => esc_html__( 'Style 30', 'bwd-masking-effects' ),
					'bwdme-masking31' => esc_html__( 'Style 31', 'bwd-masking-effects' ),
					'bwdme-masking32' => esc_html__( 'Style 32', 'bwd-masking-effects' ),
					'bwdme-masking33' => esc_html__( 'Style 33', 'bwd-masking-effects' ),
					'bwdme-masking34' => esc_html__( 'Style 34', 'bwd-masking-effects' ),
					'bwdme-masking35' => esc_html__( 'Style 35', 'bwd-masking-effects' ),
					'bwdme-masking36' => esc_html__( 'Style 36', 'bwd-masking-effects' ),
					'bwdme-masking37' => esc_html__( 'Style 37', 'bwd-masking-effects' ),
					'bwdme-masking38' => esc_html__( 'Style 38', 'bwd-masking-effects' ),
					'bwdme-masking39' => esc_html__( 'Style 39', 'bwd-masking-effects' ),
					'bwdme-masking40' => esc_html__( 'Style 40', 'bwd-masking-effects' ),
					'bwdme-masking41' => esc_html__( 'Style 41', 'bwd-masking-effects' ),
					'bwdme-masking42' => esc_html__( 'Style 42', 'bwd-masking-effects' ),
					'bwdme-masking43' => esc_html__( 'Style 43', 'bwd-masking-effects' ),
					'bwdme-masking44' => esc_html__( 'Style 44', 'bwd-masking-effects' ),
					'bwdme-masking45' => esc_html__( 'Style 45', 'bwd-masking-effects' ),
					'bwdme-masking46' => esc_html__( 'Style 46', 'bwd-masking-effects' ),
					'bwdme-masking47' => esc_html__( 'Style 47', 'bwd-masking-effects' ),
					'bwdme-masking48' => esc_html__( 'Style 48', 'bwd-masking-effects' ),
					'bwdme-masking49' => esc_html__( 'Style 49', 'bwd-masking-effects' ),
					'bwdme-masking50' => esc_html__( 'Style 50', 'bwd-masking-effects' ),
					'bwdme-masking51' => esc_html__( 'Style 51', 'bwd-masking-effects' ),
					'bwdme-masking52' => esc_html__( 'Style 52', 'bwd-masking-effects' ),
					'bwdme-masking53' => esc_html__( 'Style 53', 'bwd-masking-effects' ),
					'bwdme-masking54' => esc_html__( 'Style 54', 'bwd-masking-effects' ),
					'bwdme-masking55' => esc_html__( 'Style 55', 'bwd-masking-effects' ),
					'bwdme-masking56' => esc_html__( 'Style 56', 'bwd-masking-effects' ),
					'bwdme-masking57' => esc_html__( 'Style 57', 'bwd-masking-effects' ),
					'bwdme-masking58' => esc_html__( 'Style 58', 'bwd-masking-effects' ),
					'bwdme-masking59' => esc_html__( 'Style 59', 'bwd-masking-effects' ),
					'bwdme-masking60' => esc_html__( 'Style 60', 'bwd-masking-effects' ),
					'bwdme-masking61' => esc_html__( 'Style 61', 'bwd-masking-effects' ),
					'bwdme-masking62' => esc_html__( 'Style 62', 'bwd-masking-effects' ),
					'bwdme-masking63' => esc_html__( 'Style 63', 'bwd-masking-effects' ),
					'bwdme-masking64' => esc_html__( 'Style 64', 'bwd-masking-effects' ),
					'bwdme-masking65' => esc_html__( 'Style 65', 'bwd-masking-effects' ),
					'bwdme-masking66' => esc_html__( 'Style 66', 'bwd-masking-effects' ),
					'bwdme-masking67' => esc_html__( 'Style 67', 'bwd-masking-effects' ),
					'bwdme-masking68' => esc_html__( 'Style 68', 'bwd-masking-effects' ),
					'bwdme-masking69' => esc_html__( 'Style 69', 'bwd-masking-effects' ),
					'bwdme-masking70' => esc_html__( 'Style 70', 'bwd-masking-effects' ),
					'bwdme-masking71' => esc_html__( 'Style 71', 'bwd-masking-effects' ),
					'bwdme-masking72' => esc_html__( 'Style 72', 'bwd-masking-effects' ),
					'bwdme-masking73' => esc_html__( 'Style 73', 'bwd-masking-effects' ),
					'bwdme-masking74' => esc_html__( 'Style 74', 'bwd-masking-effects' ),
					'bwdme-masking75' => esc_html__( 'Style 75', 'bwd-masking-effects' ),
					'bwdme-masking76' => esc_html__( 'Style 76', 'bwd-masking-effects' ),
					'bwdme-masking77' => esc_html__( 'Style 77', 'bwd-masking-effects' ),
					// 'customtext' => esc_html__( 'Custom Text', 'bwd-masking-effects' ),
				],
				'condition' => [
					'bwdme_masking_custom_text!' => 'yes'
				],
			]
		);
		$this->add_control(
			'bwdme_masking_custom_text',
			[
				'label' => esc_html__( 'Custom Text', 'bwd-masking-effects' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bwd-masking-effects' ),
				'label_off' => esc_html__( 'NO', 'bwd-masking-effects' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'bwdme_masking_color',
			[
				'label' => esc_html__( 'Masking Color', 'bwd-masking-effects' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'bwdme_masking_title_for_sale30',
			[
				'label' => esc_html__( 'Text', 'bwd-masking-effects' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('BEST WP DEVELOPER', 'bwd-masking-effects'),
				'condition' => [
					// 'bwdme_style_selection' => 'customtext',
					'bwdme_masking_custom_text' => 'yes',
				],
				'label_block' => true,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'bwdme_masking_title_typography',
				'selector' => '{{WRAPPER}} .bwdme-custom-text-in',
				'condition' => [
					// 'bwdme_style_selection' => 'customtext',
					'bwdme_masking_custom_text' => 'yes',
				],
			]
		);
		$this->add_control(
			'bwdme_masking_salesk',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					// 'bwdme_style_selection' => 'customtext',
					'bwdme_masking_custom_text' => 'yes',
				],
			]
		);
		$this->add_responsive_control(
			'bwdme_masking_width',
			[
				'label' => esc_html__( 'Width', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'rem', 'em', 'vh'],
                'default' => [
                    'unit' => '%',
                    'size' => '100',
                ],
				'devices' => [ 'desktop', 'laptop', 'tablet', 'tablet_extra', 'mobile', 'mobile_extra' ],
				'selectors' => [
					'{{WRAPPER}} .bwdme-svg-img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'bwdme_masking_min_height',
			[
				'label' => esc_html__( 'Height', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SLIDER,
                'size_units' => ['vh', 'px', 'rem', 'em', '%'],
                'default' => [
                    'unit' => 'vh',
                    'size' => '100',
                ],
				'devices' => [ 'desktop', 'laptop', 'tablet', 'tablet_extra', 'mobile', 'mobile_extra' ],
				'selectors' => [
					'{{WRAPPER}} .bwdme-svg-img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'bwdme_masking_position',
			[
				'label' => esc_html__( 'Masking Position', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'center' => esc_html__( 'Center', 'bwd-masking-effects' ),
					'top' => esc_html__( 'Top', 'bwd-masking-effects' ),
					'bottom' => esc_html__( 'Bottom', 'bwd-masking-effects' ),
					'left' => esc_html__( 'Left', 'bwd-masking-effects' ),
					'right' => esc_html__( 'Right', 'bwd-masking-effects' ),
					'auto' => esc_html__( 'Auto', 'bwd-masking-effects' ),
				],
			]
		);
		$this->add_control(
			'bwdme_masking_size',
			[
				'label' => esc_html__( 'Masking Size', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'auto' => esc_html__( 'Auto', 'bwd-masking-effects' ),
					'contain' => esc_html__( 'Contain', 'bwd-masking-effects' ),
					'cover' => esc_html__( 'Cover', 'bwd-masking-effects' ),
				],
			]
		);
		$this->add_control(
			'bwdme_masking_repeat_mask',
			[
				'label' => esc_html__( 'Masking Repeat', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'repeat' => esc_html__( 'Repeat', 'bwd-masking-effects' ),
					'no-repeat' => esc_html__( 'No-Repeat', 'bwd-masking-effects' ),
					'repeat-x' => esc_html__( 'Repeat-x', 'bwd-masking-effects' ),
					'repeat-y' => esc_html__( 'Repeat-y', 'bwd-masking-effects' ),
					'round' => esc_html__( 'Round', 'bwd-masking-effects' ),
					'space' => esc_html__( 'Space', 'bwd-masking-effects' ),
				],
			]
		);
		$this->end_controls_section();

		
		$this->start_controls_section(
			'bwdme_background_content_section',
			[
				'label' => esc_html__( 'Background Content', 'bwd-masking-effects' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'bwdme_masking_image',
			[
				'label' => esc_html__( 'Choose Background', 'bwd-masking-effects' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_responsive_control(
			'bwdme_background_width',
			[
				'label' => esc_html__( 'Width', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'rem', 'em', 'vh'],
                'default' => [
                    'unit' => '%',
                    'size' => '100',
                ],
				'devices' => [ 'desktop', 'laptop', 'tablet', 'tablet_extra', 'mobile', 'mobile_extra' ],
				'selectors' => [
					'{{WRAPPER}} .bwdme-bg-img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'bwdme_background_min_height',
			[
				'label' => esc_html__( 'Height', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SLIDER,
                'size_units' => ['vh', 'px', 'rem', 'em', '%'],
                'default' => [
                    'unit' => 'vh',
                    'size' => '100',
                ],
				'devices' => [ 'desktop', 'laptop', 'tablet', 'tablet_extra', 'mobile', 'mobile_extra' ],
				'selectors' => [
					'{{WRAPPER}} .bwdme-bg-img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'bwdme_masking_attachment',
			[
				'label' => esc_html__( 'Bg Attachment', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'paralax',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'paralax' => esc_html__( 'Paralax', 'bwd-masking-effects' ),
				],
			]
		);
		$this->add_control(
			'bwdme_background_position',
			[
				'label' => esc_html__( 'Background Position', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'center' => esc_html__( 'Center', 'bwd-masking-effects' ),
					'top' => esc_html__( 'Top', 'bwd-masking-effects' ),
					'bottom' => esc_html__( 'Bottom', 'bwd-masking-effects' ),
					'left' => esc_html__( 'Left', 'bwd-masking-effects' ),
					'right' => esc_html__( 'Right', 'bwd-masking-effects' ),
					'auto' => esc_html__( 'Auto', 'bwd-masking-effects' ),
				],
			]
		);
		$this->add_control(
			'bwdme_background_size',
			[
				'label' => esc_html__( 'Background Size', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'auto' => esc_html__( 'Auto', 'bwd-masking-effects' ),
					'contain' => esc_html__( 'Contain', 'bwd-masking-effects' ),
					'cover' => esc_html__( 'Cover', 'bwd-masking-effects' ),
				],
			]
		);
		$this->add_control(
			'bwdme_background_repeat_masking',
			[
				'label' => esc_html__( 'Background Repeat', 'bwd-masking-effects' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'bwd-masking-effects' ),
					'repeat' => esc_html__( 'Repeat', 'bwd-masking-effects' ),
					'no-repeat' => esc_html__( 'No-Repeat', 'bwd-masking-effects' ),
					'repeat-x' => esc_html__( 'Repeat-x', 'bwd-masking-effects' ),
					'repeat-y' => esc_html__( 'Repeat-y', 'bwd-masking-effects' ),
					'round' => esc_html__( 'Round', 'bwd-masking-effects' ),
					'space' => esc_html__( 'Space', 'bwd-masking-effects' ),
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'bwdme_masking_style_section',
			[
				'label' => esc_html__( 'Masking Style', 'bwd-masking-effects' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
            'bwdme_masking_the_box_margin',
            [
                'label' => esc_html__('Margin', 'bwd-masking-effects'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bwdme-svg-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'bwdme_masking_the_box_padding',
            [
                'label' => esc_html__('Padding', 'bwd-masking-effects'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bwdme-svg-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<?php
        if( $settings['bwdme_style_selection'] ){
            ?>
            <div class="bwdme-svg-img <?php if('center' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-default <?php } elseif('top' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-top <?php } elseif('bottom' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-bottom <?php } elseif('left' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-left <?php } elseif('right' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-right <?php } elseif('auto' === $settings['bwdme_masking_position']){ ?>bwdme-svg-margin <?php } ?> <?php if('cover' === $settings['bwdme_masking_size']){ ?>bwdme-masking-size-default <?php } elseif('auto' === $settings['bwdme_masking_size']){ ?>bwdme-masking-size-auto <?php } elseif('contain' === $settings['bwdme_masking_size']){ ?>bwdme-masking-size-contain <?php } ?> <?php if('no-repeat' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-no-repeat-default <?php } elseif('repeat' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat <?php } elseif('repeat-x' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-x <?php } elseif('repeat-y' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-y <?php } elseif('round' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-round <?php } elseif('space' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-space <?php } ?> <?php echo $settings['bwdme_style_selection']; ?>">
                <div class="bwdme-bg-img 
				<?php if('paralax' === $settings['bwdme_masking_attachment']){ ?>bwdme_text_paralax <?php } ?> 
				<?php if('center' === $settings['bwdme_background_position']){ ?>bwdme-background-position-default <?php } elseif('top' === $settings['bwdme_background_position']){ ?>bwdme-background-position-top <?php } elseif('bottom' === $settings['bwdme_background_position']){ ?>bwdme-background-position-bottom <?php } elseif('left' === $settings['bwdme_background_position']){ ?>bwdme-background-position-left <?php } elseif('right' === $settings['bwdme_background_position']){ ?>bwdme-background-position-right <?php } elseif('auto' === $settings['bwdme_background_position']){ ?>bwdme-background-img <?php } ?> 
				<?php if('cover' === $settings['bwdme_background_size']){ ?>bwdme-background-default <?php } elseif('auto' === $settings['bwdme_background_size']){ ?>bwdme-background-auto <?php } elseif('contain' === $settings['bwdme_background_size']){ ?>bwdme-background-contain <?php } ?> 
				<?php if('no-repeat' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-no-repeat-default <?php } elseif('repeat' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat <?php } elseif('repeat-x' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-x <?php } elseif('repeat-y' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-y <?php } elseif('round' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-round <?php } elseif('space' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-space <?php } ?>
				" style="background-image: url(<?php echo esc_url($settings['bwdme_masking_image']['url']); ?>);"></div>
            </div>
            <?php
        } 
		
		if('yes' === $settings['bwdme_masking_custom_text']){
			?>
			<div class="bwdme-svg-img bwdme-custom-text 
				<?php if('paralax' === $settings['bwdme_masking_attachment']){ ?>bwdme_text_paralax <?php } ?> 
				<?php if('center' === $settings['bwdme_background_position']){ ?>bwdme-background-position-default <?php } elseif('top' === $settings['bwdme_background_position']){ ?>bwdme-background-position-top <?php } elseif('bottom' === $settings['bwdme_background_position']){ ?>bwdme-background-position-bottom <?php } elseif('left' === $settings['bwdme_background_position']){ ?>bwdme-background-position-left <?php } elseif('right' === $settings['bwdme_background_position']){ ?>bwdme-background-position-right <?php } elseif('auto' === $settings['bwdme_background_position']){ ?>bwdme-background-img <?php } ?> 
				<?php if('cover' === $settings['bwdme_background_size']){ ?>bwdme-background-default <?php } elseif('auto' === $settings['bwdme_background_size']){ ?>bwdme-background-auto <?php } elseif('contain' === $settings['bwdme_background_size']){ ?>bwdme-background-contain <?php } ?> 
				<?php if('no-repeat' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-no-repeat-default <?php } elseif('repeat' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat <?php } elseif('repeat-x' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-x <?php } elseif('repeat-y' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-y <?php } elseif('round' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-round <?php } elseif('space' === $settings['bwdme_background_repeat_masking']){ ?>bwdme-background-repeat-space <?php } ?>
				" style="background-image: url(<?php echo esc_url($settings['bwdme_masking_image']['url']); ?>);">
				<div class="bwdme-custom-text-in 
				<?php if('center' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-default <?php } elseif('top' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-top <?php } elseif('bottom' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-bottom <?php } elseif('left' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-left <?php } elseif('right' === $settings['bwdme_masking_position']){ ?>bwdme-masking-position-right <?php } elseif('auto' === $settings['bwdme_masking_position']){ ?>bwdme-svg-margin <?php } ?> 
				<?php if('cover' === $settings['bwdme_masking_size']){ ?>bwdme-masking-size-default <?php } elseif('auto' === $settings['bwdme_masking_size']){ ?>bwdme-masking-size-auto <?php } elseif('contain' === $settings['bwdme_masking_size']){ ?>bwdme-masking-size-contain <?php } ?> 
				<?php if('no-repeat' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-no-repeat-default <?php } elseif('repeat' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat <?php } elseif('repeat-x' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-x <?php } elseif('repeat-y' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-y <?php } elseif('round' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-round <?php } elseif('space' === $settings['bwdme_masking_repeat_mask']){ ?>bwdme-masking-repeat-space <?php } ?>
				"><?php echo esc_html($settings['bwdme_masking_title_for_sale30']); ?></div>
			</div>
			<?php
		}
	}
}
