
/******************************************************************************/
/******************************************************************************/

function CHBSHelper()
{
    /**************************************************************************/
    
    var $self=this;
    
	/**************************************************************************/

	this.getValueFromClass=function(object,pattern)
	{
		var reg=new RegExp(pattern);
		var className=jQuery(object).attr('class').split(' ');

		for(var i in className)
		{
			if(reg.test(className[i]))
				return(className[i].substring(pattern.length));
		}

		return(false);		
	};	
	
	/**************************************************************************/

	this.getRandom=function(min,max)
	{
		return((Math.floor(Math.random()*(max-min)))+min);
	};

	/**************************************************************************/
	 
    this.getRandomString=function(length)
	{
		var string='';
		for(var i=0;i<length;i++)
			string+=String.fromCharCode(this.getRandom(65,90));
		return(string);
	};
    
	/**************************************************************************/
	
	this.isEmpty=function(value)
	{
		return(jQuery.trim(value).length===0 ? true : false);
	};
    
    /**************************************************************************/
    
    this.compareDate=function(date)
    {
        date[0]=Date.parse($self.reverseDate(date[0]));
        date[1]=Date.parse($self.reverseDate(date[1]));
        date[2]=Date.parse($self.reverseDate(date[2]));
        
        return(((date[0]>=date[1]) && (date[0]<=date[2])) ? true : false);
    };
    
    /**************************************************************************/
    
    this.reverseDate=function(date)
    {
        date=date.split('-');
        return(date[2]+'-'+date[1]+'-'+date[0]);
    };
    
    /**************************************************************************/
    
    this.isDate=function(date)
    {
        var bit=date.split('-');
        var formatDate=new Date(bit[2],bit[1]-1,bit[0]);
        return((formatDate) && ((formatDate.getMonth()+1)==bit[1]));       
    };
    
    /**************************************************************************/
    
    this.isMobile=function()
    {
        var check=false;
        (function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) check = true;})(navigator.userAgent||navigator.vendor||window.opera);
        return(check);
    };
    
    /**************************************************************************/
    
    this.generatePassword=function(length)
    {
        var length=length ? length : 10;
        
        var character='0123456789abcdefghijklmnopqrstuvwxyz!@#$%^&*()_+~`|}{[]\:;?><,./-=';
        var characterLength=character.length;
        
        var password='';
        
        while(password.length<length)
        {
            var position=Math.ceil(characterLength*Math.random());
            var char=character.charAt(position);
            
            if(Math.random()>0.5) char=char.toUpperCase();
            
            password+=char;
        }
        
        return(password);
    };
    
    /**************************************************************************/
    
    this.urlParam=function(name)
    {
        var result=new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
        if(result==null) return(null);
        return(decodeURI(result[1]) || 0);
    };
    
    /**************************************************************************/
    
    this.getMessageFromConsole=function()
    {
		return;
		
        var errorDisplayed=false;
        
        var console=window.console;
        if(!console) return;

        function intercept(method)
        {
            var original=console[method];
            console[method]=function()
            {
                if(original.apply)
                {
                    original.apply(console,arguments);
                    var message=arguments[0];
                }
                else
                {
                    var message=Array.prototype.slice.apply(arguments).join(' ');
                    original(message);
                }
                
                try
                {
                    if(message.indexOf('Google Maps JavaScript API')>-1) 
                    {    
                        if(!errorDisplayed) alert(message);
                        errorDisplayed=true;
                    }
                }
                catch(e) {}
            };
        };

        var methods=['log','warn','error'];
        for(var i=0;i<methods.length;i++)
            intercept(methods[i]);
    };
	
	/**************************************************************************/
	
	this.seralizeForm=function(object,returnValue=1)
	{
		var data=[];
		var queryString='';
		
		object.find(':input').each(function()
		{
			data[jQuery(this).attr('name')]=jQuery(this).val();
			
			if(!$self.isEmpty(queryString)) queryString+='&';
			queryString+=jQuery(this).attr('name')+'='+jQuery(this).val();
		});
		
		return(returnValue===1 ? queryString : data);
	};
	
	/**************************************************************************/
	
	this.mapToBool=function(value)
	{
		if((value=='false') || (parseInt(value,10)===0)) return(false);
		if((value=='true') || (parseInt(value,10)===1)) return(true);
		
		return(false);
	};
	
	/**************************************************************************/
	
	this.setWidthClass=function(object,recursion=false)
	{
		var width=object.parent().width();
			
		var className=null;
		var classPrefix='chbs-width-';
			
		if(width>=1220) className='1220';
		else if(width>=960) className='960';
		else if(width>=768) className='768';
		else if(width>=480) className='480';
		else if(width>=300) className='300';
		else className='300';
			
		var oldClassName=$self.getValueFromClass(object,classPrefix);
		if(oldClassName!==false) object.removeClass(classPrefix+oldClassName);
			
		object.addClass(classPrefix+className);	
		
		if(width>=960) object.removeClass('chbs-widthlt-960');
		else object.addClass('chbs-widthlt-960');
		
		if(recursion)
		{
			var Helper=new CHBSHelper();
			setTimeout(Helper.setWidthClass,500,object,recursion);
		}
		
		return(width);
	};
	
	/**************************************************************************/
	
	this.coordinateInsidePolygon=function(point, vs)
	{
		var x = point[0], y = point[1];

		var inside = false;
		for (var i = 0, j = vs.length - 1; i < vs.length; j = i++) {
			var xi = vs[i][0], yi = vs[i][1];
			var xj = vs[j][0], yj = vs[j][1];

			var intersect = ((yi > y) != (yj > y))
				&& (x < (xj - xi) * (y - yi) / (yj - yi) + xi);
			if (intersect) inside = !inside;
		}

		return inside;
	};
    
    /**************************************************************************/
};

/******************************************************************************/
/******************************************************************************/