<?php

    if ( ! class_exists( 'weLaunch' ) && ! class_exists( 'Redux' ) ) {
        return;
    }

    if( class_exists( 'weLaunch' ) ) {
        $framework = new weLaunch();
    } else {
        $framework = new Redux();
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "wordpress_multisite_sync";
    $tmp = array();
    $post_types = array();
    $sitesSelect = array();
    $taxonomyTerms = array();
    $desc = "";

    $options = get_network_option(null, 'wordpress_multisite_sync');

    if(isset($_GET['page']) && $_GET['page'] == "wordpress_multisite_sync_options") {

        $active_cron_jobs = get_option( 'cron' );
        $temp = array();
        foreach ($active_cron_jobs as $active_cronjob) {
            if(is_array($active_cronjob)) {
                $cron_name = key($active_cronjob);

                if (strpos($cron_name, 'run_wordpress_multisite_sync_cronjob') !== false) {

                    $temp[$cron_name] = array(
                        'name' => substr($cron_name, 29)
                    );
                    
                    foreach ($active_cronjob as $key => $value) {

                        foreach ($value as $key2 => $value2) {
                            $temp[$cron_name]['schedule'] = $value2['schedule'];
                            $temp[$cron_name]['interval'] = $value2['interval'];
                        }
                    }
                }
            }
        }

        global $wpdb;

        // WP > 4.6
        if ( function_exists( 'get_sites' ) && class_exists( 'WP_Site_Query' ) ) {
            $sites = get_sites(array('number' => 9999));
        // WP < 4.6
        } else {
            $sites = wp_get_sites();
        }

        $post_types = array();
        $res = $wpdb->get_results("SELECT DISTINCT post_type FROM `{$wpdb->prefix}posts`", ARRAY_A);
        if(!empty($res)) {
            foreach ($res as $key => $value) {
                $post_types[] = $value['post_type'];
            }
        }
        $post_types = array_combine($post_types, $post_types);
        unset($post_types['attachment']);
        unset($post_types['revision']);
        unset($post_types['nav_menu_item']);

        foreach ($sites as $site) {
            
            $sitesSelect[$site->blog_id] = $site->domain . $site->path;

            if(isset($options['syncOnlyCustomTaxonomies']) && $options['syncOnlyCustomTaxonomies'] == "1") {

                switch_to_blog($site->blog_id);
            
                $taxonomies = $wpdb->get_results(
                                "SELECT taxonomy, {$wpdb->prefix}term_taxonomy.term_id, name FROM `{$wpdb->prefix}term_taxonomy` 
                                INNER JOIN {$wpdb->prefix}terms 
                                ON {$wpdb->prefix}terms.term_id = {$wpdb->prefix}term_taxonomy.term_id;", ARRAY_A);

                
                if(!empty($taxonomies)) {
                    foreach ($taxonomies as $taxonomy) {
                        $tax = $taxonomy['taxonomy'];
                        $term_id = $taxonomy['term_id'];
                        $term_name = $taxonomy['name'];
                        $taxonomyTerms[$tax][$site->blog_id . '_' . $term_id] = 'Blog ' . $site->blog_id . ': ' . $term_name;
                    }
                }

                restore_current_blog();
            }
        }

        $active_cron_jobs = $temp;
        $desc = "<h2>Active Cronjobs:</h2>";
        foreach ($active_cron_jobs as $active_cron_job) {
            $desc .= '<b>' . $active_cron_job['name'] . '</b> (Scheduled: ' . $active_cron_job['schedule'] . ' / Interval: ' . $active_cron_job['interval'] . ')<br/>';
        }
    }

    $args = array(
        'opt_name' => 'wordpress_multisite_sync',
        'use_cdn' => TRUE,
        'dev_mode' => FALSE,
        'display_name' => 'WordPress Multisite Sync',
        'display_version' => '1.1.14',
        'page_title' => 'WordPress Multisite Sync',
        'update_notice' => TRUE,
        'intro_text' => '',
        'footer_text' => '&copy; '.date('Y').' weLaunch',
        'admin_bar' => FALSE,
        'menu_type' => 'menu',
        'menu_title' => 'Multisite Sync',
        'allow_sub_menu' => TRUE,
        'page_parent_post_type' => 'your_post_type',
        'customizer' => FALSE,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_network',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
        'network_admin' => true,
        'database' => 'network',
    );

    global $weLaunchLicenses;
    if( isset($weLaunchLicenses['wordpress-multisite-sync']) && !empty($weLaunchLicenses['wordpress-multisite-sync'])  ) {
        $args['display_name'] = '<span class="dashicons dashicons-yes-alt" style="color: #9CCC65 !important;"></span> ' . $args['display_name'];
    } else {
        $args['display_name'] = '<span class="dashicons dashicons-dismiss" style="color: #EF5350 !important;"></span> ' . $args['display_name'];
    }

    $framework::setArgs( $opt_name, $args );

    $framework::setSection( $opt_name, array(
        'title'  => __( 'Wordpress Multisite Sync', 'wordpress-multisite-sync' ),
        'id'     => 'general',
        'desc'   => __( 'Need support? Please use the comment function on codecanyon.', 'wordpress-multisite-sync' ),
        'icon'   => 'el el-home',
    ) );

    $framework::setSection( $opt_name, array(
        'title'      => __( 'General', 'wordpress-multisite-sync' ),
        'desc'       => __( 'To get auto updates please <a href="' . admin_url('tools.php?page=welaunch-framework') . '">register your License here</a>.', 'wordpress-multisite-sync' ),
        'id'         => 'general-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enable',
                'type'     => 'switch',
                'title'    => __( 'Enable', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Enable Wordpress Multisite Sync to use the options below', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'imageDebug',
                'type'     => 'switch',
                'title'    => __( 'Enable Image Debug', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Enable this, then update a post to see the error when image upload fails.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => 'syncOnlyCustomTaxonomies',
                'type'     => 'switch',
                'title'    => esc_html__( 'Only Sync Specific Taxonomy Terms', 'wordpress-multisite-sync' ),
                'subtitle' => esc_html__( 'After enabling reload this page. Then under each cronjob you see all custom taxonomies to choose which terms to sync.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => 'syncOnlySpecificPosts',
                'type'     => 'switch',
                'title'    => esc_html__( 'Only Sync Specific Posts', 'wordpress-multisite-sync' ),
                'subtitle' => esc_html__( 'When enabled a checkbox will be added to all posts when you edit them in the backed. Check this to sync this post.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => 'syncOnlySpecificPostsPerSite',
                'type'     => 'switch',
                'title'    => esc_html__( 'Only Sync Specific Posts to specific Sites', 'wordpress-multisite-sync' ),
                'subtitle' => esc_html__( 'When enabled a checkbox will be added to all posts when you edit them in the backed. Check this to sync this post.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => 'mailLogs',
                'type'     => 'checkbox',
                'title'    => __( 'Email Logs', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Send logs by email', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => 'mailLogsEmail',
                'type'     => 'text',
                'title'    => __( 'Email', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'The Email where the logs will be sent.', 'wordpress-multisite-sync' ),
                'required' => array('mailLogs','equals','1'),
            ),

            array(
                'id'   => 'runNow',
                'type' => 'info',
                'desc' => $desc . __('<br/><a href="http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"] . '&multisite-sync=true" class="button button-primary">Manually Run Sync</a><br/> <br/>When you activate / deactive a cron, please reload the page!', 'redux-framework-demo')
            ),
        )
    ) );

    $crons = array(
        1 => 'first-cron-',
        2 => 'second-cron-',
        3 => 'third-cron-',
        4 => 'fourth-cron-',
        5 => 'fifth-cron-',
        6 => 'sixth-cron-',
        7 => 'seventh-cron-',
        8 => 'eight-cron-',
        9 => 'ninth-cron-',
        10 => 'tenth-cron-',
    );

    foreach ($crons as $key => $cron) {


        if(!empty($taxonomyTerms)) {
            $tmp = array();
            foreach ($taxonomyTerms as $taxonomy => $terms) {

                $tmp[] = array(
                    'id'       => $cron.'postTaxonomy' . $taxonomy,
                    'type'     => 'select',
                    'multi'    => true,
                    'title'    => 'Only sync Taxonomy: ' . $taxonomy,
                    'subtitle' => __( 'Only sync above taxonomy.', 'wordpress-multisite-sync' ),
                    'options' => $terms,
                );                        
            }
        }

        $fields = array(
            array(
                'id'       => $cron.'enable',
                'type'     => 'switch',
                'title'    => __( 'Enable', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Enable this cron.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => $cron.'runOnPublish',
                'type'     => 'checkbox',
                'title'    => __( 'Run on Publish', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Run Cronjob when a post is created / published.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => $cron.'runOnUpdate',
                'type'     => 'checkbox',
                'title'    => __( 'Run on Update', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Run Cronjob when a post is updated / edited.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => $cron.'runOnTrash',
                'type'     => 'checkbox',
                'title'    => __( 'Run on Trash', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Run Cronjob when a post is Trashed (NOT DELETED).', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => $cron.'recurrence',
                'type'     => 'select',
                'title'    => __( 'Recurrence', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'How often the event should reoccur.', 'wordpress-multisite-sync' ),
                'options' => array(
                    'minute' => 'Every Minute',
                    '10minutes' => 'Every 10 Minutes',
                    '30minutes' => 'Half an Hour',
                    'hourly' => 'Hourly',
                    'twicedaily' => 'Twicedaily',
                    'daily' => 'Daily',
                    'weekly' => 'Weekly',
                    'monthly' => 'Monthly',
                    ),
                'default' => 'twicedaily'
            ),
            array(
                'id'       => $cron.'sourceSite',
                'type'     => 'select',
                'title'    => __( 'Source Site', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'From this site the posts get copied', 'wordpress-multisite-sync' ),
                'options'     => $sitesSelect,
            ),
            array(
                'id'       => $cron.'destinationSites',
                'type'     => 'select',
                'title'    => __( 'Destination Sites', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'To this sites the posts get copied', 'wordpress-multisite-sync' ),
                'options'     => $sitesSelect,
                'multi' => true,
            ),
            array(
                'id'       => $cron.'sourcePostTypes',
                'type'     => 'select',
                'title'    => __( 'Source Post types', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'What post types do you want to sync? Attachments not working today! Empty = all.', 'wordpress-multisite-sync' ),
                'options' => $post_types,
                'multi' => true,
            ),
            array(
                'id'       => $cron.'sourcePostStatus',
                'type'     => 'select',
                'title'    => __( 'Source Post Status', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'What post status do you want to sync?  Empty = all.', 'wordpress-multisite-sync' ),
                'multi' => true,
                'options' => array(
                    'publish' => 'Publish',
                    'draft' => 'Draft',
                    'pending' => 'Pending',
                    'private' => 'Private',
                    'trash' => 'Trash',
                    ),
                'default' => ''
            ),
            array(
                'id'       => $cron.'createIfNotExists',
                'type'     => 'checkbox',
                'title'    => __( 'Create posts', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Also create posts if they do not exist?', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => $cron.'updateIfExists',
                'type'     => 'checkbox',
                'title'    => __( 'Update if Exists?', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Update posts if they exists?', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => $cron.'updateKey',
                'type'     => 'select',
                'title'    => __( 'Update key', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Check for posts to be updated by slug or name?', 'wordpress-multisite-sync' ),
                'options' => array(
                    'post_name' => 'Slug',
                    'post_title' => 'Title',
                    'sku' => 'SKU',
                    ),
                'default' => 'post_title',
                'required' => array($cron . 'updateIfExists','equals','1'),
            ),

            array(
                'id'       => $cron.'runOnDelete',
                'type'     => 'checkbox',
                'title'    => __( 'Delete posts', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'When a post is deleted, delete the post also on subsites.', 'wordpress-multisite-sync' ),
                'default' => 0,
            ),
            array(
                'id'       => $cron.'deleteKey',
                'type'     => 'select',
                'title'    => __( 'Delete key', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Check for posts to be deleted by slug, SKU or name?', 'wordpress-multisite-sync' ),
                'options' => array(
                    'post_name' => 'Slug',
                    'post_title' => 'Title',
                    'sku' => 'SKU',
                    ),
                'default' => 'post_title',
                'required' => array($cron . 'runOnDelete','equals','1'),
            ),
            array(
                'id'       => $cron.'excludePosts',
                'type'     => 'text',
                'title'    => __( 'Exclude Posts', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Exclude some posts? Enter the ID seperated by comma!', 'wordpress-multisite-sync' ),
                'placeholder' => '154,156'
            ),

            array(
                'id'       => $cron.'postStatus',
                'type'     => 'select',
                'title'    => __( 'Post Status', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Give your sync posts a custom post-type?', 'wordpress-multisite-sync' ),
                'options' => array(
                    '' => 'Keep original Status',
                    'publish' => 'Publish',
                    'draft' => 'Draft',
                    'pending' => 'Pending',
                    'private' => 'Private',
                    'trash' => 'Trash',
                    ),
                'default' => 'publish'
            ),
            array(
                'id'       => $cron.'syncTaxonomies',
                'type'     => 'checkbox',
                'title'    => __( 'Taxonomies', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Also sync Taxonomies?', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => $cron.'syncPostMeta',
                'type'     => 'checkbox',
                'title'    => __( 'Post Meta', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Also sync post meta?', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),

                array(
                    'id'       => $cron.'excludePostmeta',
                    'type'     => 'text',
                    'title'    => __( 'Exclude Post Meta fields', 'wordpress-multisite-sync' ),
                    'subtitle' => __( 'Exclude custom post Meta fields (splitted by comma)!', 'wordpress-multisite-sync' ),
                    'placeholder' => '_price,_shipping_class',
                    'required' => array($cron.'syncPostMeta','equals','1'),
                ),
                array(
                    'id'       => $cron.'includePostmeta',
                    'type'     => 'text',
                    'title'    => __( 'Include Post Meta fields', 'wordpress-multisite-sync' ),
                    'subtitle' => __( 'Include ONLY these custom post Meta fields (splitted by comma)!', 'wordpress-multisite-sync' ),
                    'placeholder' => '_price,_shipping_class',
                    'required' => array($cron.'syncPostMeta','equals','1'),
                ),

            array(
                'id'       => $cron.'syncImages',
                'type'     => 'checkbox',
                'title'    => __( 'Images', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Also sync images?', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => $cron.'syncTags',
                'type'     => 'checkbox',
                'title'    => __( 'Tags', 'wordpress-multisite-sync' ),
                'subtitle' => __( 'Also sync tags?', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
        );

        $fields = array_merge($fields, $tmp);

        $framework::setSection( $opt_name, array(
            'title'      => __( $key.'. Cron Settings', 'wordpress-multisite-sync' ),
            // 'desc'       => __( '', 'wordpress-multisite-sync' ),
            'id'         => $cron.'settings',
            'subsection' => true,
            'fields'     => $fields,
        ) );
    }

    // post_author
    // post_date
    // post_date_gmt
    // post_content
    // post_title
    // post_excerpt
    // post_status
    // post_password
    // post_name
    // post_modified
    // post_modified_gmt
    // post_content_filtered
    // post_parent
    // post_type
    // post_mime_type
    // comment_status
    // comment_count
    // ping_status
    // to_ping
    // pinged
    // guid
    // menu_order
    $framework::setSection( $opt_name, array(
        'title'      => __( 'Data', 'wordpress-multisite-sync' ),
        'desc'       => __( 'What data do you want to sync?', 'wordpress-multisite-sync' ),
        'id'         => 'data',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'post_author',
                'type'     => 'checkbox',
                'title'    => __( 'Author', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_date',
                'type'     => 'checkbox',
                'title'    => __( 'Date', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_date_gmt',
                'type'     => 'checkbox',
                'title'    => __( 'Date GMT', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_content',
                'type'     => 'checkbox',
                'title'    => __( 'Content', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_title',
                'type'     => 'checkbox',
                'title'    => __( 'Title', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_excerpt',
                'type'     => 'checkbox',
                'title'    => __( 'Excerpt', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_status',
                'type'     => 'checkbox',
                'title'    => __( 'Status', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_password',
                'type'     => 'checkbox',
                'title'    => __( 'Password', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_name',
                'type'     => 'checkbox',
                'title'    => __( 'Name', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_modified',
                'type'     => 'checkbox',
                'title'    => __( 'Modified', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_modified_gmt',
                'type'     => 'checkbox',
                'title'    => __( 'Modified GMT', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_content_filtered',
                'type'     => 'checkbox',
                'title'    => __( 'Content filtered', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_parent',
                'type'     => 'checkbox',
                'title'    => __( 'Parent', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_type',
                'type'     => 'checkbox',
                'title'    => __( 'Post Type', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'post_mime_type',
                'type'     => 'checkbox',
                'title'    => __( 'Mime Type', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'comment_status',
                'type'     => 'checkbox',
                'title'    => __( 'Comment Status', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'comment_count',
                'type'     => 'checkbox',
                'title'    => __( 'Comment Count', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'ping_status',
                'type'     => 'checkbox',
                'title'    => __( 'Ping Status', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'to_ping',
                'type'     => 'checkbox',
                'title'    => __( 'To Ping', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'pinged',
                'type'     => 'checkbox',
                'title'    => __( 'Pinged', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'guid',
                'type'     => 'checkbox',
                'title'    => __( 'GUID', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
            array(
                'id'       => 'menu_order',
                'type'     => 'checkbox',
                'title'    => __( 'Menu Order', 'wordpress-multisite-sync' ),
                'default' => 1,
            ),
          
        )
    ) );

    /*
     * <--- END SECTIONS
     */
