<?php

/**
 * Fired during plugin deactivation
 *
 * @link       http://wordpress-multisite-sync.db-dzine.de
 * @since      1.0.0
 *
 * @package    Wordpress_Multisite_Sync
 * @subpackage Wordpress_Multisite_Sync/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Wordpress_Multisite_Sync
 * @subpackage Wordpress_Multisite_Sync/includes
 * @author     Daniel Barenkamp <contact@db-dzine.de>
 */
class Wordpress_Multisite_Sync_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		
		wp_clear_scheduled_hook('run_wordpress_multisite_sync_cron');
		wp_clear_scheduled_hook('run_wordpress_multisite_sync');

    	$crons = array(
	        1 => 'first-cron-',
	        2 => 'second-cron-',
	        3 => 'third-cron-',
	        4 => 'fourth-cron-',
	        5 => 'fifth-cron-',
	        6 => 'sixth-cron-',
	        7 => 'seventh-cron-',
	        8 => 'eight-cron-',
	        9 => 'ninth-cron-',
	        10 => 'tenth-cron-',
        );

        foreach ($crons as $key => $value) {
        	wp_clear_scheduled_hook('run_wordpress_multisite_sync_cronjob' . $key);
        }

	}

}
