<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       http://wordpress-multisite-sync.db-dzine.de
 * @since      1.0.0
 *
 * @package    Wordpress_Multisite_Sync
 * @subpackage Wordpress_Multisite_Sync/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Wordpress_Multisite_Sync
 * @subpackage Wordpress_Multisite_Sync/includes
 * @author     Daniel Barenkamp <contact@db-dzine.de>
 */
class Wordpress_Multisite_Sync_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		$loaded = load_plugin_textdomain(
			'wordpress-multisite-sync',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
