<?php

/**
 * The plugin bootstrap file
 *
 *
 * @link              https://welaunch.io
 * @since             1.0.
 * @package           Wordpress_Multisite_Sync
 *
 * @wordpress-plugin
 * Plugin Name:       Wordpress Multisite Sync
 * Plugin URI:        https://welaunch.io/plugins/wordpress-multisite-sync/
 * Description:       Sync all your posts through your multisite.
 * Version:           1.1.14
 * Author:            weLaunch
 * Author URI:        https://welaunch.io
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wordpress-multisite-sync
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wordpress-multisite-sync-activator.php
 */
function activate_wordpress_multisite_sync() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-multisite-sync-activator.php';
	Wordpress_Multisite_Sync_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wordpress-multisite-sync-deactivator.php
 */
function deactivate_wordpress_multisite_sync() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-multisite-sync-deactivator.php';
	Wordpress_Multisite_Sync_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wordpress_multisite_sync' );
register_deactivation_hook( __FILE__, 'deactivate_wordpress_multisite_sync' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-multisite-sync.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wordpress_multisite_sync($args = array()) {

	$plugin = new Wordpress_Multisite_Sync();
	$plugin->run();

}


include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( (is_plugin_active('redux-dev-master/redux-framework.php') || is_plugin_active('redux-framework/redux-framework.php') ||  is_plugin_active('welaunch-framework/welaunch-framework.php')) && function_exists('get_sites')){
	run_wordpress_multisite_sync();
	add_action('run_wordpress_multisite_sync_cron', 'run_wordpress_multisite_sync');
} else {
	add_action( 'admin_notices', 'run_Wordpress_Multisite_Sync_Not_Installed' );
}

function run_Wordpress_Multisite_Sync_Not_Installed()
{
	?>
    <div class="error">
      <p><?php _e( 'Wordpress Multisite Sync requires the weLaunch Framework plugin & a WP Multisite. Please install or activate it before: https://www.welaunch.io/updates/welaunch-framework.zip', 'wordpress-multisite-sync'); ?></p>
    </div>
    <?php
}

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}
