<?php
/**
 * DeBlocker
 * Most effective way to detect ad blockers. Ask the visitors to disable their ad blockers.
 * Exclusively on https://1.envato.market/deblocker
 *
 * @encoding        UTF-8
 * @version         3.4.12
 * @copyright       (C) 2018-2024 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Deblocker;

final class FrontEndSettings {

	/**
	 * Convert an array with settings to JS object.
	 * @param $settingsArray
	 *
	 * @return string
	 */
	public static function array_to_js_object( $settingsArray ): string {

		$jsObject = '{';
		foreach ( $settingsArray as $key => $value ) {

			if ( is_array( $value ) ) {

				if ( self::is_aa( $value ) ) {

					empty( $value ) ?
						$jsObject .= '"' . $key . '": {},' :
						$jsObject .= '"' . $key . '":' . self::array_to_js_object( $value ) . ',';

				} else {

					empty( $value ) ?
						$jsObject .= '"' . $key . '": [],' :
						$jsObject .= '"' . $key . '":' . self::convert_na_array( $value ) . ',';

				}

			} else {

				if ( is_bool( $value ) ) {

					$jsObject .= '"' . $key . '": ' . $value . ',';

				} else if ( is_numeric( $value ) ) {

					$jsObject .= '"' . $key . '":' . intval( $value ) . ',';

				} else if ( $value === '"[]"' || $value === '"{}"' ) {

					$jsObject .= '"' . $key . '":' . $value . ',';

				} else {
					if ( in_array( $value, ['on', 'off', '{}']) ) {
						$jsObject .= '"' . $key . '":"' . $value . '",';
					} else {
						$jsObject .= '"' . $key . '":"' . base64_encode($value) . '",';
					}
				}

			}

		}
		$jsObject = rtrim( $jsObject, ',' );
		$jsObject .= '}';

		return $jsObject;

	}

	/**
	 * Convert a one-dimensional non-associative PHP array to JS array in string format.
	 *
	 * @param $array
	 *
	 * @return string
	 */
	private static function convert_na_array( $array ): string {

		return strval( json_encode( $array ) );

	}

	/**
	 * Check is an array is associative.
	 * @param $array
	 *
	 * @return bool
	 */
	private static function is_aa( $array ): bool {

		foreach ( $array as $key => $value ) {

			return $key !== intval( $key );

		}

		return false;

	}

}
