<?php
/**
 * DeBlocker
 * Most effective way to detect ad blockers. Ask the visitors to disable their ad blockers.
 * Exclusively on https://1.envato.market/deblocker
 *
 * @encoding        UTF-8
 * @version         3.4.12
 * @copyright       (C) 2018-2024 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Deblocker;

use Exception;

final class Tools {

	/**
	 * Generate random string.
	 * @return string
	 * @throws Exception
	 */
	public static function random_string(): string {

		$characters        = 'abcdefghijklmnopqrstuvwxyz';
		$characters_length = strlen( $characters );
		$randomString      = '';

		for ( $i = 0; $i < 64; $i ++ ) {
			$randomString .= $characters[ random_int( 0, $characters_length - 1 ) ];
		}

		return $randomString;

	}

	/**
	 * Remove file.
	 * @param $file_path
	 * @return bool|null
	 */
	public static function remove_file($file_path): ?bool {
		if (file_exists($file_path)) {
			if (unlink($file_path)) {
				return true;
			} else {
				return false;
			}
		} else {
			return null;
		}
	}

}
