<?php
/**
 * Plugin Name: Exporo
 * Plugin URI: https://palleon.website/exporo/
 * Description: PDF Catalog Creator For WooCommerce
 * Version: 1.0
 * Requires PHP: 7.0
 * Author: Egemenerd
 * Author URI: http://codecanyon.net/user/egemenerd
 * License: http://codecanyon.net/licenses
 * Text Domain: exporo
 * Domain Path: /languages
 *
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'EXPORO_VERSION' ) ) {
	define( 'EXPORO_VERSION', '1.0');
}

if ( ! defined( 'EXPORO_PLUGIN_URL' ) ) {
    define( 'EXPORO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

/* ---------------------------------------------------------
Include required files
----------------------------------------------------------- */

if ( file_exists( __DIR__ . '/cmb2/init.php' ) ) {
    require_once(__DIR__ . '/cmb2/init.php');
} else if ( file_exists(  __DIR__ . '/CMB2/init.php' ) ) {
    require_once(__DIR__ . '/CMB2/init.php');
}

require_once __DIR__ . '/vendor/autoload.php';
require_once('settingsClass.php');
require_once('mainClass.php');

/* ---------------------------------------------------------
Pdf File Cache
----------------------------------------------------------- */

$file_cache_check = ExporoSettings::get_option('exporo_file_cache', 'enable');
if ($file_cache_check == 'enable') {
    // Define a hook name for your cleanup event
    if ( ! defined( 'EXPORO_CACHE_CLEANUP_HOOK' ) ) {
        define('EXPORO_CACHE_CLEANUP_HOOK', 'exporo_cleanup_cache_event');
    }
    register_activation_hook( __FILE__, 'exporo_schedule_cleanup' );
    register_deactivation_hook( __FILE__, 'exporo_unschedule_cleanup' );
    // Hook the cleanup function to the custom WP-Cron event
    add_action( EXPORO_CACHE_CLEANUP_HOOK, 'exporo_delete_old_cache_files' );
}

/**
 * Deletes cached mPDF files older than a defined period (e.g., 7 days).
 */
function exporo_delete_old_cache_files() {
    $cache_lifetime = (int) ExporoSettings::get_option('exporo_cache_lifetime', 7);
    $upload_dir = wp_upload_dir();
    $cache_dir  = $upload_dir['basedir'] . '/pdf_cache/';
    
    // Check if the directory exists
    if ( ! is_dir( $cache_dir ) ) {
        return;
    }

    // Define the cache lifetime (e.g., 7 days in seconds)
    $cache_lifetime_seconds = $cache_lifetime * DAY_IN_SECONDS; 
    $cutoff_time            = time() - $cache_lifetime_seconds;
    
    // Scan the directory for files
    $files = scandir( $cache_dir );

    foreach ( $files as $file ) {
        // Skip current ('.') and parent ('..') directory pointers
        if ( in_array( $file, array('.', '..', '.htaccess') ) ) {
            continue;
        }
        $file_path = $cache_dir . $file;
        // Ensure it's a file and not a subdirectory
        if ( is_file( $file_path ) ) {
            // Get the last modification time
            $file_modified_time = filemtime( $file_path );
            
            // Check if the file is older than the cutoff time
            if ( $file_modified_time !== false && $file_modified_time < $cutoff_time ) {
                // Delete the file
                unlink( $file_path ); 
            }
        }
    }
}

/**
 * Clear the scheduled event when the plugin is deactivated.
 */
function exporo_unschedule_cleanup() {
    $timestamp = wp_next_scheduled( EXPORO_CACHE_CLEANUP_HOOK );
    wp_unschedule_event( $timestamp, EXPORO_CACHE_CLEANUP_HOOK );
}

/**
 * Schedule the cache cleanup when the plugin is activated.
 */
function exporo_schedule_cleanup() {
    // Check if the event is already scheduled
    if ( ! wp_next_scheduled( EXPORO_CACHE_CLEANUP_HOOK ) ) {
        // Schedule to run daily. Use 'twicedaily' or 'hourly' if needed.
        wp_schedule_event( time(), 'daily', EXPORO_CACHE_CLEANUP_HOOK );
    }
}

/**
 * Delete Cache Directories
 */
function exporo_delete_directory() {
    $upload_dir = wp_upload_dir();
    $dir_path  = $upload_dir['basedir'] . '/pdf_cache'; 
    if ( ! is_dir( $dir_path ) ) {
        return true;
    }
    $objects = scandir( $dir_path );
    foreach ( $objects as $object ) {
        if ( $object != "." && $object != ".." ) {
            $file_path = $dir_path . '/' . $object;
            
            // Check if the object is a directory
            if ( is_dir( $file_path ) ) {
                // Recursively delete the subdirectory
                exporo_delete_directory( $file_path );
            } else {
                // Delete the file
                unlink( $file_path );
            }
        }
    }
    // Delete the now-empty directory itself
    return rmdir( $dir_path );
}

function exporo_delete_temp_directory() {
    $upload_dir = wp_upload_dir();
    $dir_path  = $upload_dir['basedir'] . '/pdf_temp/mpdf/ttfontdata'; 
    if ( ! is_dir( $dir_path ) ) {
        return true;
    }
    $objects = scandir( $dir_path );
    foreach ( $objects as $object ) {
        if ( $object != "." && $object != ".." ) {
            $file_path = $dir_path . '/' . $object;
            
            // Check if the object is a directory
            if ( is_dir( $file_path ) ) {
                // Recursively delete the subdirectory
                exporo_delete_temp_directory( $file_path );
            } else {
                // Delete the file
                unlink( $file_path );
            }
        }
    }
    // Delete the now-empty directory itself
    return rmdir( $dir_path );
}

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}