<?php
defined( 'ABSPATH' ) || exit;

class ExporoSettings {
    /* The single instance of the class */
	protected static $_instance = null;

    /* Main Instance */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

    /* Constructor */
    public function __construct() {
        add_action( 'cmb2_admin_init', array($this, 'register_metabox') );
        add_action( 'admin_enqueue_scripts',array($this, 'colorpicker_labels'), 99 );
        add_action( 'admin_enqueue_scripts', array($this, 'admin_scripts') );
        add_filter( 'cmb2_override_meta_value', array($this, 'cmb2_override'), 10, 4 );
    }

    /* Admin Scripts */
    public function admin_scripts(){
        if (isset($_GET['page']) && $_GET['page'] == 'exporo_options') {
            wp_enqueue_style('exporo-settings', EXPORO_PLUGIN_URL . 'css/admin-settings.css', false, EXPORO_VERSION);
            wp_enqueue_script('exporo-settings', EXPORO_PLUGIN_URL . 'js/admin-settings.js', array( 'jquery' ), EXPORO_VERSION, true);
        }
    }

    /**
    * Hook in and register a metabox to handle a plugin options page and adds a menu item.
    */
    public function register_metabox() {
        $registered_sizes_array = array();
        $registered_sizes_array['full'] = 'full';
        $registered_sizes = get_intermediate_image_sizes();
        foreach ( $registered_sizes as $registered_size ) {
            $registered_sizes_array[$registered_size] = $registered_size;
        }

        $args = array(
            'id'           => 'exporo_options',
            'title'        => esc_html__('Exporo Settings', 'exporo') . ' <span><a href="https://exporo.website/exporo/documentation/" target="_blank">' . esc_html__( 'Help Docs', 'exporo' ) . ' - v' . EXPORO_VERSION . '<span class="dashicons dashicons-external"></span></a></span>',
            'menu_title'   => esc_html__('Settings', 'exporo'),
            'object_types' => array( 'options-page' ),
            'option_key'   => 'exporo_options',
            'capability'      => 'manage_options',
            'parent_slug'     => 'exporo',
            'save_button'     => esc_html__( 'Save Settings', 'exporo' )
        );

        $options = new_cmb2_box( $args );

        $options->add_field( array(
            'name'    => esc_html__( 'General', 'exporo' ),
            'id'      => 'exporo_general_title',
            'classes'   => array('active'),
            'type' => 'title',
            'before_row' => '<div id="exporo-tabs">',
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'PDF Output', 'exporo' ),
            'id'      => 'exporo_output_title',
            'type' => 'title'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'PDF Creator', 'exporo' ),
            'id'      => 'exporo_creator_title',
            'type' => 'title'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Shortcode', 'exporo' ),
            'id'      => 'exporo_buttonstyles_title',
            'type' => 'title'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Default PDF Settings', 'exporo' ),
            'id'      => 'exporo_properties_title',
            'type' => 'title'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'PDF Styles', 'exporo' ),
            'id'      => 'exporo_styles_title',
            'type' => 'title',
            'after_row' => '</div><div id="exporo-tab-boxes">'
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Is logging in required?', 'exporo' ),
            'description' => esc_html__( 'Do users have to sign in to access the pdf files?', 'exporo' ),
            'id'   => 'exporo_login_required',
            'type' => 'radio_inline',
            'options' => array(
                'yes' => esc_html__( 'Yes', 'exporo' ),
                'no'   => esc_html__( 'No', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'no',
            'before_row' => '<div class="exporo-tab-content active" data-id="exporo-general-title">',
        ) );

        if ( ! function_exists( 'get_editable_roles' ) ) {
            require_once ABSPATH . 'wp-admin/includes/user.php';
        }

        $user_roles = get_editable_roles();
        $user_roles_array = array();

        foreach ($user_roles as $role_name => $role_info) {
            if ($role_name != 'administrator') {
                $user_roles_array[$role_name] = $role_name;
            }
        }

        $options->add_field( array(
            'name'    => esc_html__( 'Restrict Access', 'exporo' ),
            'desc'    => esc_html__( 'If login is required, select the user roles that are granted access to PDF files. Administrators are always granted access.', 'exporo' ),
            'id'      => 'exporo_user_roles',
            'type'    => 'multicheck_inline',
            'options' => $user_roles_array,
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'File Caching', 'exporo' ),
            'description' => esc_html__( 'When enabled, PDF files will be temporarily stored in the "uploads" folder (Front-end requests only). If you get an error, Check WordPress file permissions and maximum file upload limits or turn this setting off.', 'exporo' ),
            'id'      => 'exporo_file_cache',
            'type' => 'radio_inline',
            'options' => array(
                'enable'   => esc_html__( 'Enable', 'exporo' ),
                'disable'   => esc_html__( 'Disable', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'enable',
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'File Cache Lifetime (Days)', 'exporo' ),
            'id'      => 'exporo_cache_lifetime',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 7,
            'after_field' => '<button id="exporo-clear-cache" type="button" class="button-secondary">' . esc_html__( 'Clear Cache', 'exporo' ) . '</button>',
            'after_row' => '</div>'
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Catalog Fields', 'exporo' ),
            'description' => esc_html__( '* For Single Product Only.', 'exporo' ),
            'id'   => 'exporo_catalog_fields',
            'type' => 'multicheck_inline',
            'select_all_button' => true,
            'options' => array(
                'sku'   => esc_html__( 'SKU', 'exporo' ),
                'price'   => esc_html__( 'Price', 'exporo' ),
                'permalink'   => esc_html__( 'Permalink', 'exporo' ),
                'image'   => esc_html__( 'Product Image', 'exporo' ),
                'gallery'   => esc_html__( '*Product Gallery', 'exporo' ),
                'desc'   => esc_html__( '*Product Description', 'exporo' ),
                'short_desc' => esc_html__( 'Short Description', 'exporo' ),
                'cats'   => esc_html__( 'Product Categories', 'exporo' ),
                'tags'   => esc_html__( 'Product Tags', 'exporo' ),
                'brands' => esc_html__( 'Brands', 'exporo' ),
                'attr' => esc_html__( '*Attributes', 'exporo' ),
                'reviews' => esc_html__( '*Reviews', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => array('sku', 'price', 'permalink', 'image', 'desc', 'short_desc', 'cats', 'tags'),
            'before_row' => '<div class="exporo-tab-content" data-id="exporo-output-title">'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Product Image Size', 'exporo' ),
            'id'      => 'exporo_image_size',
            'description' => esc_html__( "It's recommended to use square images (1:1 Ratio).", 'exporo' ) .  ' ' . esc_html__( 'Large images may cause PHP errors depending on your server settings. In this case, reduce the image size or contact your hosting provider to increase PHP limits.', 'exporo' ),
            'type' => 'select',
            'options' => $registered_sizes_array,
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'woocommerce_single',
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Product Gallery Image Sizes', 'exporo' ),
            'id'      => 'exporo_gallery_image_size',
            'description' => esc_html__( 'Large images may cause PHP errors depending on your server settings. In this case, reduce the image size or contact your hosting provider to increase PHP limits.', 'exporo' ),
            'type' => 'select',
            'options' => $registered_sizes_array,
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'large'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Max. Chars', 'exporo' ),
            'description' => esc_html__( 'Maximum number of characters for short product description.', 'exporo' ),
            'id'      => 'exporo_max_chars',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 220
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Site Info', 'exporo' ),
            'description' => esc_html__( 'Include the site title and store url in the header of the PDF file.', 'exporo' ),
            'id'      => 'exporo_site_info',
            'type' => 'radio_inline',
            'options' => array(
                'yes'   => esc_html__( 'Yes', 'exporo' ),
                'no'   => esc_html__( 'No', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'yes'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Credits', 'exporo' ),
            'description' => esc_html__( 'Include credits in the footer of the PDF file.', 'exporo' ),
            'id'      => 'exporo_credits',
            'type' => 'text',
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => '',
            'after_row' => '</div>',
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Admin Table Columns', 'exporo' ),
            'description' => esc_html__( 'ID, name and date fields are required. These are optional fields.', 'exporo' ),
            'id'   => 'exporo_table_columns',
            'type' => 'multicheck_inline',
            'select_all_button' => true,
            'options' => array(
                'sku'   => esc_html__( 'SKU', 'exporo' ),
                'categories'   => esc_html__( 'Product Categories', 'exporo' ),
                'tags'   => esc_html__( 'Product Tags', 'exporo' ),
                'brands' => esc_html__( 'Brands', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => array('categories'),
            'before_row' => '<div class="exporo-tab-content" data-id="exporo-creator-title">'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Admin Table Rows', 'exporo' ),
            'description' => esc_html__( 'The default maximum number of rows to display.', 'exporo' ),
            'id'      => 'exporo_table_rows',
            'type' => 'select',
            'options' => array(
                '10'   => '10',
                '25'   => '25',
                '50'   => '50',
                '100'   => '100'
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => '25'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Download File', 'exporo' ),
            'description' => esc_html__( 'If this setting is enabled, files created with the PDF catalog creator will be downloaded automatically. Otherwise, you can manually download the PDF file opened in the browser.', 'exporo' ),
            'id'      => 'exporo_download_file',
            'type' => 'radio_inline',
            'options' => array(
                'enable'   => esc_html__( 'Enable', 'exporo' ),
                'disable'   => esc_html__( 'Disable', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'disable',
            'after_row' => '</div>'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Shop Button', 'exporo' ),
            'description' => esc_html__( 'Automatically add the shortcode (button) to the WooCommerce shop page just before the product loop.', 'exporo' ),
            'id'      => 'exporo_shop_btn',
            'type' => 'radio_inline',
            'options' => array(
                'yes'   => esc_html__( 'Yes', 'exporo' ),
                'no'   => esc_html__( 'No', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'yes',
            'before_row' => '<div class="exporo-tab-content" data-id="exporo-buttonstyles-title">'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Category Button', 'exporo' ),
            'description' => esc_html__( 'Automatically add the shortcode (button) to the WooCommerce category page just before the product loop.', 'exporo' ),
            'id'      => 'exporo_cat_btn',
            'type' => 'radio_inline',
            'options' => array(
                'yes'   => esc_html__( 'Yes', 'exporo' ),
                'no'   => esc_html__( 'No', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'yes'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Single Product Button', 'exporo' ),
            'description' => esc_html__( 'Automatically add the shortcode (button) to the WooCommerce product page.', 'exporo' ),
            'id'      => 'exporo_single_btn',
            'type' => 'radio_inline',
            'options' => array(
                'yes'   => esc_html__( 'Yes', 'exporo' ),
                'no'   => esc_html__( 'No', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'yes'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Button Color', 'exporo' ),
            'id'      => 'exporo_btn_color',
            'type'    => 'colorpicker',
            'default' => '#FFFFFF',
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Button Background', 'exporo' ),
            'id'      => 'exporo_btn_bg_color',
            'type'    => 'colorpicker',
            'default' => '#000000'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Font Size', 'exporo' ),
            'description' => esc_html__( 'Font size of the button (px).', 'exporo' ),
            'id'      => 'exporo_btn_font_size',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 16
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Font Weight', 'exporo' ),
            'description' => esc_html__( 'Font weight of the button.', 'exporo' ),
            'id'      => 'exporo_font_weight',
            'type' => 'select',
            'options' => array(
                'normal'   => esc_html__( 'Normal', 'exporo' ),
                'bold'   => esc_html__( 'Bold', 'exporo' ),
                'bolder'   => esc_html__( 'Bolder', 'exporo' ),
                'lighter'   => esc_html__( 'Lighter', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'bold'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'H-Padding', 'exporo' ),
            'description' => esc_html__( 'Horizontal padding on the button (px).', 'exporo' ),
            'id'      => 'exporo_btn_h_padding',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 18
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'V-Padding', 'exporo' ),
            'description' => esc_html__( 'Vertical padding on the button (px).', 'exporo' ),
            'id'      => 'exporo_btn_v_padding',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 12
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Border Radius', 'exporo' ),
            'description' => esc_html__( 'Border Radius of the button (px).', 'exporo' ),
            'id'      => 'exporo_btn_radius',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 5,
            'after_row' => '</div>'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Title', 'exporo' ),
            'id'      => 'exporo_default_title',
            'type' => 'text',
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => esc_html__( 'Product Catalog', 'exporo' ),
            'before_row' => '<div class="exporo-tab-content" data-id="exporo-properties-title">'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Subject', 'exporo' ),
            'id'      => 'exporo_default_subject',
            'type' => 'text',
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => ''
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Author', 'exporo' ),
            'id'      => 'exporo_default_author',
            'type' => 'text',
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => ''
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Creator', 'exporo' ),
            'id'      => 'exporo_default_creator',
            'type' => 'text',
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => ''
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Keywords', 'exporo' ),
            'id'      => 'exporo_default_keywords',
            'type' => 'text',
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => ''
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Cover Image', 'exporo' ),
            'description' => esc_html__( 'Recommended image dimentions: 841x1189px or 1682x2378px.', 'exporo' ),
            'id'      => 'exporo_cover_image',
            'type'    => 'file',
            'query_args' => array(
                'type' => array(
                    'image/jpeg',
                    'image/png',
                    'image/webp'
                ),
            ),
            'preview_size' => 'medium',
            'default' => ''
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Catalog Layout', 'exporo' ),
            'id'   => 'exporo_catalog_style',
            'type' => 'radio_inline',
            'options' => array(
                'default' => esc_html__( 'Default', 'exporo' ),
                'table'   => esc_html__( 'Table', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'default'
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Organize by Categories', 'exporo' ),
            'id'   => 'exporo_default_org',
            'type' => 'radio_inline',
            'options' => array(
                'yes' => esc_html__( 'Yes', 'exporo' ),
                'no'   => esc_html__( 'No', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'no',
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Bookmarks', 'exporo' ),
            'id'   => 'exporo_default_bookmarks',
            'type' => 'radio_inline',
            'options' => array(
                'yes' => esc_html__( 'Enable', 'exporo' ),
                'no'   => esc_html__( 'Disable', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'yes',
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Table Of Contents', 'exporo' ),
            'id'   => 'exporo_default_toc',
            'type' => 'radio_inline',
            'options' => array(
                'yes' => esc_html__( 'Enable', 'exporo' ),
                'no'   => esc_html__( 'Disable', 'exporo' )
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'no',
            'after_row' => '</div>'
        ) );

        $options->add_field( array(
            'name' => esc_html__( 'Font Family', 'exporo' ),
            'id'   => 'exporo_font_family',
            'type' => 'select',
            'options' => array(
                'noto' => esc_html__( 'Noto', 'exporo' ),
                'roboto' => esc_html__( 'Roboto', 'exporo' ),
                'opensans' => esc_html__( 'Open Sans', 'exporo' ),
                'lato' => esc_html__( 'Lato', 'exporo' ),
                'dejavusans'   => esc_html__( 'Dejavu Sans', 'exporo' ),
                'dejavuserif'   => esc_html__( 'Dejavu Serif', 'exporo' ),
                'dejavusanscondensed'   => esc_html__( 'Dejavu Condensed', 'exporo' ),
                'dejavuserifcondensed'   => esc_html__( 'Dejavu Serif Condensed', 'exporo' ),
                'dejavusansmono'   => esc_html__( 'Dejavu Mono', 'exporo' ),
                'helvetica' => esc_html__( 'Helvetica', 'exporo' ),
                'times' => esc_html__( 'Times New Roman', 'exporo' ),
                'courier' => esc_html__( 'Courier', 'exporo' ),
            ),
            'attributes' => array(
                'autocomplete' => 'off'
            ),
            'default' => 'yes',
            'before_row' => '<div class="exporo-tab-content" data-id="exporo-styles-title">'
        ) );

         $options->add_field( array(
            'name'    => esc_html__( 'Font Size (pt)', 'exporo' ),
            'id'      => 'exporo_font_size',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 11
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Thumb Size (Table Layout)', 'exporo' ),
            'id'      => 'exporo_thumb_size',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 50
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Image Size (Default Layout)', 'exporo' ),
            'id'      => 'exporo_default_layout_size',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 215
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Image Size (Category Layout)', 'exporo' ),
            'id'      => 'exporo_cat_layout_size',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 200
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Image Size (Single Product)', 'exporo' ),
            'id'      => 'exporo_single_layout_size',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
                'autocomplete' => 'off'
            ),
            'default' => 215
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Heading Color', 'exporo' ),
            'id'      => 'exporo_heading_color',
            'type'    => 'colorpicker',
            'default' => '#212121'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Text Color', 'exporo' ),
            'id'      => 'exporo_text_color',
            'type'    => 'colorpicker',
            'default' => '#424242'
        ) );

        $options->add_field( array(
            'name'    => esc_html__( 'Link Color', 'exporo' ),
            'id'      => 'exporo_link_color',
            'type'    => 'colorpicker',
            'default' => '#212121',
            'after_row' => '</div></div>'
        ) );
    }
    /**
    * Colorpicker Labels
    */
    public function colorpicker_labels( $hook ) {
        global $wp_version;
        if( version_compare( $wp_version, '5.4.2' , '>=' ) ) {
            wp_localize_script(
            'wp-color-picker',
            'wpColorPickerL10n',
            array(
                'clear'            => esc_html__( 'Clear', 'exporo' ),
                'clearAriaLabel'   => esc_html__( 'Clear color', 'exporo' ),
                'defaultString'    => esc_html__( 'Default', 'exporo' ),
                'defaultAriaLabel' => esc_html__( 'Select default color', 'exporo' ),
                'pick'             => esc_html__( 'Select Color', 'exporo' ),
                'defaultLabel'     => esc_html__( 'Color value', 'exporo' )
            )
            );
        }
    }

    /**
    * Set default blank canvas field values
    */
    public function cmb2_override( $value, $object_id, $args, $field ) {
        static $defaults = null;
        if ( 'cmb2_field_no_override_val' !== $value ) {
            return $value;
        }
        // Get the value for the field.
        $data = 'options-page' === $args['type']
        ? cmb2_options( $args['id'] )->get( $args['field_id'] )
        : get_metadata( $args['type'], $args['id'], $args['field_id'], ( $args['single'] || $args['repeat'] ) );
    
        return $value;
    }

    /**
    * Exporo get option
    */
    static function get_option( $key = '', $default = false ) {
        if ( function_exists( 'cmb2_get_option' ) ) {
            return cmb2_get_option( 'exporo_options', $key, $default );
        }
        $opts = get_option( 'exporo_options', $default );
        $val = $default;
        if ( 'all' == $key ) {
            $val = $opts;
        } elseif ( is_array( $opts ) && array_key_exists( $key, $opts ) && false !== $opts[ $key ] ) {
            $val = $opts[ $key ];
        }
        return $val;
    }

}

/**
 * Returns the main instance of the class.
 */
function ExporoSettings() {  
	return ExporoSettings::instance();
}
// Global for backwards compatibility.
$GLOBALS['ExporoSettings'] = ExporoSettings();