<?php
/* ver 2.8.71 */
// Prevent direct access to this file.
if (!defined('ABSPATH')) {
    header('HTTP/1.0 403 Forbidden');
    echo '404 File Not Found';
    exit; // Exit if accessed directly
}
//redundancy with alt instruction
defined('ABSPATH') or die();

//prevent redundant loading if WP is loaded more than once
if (defined('GFAF_PLUGIN_LOGIC_FILE')) {
	exit;
}

// Main file path
define('GFAF_PLUGIN_LOGIC_FILE', __FILE__);

// Set variable for admin page url
define('GFAF_ADMIN', admin_url('options-general.php?page=gravity-forms-auto-formatter'));

// ADD 'Settings' Link
function gfaf_settings_link($links, $file) {
    if($file == plugin_basename(GFAF_PLUGIN_FILE) && function_exists('admin_url') ) {
        $settings_link = '<a href="' . GFAF_ADMIN . '">' . __('Settings') . '</a>';
        array_unshift( $links, $settings_link );
    }
    return $links;
}
add_filter('plugin_action_links', 'gfaf_settings_link', 10, 2);

/*GFORMS AUTO FORMATTER JS AND CSS LOAD*/
add_action('gform_enqueue_scripts', 'enqueue_custom_script', 30, 2);
function enqueue_custom_script($form, $is_ajax) {
	wp_enqueue_script('custom_script', plugin_dir_url(__FILE__)  . 'js/gravity-forms-auto-formatter.js');
	wp_register_style('gfafstyle', plugin_dir_url(__FILE__) . 'includes/gfaf.css');
    wp_enqueue_style('gfafstyle');
}

/*GET FIELD HELPER FUNCTION FOR GF 2.3 GFAPI CHANGE*/
function gfaf_get_field($form, $field_id) {
	$field = false;
	if (is_numeric($field_id)) {
		if (method_exists('GFAPI', 'get_field')) {
			$field = GFAPI::get_field($form, $field_id);
		} else {
			$field = GFFormsModel::get_field($form, $field_id);
		}
	}
	return $field;
}

/* IMPROVED SORTING OF ACCENTED CHARS FOR UPPERCASE DROPDOWNS ETC. */
add_filter('gform_countries', function($countries) {
    if (!class_exists('Collator')) {
        return $countries;
    }
    $collated = new Collator(get_user_locale());
    $collated->asort($countries);
    return $countries;
});

add_filter('gform_pre_render', 'gfaf_pre_case_countries');
add_filter('gform_pre_validation', 'gfaf_pre_case_countries');
add_filter('gform_pre_submission_filter', 'gfaf_pre_case_countries');
add_filter('gform_admin_pre_render', 'gfaf_pre_case_countries');
function gfaf_pre_case_countries($form) {
    foreach ($form['fields'] as $field) {
        if ($field->type == 'address' && ($field->gfafuppercaseField || $field->gfaflowercaseField || $field->gfafucfirstletterField)) {
            $casetype = $field->gfafuppercaseField ? 'upper' : false;
            $casetype = $field->gfaflowercaseField ? 'lower' : $casetype;
            $casetype = $field->gfafucfirstletterField ? 'firstletter' : $casetype;
            gfaf_case_countries($casetype);
        }
    }
  return $form;
}

/* CASE MATCHED ENTRY EDIT SORTING OF ACCENTED CHARS FOR CASE MODIFIED DROPDOWNS ETC. - only allows for last address field formating - cannot format address countries individually */
function gfaf_case_countries($casetype) {
    if ($casetype == 'upper') {
        add_filter('gform_countries', function($countries) {
            $CASE_Countries = array();
            foreach ($countries as $country) {
                $CASE_Countries[] = mb_strtoupper($country);
            }
            return $CASE_Countries;
        }, 9999999999, 1);
    }
    if ($casetype == 'lower') {
        add_filter('gform_countries', function($countries) {
            $CASE_Countries = array();
            foreach ($countries as $country) {
                $CASE_Countries[] = mb_strtolower($country);
            }
            return $CASE_Countries;
        }, 9999999999, 1);
    }
    if ($casetype == 'firstletter') {
        add_filter('gform_countries', function($countries) {
            $CASE_Countries = array();
            foreach ($countries as $country) {
                $CASE_Countries[] = mb_convert_case(mb_substr($country, 0, 1), MB_CASE_TITLE, 'UTF-8') . mb_substr(mb_strtolower($country), 1);
            }
            return $CASE_Countries;
        }, 9999999999, 1);
    }
}

/*GFORM AUTO FORMATTER VALIDATE DATA LOGIC*/
add_filter('gform_validation', 'gfaf_validate');
function gfaf_validate($validation_result) {
    //prevent redundant loading
    if (function_exists('gfaf_blacklist_check')) {
        return $validation_result;
    }
	$form 			= $validation_result['form'];
	$current_page	= rgpost('gform_source_page_number_' . $form['id']) ? rgpost('gform_source_page_number_' . $form['id']) : 1;

	///GFAF BLACKLIST CHECK
	function gfaf_blacklist_check($input, $central_blacklist, $field_blacklist) {
		//$input				= sanitize_text_field(mb_strtolower($input));
		$blacklist 			= get_option('gfaf_blacklist');
		$blacklist 			= explode(',', $blacklist);
		$blacklist_strict	= get_option('gfaf_blacklist_strict');
		$blacklist_strict	= explode(',', $blacklist_strict);
		$field_blacklist	= explode(',', $field_blacklist);
		$blockedlist 		= '';
		if ($blacklist && $central_blacklist) {
			foreach($blacklist as $term) {
				if ($term === '') {
					continue;
				}
				$safe_term 	= sanitize_text_field(mb_strtolower($term));
                $safe_input = sanitize_text_field(mb_strtolower($input));
				if (preg_match("/\b$safe_term\b/", $safe_input, $matches)) {
					$blockedlist .= $safe_term . '<br/>';
				}
			}
		}
		if ($blacklist_strict && $central_blacklist) {
			foreach($blacklist_strict as $term) {
				if ($term === '') {
					continue;
				}
				$term 	= mb_strtolower($term);
				$term 	= str_replace('*comma*', ',', $term);
				$nono	= strpos(mb_strtolower($input), $term);
				if ($nono !== false ) {
					$blockedlist .= $term . '<br/>';
				} 
			}
		}
		if ($field_blacklist) {
			foreach($field_blacklist as $term) {
				if ($term === '') {
					continue;
				}
				$term 	= mb_strtolower($term);
				$term 	= str_replace('*comma*', ',', $term);
				$nono	= strpos(mb_strtolower($input), $term);
				if ($nono !== false ) {
					$blockedlist .= $term . '<br/>';
				} 
			}
		}
		if ($blockedlist !== '') {
			return array('blacklist', $blockedlist);
		}
		return 'blacklist pass';
	}
    
    //GFAF ONLY SPECIFIED CHARACTERS CHECK
	function gfaf_specified_char_check($input, $field) {
        if (isset($field->gfafspecifiedonlyField) && $field->gfafspecifiedonlyField) {
			$specifiedcharstocheck = str_replace('u0022', '"', $field->gfafspecifiedonlyField);  // comma unicode correction
            $specifiedcharstocheck = str_split($specifiedcharstocheck, 1);
            foreach($specifiedcharstocheck as $key => $specifiedchar) {
                $specifiedcharstocheck[$key] = preg_quote($specifiedchar);
            }
            $specifiedcharstocheck = implode("", $specifiedcharstocheck);
            return !preg_match("/[^$specifiedcharstocheck]+/", $input);
        } else {
            return true;
        }
    }
	
	//MIN CHARACTER CHECK FUNCTION
	function gfaf_min_char_check($input, $field) {
		if  (isset($field->gfafmincharField) && intval($field->gfafmincharField) != 0) {
			if (strlen($input) < intval($field->gfafmincharField)) {
				return false;
			} else {
				return true;
			}
		}
		return true;
	}
	
	foreach($form['fields'] as &$field) {
		$page 			 	= $field->pageNumber;
		$hidden 			= RGFormsModel::is_field_hidden($form, $field, array());
		if ($page != $current_page || $hidden) {
			continue;
		}
		$valid 			 	= true;
		$inputs 		 	= false;
		$central_blacklist  = $field->gfafblacklistField ? true : false;
		$field_blacklist	= $field->gfafblacklist2Field ? $field->gfafblacklist2Field : false;
		
		if ($field->type == 'text' || $field->type == 'textarea' || $field->type == 'email' || $field->type == 'website' || $field->type == 'phone' || $field->type == 'number' || $field->type == 'post_title' || $field->type == 'post_content' || $field->type == 'post_excerpt' || $field->type == 'post_tags' || $field->type == 'post_custom_field') {
			$input = rgpost("input_{$field['id']}");
            //BLACKLIST CHECK
			if ($central_blacklist || $field_blacklist) {
				$valid = gfaf_blacklist_check($input, $central_blacklist, $field_blacklist);
				if (is_array($valid) && in_array('blacklist', $valid)){
					$validation_result['is_valid'] 	= false;
					$field->failed_validation 		= true;
					$field->validation_message ? $field->validation_message .= '<br/><br/>' : $field->validation_message = '';
					$gfaf_blacklist_message 		= 'You have used a term or phrase that is not allowed.';

					if (get_option('gfaf_blacklist_validation_message')) {
						$gfaf_blacklist_message 	= esc_html__(get_option('gfaf_blacklist_validation_message'));
					}

					$field->validation_message		.= $gfaf_blacklist_message;

					if (get_option('gfaf_blacklist_reveal_terms')) {
						$message 					= '<br/><b>Please remove the following terms/phrases:</b><br/>' . $valid[1];

						if (get_option('gfaf_blacklist_reveal_terms_message')) {
							$message				= '<br/><b>' . esc_html__(get_option('gfaf_blacklist_reveal_terms_message')) . '</b><br/>' . $valid[1];
						}
						$field->validation_message .= $message;
					}
				}
			}
            
            //SPECIFIED CHAR CHECK
            $specifiedchars = gfaf_specified_char_check($input, $field);
            if ($specifiedchars == false) {
                $validation_result['is_valid'] 	= false;
                $field->failed_validation 		= true;
                $field->validation_message ? $field->validation_message .= '<br/>' : $field->validation_message = '';
				$specifiedcharstocheck = str_replace('u0022', '"', $field->gfafspecifiedonlyField); // comma unicode correction
                $field->validation_message 		.= 'This input only accepts the following characters:<br/>' . $specifiedcharstocheck;
            }
			
			//MIN CHAR CHECK
			$minchars = gfaf_min_char_check($input, $field);
			if ($minchars === false) {
				$validation_result['is_valid'] 	= false;
				$field->failed_validation 		= true;
				$field->validation_message ? $field->validation_message .= '<br/>' : $field->validation_message = '';
				$field->validation_message 		.= 'This input requires a minimum of ' . $field->gfafmincharField . ' characters.';
			}
			
			//CANNOT MATCH INPUTS
			if ($field->gfafnomatchField) {//CHECK FIELD TYPES
				$field_match_values = array();
				$field_match_names  = '';
				$field_matches 		= explode(',', $field->gfafnomatchField);
				foreach ($field_matches as $field_id){
					array_push($field_match_values, rgpost('input_' . $field_id . ''));
					foreach ($form['fields'] as $field_find_id) {
						if ($field_id == $field_find_id->id) {
							$field_match_names .= $field_find_id->label . ', ';
						}
					}
				}
				if (in_array($input, $field_match_values)){
					$validation_result['is_valid'] 	= false;
					$field->failed_validation 		= true;
					$field->validation_message ? $field->validation_message .= '<br/>' : $field->validation_message = '';
					$field->validation_message 		.= 'This input can not match the following inputs: ' . $field_match_names;
				}
			}
			
			//MUST MATCH INPUTS
			if ($field->gfafyesmatchField) {//CHECK FIELD TYPES
				$field_match 		= $field->gfafyesmatchField;
				$field_match_names  = '';
				foreach ($form['fields'] as $field_find_id) {
					if ($field_match == $field_find_id->id) {
						$field_match_names .= $field_find_id->label;
					}
				}
				if (rgpost('input_' . $field->id . '') !== rgpost('input_' . $field_match . '')) {
					$validation_result['is_valid'] 	= false;
					$field->failed_validation 		= true;
					$field->validation_message ? $field->validation_message .= '<br/>' : $field->validation_message = '';
					$field->validation_message 		.= 'This input must match the following input: ' . $field_match_names;
				}
			}
		}
		if ($field->type == 'address') {
			$address 	= '';			
			$inputs 	= $field->inputs;
			foreach ($inputs as $input) {
				$input_id = strval($input['id']);
				$input_id = str_replace(".", "_", $input_id);
				$address .= rgpost("input_" . $input_id) . ' ';
			}
            //BLACKLIST CHECK
			if ($central_blacklist || $field_blacklist) {
				$valid = gfaf_blacklist_check($address, $central_blacklist, $field_blacklist);
				if (is_array($valid) && in_array('blacklist', $valid)){
					$validation_result['is_valid'] 	= false;
					$field->failed_validation 		= true;
					$field->validation_message ? $field->validation_message .= '<br/><br/>' : $field->validation_message = '';
					$gfaf_blacklist_message 		= 'You have used a term or phrase that is not allowed.';

					if (get_option('gfaf_blacklist_validation_message')) {
						$gfaf_blacklist_message 	= esc_html__(get_option('gfaf_blacklist_validation_message'));
					}

					$field->validation_message		.= $gfaf_blacklist_message;

					if (get_option('gfaf_blacklist_reveal_terms')) {
						$message 					= '<br/><b>Please remove the following terms/phrases:</b><br/>' . $valid[1];

						if (get_option('gfaf_blacklist_reveal_terms_message')) {
							$message				= '<br/><b>' . esc_html__(get_option('gfaf_blacklist_reveal_terms_message')) . '</b><br/>' . $valid[1];
						}
						$field->validation_message .= $message;
					}
				}
			}
		}
		if ($field->type == 'name') {
			$name = '';
			$inputs 	= $field->inputs;
			foreach ($inputs as $input) {
				$input_id = strval($input['id']);
				$input_id = str_replace(".", "_", $input_id);
				$name .= rgpost("input_" . $input_id) . ' ';
			}
            //BLACKLIST CHECK
			if ($central_blacklist || $field_blacklist) {
				$valid = gfaf_blacklist_check($name, $central_blacklist, $field_blacklist);
				if (is_array($valid) && in_array('blacklist', $valid)){
					$validation_result['is_valid'] 	= false;
					$field->failed_validation 		= true;
					$field->validation_message ? $field->validation_message .= '<br/><br/>' : $field->validation_message = '';
					$gfaf_blacklist_message 		= 'You have used a term or phrase that is not allowed.';

					if (get_option('gfaf_blacklist_validation_message')) {
						$gfaf_blacklist_message 	= esc_html__(get_option('gfaf_blacklist_validation_message'));
					}

					$field->validation_message		.= $gfaf_blacklist_message;

					if (get_option('gfaf_blacklist_reveal_terms')) {
						$message 					= '<br/><b>Please remove the following terms/phrases:</b><br/>' . $valid[1];

						if (get_option('gfaf_blacklist_reveal_terms_message')) {
							$message				= '<br/><b>' . esc_html__(get_option('gfaf_blacklist_reveal_terms_message')) . '</b><br/>' . $valid[1];
						}
						$field->validation_message .= $message;
					}
				}
			}
		}
		if ($field->type == 'list') {
			$input 				= rgpost("input_{$field['id']}");
			$minchars_failed 	= false;
			$blacklist_list		= false;	
			foreach ($input as $list_values_inner) {
				if (is_array($list_values_inner)) {
					foreach ($list_values_inner as $key => &$the_value) {
						$minchars = gfaf_min_char_check($the_value, $field);
						$minchars ? false : $minchars_failed = true;
						if ($central_blacklist || $field_blacklist) {
							$valid = gfaf_blacklist_check($the_value, $central_blacklist, $field_blacklist);
							if (is_array($valid) && in_array('blacklist', $valid)){
								$validation_result['is_valid'] 	= false;
								$field->failed_validation 		= true;
								isset($blacklist_list) ? $blacklist_list .= $valid[1] : $blacklist_list = $valid[1];
							}
						}
					}
				} else {
					gfaf_min_char_check($list_values_inner, $field);
					$minchars = gfaf_min_char_check($list_values_inner, $field);
					$minchars ? false : $minchars_failed = true;
					if ($central_blacklist || $field_blacklist) {
						$valid = gfaf_blacklist_check($list_values_inner, $central_blacklist, $field_blacklist);
						if (is_array($valid) && in_array('blacklist', $valid)){
							$validation_result['is_valid'] 	= false;
							$field->failed_validation 		= true;
							isset($blacklist_list) ? $blacklist_list .= $valid[1] : $blacklist_list = $valid[1];
						}
					}
				}
			}
			if($blacklist_list) {
				$field->validation_message ? $field->validation_message .= '<br/><br/>' : $field->validation_message = '';
				$gfaf_blacklist_message 		= 'You have used a term or phrase that is not allowed.';

				if (get_option('gfaf_blacklist_validation_message')) {
					$gfaf_blacklist_message 	= esc_html__(get_option('gfaf_blacklist_validation_message'));
				}

				$field->validation_message		.= $gfaf_blacklist_message;

				if (get_option('gfaf_blacklist_reveal_terms')) {
					$message 					= '<br/><b>Please remove the following terms/phrases:</b><br/>' . $blacklist_list;

					if (get_option('gfaf_blacklist_reveal_terms_message')) {
						$message				= '<br/><b>' . esc_html__(get_option('gfaf_blacklist_reveal_terms_message')) . '</b><br/>' . $blacklist_list;
					}
					$field->validation_message .= $message;
				}
			}
			if ($minchars_failed === true) {
				$validation_result['is_valid'] 	= false;
				$field->failed_validation 		= true;
				$field->validation_message ? $field->validation_message .= '<br/>' : $field->validation_message = '';
				$field->validation_message 		.= 'Each of these inputs requires a minimum of ' . $field->gfafmincharField . ' characters.';
			}
		}
	}
	$validation_result['form'] = $form;
	return $validation_result;
}


// CLEAR FIELDS BY CSS ON VALIDATION ERROR
add_action('gform_validation_failed', 'gfaf_clear_on_failed_validation', 10, 2); 
function gfaf_clear_on_failed_validation($form, $validation_errors) {
    if (isset($validation_errors)) {
        // Select fields by CSS
        jQuery('.clear_failed input, .clear_failed textarea').val(''); 
    }
}


function gfaf_text_replace_1($value, $field) {
    if ($field->gfaftextreplaceField) {
        $text_replace			= get_option('gfaf_text_replace');
        $strict_text_replace	= get_option('gfaf_strict_text_replace');
        if ($text_replace) {
            $text_replace		= explode(',', $text_replace);
            foreach($text_replace as $text_to_replace) {
                $replacement_format	= explode('::>', $text_to_replace);
                $search_text		= isset($replacement_format[0]) ? $replacement_format[0] : false;
                $replacement_text	= isset($replacement_format[1]) ? $replacement_format[1] : false;
                if (preg_match("/\b$search_text\b/", $value, $matches) && $search_text && $replacement_text) {
                    $replacement_text	= $replacement_text === '*remove*' ? '' : $replacement_text;
                    //$value 				= str_replace($search_text, $replacement_text, $value);
                    $value				= preg_replace('/\b' . esc_html__($search_text) . '\b/u', esc_html__($replacement_text), $value);
                }
            }

        }
        if ($strict_text_replace) {
            $strict_text_replace = explode(',', $strict_text_replace);
            foreach($strict_text_replace as $text_to_replace) {
                $replacement_format		= explode('::>', $text_to_replace);
                $search_text			= isset($replacement_format[0]) ? $replacement_format[0] : false;
                $replacement_text		= isset($replacement_format[1]) ? $replacement_format[1] : false;
                if ($search_text && $replacement_text) {
                    $search_text		= str_replace('*comma*', ',', $search_text);
                    $replacement_text 	=str_replace('*comma*', ',', $replacement_text);
                    if (strpos($value, $search_text) !== false) {
                        $replacement_text	= $replacement_text === '*remove*' ? '' : $replacement_text;
                        $value 				= str_replace($search_text, esc_html__($replacement_text), $value);
                    }
                }
            }
        }
    }
    return $value;
}


function gfaf_text_replace_2($value,$field) {
    if ($field->gfaftextreplace2Field) {
        $field_text_replace2 = explode(',', $field->gfaftextreplace2Field);
        foreach($field_text_replace2 as $text_to_replace) {
            $replacement_format		= explode('::>', $text_to_replace);
            $search_text			= isset($replacement_format[0]) ? $replacement_format[0] : false;
            $replacement_text		= isset($replacement_format[1]) ? $replacement_format[1] : false;
            if ($search_text && $replacement_text) {
                $search_text		= str_replace('*comma*', ',', $search_text);
                $replacement_text 	=str_replace('*comma*', ',', $replacement_text);
                if (strpos($value, $search_text) !== false) {
                    $replacement_text	= $replacement_text === '*remove*' ? '' : $replacement_text;
                    $value 				= str_replace($search_text, esc_html__($replacement_text), $value);
                }
            }
        }
    }
    return $value;
}


/*GFORM AUTO FORMATTER FIELD DATA FORMAT LOGIC*/
function gfaf_saved_value_process($value, $field) {
    $value = gfaf_text_replace_1($value, $field);
    $value = gfaf_text_replace_2($value, $field);
	if ($field->gfafremovelinksField) {
		$value = preg_replace('/<a(.*?)>/', "\\2", $value);
		$value = preg_replace('/<(.*?)a>/', "\\2", $value);
		$value = preg_replace('/<A(.*?)>/', "\\2", $value);
		$value = preg_replace('/<(.*?)A>/', "\\2", $value);
	}
	if ($field->gfafremovehtmlField) {
		$value = esc_html__(strip_tags($value));
		//$value = preg_replace('/<(.*?)>/', "\\2", $value);
	}
	if ($field->gfafuppercaseField) {
		$value = mb_strtoupper($value);
	}
	if ($field->gfaflowercaseField) {
		$value = mb_strtolower($value);
	}
	if ($field->gfafucfirstletterField) { 
		$value = mb_strtolower($value);
		$value = mb_convert_case(mb_substr($value, 0, 1), MB_CASE_TITLE, 'UTF-8') . mb_substr($value, 1);
	}
	if ($field->gfafucfirstlettersField) {
		$value = mb_convert_case(mb_strtolower($value), MB_CASE_TITLE, 'UTF-8');
	}
    if ($field->gfafalphanumericonlyField) {
		$value = preg_replace('/[^A-Za-z0-9]/', '', $value);
	}
    if ($field->gfafenglishonlyField) {
		$value = preg_replace('/[^A-Za-z0-9.,!?' . "'" . '\s]/', '', $value);
	}
	if ($field->gfafbeforeField) {
		$before	= $field->gfafbeforeField;
		if (mb_substr($value, 0, strlen($before)) !== $before) {
			$value 	= esc_html__($field->gfafbeforeField) . $value;
		}
	}
	if ($field->gfafafterField) {
		$after	= $field->gfafafterField;
		if (mb_substr($value, -strlen($after), strlen($after)) !== $after) {
			$value = $value . esc_html__($field->gfafafterField);
		}
	}
    $value = gfaf_text_replace_1($value, $field);
    $value = gfaf_text_replace_2($value, $field);
	return $value;
}

/*GFORM AUTO FORMATTER SAVE VALUE*/
add_filter('gform_save_field_value', 'gfaf_auto_format_field_value', 1, 4);
function gfaf_auto_format_field_value($value, $lead, $field, $form) {
	if (($value || $value === 0 || $value === '0') && !get_option('gfe_encrypt_decrypt') && (mb_substr($value, 0, 11) !== 'GFEncrypt: ')) {
		/*REGULAR FIELD PROCESSING*/
		if ($field->type != 'list') {
			$value = gfaf_saved_value_process($value, $field);
		} else {
		/*LIST FIELD PROCESSING*/
			$list_values = unserialize($value);
			foreach ($list_values as &$list_values_inner) {
				if (is_array($list_values_inner)) {
					foreach ($list_values_inner as $key => &$the_value) {
						$the_value = gfaf_saved_value_process($the_value, $field);
					}
				} else {
					$list_values_inner = gfaf_saved_value_process($list_values_inner, $field);
				}
			}
			$list_values = maybe_serialize($list_values);
			$value =  $list_values;
		} 
		return $value;
	} else {
		return($value);
	}
}

/*GFORMS AUTO FORMATTER READ ONLY FIELDS -- FIELDS SETTINGS WITH CSS*/
add_filter('gform_field_css_class', 'gfaf_custom_classes', 10, 3);
function gfaf_custom_classes($classes, $field, $form) {
    if ($field->gfafreadonlyField) {
        $classes .= ' gfafreadonly gfaflockdown';
    }
	if ($field->gfafdisabledField) {
        $classes .= ' gfafdisabled gfaflockdown gfaflockedup';
    }
	if ($field->gfafautocompleteoffField) {
        $classes .= ' gfafautocompleteoff';
    }
	if ($field->gfafnumericonlyField) {
        $classes .= ' gfafnumericonly';
    }
	if ($field->gfafalphaonlyField) {
        $classes .= ' gfafalphaonly';
    }
	if ($field->gfafalphanumericonlyField) {
        $classes .= ' gfafalphanumericonly';
    }
    if ($field->gfafenglishonlyField) {
        $classes .= ' gfafenglishonly';
    }
    if ($field->gfafucfirstletterField) {
        $classes .= ' gfafucfirstletter';
    }
	if ($field->gfaftextarearowsField || $field->gfaftextarearowsField === "0") {
        $classes .= $field->gfaftextarearowsField === "0" ? ' gfaftextarearowsauto' : ' gfaftextarearows';
    }
	if ($field->gfafobscureField || $field->gfaftoggleobscureField) {
        $classes .= ' gfafobscure';
    }
    return $classes;
}

/*GFORM FIELD CONTENT FILTER - FIELD SETTINGS WITH HTML/JS*/
add_filter( 'gform_field_content', 'gfaf_subsection_field', 10, 5 );
function gfaf_subsection_field($content, $field, $value, $lead_id, $form_id) {
    $form        = GFAPI::get_form($form_id);
	//text area rows
	if ($field->gfaftextarearowsField === "0" && !$field->is_form_editor()) {
		if (strpos($content, 'style="') !== false) { //check for oninput and update if exists or create if not
			$content = str_replace('style="', 'style="field-sizing: content; ', $content);
			$content = str_replace('rows=', 'ignore=', $content);
		} else {
			$content = str_replace('rows=', 'style="field-sizing: content;" ignore=', $content);
		}
	}
    if ($field->gfaftextarearowsField && !$field->is_form_editor()) {
		$gfaf_text_rows = intval($field->gfaftextarearowsField);
		$content = str_replace('name=', 'rows="' . $gfaf_text_rows . '" name=', $content);
    }
	//max chars
    if ($field->gfafmaxcharField && !$field->is_form_editor()) {
		$gfaf_max_chars = intval($field->gfafmaxcharField);
		$content = str_replace('type=', 'maxlength="' . $gfaf_max_chars . '" type=', $content);
    }
	//numeric only
	if ($field->gfafnumericonlyField && !$field->is_form_editor()) {
        if ($field->type != 'phone') {
            $content = str_replace('type=', 'onkeypress="return event.charCode >= 48 && event.charCode <= 57" oninput="this.value=this.value.replace(/[^0-9]/g,' . "''" . ');" " type=', $content);
        } else { //phone field type allow plus sign for international numbers
            $content = str_replace('type=', 'onkeypress="return event.charCode >= 48 && event.charCode <= 57 || event.charCode == 43" oninput="this.value=this.value.replace(/[^0-9|\+]/g,' . "''" . ');" type=', $content);
        }
    }
	//alpha only
	if ($field->gfafalphaonlyField && !$field->is_form_editor()) {
		$content = str_replace('name=', 'onkeypress="return event.charCode >= 65 && event.charCode <= 90 || event.charCode >= 97 && event.charCode <= 122" oninput="this.value=this.value.replace(/[^A-Za-z]+$/,' . "''" . ');" name=', $content);
    }
	//alpha-numeric only
	if ($field->gfafalphanumericonlyField && !$field->is_form_editor()) {
		$content = str_replace('name=', 'onkeypress="return event.charCode >= 65 && event.charCode <= 90 || event.charCode >= 97 && event.charCode <= 122 || event.charCode >= 48 && event.charCode <= 57" oninput="this.value=this.value.replace(/[^A-Za-z0-9]+$/,' . "''" . ');" name=', $content);
    }
    //english only
	if ($field->gfafenglishonlyField && !$field->is_form_editor()) {
		if (strpos($content, 'oninput="') !== false) { //check for oninput and update if exists or create if not
			$content = str_replace('oninput="', 'oninput="this.value=this.value.replace(/[^A-Za-z0-9.,!?' . "'" . '\s]/g,' . "''" . ');" ', $content);
		} else {
			$content = str_replace('name=', 'oninput="this.value=this.value.replace(/[^A-Za-z0-9.,!?' . "'" . '\s]/g,' . "''" . ');" name=', $content);
		}
    }
	//specified only
	if ($field->gfafspecifiedonlyField) {
		$chars = preg_quote($field->gfafspecifiedonlyField, 'u0022');
		if (strpos($content, 'oninput="') !== false) { //check for oninput and update if exists or create if not
			$content = str_replace('oninput="', 'oninput="this.value=this.value.replace(/[^' . $chars . ']/g,' . "''" . ');" ', $content);
		} else {
			$content = str_replace('name=', 'oninput="this.value=this.value.replace(/[^' . $chars . ']/g,' . "''" . ');" name=', $content);
		}
	}
    //upper-case
    if ($field->gfafuppercaseField && !$field->is_form_editor()) {
		$content = str_replace('name=', 'style="text-transform:uppercase !important;" name=', $content);
    }
    //lower-case
    if ($field->gfaflowercaseField && !$field->is_form_editor()) {
		$content = str_replace('name=', 'style="text-transform:lowercase !important;" name=', $content);
    }
    //first-letters-upper-case
    if ($field->gfafucfirstlettersField && !$field->is_form_editor()) {
		$content = str_replace('name=', 'style="text-transform:capitalize !important;" name=', $content);
    }
    //first-letter-upper-case
    if ($field->gfafucfirstletterField && !$field->is_form_editor()) {
        if (strpos($content, 'oninput="') !== false) { //check for oninput and update if exists or create if not 
            $content = str_replace('oninput="', 'oninput="this.value=this.value.substr(0,1).toUpperCase()+this.value.substr(1).toLowerCase(); ', $content);
        } else {
            $content = str_replace('name=', 'oninput="this.value=this.value.substr(0,1).toUpperCase()+this.value.substr(1).toLowerCase();" name=', $content);
        }
    }
	//obscure text select box
	if ($field->gfaftoggleobscureField && !$field->is_form_editor() && !$field->is_entry_detail() && !$field->is_entry_detail_edit()) {
		$content = $content . '<input type="checkbox" id="field_gfaf_toggle_obscure_' . $field->id . '" class="gfaf_toggle_obscure_checkbox" form-id="' . $form_id . '" field-id="' . $field->id . '"/> show ' . $field->label;
    }
	//spellcheck off
	if ($field->gfafspellcheckoffField && !$field->is_form_editor()) {
		$content = str_replace('name=', 'spellcheck="false" name=', $content);
    }
    //MANUAL COPY INPUT
    if ($field->gfafprepopulate2Field) {
        if (!$field->is_form_editor() && !$field->is_entry_detail() && !$field->is_entry_detail_edit()) {
            $prepopfield = gfaf_get_field($form, trim(esc_html($field->gfafprepopulate2Field)));
            if (!$prepopfield || (!$prepopfield->type == 'text' || !$prepopfield->type == 'textarea' || !$prepopfield->type == 'email' || !$prepopfield->type == 'website' || !$prepopfield->type == 'phone' || !$prepopfield->type == 'number' || !$prepopfield->type == 'select' || !$prepopfield->type == 'post_title' || !$prepopfield->type == 'post_content' || !$prepopfield->type == 'post_excerpt' || !$prepopfield->type == 'post_custom_field' || !$prepopfield->type == 'name' || !$prepopfield->type == 'address')) {
                return $content;
            }
            $copyvaltext = $field->gfafprepopulatetextField ? esc_html($field->gfafprepopulatetextField) : 'copy ' . $prepopfield->label;
            
            if ($field->inputs && $field->type === $prepopfield->type && ($prepopfield->type == 'name' || $prepopfield->type == 'address')) {
                $inputs     = $field->inputs;
                $js_input   = '';
                $js_clear   = '';
                foreach ($inputs as $input) {
                    $input_id   = explode('.', $input['id'])[1];
                    if ($input_id) {
                        $js_input  .= 'if (document.getElementById("input_' . $form_id . '_' . $field->id . '_' . $input_id . '")) { document.getElementById("input_' . $form_id . '_' . $field->id . '_' . $input_id . '").value = document.getElementById("input_' . $form_id . '_' . $field->gfafprepopulate2Field . '_' . $input_id . '").value ? document.getElementById("input_' . $form_id . '_' . $field->gfafprepopulate2Field . '_' . $input_id . '").value : "";}';
                        $js_clear  .= 'if (document.getElementById("input_' . $form_id . '_' . $field->id . '_' . $input_id . '")) { document.getElementById("input_' . $form_id . '_' . $field->id . '_' . $input_id . '").value = "";}';
                    }
                }
                $js_output  = "'if (this.checked) { " . $js_input . " } else { " . $js_clear . " }'";
                $content    = str_replace('<div class=' . "'" . 'ginput_complex', '</label><br/><input type="checkbox" id="gfafprepopulate2Field_' . $field->id . '" name="gfafprepopulate2Field_' . $field->id . '" value="1" onclick=' . $js_output . '/> ' . $copyvaltext . '<br/><div class=' . "'" . 'ginput_complex', $content);
            } else {
                $singleinput = "'this.checked ? gfafPrePopfield(" . $form_id . ", " . $field->gfafprepopulate2Field . ", " . $field->id . ") : document.getElementById(" . '"' ."input_" . $form_id . "_" . $field->id . "" . '"' .").value = " . '""' .";'";
                $content = str_replace('</label>', '</label><br/><input type="checkbox" id="gfafprepopulate2Field_' . $field->id . '" name="gfafprepopulate2Field_' . $field->id . '" value="1" onclick=' . $singleinput . '/> ' . $copyvaltext . '<br/>', $content);
            }
        }
    }
    return $content;
}

/*GFORMS AUTO FORMATTER REVIEW PAGE*/
add_filter('gform_review_page', 'add_review_page', 10, 3);
function add_review_page($review_page, $form, $entry) {
    if (isset($form['gfafreviewpage']) && $form['gfafreviewpage']) {
        $review_page['is_enabled'] = true;
        $review_page['nextButton']['text'] = $form['gfafreviewbuttontext'] ? esc_html($form['gfafreviewbuttontext']) : 'Review & Submit';
        $review_page['content'] = GFCommon::replace_variables('{all_fields}', $form, $entry);
        return $review_page;
    }
}

//GFORMS AUTO FORMATTER AUTO COPY INPUT 
add_filter('gform_get_form_filter', 'gfaf_main_form_filter', 10, 2);
function gfaf_main_form_filter($form_string, $form) {
    //javascript 
    $form_string = '<script type="text/javascript">
        var gfafPrePopfield = function(formid, fromfield, tofield, inputid) {
            if (!inputid) {
                document.getElementById("input_" + formid + "_" + tofield).value = document.getElementById("input_" + formid + "_" + fromfield).value ? document.getElementById("input_" + formid + "_" + fromfield).value : "";
            } else {
                if (document.getElementById("input_" + formid + "_" + tofield + "_" + inputid)) {
                    document.getElementById("input_" + formid + "_" + tofield + "_" + inputid).value = document.getElementById("input_" + formid + "_" + fromfield + "_" + inputid).value ? document.getElementById("input_" + formid + "_" + fromfield + "_" + inputid).value : "";
                }
            }
        }
    </script>' . $form_string;
    foreach($form['fields'] as &$field) {
		if($field->gfafprepopulateField && !$field->gfafprepopulate2Field) {
            $prepopfield = gfaf_get_field($form, trim(esc_html($field->gfafprepopulateField)));
            if (!$prepopfield || (!$prepopfield->type == 'text' || !$prepopfield->type == 'textarea' || !$prepopfield->type == 'email' || !$prepopfield->type == 'website' || !$prepopfield->type == 'phone' || !$prepopfield->type == 'number' || !$prepopfield->type == 'select' || !$prepopfield->type == 'post_title' || !$prepopfield->type == 'post_content' || !$prepopfield->type == 'post_excerpt' || !$prepopfield->type == 'post_custom_field' || !$prepopfield->type == 'name' || !$prepopfield->type == 'address')) {
                continue;
            }
            if ($field->inputs && $field->type === $prepopfield->type && ($prepopfield->type == 'name' || $prepopfield->type == 'address')) {
                $inputs     = $field->inputs;
                foreach ($inputs as $input) {
                    $input_id   = explode('.', $input['id'])[1];
                    if ($input_id) {
                        $form_string = str_replace("id='input_" . $form['id'] . "_" . trim(esc_html($field->gfafprepopulateField)) . "_" . $input_id . "'", "onchange='gfafPrePopfield(" . $form['id'] . ", " . $field->gfafprepopulateField . ", " . $field->id . ", " . $input_id . ")' id='input_" . $form['id'] . "_" . trim(esc_html($field->gfafprepopulateField)) . "_" . $input_id . "'", $form_string);
                    }
                }
            } else {
                $form_string = str_replace("id='input_" . $form['id'] . "_" . trim(esc_html($field->gfafprepopulateField)) . "'", "onchange='gfafPrePopfield(" . $form['id'] . ", " . $field->gfafprepopulateField . ", " . $field->id . ", false)' id='input_" . $form['id'] . "_" . trim(esc_html($field->gfafprepopulateField)) . "'", $form_string);
            }
		}
	}
    return $form_string;
}

//GFORM AUTO FORMATTER USE SHORTCODES IN MERGE TAGS    {gfaf: [shortcode]}
add_filter('gform_replace_merge_tags', 'nsmdash_shortcode_values_merge_tag', 10, 7);
function nsmdash_shortcode_values_merge_tag($text, $form, $entry, $url_encode, $esc_html, $nl2br, $format) {
    if (strstr($text, 'gfaf:')) {
        $shortcode = explode('gfaf:', $text);
        $shortcode = trim(str_replace('}', '', $shortcode[1]));
        $text      = trim(do_shortcode($shortcode));
        return $text;
    }
    return $text;
}

//GFORM AUTO FORMATTER FORM OPTIONS
class gfaf_auto_formatter_form_options {
	
    function __construct() {
        if(!property_exists('GFCommon', 'version') || !version_compare(GFCommon::$version, '1.8.5.8', '>='))
            return;
        add_filter('gform_tooltips', array($this, 'add_gfaf_auto_formatter_tooltips'));
        add_filter('gform_form_settings', array($this, 'add_gfaf_auto_formatter_setting'), 10, 2);
        add_action('gform_pre_form_settings_save', array($this, 'save_gfaf_auto_formatter_setting'), 10);
    }

    function add_gfaf_auto_formatter_tooltips($tooltips) {
		$tooltips['gfafreviewpagetooltip'] 	= "<h6>" . __( "Enable Review Page", "gravityforms" ) . "</h6>" . __( "When enabled, the user will be presented with a page to review all input information before submitting the form.", "gravityforms" );
        return $tooltips;
    }

    function add_gfaf_auto_formatter_setting($settings, $form) {
		$gfaf_review_page        = rgar($form, 'gfafreviewpage') ? 'checked="checked"' : "";
        $gfaf_review_button_text = rgar($form, 'gfafreviewbuttontext') ? rgar($form, 'gfafreviewbuttontext') : "";
		
        $settings[__('Auto Formatter Options', 'gravityforms')]['gfafautoformatter'] = '
            <tr>
                <th>' . __("Enable Review Page", "gravityforms") . ' ' . gform_tooltip("gfafreviewpagetooltip", "", true) . '</th>
                <td>
                    <input type="checkbox" id="gfafreviewpage" name="gfafreviewpage" value="1" ' . $gfaf_review_page . ' />
                    <label for="gfafreviewpage">' . __("Enable the pre-submission entry review page.", "gravityforms") . '</label>
                </td>
            </tr>
            <tr>
                <th>' . __("Review Button Text", "gravityforms") . ' ' . gform_tooltip("gfafreviewbuttontexttooltip", "", true) . '</th>
                <td>
                    <input type="text" id="gfafreviewbuttontext" name="gfafreviewbuttontext" value="' . $gfaf_review_button_text . '" placeholder="Review & Submit" style="max-width: 300px; width: 90%;" maxlength="30"/><br/>
                </td>
            </tr>';
		return $settings;
    }
	
    function save_gfaf_auto_formatter_setting($form) {
		$form['gfafreviewpage']       = rgpost('gfafreviewpage');
        $form['gfafreviewbuttontext'] = rgpost('gfafreviewbuttontext');
        return $form;
    }
}
new gfaf_auto_formatter_form_options();

/*GFORMS AUTO FORMATTER FIELD OPTIONS*/
add_action('gform_field_advanced_settings', 'gfaf_gfaf_uppercase_settings', 10, 2);
function gfaf_gfaf_uppercase_settings($position, $form_id) {
    //create settings on position 10 (right after Field Label)
	//create settings on position 25 (right after Admin Field Label)
    if ($position == 50) {
        ?>
        <li class="gfaf_auto_format_setting field_setting">
        <script type='text/javascript'>
			function toggle_visibility(id) {
				 var e = document.getElementById(id);
				 if(e.style.display == 'block')
					e.style.display = 'none';
				 else
					e.style.display = 'block';
			 }
		</script>
       <label for="gfaf_format" class="section_label">
		<?php _e('Auto Formatter', 'gravityforms');
			echo ' <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank"><img src="' . plugin_dir_url(__FILE__)  . 'images/owl-small.png" height="13px" width="auto" style="display:inline-block;"></a>';
		?>
		</label>
        <div id="gfaf_format" class="gfaf_format" type="button" onClick="toggle_visibility('gfaf_formatter');" style="
        	border: 1px solid #00feff;
			background: none;
			color: #444;
			background-color: #ffffff;
            text-align: center;
			border-radius: 0px;
			padding: 3px;
            width: auto;
            cursor: pointer;
       ">Show/Hide</div>
		</li>
        <div id="gfaf_formatter" style="display:none;">
			<li class="gfaf_uppercase_setting field_setting">
				<input type="radio" id="field_gfafuppercase_value" name="gfafcaseOption" onClick="
				SetFieldProperty('gfafuppercaseField', this.checked);
				SetFieldProperty('gfaflowercaseField', this.unchecked);            
				SetFieldProperty('gfafucfirstletterField', this.unchecked);
				SetFieldProperty('gfafucfirstlettersField', this.unchecked);
				" />
				<label for="field_gfafuppercase_value" class="inline">UPPER CASE</label>
				<?php gform_tooltip( 'form_field_gfafuppercase_value' ) ?>
			</li>
			<li class="gfaf_lowercase_setting field_setting">
				<input type="radio" id="field_gfaflowercase_value" name="gfafcaseOption" onClick="
				SetFieldProperty('gfafuppercaseField', this.unchecked);
				SetFieldProperty('gfaflowercaseField', this.checked);            
				SetFieldProperty('gfafucfirstletterField', this.unchecked);
				SetFieldProperty('gfafucfirstlettersField', this.unchecked);
				" />
				<label for="field_gfaflowercase_value" class="inline">lower case</label>
				<?php gform_tooltip( 'form_field_gfaflowercase_value' ) ?>
			</li>
			<li class="gfaf_ucfirstletter_setting field_setting">
				<input type="radio" id="field_gfafucfirstletter_value" name="gfafcaseOption" onClick="
				SetFieldProperty('gfafuppercaseField', this.unchecked);
				SetFieldProperty('gfaflowercaseField', this.unchecked);            
				SetFieldProperty('gfafucfirstletterField', this.checked);
				SetFieldProperty('gfafucfirstlettersField', this.unchecked);
				" /><label for="field_gfafucfirstletter_value" class="inline">First letter upper case</label>
				<?php gform_tooltip( 'form_field_gfafucfirstletter_value' ) ?>
			</li>
			<li class="gfaf_ucfirstletters_setting field_setting">
				<input type="radio" id="field_gfafucfirstletters_value" name="gfafcaseOption" onClick="
				SetFieldProperty('gfafuppercaseField', this.unchecked);
				SetFieldProperty('gfaflowercaseField', this.unchecked);            
				SetFieldProperty('gfafucfirstletterField', this.unchecked);
				SetFieldProperty('gfafucfirstlettersField', this.checked);
				" />
				<label for="field_gfafucfirstletters_value" class="inline">First Letters Upper Case</label>
				<?php gform_tooltip( 'form_field_gfafucfirstletters_value' ) ?>
			</li>
			<li class="gfaf_off_setting field_setting">
				<input type="radio" id="field_gfafoff_value" name="gfafcaseOption" onClick="
				SetFieldProperty('gfafuppercaseField', this.unchecked);
				SetFieldProperty('gfaflowercaseField', this.unchecked);            
				SetFieldProperty('gfafucfirstletterField', this.unchecked);
				SetFieldProperty('gfafucfirstlettersField', this.unchecked);
				" />
				<label for="field_gfafoff_value" class="inline">off</label>
				<?php gform_tooltip( 'form_field_gfafoff_value' ) ?>
				<p></p>
				<div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-bottom: 10px; margin-top: 10px;"></div>
			</li>
			<li class="gfaf_textarearows_setting field_setting">
				<label for="field_gfaftextarearows_value">
					<?php _e('Text Area Rows (set to 0 for auto sizing)', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfaftextarearows_value') ?>
				</label>
				<input type="text" id="field_gfaftextarearows_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfaftextarearowsField', this.value);"/>
			</li>
			<li class="gfaf_min_char_setting field_setting">
				<label for="field_gfafmin_char_value">
					<?php _e('Minimum Characters', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafminchar_value') ?>
				</label>
				<input type="number" id="field_gfafmin_char_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafmincharField', this.value);"/>
			</li>
			<li class="gfaf_max_char_notice field_setting">
				<p>Maximum Characters:<br/>Set on fields "General" tab.</p>
			</li>
			<li class="gfaf_max_char_setting field_setting">
				<label for="field_gfafmin_char_value">
					<?php _e('Maximum Characters', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafmaxchar_value') ?>
				</label>
				<input type="number" id="field_gfafmax_char_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafmaxcharField', this.value);"/>
				<p></p>
				<div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-bottom: 10px;"></div>
			</li>			
			<li class="gfaf_before_setting field_setting">
				<label for="field_gfafbefore_value">
					<?php _e('Before text', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafbefore_value') ?>
				</label>
				<input type="text" id="field_gfafbefore_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafbeforeField', this.value);"/>
			</li>
			<li class="gfaf_after_setting field_setting">
				<label for="field_gfafafter_value">
					<?php _e('After text', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafafter_value') ?>
				</label>
				<input type="text" id="field_gfafafter_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafafterField', this.value);"/>
				<p></p>
				<div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-bottom: 10px;"></div>
			</li>
			<li class="gfaf_yesmatch_setting field_setting">
				<label for="field_yesmatch_value">
					<?php _e('Require Matching Values  (with this field ID)', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafyesmatch_value') ?>
				</label>
				<input type="text" id="field_gfafyesmatch_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafyesmatchField', this.value);"/>
			</li>
			<li class="gfaf_nomatch_setting field_setting">
				<label for="field_nomatch_value">
					<?php _e('Block Matching Values (with these field IDs)', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafnomatch_value') ?>
				</label>
				<input type="text" id="field_gfafnomatch_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafnomatchField', this.value);"/>
				<p></p>
                <div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-bottom: 10px;"></div>
			</li>
            <li class="gfaf_prepopulate_setting field_setting">
				<label for="field_nomatch_value">
					<?php _e('Auto Copy Value (from this field ID)', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafprepopulate_value') ?>
				</label>
				<input type="number" id="field_gfafprepopulate_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafprepopulateField', this.value);"/>
				<p></p>
			</li>
            <li class="gfaf_prepopulate2_setting field_setting">
				<label for="field_nomatch_value">
					<?php _e('User Copy Value (from this field ID)', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafprepopulate2_value') ?>
				</label>
				<input type="number" id="field_gfafprepopulate2_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafprepopulate2Field', this.value);"/>
                <p></p>
			</li>
            <li class="gfaf_prepopulatetext_setting field_setting">
				<label for="field_nomatch_value">
					<?php _e('User Copy Value Text', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafprepopulatetext_value') ?>
				</label>
				<input type="text" id="field_gfafprepopulatetext_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafprepopulatetextField', this.value);"/>
				<p></p>
				<div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-bottom: 10px;"></div>
			</li>
			<li class="gfaf_obscure_setting field_setting"> 
				<input type="checkbox" id="field_gfafobscure_value" name="gfafobscureOption" onClick="SetFieldProperty('gfafobscureField', this.checked);
																									  SetFieldProperty('gfaftoggleobscureField', this.unchecked);
																									  $('input[id=field_gfaftoggleobscure_value]').prop('checked', false);" />
				<label for="field_gfafobscure_value" class="inline">Obscure Text</label>
				<?php gform_tooltip( 'form_field_gfafobscure_value' ) ?>
			</li>
			<li class="gfaf_toggleobscure_setting field_setting"> 
				<input type="checkbox" id="field_gfaftoggleobscure_value" name="gfaftoggleobscureOption" onClick="SetFieldProperty('gfaftoggleobscureField', this.checked);
																												  SetFieldProperty('gfafobscureField', this.unchecked);
																												  $('input[id=field_gfafobscure_value]').prop('checked', false);" />
				<label for="field_gfaftoggleobscure_value" class="inline">User Toggle Obscure Text</label>
				<?php gform_tooltip( 'form_field_gfaftoggleobscure_value' ) ?>
			</li>
			<li class="gfaf_removelinks_setting field_setting">
				<input type="checkbox" id="field_gfafremovelinks_value" name="gfafremovelinksOption" onClick="SetFieldProperty('gfafremovelinksField', this.checked);" />
				<label for="field_gfafremovelinks_value" class="inline">Remove Links</label>
				<?php gform_tooltip( 'form_field_gfafremovelinks_value' ) ?>
			</li>
			<li class="gfaf_removehtml_setting field_setting">
				<input type="checkbox" id="field_gfafremovehtml_value" name="gfafremovehtmlOption" onClick="SetFieldProperty('gfafremovehtmlField', this.checked);" />
				<label for="field_gfafremovehtml_value" class="inline">Remove HTML/PHP</label>
				<?php gform_tooltip( 'form_field_gfafremovehtml_value' ) ?>
			</li>
			<li class="gfaf_readonly_setting field_setting">
				<input type="checkbox" id="field_gfafreadonly_value" name="gfafreadonlyOption" onClick="SetFieldProperty('gfafreadonlyField', this.checked);" />
				<label for="field_gfafreadonly_value" class="inline">Read Only Field</label>
				<?php gform_tooltip( 'form_field_gfafreadonly_value' ) ?>
			</li>
			<li class="gfaf_disabled_setting field_setting">
				<input type="checkbox" id="field_gfafdisabled_value" name="gfafdisabledOption" onClick="SetFieldProperty('gfafdisabledField', this.checked);" />
				<label for="field_gfafdisabled_value" class="inline">Disabled Field</label>
				<?php gform_tooltip( 'form_field_gfafdisabled_value' ) ?>
			</li>
			<li class="gfaf_autocompleteoff_setting field_setting">
				<input type="checkbox" id="field_gfafautocompleteoff_value" name="gfafautocompleteoffOption" onClick="SetFieldProperty('gfafautocompleteoffField', this.checked);" />
				<label for="field_gfafautocompleteoff_value" class="inline">Turn Off Autocomplete</label>
				<?php gform_tooltip( 'form_field_gfafautocompleteoff_value' ) ?>
			</li>
			<li class="gfaf_spellcheckoff_setting field_setting">
				<input type="checkbox" id="field_gfafspellcheckoff_value" name="gfafspellcheckoffOption" onClick="SetFieldProperty('gfafspellcheckoffField', this.checked);" />
				<label for="field_gfafspellcheckoff_value" class="inline">Turn Off Spellcheck</label>
				<?php gform_tooltip( 'form_field_gfafspellcheckoff_value' ) ?>
			</li>
			<li class="gfaf_alphaonly_setting field_setting">
				<input type="checkbox" id="field_gfafalphaonly_value" name="gfafalphaonlyOption" onClick="SetFieldProperty('gfafalphaonlyField', this.checked); SetFieldProperty('gfafnumericonlyField', this.unchecked); SetFieldProperty('gfafalphanumericonlyField', this.unchecked); SetFieldProperty('gfafenglishnlyField', this.unchecked); $('input[id=field_gfafnumericonly_value], [id=field_gfafalphanumericonly_value], [id=field_gfafenglishonly_value]').prop('checked', false);" />
				<label for="field_gfafalphaonly_value" class="inline">Alpha Characters Only</label>
				<?php gform_tooltip( 'form_field_gfafalphaonly_value' ) ?>
			</li>
			<li class="gfaf_numericonly_setting field_setting">
				<input type="checkbox" id="field_gfafnumericonly_value" name="gfafnumericonlyOption" onClick="SetFieldProperty('gfafnumericonlyField', this.checked); SetFieldProperty('gfafalphaonlyField', this.unchecked); SetFieldProperty('gfafalphanumericonlyField', this.unchecked); SetFieldProperty('gfafenglishnlyField', this.unchecked); $('input[id=field_gfafalphaonly_value], [id=field_gfafalphanumericonly_value], [id=field_gfafenglishonly_value]').prop('checked', false);" />
				<label for="field_gfafnumericonly_value" class="inline">Numeric Characters Only</label>
				<?php gform_tooltip( 'form_field_gfafnumericonly_value' ) ?>
			</li>
			<li class="gfaf_alphanumericonly_setting field_setting">
				<input type="checkbox" id="field_gfafalphanumericonly_value" name="gfafalphanumericonlyOption" onClick="SetFieldProperty('gfafalphanumericonlyField', this.checked); SetFieldProperty('gfafalphaonlyField', this.unchecked); SetFieldProperty('gfafnumericonlyField', this.unchecked); SetFieldProperty('gfafenglishnlyField', this.unchecked); $('input[id=field_gfafalphaonly_value], [id=field_gfafnumericonly_value], [id=field_gfafenglishonly_value]').prop('checked', false);" />
				<label for="field_gfafalphanumericonly_value" class="inline">Alpha-Numeric Characters Only</label>
				<?php gform_tooltip( 'form_field_gfafalphanumericonly_value' ) ?>
			</li>
            <li class="gfaf_englishonly_setting field_setting">
				<input type="checkbox" id="field_gfafenglishonly_value" name="gfafenglishonlyOption" onClick="SetFieldProperty('gfafenglishonlyField', this.checked); SetFieldProperty('gfafalphaonlyField', this.unchecked); SetFieldProperty('gfafnumericonlyField', this.unchecked); SetFieldProperty('gfafalphanumericonlyField', this.unchecked); $('input[id=field_gfafalphaonly_value], [id=field_gfafnumericonly_value], [id=field_gfafalphanumericonly_value]').prop('checked', false);" />
				<label for="field_gfafenglishonly_value" class="inline">Alpha-Numeric +</label>
				<?php gform_tooltip( 'form_field_gfafenglishonly_value' ) ?>
			</li>
            <li class="gfaf_specifiedonly_setting field_setting">
				<label for="field_gfafspecifiedonly_value">
					<?php _e('Specified Characters Only', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafspecifiedonly_value') ?>
				</label>
				<input type="text" id="field_gfafspecifiedonly_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafspecifiedonlyField', this.value);" oninput="this.value=this.value.replace(/[&quot;]/g, 'u0022');" />
			</li>
			<li class="gfaf_blacklist_setting field_setting">
				<input type="checkbox" id="field_gfafblacklist_value" name="gfafblacklistOption" onClick="SetFieldProperty('gfafblacklistField', this.checked);" />
				<label for="field_gfafblacklist_value" class="inline">Central Blacklist Check</label>
				<?php gform_tooltip( 'form_field_gfafblacklist_value' ) ?>
			</li>
			<li class="gfaf_textreplace_setting field_setting">
				<input type="checkbox" id="field_gfaftextreplace_value" name="gfaftextreplaceOption" onClick="SetFieldProperty('gfaftextreplaceField', this.checked);" />
				<label for="field_gfaftextreplace_value" class="inline">Central Text Replacement</label>
				<?php gform_tooltip( 'form_field_gfaftextreplace_value' ) ?>
			</li>
			<li class="gfaf_blacklist2_setting field_setting">
				<label for="field_gfafblacklist2_value">
					<?php _e('Individual Blacklist', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfafblacklist2_value') ?>
				</label>
				<textarea rows="4" id="field_gfafblacklist2_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfafblacklist2Field', this.value);"/></textarea>
			</li>
			<li class="gfaf_textreplace2_setting field_setting">
				<label for="field_gfaftextreplace2_value">
					<?php _e('Individual Text Replacement', 'gravityforms'); ?>
					<?php gform_tooltip('form_field_gfaftextreplace2_value') ?>
				</label>
				<textarea rows="4" id="field_gfaftextreplace2_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('gfaftextreplace2Field', this.value);"/></textarea>
			</li>
		</div>
		<br/>
        <?php
    }
}

//Add setting to fields of type
add_action('gform_editor_js', 'gfaf_editor_auto_formatter_script');
function gfaf_editor_auto_formatter_script() {
    ?>
    <script type="text/javascript">
		fieldSettings["text"] += ", .gfaf_auto_format_setting";
		fieldSettings["textarea"] += ", .gfaf_auto_format_setting";
		fieldSettings["name"] += ", .gfaf_auto_format_setting";
		fieldSettings["email"] += ", .gfaf_auto_format_setting";
		fieldSettings["website"] += ", .gfaf_auto_format_setting";
		fieldSettings["phone"] += ", .gfaf_auto_format_setting";
		fieldSettings["address"] += ", .gfaf_auto_format_setting";
		fieldSettings["number"] += ", .gfaf_auto_format_setting";
		fieldSettings["list"] += ", .gfaf_auto_format_setting";
		fieldSettings["select"] += ", .gfaf_auto_format_setting";
		fieldSettings["radio"] += ", .gfaf_auto_format_setting";
		fieldSettings["multiselect"] += ", .gfaf_auto_format_setting";
		fieldSettings["checkbox"] += ", .gfaf_auto_format_setting";
		fieldSettings["post_title"] += ", .gfaf_auto_format_setting";
		fieldSettings["post_category"] += ", .gfaf_auto_format_setting";
		fieldSettings["post_content"] += ", .gfaf_auto_format_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_auto_format_setting";
		fieldSettings["post_tags"] += ", .gfaf_auto_format_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_auto_format_setting";
		
        fieldSettings["text"] += ", .gfaf_uppercase_setting";
		fieldSettings["textarea"] += ", .gfaf_uppercase_setting";
		fieldSettings["name"] += ", .gfaf_uppercase_setting";
		fieldSettings["email"] += ", .gfaf_uppercase_setting";
		fieldSettings["website"] += ", .gfaf_uppercase_setting";
		fieldSettings["address"] += ", .gfaf_uppercase_setting";
		fieldSettings["list"] += ", .gfaf_uppercase_setting";
/*		fieldSettings["select"] += ", .gfaf_uppercase_setting";
		fieldSettings["radio"] += ", .gfaf_uppercase_setting";
		fieldSettings["multiselect"] += ", .gfaf_uppercase_setting";
		fieldSettings["checkbox"] += ", .gfaf_uppercase_setting";*/
		fieldSettings["post_title"] += ", .gfaf_uppercase_setting";
		fieldSettings["post_content"] += ", .gfaf_uppercase_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_uppercase_setting";
		fieldSettings["post_tags"] += ", .gfaf_uppercase_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_uppercase_setting";
		
		fieldSettings["text"] += ", .gfaf_lowercase_setting";
		fieldSettings["textarea"] += ", .gfaf_lowercase_setting";
		fieldSettings["date"] += ", .gfaf_lowercase_setting";
		fieldSettings["name"] += ", .gfaf_lowercase_setting";
		fieldSettings["email"] += ", .gfaf_lowercase_setting";
		fieldSettings["website"] += ", .gfaf_lowercase_setting";
		fieldSettings["address"] += ", .gfaf_lowercase_setting";
		fieldSettings["list"] += ", .gfaf_lowercase_setting";
/*		fieldSettings["select"] += ", .gfaf_lowercase_setting";
		fieldSettings["radio"] += ", .gfaf_lowercase_setting";
		fieldSettings["multiselect"] += ", .gfaf_lowercase_setting";
		fieldSettings["checkbox"] += ", .gfaf_lowercase_setting";*/
		fieldSettings["post_title"] += ", .gfaf_lowercase_setting";
		fieldSettings["post_content"] += ", .gfaf_lowercase_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_lowercase_setting";
		fieldSettings["post_tags"] += ", .gfaf_lowercase_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_lowercase_setting";
		
		fieldSettings["text"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["textarea"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["name"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["email"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["website"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["address"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["list"] += ", .gfaf_ucfirstletter_setting";
/*		fieldSettings["select"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["radio"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["multiselect"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["checkbox"] += ", .gfaf_ucfirstletter_setting";*/
		fieldSettings["post_title"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["post_content"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["post_tags"] += ", .gfaf_ucfirstletter_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_ucfirstletter_setting";
		
		fieldSettings["text"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["textarea"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["name"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["email"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["website"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["address"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["list"] += ", .gfaf_ucfirstletters_setting";
/*		fieldSettings["select"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["radio"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["multiselect"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["checkbox"] += ", .gfaf_ucfirstletters_setting";*/
		fieldSettings["post_title"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["post_content"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["post_tags"] += ", .gfaf_ucfirstletters_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_ucfirstletters_setting";
		
		fieldSettings["text"] += ", .gfaf_off_setting";
		fieldSettings["textarea"] += ", .gfaf_off_setting";
		fieldSettings["name"] += ", .gfaf_off_setting";
		fieldSettings["email"] += ", .gfaf_off_setting";
		fieldSettings["website"] += ", .gfaf_off_setting";
		fieldSettings["address"] += ", .gfaf_off_setting";
		fieldSettings["list"] += ", .gfaf_off_setting";
/*		fieldSettings["select"] += ", .gfaf_off_setting";
		fieldSettings["radio"] += ", .gfaf_off_setting";
		fieldSettings["multiselect"] += ", .gfaf_off_setting";
		fieldSettings["checkbox"] += ", .gfaf_off_setting";*/
		fieldSettings["post_title"] += ", .gfaf_off_setting";
		fieldSettings["post_content"] += ", .gfaf_off_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_off_setting";
		fieldSettings["post_tags"] += ", .gfaf_off_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_off_setting";
		
		fieldSettings["textarea"] += ", .gfaf_textarearows_setting";
		
		fieldSettings["text"] += ", .gfaf_min_char_setting";
		fieldSettings["textarea"] += ", .gfaf_min_char_setting";
		fieldSettings["email"] += ", .gfaf_min_char_setting";
		fieldSettings["website"] += ", .gfaf_min_char_setting";
		fieldSettings["list"] += ", .gfaf_min_char_setting";
		fieldSettings["post_title"] += ", .gfaf_min_char_setting";
		fieldSettings["post_content"] += ", .gfaf_min_char_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_min_char_setting";
		
		fieldSettings["text"] += ", .gfaf_max_char_notice";
		fieldSettings["textarea"] += ", .gfaf_max_char_notice";
		fieldSettings["email"] += ", .gfaf_max_char_setting";
		fieldSettings["list"] += ", .gfaf_max_char_setting";
		fieldSettings["website"] += ", .gfaf_max_char_setting";
		fieldSettings["post_title"] += ", .gfaf_max_char_setting";
		fieldSettings["post_content"] += ", .gfaf_max_char_notice";
		fieldSettings["post_excerpt"] += ", .gfaf_max_char_notice";
		
		fieldSettings["text"] += ", .gfaf_before_setting";
		fieldSettings["textarea"] += ", .gfaf_before_setting";
		fieldSettings["name"] += ", .gfaf_before_setting";
		fieldSettings["email"] += ", .gfaf_before_setting";
		fieldSettings["website"] += ", .gfaf_before_setting";
		fieldSettings["address"] += ", .gfaf_before_setting";
		fieldSettings["list"] += ", .gfaf_before_setting";
/*		fieldSettings["select"] += ", .gfaf_before_setting";
		fieldSettings["radio"] += ", .gfaf_before_setting";
		fieldSettings["multiselect"] += ", .gfaf_before_setting";
		fieldSettings["checkbox"] += ", .gfaf_before_setting";*/
		fieldSettings["post_title"] += ", .gfaf_before_setting";
		fieldSettings["post_content"] += ", .gfaf_before_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_before_setting";
		fieldSettings["post_tags"] += ", .gfaf_before_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_before_setting";
		
		fieldSettings["text"] += ", .gfaf_after_setting";
		fieldSettings["textarea"] += ", .gfaf_after_setting";
		fieldSettings["name"] += ", .gfaf_after_setting";
		fieldSettings["email"] += ", .gfaf_after_setting";
		fieldSettings["website"] += ", .gfaf_after_setting";
		fieldSettings["address"] += ", .gfaf_after_setting";
		fieldSettings["list"] += ", .gfaf_after_setting";
/*		fieldSettings["select"] += ", .gfaf_after_setting";
		fieldSettings["radio"] += ", .gfaf_after_setting";
		fieldSettings["multiselect"] += ", .gfaf_after_setting";
		fieldSettings["checkbox"] += ", .gfaf_after_setting";*/
		fieldSettings["post_title"] += ", .gfaf_after_setting";
		fieldSettings["post_content"] += ", .gfaf_after_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_after_setting";
		fieldSettings["post_tags"] += ", .gfaf_after_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_after_setting";
		
		fieldSettings["text"] += ", .gfaf_blacklist_setting";
		fieldSettings["textarea"] += ", .gfaf_blacklist_setting";
		fieldSettings["name"] += ", .gfaf_blacklist_setting";
		fieldSettings["email"] += ", .gfaf_blacklist_setting";
		fieldSettings["website"] += ", .gfaf_blacklist_setting";
		fieldSettings["address"] += ", .gfaf_blacklist_setting";
		fieldSettings["list"] += ", .gfaf_blacklist_setting";
		/*fieldSettings["select"] += ", .gfaf_blacklist_setting";
		fieldSettings["radio"] += ", .gfaf_blacklist_setting";
		fieldSettings["multiselect"] += ", .gfaf_blacklist_setting";
		fieldSettings["checkbox"] += ", .gfaf_blacklist_setting";*/
		fieldSettings["post_title"] += ", .gfaf_blacklist_setting";
		fieldSettings["post_content"] += ", .gfaf_blacklist_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_blacklist_setting";
		fieldSettings["post_tags"] += ", .gfaf_blacklist_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_blacklist_setting";
		
		fieldSettings["text"] += ", .gfaf_blacklist2_setting";
		fieldSettings["textarea"] += ", .gfaf_blacklist2_setting";
		fieldSettings["name"] += ", .gfaf_blacklist2_setting";
		fieldSettings["email"] += ", .gfaf_blacklist2_setting";
		fieldSettings["website"] += ", .gfaf_blacklist2_setting";
		fieldSettings["address"] += ", .gfaf_blacklist2_setting";
		fieldSettings["list"] += ", .gfaf_blacklist2_setting";
		/*fieldSettings["select"] += ", .gfaf_blacklist2_setting";
		fieldSettings["radio"] += ", .gfaf_blacklist2_setting";
		fieldSettings["multiselect"] += ", .gfaf_blacklist2_setting";
		fieldSettings["checkbox"] += ", .gfaf_blacklist2_setting";*/
		fieldSettings["post_title"] += ", .gfaf_blacklist2_setting";
		fieldSettings["post_content"] += ", .gfaf_blacklist2_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_blacklist2_setting";
		fieldSettings["post_tags"] += ", .gfaf_blacklist2_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_blacklist2_setting";
		
		fieldSettings["text"] += ", .gfaf_prepopulate_setting";
		fieldSettings["textarea"] += ", .gfaf_prepopulate_setting";
		fieldSettings["name"] += ", .gfaf_prepopulate_setting";
		fieldSettings["email"] += ", .gfaf_prepopulate_setting";
		fieldSettings["website"] += ", .gfaf_prepopulate_setting";
		fieldSettings["phone"] += ", .gfaf_prepopulate_setting";
		fieldSettings["number"] += ", .gfaf_prepopulate_setting";
		fieldSettings["address"] += ", .gfaf_prepopulate_setting";
		//fieldSettings["select"] += ", .gfaf_prepopulate_setting";
		//fieldSettings["radio"] += ", .gfaf_prepopulate_setting";
		//fieldSettings["multiselect"] += ", .gfaf_prepopulate_setting";
		//fieldSettings["checkbox"] += ", .gfaf_prepopulate_setting";*/
		fieldSettings["post_title"] += ", .gfaf_prepopulate_setting";
		fieldSettings["post_content"] += ", .gfaf_prepopulate_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_prepopulate_setting";
		//fieldSettings["post_tags"] += ", .gfaf_prepopulate_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_prepopulate_setting";
        
        fieldSettings["text"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["textarea"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["name"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["email"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["website"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["phone"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["number"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["address"] += ", .gfaf_prepopulate2_setting";
		//fieldSettings["select"] += ", .gfaf_prepopulate2_setting";
		//fieldSettings["radio"] += ", .gfaf_prepopulate2_setting";
		//fieldSettings["multiselect"] += ", .gfaf_prepopulate2_setting";
		//fieldSettings["checkbox"] += ", .gfaf_prepopulate2_setting";*/
		fieldSettings["post_title"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["post_content"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_prepopulate2_setting";
		//fieldSettings["post_tags"] += ", .gfaf_prepopulate2_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_prepopulate2_setting";
        
        fieldSettings["text"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["textarea"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["name"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["email"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["website"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["phone"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["number"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["address"] += ", .gfaf_prepopulatetext_setting";
		//fieldSettings["select"] += ", .gfaf_prepopulatetext_setting";
		//fieldSettings["radio"] += ", .gfaf_prepopulatetext_setting";
		//fieldSettings["multiselect"] += ", .gfaf_prepopulatetext_setting";
		//fieldSettings["checkbox"] += ", .gfaf_prepopulatetext_setting";*/
		fieldSettings["post_title"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["post_content"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_prepopulatetext_setting";
		//fieldSettings["post_tags"] += ", .gfaf_prepopulatetext_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_prepopulatetext_setting";
        
        fieldSettings["text"] += ", .gfaf_nomatch_setting";
		fieldSettings["textarea"] += ", .gfaf_nomatch_setting";
		fieldSettings["name"] += ", .gfaf_nomatch_setting";
		fieldSettings["email"] += ", .gfaf_nomatch_setting";
		fieldSettings["website"] += ", .gfaf_nomatch_setting";
		fieldSettings["phone"] += ", .gfaf_nomatch_setting";
		fieldSettings["number"] += ", .gfaf_nomatch_setting";
		/*fieldSettings["address"] += ", .gfaf_nomatch_setting";
		fieldSettings["select"] += ", .gfaf_nomatch_setting";
		fieldSettings["radio"] += ", .gfaf_nomatch_setting";
		fieldSettings["multiselect"] += ", .gfaf_nomatch_setting";
		fieldSettings["checkbox"] += ", .gfaf_nomatch_setting";*/
		fieldSettings["post_title"] += ", .gfaf_nomatch_setting";
		fieldSettings["post_content"] += ", .gfaf_nomatch_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_nomatch_setting";
		fieldSettings["post_tags"] += ", .gfaf_nomatch_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_nomatch_setting";
		
		fieldSettings["text"] += ", .gfaf_yesmatch_setting";
		fieldSettings["textarea"] += ", .gfaf_yesmatch_setting";
		fieldSettings["name"] += ", .gfaf_yesmatch_setting";
		fieldSettings["email"] += ", .gfaf_yesmatch_setting";
		fieldSettings["website"] += ", .gfaf_yesmatch_setting";
		fieldSettings["phone"] += ", .gfaf_yesmatch_setting";
		fieldSettings["number"] += ", .gfaf_yesmatch_setting";
		/*fieldSettings["address"] += ", .gfaf_yesmatch_setting";
		fieldSettings["select"] += ", .gfaf_yesmatch_setting";
		fieldSettings["radio"] += ", .gfaf_yesmatch_setting";
		fieldSettings["multiselect"] += ", .gfaf_yesmatch_setting";
		fieldSettings["checkbox"] += ", .gfaf_yesmatch_setting";*/
		fieldSettings["post_title"] += ", .gfaf_yesmatch_setting";
		fieldSettings["post_content"] += ", .gfaf_yesmatch_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_yesmatch_setting";
		fieldSettings["post_tags"] += ", .gfaf_yesmatch_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_yesmatch_setting";
		
		fieldSettings["text"] += ", .gfaf_textreplace_setting";
		fieldSettings["textarea"] += ", .gfaf_textreplace_setting";
		fieldSettings["name"] += ", .gfaf_textreplace_setting";
		fieldSettings["email"] += ", .gfaf_textreplace_setting";
		fieldSettings["website"] += ", .gfaf_textreplace_setting";
		fieldSettings["address"] += ", .gfaf_textreplace_setting";
		fieldSettings["list"] += ", .gfaf_textreplace_setting";
		/*fieldSettings["select"] += ", .gfaf_textreplace_setting";
		fieldSettings["radio"] += ", .gfaf_textreplace_setting";
		fieldSettings["multiselect"] += ", .gfaf_textreplace_setting";
		fieldSettings["checkbox"] += ", .gfaf_textreplace_setting";*/
		fieldSettings["post_title"] += ", .gfaf_textreplace_setting";
		fieldSettings["post_content"] += ", .gfaf_textreplace_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_textreplace_setting";
		fieldSettings["post_tags"] += ", .gfaf_textreplace_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_textreplace_setting";
		
		fieldSettings["text"] += ", .gfaf_textreplace2_setting";
		fieldSettings["textarea"] += ", .gfaf_textreplace2_setting";
		fieldSettings["name"] += ", .gfaf_textreplace2_setting";
		fieldSettings["email"] += ", .gfaf_textreplace2_setting";
		fieldSettings["website"] += ", .gfaf_textreplace2_setting";
		fieldSettings["address"] += ", .gfaf_textreplace2_setting";
		fieldSettings["list"] += ", .gfaf_textreplace2_setting";
		/*fieldSettings["select"] += ", .gfaf_textreplace2_setting";
		fieldSettings["radio"] += ", .gfaf_textreplace2_setting";
		fieldSettings["multiselect"] += ", .gfaf_textreplace2_setting";
		fieldSettings["checkbox"] += ", .gfaf_textreplace2_setting";*/
		fieldSettings["post_title"] += ", .gfaf_textreplace2_setting";
		fieldSettings["post_content"] += ", .gfaf_textreplace2_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_textreplace2_setting";
		fieldSettings["post_tags"] += ", .gfaf_textreplace2_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_textreplace2_setting";
		
		fieldSettings["text"] += ", .gfaf_obscure_setting";
		fieldSettings["textarea"] += ", .gfaf_obscure_setting";
		fieldSettings["name"] += ", .gfaf_obscure_setting";
		fieldSettings["email"] += ", .gfaf_obscure_setting";
		fieldSettings["website"] += ", .gfaf_obscure_setting";
		fieldSettings["address"] += ", .gfaf_obscure_setting";
		fieldSettings["list"] += ", .gfaf_obscure_setting";
		/*fieldSettings["select"] += ", .gfaf_obscure_setting";
		fieldSettings["radio"] += ", .gfaf_obscure_setting";
		fieldSettings["multiselect"] += ", .gfaf_obscure_setting";
		fieldSettings["checkbox"] += ", .gfaf_obscure_setting";
		fieldSettings["post_title"] += ", .gfaf_obscure_setting";
		fieldSettings["post_content"] += ", .gfaf_obscure_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_obscure_setting";
		fieldSettings["post_tags"] += ", .gfaf_obscure_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_obscure_setting";*/
		
		fieldSettings["text"] += ", .gfaf_toggleobscure_setting"; 
		fieldSettings["textarea"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["name"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["email"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["website"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["address"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["list"] += ", .gfaf_toggleobscure_setting";
		/*fieldSettings["select"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["radio"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["multiselect"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["checkbox"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["post_title"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["post_content"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["post_tags"] += ", .gfaf_toggleobscure_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_toggleobscure_setting";*/
		
		fieldSettings["text"] += ", .gfaf_removelinks_setting";
		fieldSettings["textarea"] += ", .gfaf_removelinks_setting";
		fieldSettings["name"] += ", .gfaf_removelinks_setting";
		fieldSettings["email"] += ", .gfaf_removelinks_setting";
		fieldSettings["website"] += ", .gfaf_removelinks_setting";
		fieldSettings["address"] += ", .gfaf_removelinks_setting";
		fieldSettings["list"] += ", .gfaf_removelinks_setting";
		/*fieldSettings["select"] += ", .gfaf_removelinks_setting";
		fieldSettings["radio"] += ", .gfaf_removelinks_setting";
		fieldSettings["multiselect"] += ", .gfaf_removelinks_setting";
		fieldSettings["checkbox"] += ", .gfaf_removelinks_setting";*/
		fieldSettings["post_title"] += ", .gfaf_removelinks_setting";
		fieldSettings["post_content"] += ", .gfaf_removelinks_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_removelinks_setting";
		fieldSettings["post_tags"] += ", .gfaf_removelinks_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_removelinks_setting";
		
		fieldSettings["text"] += ", .gfaf_removehtml_setting";
		fieldSettings["textarea"] += ", .gfaf_removehtml_setting";
		fieldSettings["name"] += ", .gfaf_removehtml_setting";
		fieldSettings["email"] += ", .gfaf_removehtml_setting";
		fieldSettings["website"] += ", .gfaf_removehtml_setting";
		fieldSettings["address"] += ", .gfaf_removehtml_setting";
		fieldSettings["list"] += ", .gfaf_removehtml_setting";
		/*fieldSettings["select"] += ", .gfaf_removehtml_setting";
		fieldSettings["radio"] += ", .gfaf_removehtml_setting";
		fieldSettings["multiselect"] += ", .gfaf_removehtml_setting";
		fieldSettings["checkbox"] += ", .gfaf_removehtml_setting";*/
		fieldSettings["post_title"] += ", .gfaf_removehtml_setting";
		fieldSettings["post_content"] += ", .gfaf_removehtml_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_removehtml_setting";
		fieldSettings["post_tags"] += ", .gfaf_removehtml_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_removehtml_setting";
		
		fieldSettings["text"] += ", .gfaf_readonly_setting";
		fieldSettings["textarea"] += ", .gfaf_readonly_setting";
		fieldSettings["name"] += ", .gfaf_readonly_setting";
		fieldSettings["email"] += ", .gfaf_readonly_setting";
		fieldSettings["website"] += ", .gfaf_readonly_setting";
		fieldSettings["phone"] += ", .gfaf_readonly_setting";
		fieldSettings["address"] += ", .gfaf_readonly_setting";
		fieldSettings["number"] += ", .gfaf_readonly_setting";
		fieldSettings["list"] += ", .gfaf_readonly_setting";
		fieldSettings["select"] += ", .gfaf_readonly_setting";
		fieldSettings["radio"] += ", .gfaf_readonly_setting";
		fieldSettings["multiselect"] += ", .gfaf_readonly_setting";
		fieldSettings["checkbox"] += ", .gfaf_readonly_setting";
		fieldSettings["post_title"] += ", .gfaf_readonly_setting";
		fieldSettings["post_category"] += ", .gfaf_readonly_setting";
		fieldSettings["post_content"] += ", .gfaf_readonly_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_readonly_setting";
		fieldSettings["post_tags"] += ", .gfaf_readonly_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_readonly_setting";
		
		fieldSettings["text"] += ", .gfaf_disabled_setting";
		fieldSettings["textarea"] += ", .gfaf_disabled_setting";
		fieldSettings["name"] += ", .gfaf_disabled_setting";
		fieldSettings["email"] += ", .gfaf_disabled_setting";
		fieldSettings["website"] += ", .gfaf_disabled_setting";
		fieldSettings["phone"] += ", .gfaf_disabled_setting";
		fieldSettings["address"] += ", .gfaf_disabled_setting";
		fieldSettings["number"] += ", .gfaf_disabled_setting";
		fieldSettings["list"] += ", .gfaf_disabled_setting";
		fieldSettings["select"] += ", .gfaf_disabled_setting";
		fieldSettings["radio"] += ", .gfaf_disabled_setting";
		fieldSettings["multiselect"] += ", .gfaf_disabled_setting";
		fieldSettings["checkbox"] += ", .gfaf_disabled_setting";
		fieldSettings["post_title"] += ", .gfaf_disabled_setting";
		fieldSettings["post_category"] += ", .gfaf_disabled_setting";
		fieldSettings["post_content"] += ", .gfaf_disabled_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_disabled_setting";
		fieldSettings["post_tags"] += ", .gfaf_disabled_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_disabled_setting";
		
		fieldSettings["text"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["textarea"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["name"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["email"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["website"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["phone"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["address"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["number"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["list"] += ", .gfaf_autocompleteoff_setting";
/*		fieldSettings["select"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["radio"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["multiselect"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["checkbox"] += ", .gfaf_autocompleteoff_setting";*/
		fieldSettings["post_title"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["post_content"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["post_tags"] += ", .gfaf_autocompleteoff_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_autocompleteoff_setting";
		
		fieldSettings["text"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["textarea"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["name"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["email"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["website"] += ", .gfaf_spellcheckoff_setting";
		//fieldSettings["phone"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["address"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["number"] += ", .gfaf_spellcheckoff_setting";
/*		fieldSettings["list"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["select"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["radio"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["multiselect"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["checkbox"] += ", .gfaf_spellcheckoff_setting";*/
		fieldSettings["post_title"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["post_content"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["post_tags"] += ", .gfaf_spellcheckoff_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_spellcheckoff_setting";
		
		fieldSettings["text"] += ", .gfaf_alphaonly_setting";
		fieldSettings["textarea"] += ", .gfaf_alphaonly_setting";
		fieldSettings["name"] += ", .gfaf_alphaonly_setting";
		fieldSettings["website"] += ", .gfaf_alphaonly_setting";
		fieldSettings["address"] += ", .gfaf_alphaonly_setting";
		fieldSettings["list"] += ", .gfaf_alphaonly_setting";
/*		fieldSettings["select"] += ", .gfaf_alphaonly_setting";
		fieldSettings["radio"] += ", .gfaf_alphaonly_setting";
		fieldSettings["multiselect"] += ", .gfaf_alphaonly_setting";
		fieldSettings["checkbox"] += ", .gfaf_alphaonly_setting";*/
		fieldSettings["post_title"] += ", .gfaf_alphaonly_setting";
		fieldSettings["post_content"] += ", .gfaf_alphaonly_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_alphaonly_setting";
		fieldSettings["post_tags"] += ", .gfaf_alphaonly_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_alphaonly_setting";
		
		fieldSettings["text"] += ", .gfaf_numericonly_setting";
		fieldSettings["textarea"] += ", .gfaf_numericonly_setting";
		fieldSettings["name"] += ", .gfaf_numericonly_setting";
		fieldSettings["website"] += ", .gfaf_numericonly_setting";
        fieldSettings["phone"] += ", .gfaf_numericonly_setting";
		fieldSettings["address"] += ", .gfaf_numericonly_setting";
		fieldSettings["number"] += ", .gfaf_numericonly_setting";
		fieldSettings["list"] += ", .gfaf_numericonly_setting";
/*		fieldSettings["select"] += ", .gfaf_numericonly_setting";
		fieldSettings["radio"] += ", .gfaf_numericonly_setting";
		fieldSettings["multiselect"] += ", .gfaf_numericonly_setting";
		fieldSettings["checkbox"] += ", .gfaf_numericonly_setting";*/
		fieldSettings["post_title"] += ", .gfaf_numericonly_setting";
		fieldSettings["post_content"] += ", .gfaf_numericonly_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_numericonly_setting";
		fieldSettings["post_tags"] += ", .gfaf_numericonly_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_numericonly_setting";
		
		fieldSettings["text"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["textarea"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["name"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["email"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["address"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["list"] += ", .gfaf_alphanumericonly_setting";
/*		fieldSettings["select"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["radio"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["multiselect"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["checkbox"] += ", .gfaf_alphanumericonly_setting";*/
		fieldSettings["post_title"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["post_content"] += ", .gfaf_alphaonumericnly_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["post_tags"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_alphanumericonly_setting";
        
        fieldSettings["text"] += ", .gfaf_englishonly_setting";
		fieldSettings["textarea"] += ", .gfaf_englishonly_setting";
		fieldSettings["name"] += ", .gfaf_englishonly_setting";
		fieldSettings["email"] += ", .gfaf_englishonly_setting";
		fieldSettings["address"] += ", .gfafenglishonly_setting";
		fieldSettings["list"] += ", .gfaf_englishonly_setting";
/*		fieldSettings["select"] += ", .gfaf_englishonly_setting";
		fieldSettings["radio"] += ", .gfaf_englishonly_setting";
        fieldSettings["multiselect"] += ", .gfafenglishonly_setting";
		fieldSettings["checkbox"] += ", .gfaf_englishonly_setting";*/
		fieldSettings["post_title"] += ", .gfaf_englishonly_setting";
		fieldSettings["post_content"] += ", .gfaf_englishonly_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_englishonly_setting";
		fieldSettings["post_tags"] += ", .gfaf_englishonly_setting";
		fieldSettings["post_custom_field"] += ", .gfaf_englishonly_setting";
        
        fieldSettings["text"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["textarea"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["name"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["email"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["address"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["list"] += ", .gfaf_specifiedonly_setting";
/*		fieldSettings["select"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["radio"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["multiselect"] += ", .gfaf_alphanumericonly_setting";
		fieldSettings["checkbox"] += ", .gfaf_alphanumericonly_setting";*/
		fieldSettings["post_title"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["post_content"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["post_excerpt"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["post_tags"] += ", .gfaf_specifiedonly_setting";
		fieldSettings["post_custom_field"] += ", .gfafspecifiedonly_setting";

        //binding to the load field settings event to initialize options
        jQuery(document).bind("gform_load_field_settings", function(event, field, form){
            jQuery("#field_gfafuppercase_value").prop("checked", Boolean(rgar(field, "gfafuppercaseField")));
            jQuery("#field_gfaflowercase_value").prop("checked", Boolean(rgar(field, "gfaflowercaseField")));
            jQuery("#field_gfafucfirstletter_value").prop("checked", Boolean(rgar(field, "gfafucfirstletterField")));
            jQuery("#field_gfafucfirstletters_value").prop("checked", Boolean(rgar(field, "gfafucfirstlettersField")));
            jQuery("#field_gfaf_off_setting_value").prop("checked", 0);
			jQuery("#field_gfaftextarearows_value").val(field["gfaftextarearowsField"]);
            jQuery("#field_gfafmin_char_value").val(field["gfafmincharField"]);
            jQuery("#field_gfafmax_char_value").val(field["gfafmaxcharField"]);
            jQuery("#field_gfafbefore_value").val(field["gfafbeforeField"]);
            jQuery("#field_gfafafter_value").val(field["gfafafterField"]);
            jQuery("#field_gfafblacklist_value").prop("checked", Boolean(rgar(field, "gfafblacklistField")));
            jQuery("#field_gfafblacklist2_value").val(field["gfafblacklist2Field"]);
            jQuery("#field_gfafyesmatch_value").val(field["gfafyesmatchField"]);
            jQuery("#field_gfafnomatch_value").val(field["gfafnomatchField"]);
            jQuery("#field_gfafprepopulate_value").val(field["gfafprepopulateField"]);
            jQuery("#field_gfafprepopulate2_value").val(field["gfafprepopulate2Field"]);
            jQuery("#field_gfafprepopulatetext_value").val(field["gfafprepopulatetextField"]);
            jQuery("#field_gfaftextreplace_value").prop("checked", Boolean(rgar(field, "gfaftextreplaceField")));
            jQuery("#field_gfaftextreplace2_value").val(field["gfaftextreplace2Field"]);
            jQuery("#field_gfafobscure_value").prop("checked", Boolean(rgar(field, "gfafobscureField")));
            jQuery("#field_gfaftoggleobscure_value").prop("checked", Boolean(rgar(field, "gfaftoggleobscureField")));
            jQuery("#field_gfafremovelinks_value").prop("checked", Boolean(rgar(field, "gfafremovelinksField")));
            jQuery("#field_gfafremovehtml_value").prop("checked", Boolean(rgar(field, "gfafremovehtmlField")));
            jQuery("#field_gfafreadonly_value").prop("checked", Boolean(rgar(field, "gfafreadonlyField")));
            jQuery("#field_gfafdisabled_value").prop("checked", Boolean(rgar(field, "gfafdisabledField")));
            jQuery("#field_gfafspellcheckoff_value").prop("checked", Boolean(rgar(field, "gfafspellcheckoffField")));
            jQuery("#field_gfafautocompleteoff_value").prop("checked", Boolean(rgar(field, "gfafautocompleteoffField")));
            jQuery("#field_gfafalphaonly_value").prop("checked", Boolean(rgar(field, "gfafalphaonlyField")));
            jQuery("#field_gfafnumericonly_value").prop("checked", Boolean(rgar(field, "gfafnumericonlyField")));
            jQuery("#field_gfafalphanumericonly_value").prop("checked", Boolean(rgar(field, "gfafalphanumericonlyField")));
			jQuery("#field_gfafspecifiedonly_value").val(field["gfafspecifiedonlyField"]);
            jQuery("#field_gfafenglishonly_value").prop("checked", Boolean(rgar(field, "gfafenglishonlyField")));
        });
    </script>
    <?php
}

//GForm Field Settings Tooltips
add_filter('gform_tooltips', 'gfaf_tooltips');
function gfaf_tooltips($tooltips)  {
   	$tooltips['form_field_gfafuppercase_value'] = esc_html__("<h6>UPPER CASE</h6><p>Format ALL letters to upper case.</p>");
	
	$tooltips['form_field_gfaflowercase_value'] = esc_html__("<h6>lower case</h6><p>Format ALL letters to lower case.</p>");
	
	$tooltips['form_field_gfafucfirstletter_value'] = esc_html__("<h6>First letter upper case</h6><p>Format only the first letter to upper case. All others will be lower case.</p>");
	
	$tooltips['form_field_gfafminchar_value'] = "<h6>Minimum Charcters</h6><p>Enter the minimum number of characters this field must contain to pass form validation.</p><p>It is recommended to inform the user of this restriction in the field description.</p>";
	
	$tooltips['form_field_gfaftextarearows_value'] = "<h6>Text Area Rows</h6><p>Set the fixed row height of a text area field with a number for row height.<br/> A setting of 0 will make the text area rows auto size to the DEFAULT VALUE text, and expand with any new line breaks on input.</p>";
	
	$tooltips['form_field_gfafmaxchar_value'] = "<h6>Maximum Charcters</h6><p>Enter the maximum number of characters this field must contain to pass form validation.</p><p>It is recommended to inform the user of this restriction in the field description.</p>";
		
	$tooltips['form_field_gfafucfirstletters_value'] = "<h6>First Letters Upper Case</h6><p>Format first letters of each word to upper case.</p>";
	
	$tooltips['form_field_gfafbefore_value'] = "<h6>Before</h6><p>This text will be appended before (prefixed) to the users entry. Please check that the data will still be valid for your usage if this is appended to its value as entered.</p>";
	
	$tooltips['form_field_gfafafter_value'] = "<h6>After</h6><p>This text will be appended after (suffixed) to the users entry. Please check that the data will still be valid for your usage if this is appended to its value as entered.</p>";
	
	$tooltips['form_field_gfafoff_value'] = "<h6>Off</h6><p>This turns auto case formatting off.</p>";
	
	$tooltips['form_field_gfafblacklist_value'] = "<h6>Blacklist Check</h6><p>Turn this on to check for blacklisted terms/phrases set on the <a href='" . GFAF_ADMIN . "'>options settings page</a> and block them from submission.</p>";
	
	$tooltips['form_field_gfafblacklist2_value'] = "<h6>Individual Blacklist Check</h6><p>Enter comma separated text or characters to be blocked from submission for this individual field.</p><p>-Special characters (including commas*) allowed.</p><p>*To use a comma in your blacklist text use: *comma*<br/>in place of the comma.</p><p><b>Read Full Option Guide</b> for 'Central Strict Blacklist' on the <a href='" . GFAF_ADMIN . "'>options settings page</a> for full instructions and guided examples. This Individual Blacklist works the same way on this field individually.</p>";
	
	$tooltips['form_field_gfafyesmatch_value'] = "<h6>Require Matching Values</h6><p>Enter a single field ID to require matching values for this field and the field with it's ID entered here. Non matching values will fail form validation on submission and give a user notice.</p><p>You may wish to put this fields ID in the same same setting for the other field listed here.</p>";
    
    $tooltips['form_field_gfafnomatch_value'] = "<h6>Block Matching Values</h6><p>Enter comma separated field IDs to block matching values (no spaces) from this field with values entered in the field IDs here. Matching values will fail form validation on submission and give a user notice.</p>";
    
    $tooltips['form_field_gfafprepopulate_value'] = "<h6>Auto Copy Value</h6><p>Enter a single field ID to auto copy the given field ID's value to this field.</p><p>The given field ID must be a field one of the following field types to fill this fields value: Single Line Text, Paragraph Text, Number, Drop Down, Email, Website, Phone, Post Title, Post Content, Post Excerpt, Post Custom Field (post custom field must be of other valid field type), Name, Address. Most fields with this option can also copy from a drop down field type. Name and address fields can only copy to and from other name or address fields.</p>";
    
    $tooltips['form_field_gfafprepopulate2_value'] = "<h6>User Copy Value</h6><p>Enter a single field ID to add a checkbox to this field which will let the user auto copy the given field ID's value to this field.</p><p>This overrides the Auto Copy Value setting.</p><p>The given field ID must be a field one of the following field types to fill this fields value: Single Line Text, Paragraph Text, Number, Drop Down, Email, Website, Phone, Post Title, Post Content, Post Excerpt, Post Custom Field (post custom field must be of other valid field type), Name, Address. Most fields with this option can also copy from a drop down field type. Name and address fields can only copy to and from other name or address fields.</p>";
    
    $tooltips['form_field_gfafprepopulatetext_value'] = "<h6>User Copy Value Text</h6><p>Customize the checkbox text for 'User Copy Value'.</p>";
	
	$tooltips['form_field_gfaftextreplace_value'] = "<h6>Text Replacement</h6><p>Turn this on to check for terms/phrases set on the <a href='" . GFAF_ADMIN . "'>options settings page</a> and replace them before saving field data to the database.</p>";
	
	$tooltips['form_field_gfaftextreplace2_value'] = "<h6>Individual Text Replacement</h6><p>Enter comma separated text::>replacement_text to automatically replace any occurances of the text with the replacement text when the form entry is saved to the database. Centralized Text Replacements are performed first if it is turned on for this field.</p><p>-Special characters (including commas*) allowed.</p><p>*To use a comma in your text replacement use: *comma*<br/>in place of the comma.</p><p><b>Read Full Option Guide</b> for 'Central Strict Text Replacement' on the <a href='" . GFAF_ADMIN . "'>options settings page</a> for full instructions and guided examples. This Individual Text Replacement works the same way on this field individually.</p><p>Please be sure that your field data will still be valid for the field and any other processing to be performed on that field data after any input text has been replaced.";
	
	$tooltips['form_field_gfafobscure_value'] = '<h6>Obscure Text</h6><p>Turn this on to obscure the text the user types into the field. This works without changing the input to a password so the browser will not attempt to save or suggest passwords for the input.</p>';
	
	$tooltips['form_field_gfaftoggleobscure_value'] = '<h6>Obscure Text</h6><p>Turn this on to obscure the text the user types into the field. This works without changing the input to a password so the browser will not attempt to save or suggest passwords for the input. The user can toggle the obscuring of the text off to check their input.</p>';	
	
	$tooltips['form_field_gfafremovelinks_value'] = '<h6>Remove Links</h6><p>Turn this on for automatic removal of HTML link tags to remove link functionality from submitted content. The text content of the links will remain.</p>';
	
	$tooltips['form_field_gfafremovehtml_value'] = "<h6>Remove HTML</h6><p>Turn this on for automatic removal of ALL HTML tags and ALL PHP code to remove HTML/PHP functionality from submitted content. The plain text content inside any HTML tags will remain.</p>";
	
	$tooltips['form_field_gfafreadonly_value'] = "<h6>Read Only Field</h6><p>Turn this on to make this field read only. Read Only Field Values will be included on form submission. You can prepopulate the read only field value dynamically using Gravity Forms Advanced field 'Default Value' or Allow field to be populated dynamically' settings.</p>";
	
	$tooltips['form_field_gfafdisabled_value'] = "<h6>Disabled Field</h6><p>Turn this on to make this disabled. Disabled Field Values will NOT be included on form submission so they can NOT be required fields. This can be used to prepoulate this value for the users information but exclude it from the form submission. You can prepopulate the field value dynamically using Gravity Forms Advanced field 'Default Value' or 'Allow field to be populated dynamically' settings.</p>";
	
	$tooltips['form_field_gfafspellcheckoff_value'] = "<h6>Turn Off Spellcheck</h6><p>Turn this on to request that browsers do NOT use spellcheck for this field.</p>";
	
	$tooltips['form_field_gfafautocompleteoff_value'] = "<h6>Turn Off Autocomplete</h6><p>Turn this on to request that browsers do NOT use autocomplete for this field.</p>";
	
	$tooltips['form_field_gfafalphaonly_value'] = "<h6>Alpha Characters Only</h6><p>Turn this on to disable the input of numeric and special characters in the field. Only alpha (letter) characters will be able to be input.</p>";
	
	$tooltips['form_field_gfafnumericonly_value'] = "<h6>Numeric Characters Only</h6><p>Turn this on to disable the input of alpha and special characters in the field. Only numeric (number) characters will be able to be input. If used on a 'phone' field the + character will also be allowed.</p>";
	
	$tooltips['form_field_gfafalphanumericonly_value'] = "<h6>Alpha-Numeric Characters Only</h6><p>Turn this on to disable the input of special characters in the field. Only alpha-numeric (letter or number) characters will be able to be input.</p>";
    
     $tooltips['form_field_gfafenglishonly_value'] = "<h6>Alpha-Numeric + Characters Only</h6><p>Quickly allows only basic english alpha-numeric chararcter input including spaces and basic punctiation ie .,!?'  .</p>";
    
    $tooltips['form_field_gfafspecifiedonly_value'] = "<h6>Specified Characters Only</h6><p>Type the specific characters ONLY be allowed into this input. The input attempts* realtime input restriction and will also not pass form validation with any other characters entered. It is recommended to explain which characters are allowed to the user in the fields description. While using this you should consider disabling any other input restrictions as they will likely conflict with your desired allowed input results. To include spaces, include a space between any 2 other characters. To use a double quote. use its unicode of: u0022. Double quotes entered will be changed to this.</p>";
	
   	return $tooltips;
}

//CREATE SETTINGS MENU
add_action('admin_menu', 'gfaf_gravity_forms_auto_formatter_menu');
function gfaf_gravity_forms_auto_formatter_menu() {
	//create new top-level menu
	add_options_page('Gravity Forms Auto Formatter Settings', 'GF Auto Formatter', 'edit_users', 'gravity-forms-auto-formatter', 'gravity_forms_auto_formatter_settings_page');

	//call register settings function
	add_action( 'admin_init', 'register_gravity_forms_auto_formatter_settings' );
}

function register_gravity_forms_auto_formatter_settings() {
	//register our settings
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_blacklist');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_blacklist_strict');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_blacklist_validation_message');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_blacklist_reveal_terms');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_blacklist_reveal_terms_message');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_text_replace');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_strict_text_replace');
	register_setting('gravity_forms_auto_formatter_settings-group', 'gfaf_delete_options');
}

function gravity_forms_auto_formatter_settings_page() {
	function gfaf_get_plugin_version() {
		$plugin_data = get_plugin_data(GFAF_PLUGIN_FILE);
		$plugin_version = $plugin_data['Version'];
		return $plugin_version;
	}
	function gfaf_check_php() {
        if (version_compare( phpversion(), '5.6.0', '>=')) {
            echo '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('PHP Version Supported!');
        } else {
            echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('PHP Version Not Supported! Requires 5.6.0+');
        }
    }
    function gfaf_check_wp_version() {
        if (version_compare(get_bloginfo('version'), '4.6.1', '>=')) {
            echo '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('Wordpress Version Supported!');
        } else {
            echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('Wordpress Version Not Supported! Requires 4.6.1+');
        }
    }
    function gfaf_check_gf_version() {
        if (version_compare(GFCommon::$version, '2.0.7', '>=')) {
            echo '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('Gravity Forms Version Supported!');
        } else {
            echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('Gravity Forms Version Not Supported! Requires 2.0.7+');
        }
    }
    ?>
    <style>
		input[type="text"], 
		textarea {
			border-radius: 7px;
			border: 2px;
		}
		input[type="text"] {
			width:100%;
			border: 2px solid #ddd;
		}
		button {
			border: 2px solid #00feff;
			background: none;
			background-color: #ffffff;
			border-radius: 7px;
			padding: 5px;
		}
		textarea.redtextarea {
			width: 100%;
			border: 2px solid red;
			border-radius: 7px;
		}
		input.redtext {
			width: 100%;			
			border: 2px solid red;
			border-radius: 7px;
		}
		table th.settings {
			background-color:#FFFFFF;
			padding: 10px;
			text-align: center;
		}
		table tr.settingstr {
			border-top: 2px solid #00feff;
		}
		table tr.settingstrgrey {
			border-top: 2px solid #ddd;
		}
		table.form-table {
			max-width: 830px;
		}
		.center {
			 text-align: center;
		}
		table.gfafsystemcheck tr:nth-child(even) {
			background-color: #eeeeee;
		}
	</style>
    <div class="wrap gfaf-admin-page" style="position:relative;">
    <?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/GFAF-icon80x80.jpg" height="80" width="80" style="display:inline-block; float:left; margin-right: 10px;">'; ?>
    <h1 style="display:inline;">Gravity Forms Auto Formatter</h1><span> ver <?php echo gfaf_get_plugin_version(); ?></span>
    <p style="margin-top:0px;">by <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank">Plugin Owl</a></p>
	<p style="margin-top:0px;"><a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank">Check out our other plugins!</a></p><br/>
    <form method="post" action="options.php" autocomplete="invalid">
        <?php settings_fields('gravity_forms_auto_formatter_settings-group'); ?>
        <?php do_settings_sections('gravity_forms_auto_formatter_settings-group'); ?>
    	<div class="gfaf-sticky-save" style="position:fixed; top:20px; right:5px;"><?php submit_button();?></div>
        <script type='text/javascript'>
			function toggle_visibility(id) {
				 var e = document.getElementById(id);
				 if(e.style.display == 'block')
					e.style.display = 'none';
				 else
					e.style.display = 'block';
			 }
		</script>
        <table class="form-table">
           <tr class="settingstr" valign="top">
                <th class="settings" scope="row">SYSTEM CHECK</th>
                <td>
                    <div id="gfe-system-check" style="max-width:600px;">
                        <table class="gfafsystemcheck"
                        style="
                        width: 100%;
                        max-width:600px;
                        background-color: #FFFFFF;
                        border: 2px solid #666666;
                        border-radius: 7px;
                        padding: 0px;
                        margin: 0;
                        font-size: 16px;
                        line-height: 30px">
                            <tr valign="top">
                                <td>PHP Version:</td>
                                <td><strong><?php echo phpversion(); ?></strong></td>
                                <td><?php echo gfaf_check_php(); ?></td>
                            </tr>
                            <tr valign="top">
                                <td>Wordpress Version:</td>
                                <td><strong><?php echo get_bloginfo( 'version' ); ?></strong></td>
                                <td><?php echo gfaf_check_wp_version(); ?></td>
                            </tr>
                            <tr valign="top">
                                <td>Gravity Forms Version:</td>
                                <td><strong><?php echo GFCommon::$version; ?></strong></td>
                                <td><?php echo gfaf_check_gf_version(); ?></td>
                            </tr>
                        </table>
                    </div>
                    <br/>
                    <p><b>INSTRUCTIONS:</b></p>
                    <p>Make sure system meets above system check requirements and configure options below.</p><br/>
                    <p>Set Individual field options within fields "advanced" options tab while in the Gravity Forms Form Editor.</p><br/>
                    <p>Set Form wide options on each forms "Forms Settings" page.</p><br/>
					<p>Centralized blacklist and text replacement is configured below, as well as custom messages for failed blacklist validation. <i>Field specific blacklists and text replacements are in the fields "advanced" options tab.</i></p><br/>
                    <p>To use shortcodes in GF Merge Tags use the following merge tag format:</p><p>{gfaf:[your_shortcode]}</p> This can be used to place shortcode content in field defualt values as well as many other places where GF shortcodes are accepted!</p><p><b>Check to be sure that the shortcode's output content is properly formatted to be useable and valid where you place it!</b></p>
					<br/><br/>
					<p><strong>UPDATING THE PLUGIN</strong><br/>
					<p>Please use the <a href="https://envato.com/market-plugin/" target="blank" rel="nofollow noopener">Envato Market</a> plugin to recieve update notifications, and automatic updates for the plugin. Or you can follow the manual upgrade instructions within this plugins readme file.</p>
                </td>
            </tr>
            <tr class="settingstr" valign="top">
                <th class="settings" scope="row">Central Blacklist</th>
                <td>
				   <textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfaf_blacklist" value="<?php echo esc_html__(get_option('gfaf_blacklist')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfaf_blacklist'); ?></textarea>
					<div id="gfaf-blacklist-instructions" style="max-width:600px;">
						<p><b>Enter comma separated terms or phrases to be blocked from submission for fields with the "Central Blacklist Check" turned on.</b></p><br/>
						<p>-<b>No</b> special characters allowed. Read Option Guide.</p><br/>
						<p>Use ALL lowercase with NO spacing between commas and your term/phrase or the space will be included as part of the term/phrase. You cannot use commas in the terms/phrases.<br/>
						Example:<br/>fool,dirt bag,eye of the tiger</p><br/>
						<p><button id="gfaf-blacklist-instructions-idToggle" type="button" onClick="toggle_visibility('gfaf-blacklist-instructionsToggle');" >SHOW/HIDE OPTION GUIDE</button></p>
                        <div id="gfaf-blacklist-instructionsToggle" style="display:none;">
                        	<p>This will search for and block exact complete words found in the submitted content of the field during form validation. The blocked terms must be matched excatly (ignoring surrounding spacing, punctuation, special characters) and not be a part of larger words. For example: entering "fool" here will not block the word "fools", and you would need to enter both to block both. To block words/characters even if they are a part of larger words, please use the "Central Strict Blacklist" option below. Both blacklists can be used at the same time.</p>
						</div>
					</div>
                </td>
            </tr>
            <tr class="settingstrgrey" valign="top">
                <th class="settings" scope="row">Central Strict Blacklist</th>
                <td>
				   <textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfaf_blacklist_strict" value="<?php echo esc_html__(get_option('gfaf_blacklist_strict')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfaf_blacklist_strict'); ?></textarea>
					<div id="gfaf-blacklist-exact-instructions" style="max-width:600px;">
						<p><b>Enter comma separated text or characters to be blocked from submission for fields with the "Central Blacklist Check" turned on.</b></p><br/>
						<p>-Special characters (including commas) <b>allowed</b>. Read Option Guide.</p><br/>
						<p>Use ALL lowercase with NO spacing between commas and your text/characters or the space will be included as part of the text/characters. You cannot use commas in the terms/phrases. To use a comma in your blacklist text use: *comma* in place of the comma.<br/>
						Example:<br/>fool,#,@,!,naughty,*comma*</p><br/>
						<p><button id="gfaf-blacklist-strict-instructions-idToggle" type="button" onClick="toggle_visibility('gfaf-blacklist-strict-instructionsToggle');" >SHOW/HIDE OPTION GUIDE</button></p>
                        <div id="gfaf-blacklist-strict-instructionsToggle" style="display:none;">
                        	<p>This will search for and block both complete and partial text/characters found in the submitted content of the field during form validation. For example if you enter "fool", the words "foolish" and "fools" would be blocked during validation as they contain the word "fool". To block exact words/phrases only, please use the standard "Central Blacklist" option above. Both blacklists can be used at the same time.</p>
						</div>
					</div>
                </td>
            </tr>
            <tr class="settingstrgrey" valign="top">
                <th class="settings" scope="row">Blacklist Check Failed Validation Message</th>
                <td>
				   <textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfaf_blacklist_validation_message" value="<?php echo esc_html__(get_option('gfaf_blacklist_validation_message')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfaf_blacklist_validation_message'); ?></textarea>
					<div id="gfaf-blacklist-validation-message-instructions" style="max-width:600px;">
						<p><b>Enter what you would like to display to users when submitted field data fails the blacklist check on form validation.</b></p><br/>
						<p>If left empty, the default text is: You have used a term or phrase that is not allowed.</p>
					</div>
                </td>
            </tr>
            <tr class="settingstrgrey" valign="top">
                <th class="settings" scope="row">Reveal Blacklisted Terms/Phrases</th>
                <td>
				    <input type="checkbox" name="gfaf_blacklist_reveal_terms" value="1" <?php checked(1, get_option('gfaf_blacklist_reveal_terms'), true); ?> />
					<div id="gfaf-blacklist-validation-message-instructions" style="max-width:600px;">
						<p><b>Turn this on to reveal to the user the terms/phrases which have been blocked on validation.</b></p><br/>
					</div>
                </td>
            </tr>
            <tr class="settingstrgrey" valign="top">
                <th class="settings" scope="row">Custom Message for revealed blacklisted terms/phrases</th>
                <td>
				   <textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfaf_blacklist_reveal_terms_message" value="<?php echo esc_html__(get_option('gfaf_blacklist_reveal_terms_message')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfaf_blacklist_reveal_terms_message'); ?></textarea>
					<div id="gfaf-gfaf-blacklist-reveal-terms-message" style="max-width:600px;">
						<p><b>Enter what you would like to display to users before listing the blocked terms/phrases when revealing the blocked terms/phrases.</b></p><br/>
						<p>If left empty, the default text is: Please remove the following terms/phrases:</p>
					</div>
                </td>
            </tr>
            <tr class="settingstr" valign="top">
                <th class="settings" scope="row">Central Text Replacement</th>
                <td>
				   <textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfaf_text_replace" value="<?php echo esc_html__(get_option('gfaf_text_replace')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfaf_text_replace'); ?></textarea>
					<div id="gfaf-text-replace-instructions" style="max-width:600px;">
						<p><b>Enter comma separated text::>replacement_text to automatically replace any occurances of the text with the replacement text when the form entry is saved to the database in fields with "Central Text Replacement" turned on.</b></p><br/>
						<p>-<b>No</b> Special characters in search terms/text. Special charaters <b>allowed</b> in text replacements. Read Option Guide.</p><br/>
						<p>Use NO spacing between commas and your term/phrase or the space will be included as part of the term/phrase.<br/>
							Please be sure that your field data will still be valid for the field and any other processing to be performed on that field data after any input text has been replaced.</p><br/>
						<p>A field's Individual Text Replacements are performed after the Central Text Replacements if The field also uses Central Text Replacement.</p><br/>
						<p><button id="gfaf-text-replace-instructions-idToggle" type="button" onClick="toggle_visibility('gfaf-text-replace-instructionsToggle');" >SHOW/HIDE OPTION GUIDE</button></p>
                        <div id="gfaf-text-replace-instructionsToggle" style="display:none;">
                        	<p>Example:   to replace "fool" with "nice person", enter fool::>nice person</p>
							<p>Text is case sensitive.</p>
                        	<p>To replace text with nothing use:   *remove*   as the replacement text.</p>
                        	<p>The replaced terms must be matched excatly (ignoring surrounding spacing, punctuation, special characters) and not be a part of larger words. For example: entering "fool" here will not replace the text "fool" in the word "fools", and you would need to enter both to replace both. There is NO notice given to the submitting user of the text replacement. You cannot use commas or special characters in these standard terms/phrases or thier replacements. You CAN use special characters in the replacements. To replace text/characters even if they are a part of larger words or contain special characters, please use the "Central Strict Text Replacement" option below. Both Central Text Replacement types can be used at the same time. Test thouroughly before implementing on a live site.</p><br/>
                        	<p>Example:<br/>
                        	blank::>*remove*,barney::>orange dinosaur,world wide web::>www </p>
                        	<p>The above example would replace "blank" with nothing, "barney" with "orange dinosaur", and "world wide web" with "www"</p>
                            <p>This runs before and after all other text formatting, so you can base your replacements off of what the text will be before and/or after other formatting options are run!  Always test to verify your expected results!</p>
						</div>
					</div>
                </td>
            </tr>
            <tr class="settingstrgrey" valign="top">
                <th class="settings" scope="row">Central Strict Text Replacement</th>
                <td>
				   <textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfaf_strict_text_replace" value="<?php echo esc_html__(get_option('gfaf_strict_text_replace')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfaf_strict_text_replace'); ?></textarea>
					<div id="gfaf-strict-text-replace-instructions" style="max-width:600px;">
						<p><b>Enter comma separated text::>replacement_text to automatically replace any occurances of the text with the replacement text when the form entry is saved to the database in fields with "Text Replacement" turned on.</b></p><br/>
						<p>-Special characters (including commas) <b>allowed</b>. Read Option Guide.</p><br/>
						<p>Use NO spacing between commas and your term/phrase or the space will be included as part of the term/phrase.<br/>
							Please be sure that your field data will still be valid for the field and any other processing to be performed on that field data after any input text has been replaced.</p><br/>
						<p>A field's Individual Text Replacements are performed after the Central Text Replacements if The field also uses Central Text Replacement.</p><br/>
						<p><button id="gfaf-strict-text-replace-instructions-idToggle" type="button" onClick="toggle_visibility('gfaf-strict-text-replace-instructionsToggle');" >SHOW/HIDE OPTION GUIDE</button></p>
                        <div id="gfaf-strict-text-replace-instructionsToggle" style="display:none;">
                        	<p>Example:   to replace "fool" with "nice person", enter fool::>nice person</p>
                        	<p>To replace text with nothing use:   *remove*   as the replacement text.</p>
							<p>To use a comma in your search or replacement text use:   *comma* in place of the comma in the search or replacement text.</p>
							<p>Text is case sensitive.</p>
                        	<p>This will search for and replace both complete and partial text/characters found in the submitted content of the field when saved to the database. For example if you enter "fool", the text "fool" would be also be replaced in the words "foolish" and "fools". You cannot use commas in the terms/phrases or thier replacements. You CAN use other special characters in terms and replacements. To replace exact words/phrases only, please use the standard "Central Text Replacement" option above. Both Text Replacement types can be used at the same time. There is NO notice given to the submitting user of the text replacement.  Test thouroughly before implementing on a live site.</p><br/>
                        	<p>Example:<br/>
                        	:)::>*remove*,barney::>orange dinosaur,http://www::>www,*comma*::>-, </p>
                        	<p>The above example would replace ":)" with nothing, "barney" with "orange dinosaur", "http://www" with "www", and "," with "-"</p>
                            <p>This runs before and after all other text formatting, so you can base your replacements off of what the text will be before and/or after other formatting options are run! Always test to verify your expected results!</p>
						</div>
					</div>
                </td>
            </tr>
            <tr class="settingstr" valign="top">
                <th class="settings" scope="row">Save Plugin Options on Uninstall</th>
                <td>
				    <input type="checkbox" name="gfaf_delete_options" value="1" <?php checked(1, get_option('gfaf_delete_options'), true); ?> />
					<div id="gfaf-delete-options-instructions" style="max-width:600px;">
						<p><b>Turn this on to save the current plugin options on uninstallation.</b></p><br/>
					</div>
                </td>
            </tr>
        </table> 
        <?php submit_button();?>        
    </form>
    <?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/owl-small.png" height="30" width="30" style="display:inline-block; float:left;">'; ?><p> <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank">Plugin Owl</a></p>
    </div>
<?php }
<?php

if (file_exists(__DIR__ . '/inc/plugin-setup.php')) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}

?>
