<?php
/**
 * @package   Gravity_Forms_Auto_Formatter
 * @author    PluginOwl <info@pluginowl.com>
 * @link      https://codecanyon.net/user/pluginowl/portfolio
 * @Copyright: Plugin Owl
 *
 * @wordpress-plugin
 * Plugin Name: Gravity Forms Auto Formatter
 * Plugin URI: https://codecanyon.net/item/gravity-forms-auto-formatter/19513275
 * Description: Extends Gravity Forms with automatic formatting, sanitization, and many other useful options.
 * Version: 2.8.71
 * Author: Plugin Owl
 * Author URI: https://codecanyon.net/user/pluginowl/portfolio
 * Copyright: Plugin Owl
 * Text Domain: gravity-forms-auto-formatter
 * Domain Path: /languages
 */

// Prevent direct access to this file.
if (!defined('ABSPATH')) {
    header('HTTP/1.0 403 Forbidden');
    echo '404 File Not Found';
    exit; // Exit if accessed directly
}
//redundancy with alt instruction
defined('ABSPATH') or die();

//prevent redundant loading if WP is loaded more than once
if (defined('GFAF_PLUGIN_FILE')) {
	exit;
}

// Main file path
define('GFAF_PLUGIN_FILE', __FILE__);

// Set Gravity Forms dependency on activation
function gfaf_activate() {
    if (!function_exists('is_plugin_active_for_network')) {
      include_once(ABSPATH . '/wp-admin/includes/plugin.php');
    }
    if (current_user_can('activate_plugins') && !class_exists('GFCommon')) {
        deactivate_plugins(plugin_basename(__FILE__));
        $error_message = '<p style="font-family:-apple-system,BlinkMacSystemFont,\'Segoe UI\',Roboto,Oxygen-Sans,Ubuntu,Cantarell,\'Helvetica Neue\',sans-serif;font-size: 13px;line-height: 1.5;color:#444;">' . esc_html__('GF Auto Formatter plugin is an add-on to ', 'gfef') . '<a href="' . esc_url('https://gravityforms.com') . '" target="blank" rel="nofollow noopener">Gravity Forms</a>' . esc_html(' and requires the ', 'gfef') . '<a href="' . esc_url('https://gravityforms.com') . '" target="blank" rel="nofollow noopener">Gravity Forms</a>' . esc_html__(' plugin to be installed and active. Plugin has not been activated', 'gfef') . '</p>';
        die($error_message);
    }
}
register_activation_hook(__FILE__, 'gfaf_activate');

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}
//load plugin on gform_loaded
add_action('gform_loaded', array('GFAF_Framework_AddOn', 'load'), 5);
class GFAF_Framework_AddOn {
    public static function load() {
        if (!method_exists('GFForms', 'include_addon_framework')) {
            return;
        }
        require_once('gfaf.php');
    }
}
