<?php

namespace WP_JobsearchCandElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use WP_Jobsearch\Candidate_Profile_Restriction;

if (!defined('ABSPATH'))
    exit;

/**
 * @since 1.1.0
 */
class SingleCandidateExpertise extends Widget_Base {

    /**
     * Retrieve the widget name.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'single-candidate-expertise';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Single Candidate Expertise', 'wp-jobsearch');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-link';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['jobsearch-cand-single'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.1.0
     *
     * @access protected
     */
    protected function register_controls() {
        
    }

    protected function render() {
        global $post, $jobsearch_plugin_options;
        $candidate_id = is_admin() ? jobsearch_candidate_id_elementor() : $post->ID;
        $cand_profile_restrict = new Candidate_Profile_Restriction;

        $inopt_resm_skills = isset($jobsearch_plugin_options['cand_resm_skills']) ? $jobsearch_plugin_options['cand_resm_skills'] : '';

        ob_start();
        if (!$cand_profile_restrict::cand_field_is_locked('expertise_defields', 'detail_page')) {
            ob_start();
            $exfield_list = get_post_meta($candidate_id, 'jobsearch_field_skill_title', true);
            $skill_percentagefield_list = get_post_meta($candidate_id, 'jobsearch_field_skill_percentage', true);
            if (is_array($exfield_list) && sizeof($exfield_list) > 0) {
                ?>
                <div class="jobsearch_progressbar_wrap">
                    <div class="jobsearch-row">
                        <div class="jobsearch-column-12">
                            <div class="jobsearch-candidate-title">
                                <h2>
                                    <i class="jobsearch-icon jobsearch-design-skills"></i> <?php esc_html_e('Expertise', 'wp-jobsearch') ?>
                                </h2>
                            </div>
                        </div>
                        <?php
                        $exfield_counter = 0;
                        foreach ($exfield_list as $exfield) {
                            $rand_num = rand(1000000, 99999999);
                            $skill_percentagefield_val = isset($skill_percentagefield_list[$exfield_counter]) ? absint($skill_percentagefield_list[$exfield_counter]) : '';
                            $skill_percentagefield_val = $skill_percentagefield_val > 100 ? 100 : $skill_percentagefield_val;
                            ?>
                            <div class="jobsearch-column-6">
                                <div class="jobsearch_progressbar1"
                                     data-width='<?php echo($skill_percentagefield_val) ?>'><?php echo($exfield) ?></div>
                            </div>
                            <?php
                            $exfield_counter++;
                        }
                        ?>
                    </div>
                </div>

                <?php
            }
            $expertise_html = ob_get_clean();
            if ($inopt_resm_skills != 'off') {
                echo apply_filters('jobsearch_candidate_detail_expertise_html', $expertise_html, $candidate_id);
            }
        }
        $html = ob_get_clean();
        echo $html;
    }

    protected function content_template() {
        
    }

}
