<?php

global $wpdb, $table_prefix;

$posts_table = $table_prefix . 'posts';

$query = "SELECT posts.ID,posts.post_title FROM $posts_table AS posts";
$query .= " WHERE posts.post_type=%s AND posts.post_status='publish'";
$query .= " GROUP BY posts.ID";
$query .= " ORDER BY posts.ID DESC";

$items = $wpdb->get_results($wpdb->prepare($query, 'package'), 'ARRAY_A');
$pkgs_list = [];
if (!empty($items)) {
    foreach ($items as $pkg_itm) {
        $pkgs_list[$pkg_itm['ID']] = $pkg_itm['post_title'];
    }
}

$jobsearch_builder_shortcodes['jobsearch_multi_packages'] = array(
    'title' => esc_html__('All Packages', 'wp-jobsearch'),
    'id' => 'jobsearch-allpackages-shortcode',
    'template' => '[jobsearch_multi_packages {{attributes}}] {{content}} [/jobsearch_multi_packages]',
    'params' => array(
        'title' => array(
            'std' => '',
            'type' => 'text',
            'label' => esc_html__('Title', 'wp-jobsearch'),
            'desc' => '',
        ),
        'selected_packages' => array(
            'type' => 'multi_checkbox',
            'label' => esc_html__('Select Packages', 'wp-jobsearch'),
            'desc' => esc_html__('Please Select the Packages.', 'wp-jobsearch'),
            'options' => $pkgs_list
        ),
    )
);
