<?php
/*
  Class : Login_Registration
 */


// this is an include only WP file
if (!defined('ABSPATH')) {
    die;
}

add_action('login_footer', function() {
    ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script type="text/javascript">
        jQuery(document).on('click', '.jobsearch-resend-accactbtn', function (e) {
            e.preventDefault();
            var _this = jQuery(this);
            var user_login = _this.attr('data-login');
            _this.find('em').remove();
            var _this_html = _this.html();
            _this.html(_this_html + '<em>(<?php _e('Sending Email...', 'wp-jobsearch') ?></em>)');
            var request = jQuery.ajax({
                url: '<?php echo admin_url('admin-ajax.php') ?>',
                method: "POST",
                data: {
                    user_login: user_login,
                    _nonce: '<?php echo esc_attr(wp_create_nonce('jobsearch_ajax_nonce')) ?>',
                    action: 'jobsearch_resend_user_acc_approval_email',
                },
                dataType: "json"
            });

            request.done(function (response) {
                _this.html(_this_html + '<em>(<?php _e('Sent', 'wp-jobsearch') ?></em>)');
                window.location.reload(true);
            });

            request.fail(function (jqXHR, textStatus) {
                _this.html(_this_html + '<em>(<?php _e('Failed', 'wp-jobsearch') ?></em>)');
            });
        });
    </script>
    <?php
}, 25);

add_filter('wp_authenticate_user', 'jobsearch_ghghgh_user_auth_callback', 11, 2);

function jobsearch_ghghgh_user_auth_callback($user, $password = '')
{
    global $pagenow;

    $user_id = $user->ID;
    $accaprov_key_resent = get_user_meta($user_id, 'jobsearch_accaprov_key_resent', true);

    $user_login_auth = get_user_meta($user_id, 'jobsearch_accaprov_allow', true);
    if ($user_login_auth == '0') {
        $user_login = $user->user_login;
        $errors = new WP_Error();

        $active_popup_btnmsg = ' ' . __('If you have activation code then <a href="javascript:void(0);" class="jobsearch-activcode-popupbtn">Click here</a> to activate account.', 'wp-jobsearch');

        if ($pagenow == 'wp-login.php') {
            if ($accaprov_key_resent == '1') {
                $err_msg = __('Before you can login, you must activate your account with the code sent to your email address. If you did not receive this email, please check your junk/spam folder.', 'wp-jobsearch');
            } else {
                $err_msg = __('Before you can login, you must activate your account with the code sent to your email address. If you did not receive this email, please check your junk/spam folder. <a href="#" class="jobsearch-resend-accactbtn" data-login="' . $user_login . '">Click here</a> to resend the activation email.', 'wp-jobsearch');
            }
        } else {
            if ($accaprov_key_resent == '1') {
                $err_msg = __('Before you can login, you must activate your account with the code sent to your email address. If you did not receive this email, please check your junk/spam folder.', 'wp-jobsearch');
            } else {
                $err_msg = __('Before you can login, you must activate your account with the code sent to your email address. If you did not receive this email, please check your junk/spam folder. <a href="javascript:void(0);" class="jobsearch-resend-accactbtn" data-login="' . $user_login . '">Click here</a> to resend the activation email.', 'wp-jobsearch');
            }
        }

        $errors->add('appauth_error', $err_msg);
        return $errors;
    }

    return $user;
}

add_action('wp_footer', function() {
    global $jobsearch_plugin_options;

    $firebase_otp_switch = isset($jobsearch_plugin_options['firebase_otp_auth']) ? $jobsearch_plugin_options['firebase_otp_auth'] : '';
    $firebase_otp_config = isset($jobsearch_plugin_options['firebase_otp_config_code']) ? $jobsearch_plugin_options['firebase_otp_config_code'] : '';

    if ($firebase_otp_switch == 'on' && $firebase_otp_config != '' && !is_user_logged_in()) {

        wp_enqueue_script('jobsearch-firebase-app');
        wp_enqueue_script('jobsearch-firebase-auth');
        wp_enqueue_script('jobsearch-firebase-analytics');
    }
}, 1);

add_action('wp_footer', 'jobsearch_add_firebase_intialize_scripting', 99);

function jobsearch_add_firebase_intialize_scripting() {
    global $jobsearch_plugin_options;

    $firebase_otp_switch = isset($jobsearch_plugin_options['firebase_otp_auth']) ? $jobsearch_plugin_options['firebase_otp_auth'] : '';
    $firebase_otp_config = isset($jobsearch_plugin_options['firebase_otp_config_code']) ? $jobsearch_plugin_options['firebase_otp_config_code'] : '';

    if ($firebase_otp_switch == 'on' && $firebase_otp_config != '' && !is_user_logged_in()) {
        ?>
        <script>
            jQuery(document).ready(function() {
                <?php echo wp_kses($firebase_otp_config, []) ?>

                // Initialize Firebase
                firebase.initializeApp(firebaseConfig);
                firebase.auth().languageCode = "en";

                if (jQuery('#jobsearch_reg_va_fr_otp').length > 0) {
                    window.recaptchaVerifier = new firebase.auth.RecaptchaVerifier('jobsearch_reg_va_fr_otp', {
                        'size': 'invisible',
                        'callback': function (response) {},
                        'expired-callback': function () {},
                        'error-callback': function () {}
                    });
                }
            });
            //
            jQuery('.jobsearch-usereg-otptriger').on('click', function() {
                var this_btn = jQuery(this);
                var this_parent_con = this_btn.parents('.jobsearch-sendin-otpcon');
                var parent_form = this_btn.parents('form');
                var phon_num_field = parent_form.find('input[name="pt_user_phone"]');
                var loder_con = this_parent_con.find('.sendin-otp-loder');
                var genral_errmsg_con = this_parent_con.find('.sendin-otpcon-errmsg');
                genral_errmsg_con.hide();
                if (phon_num_field.length > 0) {
                    if (parent_form.find('input[name="dial_code"]').length > 0) {
                        var dial_code_val = parent_form.find('input[name="dial_code"]').val();
                        var phon_num_val = dial_code_val + phon_num_field.val();
                    } else {
                        var phon_num_val = phon_num_field.val();
                    }
                    if (phon_num_val == '') {
                        genral_errmsg_con.html('<?php _e('A valid phone number is required to send OTP.', 'wp-jobsearch'); ?>').slideDown();
                    } else {
                        loder_con.html('<i class="fa fa-refresh fa-spin"></i>');
                        this_btn.addClass('jobsearch-disable-btn');
                        var appVerifier = window.recaptchaVerifier;
                        firebase.auth().signInWithPhoneNumber(phon_num_val, appVerifier).then(function (confirmationResult) {
                            //console.log(confirmationResult);
                            window.confirmationResult = confirmationResult;
                            //
                            this_btn.hide();
                            this_parent_con.find('.jobsearch-fill-otpcon').find('.userfill-otp-msgcon').find('strong').html(phon_num_val);
                            this_parent_con.find('.jobsearch-fill-otpcon').slideDown();
                            loder_con.html('');
                        }).catch(function (error) {
                            console.log(error);
                            genral_errmsg_con.html(error.code + ': ' + error.message).slideDown();
                            loder_con.html('');
                            this_btn.removeClass('jobsearch-disable-btn');
                        });
                    }
                } else {
                    genral_errmsg_con.html('<?php _e('A valid phone number is required to send OTP.', 'wp-jobsearch'); ?>').slideDown();
                }
            });

            jQuery('.jobsearch-regotp-checkbtn').on('click', function() {
                var this_btn = jQuery(this);
                var this_parent_con = this_btn.parents('.jobsearch-sendin-otpcon');
                var genral_errmsg_con = this_parent_con.find('.sendin-otpcon-errmsg');

                genral_errmsg_con.hide();

                var otp_code = this_parent_con.find('.jobsearch-userfill-otp-field').val();
                if (otp_code == '') {
                    genral_errmsg_con.html('<?php _e('Please enter the OTP code first.', 'wp-jobsearch'); ?>').slideDown();
                } else {
                    jobsearch_phone_otp_check_call(this_btn, confirmationResult, otp_code);
                }
            });

            function jobsearch_phone_otp_check_call(this_btn, confirmationResult, otp_code) {
                var this_parent_con = this_btn.parents('.jobsearch-sendin-otpcon');
                var genral_errmsg_con = this_parent_con.find('.sendin-otpcon-errmsg');
                var loder_con = this_parent_con.find('.cheking-otp-loder');
                var parent_form = this_btn.parents('form');

                this_btn.addClass('jobsearch-disable-btn');
                loder_con.html('<i class="fa fa-refresh fa-spin"></i>');

                confirmationResult.confirm(otp_code).then(function (result) {
                    parent_form.find('.regsend-submit-btncon').removeAttr('style');
                    this_btn.parent('.userfill-otp-btnholdr').hide();
                    loder_con.html('');
                    this_parent_con.find('.userfill-otp-msgcon').addClass('alert alert-success');
                    this_parent_con.find('.userfill-otp-msgcon').find('em').html('<?php _e('You have successfully validated the OTP code. Great job! Now you are authorize to register your account.', 'wp-jobsearch'); ?>');
                }).catch(function (error) {
                    console.log(error);
                    genral_errmsg_con.html(error.code + ': ' + error.message).slideDown();
                    loder_con.html('');
                    this_btn.removeClass('jobsearch-disable-btn');
                });
            }
        </script>
        <?php
    }
}

// main plugin class
class Jobsearch_Login_Registration_Submit
{

    // hook things up
    public function __construct()
    {
        add_action('wp_ajax_jobsearch_login_member_submit', array($this, 'jobsearch_login_member_submit_callback'), 1);
        add_action('wp_ajax_nopriv_jobsearch_login_member_submit', array($this, 'jobsearch_login_member_submit_callback'), 1);
        add_action('wp_ajax_nopriv_jobsearch_reset_password', array($this, 'jobsearch_reset_password_callback'), 1);
        add_action('wp_ajax_jobsearch_register_member_submit', array($this, 'jobsearch_register_member_submit_callback'), 1);
        add_action('wp_ajax_nopriv_jobsearch_register_member_submit', array($this, 'jobsearch_register_member_submit_callback'), 1);

        add_action('init', array($this, 'reset_password_form'));

        add_action('wp_ajax_jobsearch_demo_user_login', array($this, 'demo_user_login'));
        add_action('wp_ajax_nopriv_jobsearch_demo_user_login', array($this, 'demo_user_login'));

        add_action('wp_ajax_jobsearch_resend_user_acc_approval_email', array($this, 'resend_user_account_activation'));
        add_action('wp_ajax_nopriv_jobsearch_resend_user_acc_approval_email', array($this, 'resend_user_account_activation'));

        add_action('wp_ajax_jobsearch_pass_reseting_by_redirect_url', array($this, 'reset_password_from_redirect'));
        add_action('wp_ajax_nopriv_jobsearch_pass_reseting_by_redirect_url', array($this, 'reset_password_from_redirect'));

        add_action('wp_ajax_jobsearch_activememb_accont_by_activation_url', array($this, 'user_account_activation'));
        add_action('wp_ajax_nopriv_jobsearch_activememb_accont_by_activation_url', array($this, 'user_account_activation'));

        add_action('user_register', array($this, 'jobsearch_registration_save'), 10, 1);
        add_action('jobsearch_when_user_update_at_bkend', array($this, 'jobsearch_registration_save'), 10, 1);
        add_action('jobsearch_user_create_post_manualy', array($this, 'jobsearch_registration_save'), 10, 1);
        
        // for mobile reg
        add_action('wp_ajax_jobsearch_check_mob_no_otp', array($this, 'sendcheck_mob_no_otp'));
        add_action('wp_ajax_nopriv_jobsearch_check_mob_no_otp', array($this, 'sendcheck_mob_no_otp'));
    }

    public function demo_user_login()
    {

        global $jobsearch_plugin_options;
        $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
        if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
            $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
            echo json_encode(array('msg' => $msg, 'error' => '1'));
            die;
        }
        $lang_code = '';
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            $lang_code = isset($_REQUEST['lang']) ? $_REQUEST['lang'] : '';
        }
        
        $user_type = isset($_POST['user_type']) ? sanitize_text_field($_POST['user_type']) : '';
        $demo_candidate = isset($jobsearch_plugin_options['demo_candidate']) ? $jobsearch_plugin_options['demo_candidate'] : '';
        $demo_employer = isset($jobsearch_plugin_options['demo_employer']) ? $jobsearch_plugin_options['demo_employer'] : '';

        $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
        $user_dashboard_page = jobsearch__get_post_id($user_dashboard_page, 'page');
        $page_url = jobsearch_wpml_lang_page_permalink($user_dashboard_page, 'page', $lang_code); //get_permalink($user_dashboard_page);

        if ($user_type == 'employer') {
            $_demo_user_obj = get_user_by('login', $demo_employer);
            if (isset($_demo_user_obj->ID)) {
                apply_filters('update_login_status', '', $_demo_user_obj);
                wp_set_current_user($_demo_user_obj->ID, $_demo_user_obj->user_login);
                wp_set_auth_cookie($_demo_user_obj->ID);
                echo json_encode(array('redirect' => $page_url, 'msg' => ''));
            }
        } else {
            $_demo_user_obj = get_user_by('login', $demo_candidate);

            if (isset($_demo_user_obj->ID)) {
                apply_filters('update_login_status', '', $_demo_user_obj);
                wp_set_current_user($_demo_user_obj->ID, $_demo_user_obj->user_login);
                wp_set_auth_cookie($_demo_user_obj->ID);
                echo json_encode(array('redirect' => $page_url, 'msg' => ''));
            }
        }
        die;
    }

    public function jobsearch_login_member_submit_callback()
    {
        global $jobsearch_plugin_options, $sitepress;

        // Check CSRF token
        if (!check_ajax_referer('ajax-login-nonce', 'register-security', false)) {
            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Session token has expired, please reload the page and try again', 'wp-jobsearch') . '</div>'));
            die();
        }

        $lang_code = '';
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            $lang_code = isset($_REQUEST['lang']) ? $_REQUEST['lang'] : '';
        }
        
        $current_time = current_time('timestamp');

        $user_login = sanitize_text_field($_POST['pt_user_login']);
        $user_pass = sanitize_text_field($_POST['pt_user_pass']);
        $remember_password = isset($_POST['remember_password']) && $_POST['remember_password'] == 'on' ? true : false;

        $before_signon_error = false;

        $wredirct_url = isset($_POST['jobsearch_wredirct_url']) ? sanitize_text_field($_POST['jobsearch_wredirct_url']) : '';
        $extra_params = isset($_POST['extra_login_params']) ? $_POST['extra_login_params'] : '';

        $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
        $user_dashboard_page = jobsearch__get_post_id($user_dashboard_page, 'page');
        $page_url = jobsearch_wpml_lang_page_permalink($user_dashboard_page, 'page', $lang_code); //get_permalink($user_dashboard_page);
        //
        $cand_opt_redirect_url = isset($jobsearch_plugin_options['cand-login-redirect-url']) ? $jobsearch_plugin_options['cand-login-redirect-url'] : '';
        $emp_opt_redirect_url = isset($jobsearch_plugin_options['emp-login-redirect-url']) ? $jobsearch_plugin_options['emp-login-redirect-url'] : '';

        // for already logged-in user
        if (is_user_logged_in()) {
            if (empty($user_login) || empty($user_pass)) {
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Please fill all form fields', 'wp-jobsearch') . '</div>'));
            }
            wp_logout();
        }

        // Check if input variables are empty
        if (empty($user_login) || empty($user_pass)) {

            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Please fill all form fields', 'wp-jobsearch') . '</div>'));
        } else {

            $active_popup_btnmsg = ' ' . __('If you have activation code then <a href="javascript:void(0);" class="jobsearch-activcode-popupbtn">Click here</a> to activate account.', 'wp-jobsearch');

            if (filter_var($user_login, FILTER_VALIDATE_EMAIL)) {
                $user_objj = get_user_by('email', $user_login);
            } else {
                $user_objj = get_user_by('login', $user_login);
            }
            $user_id = isset($user_objj->ID) ? $user_objj->ID : '0';

            $user_is_candidate = jobsearch_user_is_candidate($user_id);
            $user_is_employer = jobsearch_user_is_employer($user_id);

            $user_login_auth = get_user_meta($user_id, 'jobsearch_accaprov_allow', true);

            $not_active_popup_btnmsg = sprintf(__('Before you can login, you must activate your account with the code sent to your email address. If you did not receive this email, please check your junk/spam folder. <a href="javascript:void(0);" class="jobsearch-resend-accactbtn" %s >Click here</a> to resend the activation email.', 'wp-jobsearch'), 'data-login="' . $user_login . '"');

            if ($user_login_auth == '0' && isset($user_objj->ID)) {
                echo json_encode(array('error' => false, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . apply_filters('jobsearch_loginerr_msg_no_activ_account', $not_active_popup_btnmsg, $user_login) . $active_popup_btnmsg . '</div>'));
                die;
            }

            $before_signon_error = apply_filters('jobsearch_user_login_err_before_signon', $before_signon_error, $user_login, $user_pass);

            if ($before_signon_error) {
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $before_signon_error . '</div>'));
                die;
            }

            // setting redirect url here
            if ($user_is_candidate && $cand_opt_redirect_url != '') {
                $page_url = esc_url_raw($cand_opt_redirect_url);
                if ($lang_code != '') {
                    $page_url = add_query_arg(array('lang' => $lang_code), $page_url);
                }
            } else if ($user_is_employer && $emp_opt_redirect_url != '') {
                $page_url = esc_url_raw($emp_opt_redirect_url);
                if ($lang_code != '') {
                    $page_url = add_query_arg(array('lang' => $lang_code), $page_url);
                }
            }

            if ($wredirct_url != '') {
                set_transient('jobsearch_user_reglogin_' . $user_id . '_redirect_url', $wredirct_url, 300);
                $page_url = $wredirct_url;
            }

            $creds = array();
            $creds['user_login'] = $user_login;
            $creds['user_password'] = $user_pass;
            $creds['remember'] = $remember_password;

            $user = wp_signon($creds, false);


            if (is_wp_error($user)) {
                $errors_html = wp_kses($user->get_error_message(), array('strong' => array(), 'p' => array()));

                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $errors_html . '</div>'));
            } else {
                $user_id = $user->ID;
                update_user_meta($user_id, 'jobsearch_last_active', $current_time);
                
                $login_args = array(
                    'login_user' => $user,
                    'current_page_id' => (isset($_POST['current_page_id']) ? sanitize_text_field($_POST['current_page_id']) : 0),
                    'extra_params' => $extra_params,
                    'wredirct_url' => $wredirct_url,
                );
                echo apply_filters('jobsearch_after_logged_in_before_msg', '', $login_args);

                $cur_user_obj = get_user_by('ID', $user_id);

                wp_set_current_user($cur_user_obj->ID, $cur_user_obj->user_login);
                wp_set_auth_cookie($cur_user_obj->ID);

                if (in_array('administrator', (array)$cur_user_obj->roles)) {
                    $page_url = admin_url();
                }

                echo json_encode(array('error' => false, 'redirect' => apply_filters('jobsearch_dash_redirect_purl_after_login', $page_url), 'message' => '<div class="alert alert-success"><i class="fa fa-check"></i> ' . __('Login successful, reloading page...', 'wp-jobsearch') . '</div>'));
            }
        }

        die();
    }

    public function jobsearch_reset_password_callback()
    {
        $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
        if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
            $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
            echo json_encode(array('msg' => $msg, 'error' => '1'));
            die;
        }
        // Get variables
        $username_or_email = sanitize_text_field($_POST['pt_user_or_email']);

        if (empty($username_or_email)) {
            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Please fill all form fields', 'wp-jobsearch') . '</div>'));
        } else {

            $username = is_email($username_or_email) ? sanitize_email($username_or_email) : sanitize_user($username_or_email);

            $user_forgotten = $this->lost_password_retrieve($username);

            if (is_wp_error($user_forgotten)) {

                $lostpass_error_messages = $user_forgotten->errors;

                $display_errors = '<div class="alert alert-warning">';
                foreach ($lostpass_error_messages as $error) {
                    $display_errors .= '<p>' . $error[0] . '</p>';
                }
                $display_errors .= '</div>';

                echo json_encode(array('error' => true, 'message' => $display_errors));
            } else {
                echo json_encode(array('error' => false, 'message' => '<p class="alert alert-success"><i class="fa fa-check"></i> ' . __('Please check your email to reset the password.', 'wp-jobsearch') . '</p>'));
            }
        }

        die();
    }

    private function lost_password_retrieve($user_input) {

        global $wpdb, $wp_hasher;
        $errors = new WP_Error();
        if (empty($user_input)) {
            $errors->add('empty_username', __('<i class="fa fa-times"></i> <strong>ERROR</strong>: Enter a username or email address.', 'wp-jobsearch'));
        } elseif (strpos($user_input, '@')) {
            $user_data = get_user_by('email', trim($user_input));
            if (!is_object($user_data)) {
                $user_data = get_user_by('login', trim($user_input));
            }
            if (empty($user_data)) {
                $errors->add('invalid_email', __('<i class="fa fa-times"></i> <strong>ERROR</strong>: There is no user registered with that email address.', 'wp-jobsearch'));
            }
        } else {
            $login = trim($user_input);
            $user_data = get_user_by('login', $login);
        }

        /**
         * Fires before errors are returned from a password reset request.
         *
         *
         * @param WP_Error $errors A WP_Error object containing any errors generated
         * by using invalid credentials.
         */
        //do_action('lostpassword_post', $errors);

        if ($errors->get_error_code())
            return $errors;

        if (!$user_data) {
            $errors->add('invalidcombo', __('<i class="fa fa-times"></i> <strong>ERROR</strong>: Invalid username or email.', 'wp-jobsearch'));
            return $errors;
        }

        // Redefining user_login ensures we return the right case in the email.
        $user_login = $user_data->user_login;
        $user_email = $user_data->user_email;
        //$key = get_password_reset_key($user_data);
        $key = wp_generate_password(20, false);
        update_user_meta($user_data->ID, 'password_retrieve_key', $key);

        $message = __('Someone has requested a password reset for the following account:', 'wp-jobsearch') . "\r\n\r\n";
        $message .= home_url('/') . "\r\n\r\n";
        $message .= sprintf(__('Username: %s', 'wp-jobsearch'), $user_login) . "\r\n\r\n";
        $message .= __('If this was a mistake, just ignore this email and nothing will happen.', 'wp-jobsearch') . "\r\n\r\n";
        $message .= __('To reset your password, visit the following address:', 'wp-jobsearch') . "\r\n\r\n";
        $message .= '<' . home_url("/?login_action=jobsearch_rp&key=$key&login=" . rawurlencode($user_login)) . ">\r\n";

        if (is_multisite())
            $blogname = $GLOBALS['current_site']->site_name;
        else
            /*
             * The blogname option is escaped with esc_html on the way into the database
             * in sanitize_option we want to reverse this for the plain text arena of emails.
             */
            $blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);

        $title = sprintf(__('[%s] Password Reset', 'wp-jobsearch'), $blogname);

        /**
         * Filter the subject of the password reset email.
         *
         *
         * @param string $title Default email title.
         * @param string $user_login The username for the user.
         * @param WP_User $user_data WP_User object.
         */
        $title = apply_filters('retrieve_password_title', $title, $user_login, $user_data);

        /**
         * Filter the message body of the password reset mail.
         *
         *
         * @param string $message Default mail message.
         * @param string $key The activation key.
         * @param string $user_login The username for the user.
         * @param WP_User $user_data WP_User object.
         */
        $message = apply_filters('retrieve_password_message', $message, $key, $user_login, $user_data);

        // if ($message && !wp_mail($user_email, wp_specialchars_decode($title), $message))
        // $errors->add('mailfailed', __('<i class="fa fa-times"></i> <strong>ERROR</strong>: The email could not be sent. Possible reason: your host may have disabled the mail() function.', 'wp-jobsearch'));

        do_action('jobsearch_reset_password_request', $user_data, $key);

        return true;
    }

    public function reset_password_form()
    {
        $user_login = isset($_GET['login']) ? sanitize_text_field($_GET['login']) : '';
        $reg_key = isset($_GET['key']) ? sanitize_text_field($_GET['key']) : '';
        $get_action = isset($_GET['login_action']) ? sanitize_text_field($_GET['login_action']) : '';

        if ($user_login != '' && $reg_key != '' && $get_action == 'jobsearch_rp') {
            if (strpos($user_login, '@')) {
                $user_obj = get_user_by('email', trim($user_login));
                if (!is_object($user_obj)) {
                    $user_obj = get_user_by('login', trim($user_login));
                }
            } else {
                $user_obj = get_user_by('login', trim($user_login));
            }

            $user_id = isset($user_obj->ID) ? $user_obj->ID : 0;
            $user_email = isset($user_obj->user_email) ? $user_obj->user_email : '';

            $user_key = get_user_meta($user_id, 'password_retrieve_key', true);

            if ($user_email != '' && $user_key == $reg_key) {

                $popup_args = array('p_user_login' => $user_login, 'p_reg_key' => $reg_key, 'p_user_id' => $user_id);
                add_action('wp_footer', function () use ($popup_args) {

                    extract(shortcode_atts(array(
                        'p_user_login' => '',
                        'p_reg_key' => '',
                        'p_user_id' => '',
                    ), $popup_args));
                    $jobsearch_nonce = wp_create_nonce('reset_password');
                    ?>
                    <div class="jobsearch-modal fade" id="JobSearchModalResetPassForm">
                        <div class="modal-inner-area">&nbsp;</div>
                        <div class="modal-content-area">
                            <div class="modal-box-area">
                                <div class="jobsearch-modal-title-box">
                                    <h2><?php esc_html_e('Reset Your Password', 'wp-jobsearch'); ?></h2>
                                    <span class="modal-close"><i class="fa fa-times"></i></span>
                                </div>
                                <div class="jobsearch-send-message-form">
                                    <form autocomplete="off" method="post" id="jobsearch_reset_pass_form">
                                       <input type="hidden" name="password_nonce" value="<?php echo esc_attr($jobsearch_nonce);?>" />
                                        <div class="jobsearch-user-form">
                                            <ul class="email-fields-list">
                                                <li>
                                                    <label>
                                                        <?php echo esc_html__('New Password', 'wp-jobsearch'); ?>:
                                                    </label>
                                                    <div class="input-field">
                                                        <input type="password" class="jobsearch_chk_passfield"
                                                               name="new_pass"/>
                                                        <span class="passlenth-chk-msg"></span>
                                                    </div>
                                                </li>
                                                <li>
                                                    <label>
                                                        <?php echo esc_html__('Confirm Password', 'wp-jobsearch'); ?>:
                                                    </label>
                                                    <div class="input-field">
                                                        <input type="password" name="conf_pass"/>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="input-field-submit">
                                                        <input type="submit"
                                                               class="user-passreset-submit-btn jobsearch-regpass-frmbtn jobsearch-disable-btn"
                                                               disabled
                                                               data-id="<?php echo($p_user_id) ?>"
                                                               data-key="<?php echo($p_reg_key) ?>"
                                                               value="<?php esc_html_e('Reset Password', 'wp-jobsearch'); ?>"/>
                                                        <span class="loader-box"></span>
                                                    </div>
                                                </li>
                                            </ul>
                                            <div class="message-box" style="display:none;"></div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        jQuery(document).ready(function () {
                            jobsearch_modal_popup_open('JobSearchModalResetPassForm');
                        });
                    </script>
                    <?php
                }, 99, 1);
            }
        }
    }

    public function reset_password_from_redirect()
    {        
        if (isset($_POST['password_nonce']) && wp_verify_nonce($_POST['password_nonce'], 'reset_password')) {                  
            $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : '';
            $user_key = isset($_POST['user_key']) ? sanitize_text_field($_POST['user_key']) : '';
            $new_pass = isset($_POST['new_pass']) ? sanitize_text_field($_POST['new_pass']) : '';
            $conf_pass = isset($_POST['conf_pass']) ? sanitize_text_field($_POST['conf_pass']) : '';
            $user_s_key = get_user_meta($user_id, 'password_retrieve_key', true);
    
            if (!empty($user_key) && !empty($user_s_key) && $user_key === $user_s_key) {
    
                if ($new_pass == $conf_pass) {
                    $user_def_array = array(
                        'ID' => $user_id,
                        'user_pass' => $new_pass,
                    );
                    wp_update_user($user_def_array);
                    $c_user = get_user_by('ID', $user_id);
                    update_user_meta($user_id, 'password_retrieve_key', '');
                    do_action('jobsearch_user_password_change', $c_user, $new_pass);
                    echo json_encode(array('error' => '0', 'msg' => esc_html__('Password changed successfully.', 'wp-jobsearch')));
                    die;
                } else {
                    echo json_encode(array('error' => '1', 'msg' => esc_html__('Confirm password does not match.', 'wp-jobsearch')));
                    die;
                }
            }
        }

        echo json_encode(array('error' => '1', 'msg' => esc_html__('You cannot change the password.', 'wp-jobsearch')));
        die;
    }

    public function user_account_activation()
    {
        $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
        if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
            $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
            echo json_encode(array('msg' => $msg, 'error' => '1'));
            die;
        }
        $jobsearch__options = get_option('jobsearch_plugin_options');
        $user_dashboard_page = isset($jobsearch__options['user-dashboard-template-page']) ? $jobsearch__options['user-dashboard-template-page'] : '';
        $user_dashboard_page = jobsearch__get_post_id($user_dashboard_page, 'page');
        $page_url = jobsearch_wpml_lang_page_permalink($user_dashboard_page, 'page');

        $cand_opt_redirect_url = isset($jobsearch__options['cand-signup-redirect-url']) ? $jobsearch__options['cand-signup-redirect-url'] : '';
        $emp_opt_redirect_url = isset($jobsearch__options['emp-signup-redirect-url']) ? $jobsearch__options['emp-signup-redirect-url'] : '';

        $user_email = isset($_POST['user_email']) ? sanitize_text_field($_POST['user_email']) : '';
        $active_code = isset($_POST['active_code']) ? sanitize_text_field($_POST['active_code']) : '';

        $candidate_auto_approve = isset($jobsearch__options['candidate_auto_approve']) ? $jobsearch__options['candidate_auto_approve'] : '';
        $employer_auto_approve = isset($jobsearch__options['employer_auto_approve']) ? $jobsearch__options['employer_auto_approve'] : '';

        $c_user = get_user_by('email', $user_email);
        $user_id = isset($c_user->ID) ? $c_user->ID : '';
        $user_s_key = get_user_meta($user_id, 'jobsearch_accaprov_key', true);

        do_action('jobsearch_before_user_acc_activation_incall', $user_id);

        $user_is_candidate = jobsearch_user_is_candidate($user_id);
        $user_is_employer = jobsearch_user_is_employer($user_id);
        if (!$user_is_candidate && !$user_is_employer) {
            do_action('jobsearch_user_create_post_manualy', $user_id);
            $user_is_candidate = jobsearch_user_is_candidate($user_id);
            $user_is_employer = jobsearch_user_is_employer($user_id);
        }

        if (!empty($user_s_key) && $active_code == $user_s_key) {
            if ($user_is_candidate && $candidate_auto_approve == 'email') {
                $candidate_id = jobsearch_get_user_candidate_id($user_id);
                update_post_meta($candidate_id, 'jobsearch_field_candidate_approved', 'on');
            }
            if ($user_is_employer && $employer_auto_approve == 'email') {
                $employer_id = jobsearch_get_user_employer_id($user_id);
                update_post_meta($employer_id, 'jobsearch_field_employer_approved', 'on');
            }
            update_user_meta($user_id, 'jobsearch_accaprov_allow', '1');
            
            // apply job if id exist
            $reg_job_id = get_user_meta($user_id, 'jobsearch_accaprov_jobaply_id', true);
            if ($reg_job_id > 0 && get_post_type($reg_job_id) == 'job') {
                $candidate_id = jobsearch_get_user_candidate_id($user_id);
                
                $job_apply_type = get_post_meta($reg_job_id, 'jobsearch_field_job_apply_type', true);
                
                $page_url = get_permalink($reg_job_id);
                
                $can_apply = true;
                $candidate_skills = isset($jobsearch__options['jobsearch_candidate_skills']) ? $jobsearch__options['jobsearch_candidate_skills'] : '';
                if ($candidate_skills == 'on') {
                    $candidate_approve_skill = isset($jobsearch__options['jobsearch-candidate-skills-percentage']) ? $jobsearch__options['jobsearch-candidate-skills-percentage'] : 0;
                    $candidate_skill_perc = get_post_meta($candidate_id, 'overall_skills_percentage', true);
                    if (($candidate_approve_skill > 0 && $candidate_skill_perc < $candidate_approve_skill)) {
                        $can_apply = false;
                    }
                }
                if ($candidate_auto_approve == 'admin_email') {
                    $can_apply = false;
                }
                
                if ($job_apply_type != 'with_email' && $job_apply_type != 'external') {
                    if ($can_apply) {
                        jobsearch_create_user_meta_list($reg_job_id, 'jobsearch-user-jobs-applied-list', $user_id);
                        $job_applicants_list = get_post_meta($reg_job_id, 'jobsearch_job_applicants_list', true);
                        if ($job_applicants_list != '') {
                            $job_applicants_list = explode(',', $job_applicants_list);
                            if (!in_array($candidate_id, $job_applicants_list)) {
                                $job_applicants_list[] = $candidate_id;
                            }
                            $job_applicants_list = implode(',', $job_applicants_list);
                        } else {
                            $job_applicants_list = $candidate_id;
                        }
                        update_post_meta($reg_job_id, 'jobsearch_job_applicants_list', $job_applicants_list);
                        do_action('jobsearch_job_applied_to_employer', $c_user, $reg_job_id);
                        do_action('jobsearch_job_applied_to_candidate', $c_user, $reg_job_id);
                    } else {
                        $page_url = add_query_arg(array('login_apply_job' => 'false'), $page_url);
                    }
                }
            }
            //

            // setting redirect url here
            if ($user_is_candidate && $cand_opt_redirect_url != '') {
                $page_url = esc_url_raw($cand_opt_redirect_url);
            } else if ($user_is_employer && $emp_opt_redirect_url != '') {
                $page_url = esc_url_raw($emp_opt_redirect_url);
            }

            $user_pass = get_user_meta($user_id, 'jobsearch_new_user_regtpass', true);
            if ($user_pass != '') {
                $user_pass = base64_decode($user_pass);
                do_action('jobsearch_new_user_register', $c_user, $user_pass);
            }
            wp_set_current_user($user_id, $c_user->user_login);
            wp_set_auth_cookie($user_id);
            echo json_encode(array('error' => '0', 'redirect' => $page_url, 'msg' => apply_filters('jbsearch_activacc_popup_aftr_submit_msg', esc_html__('Your account is activated. Now you can login your account.', 'wp-jobsearch'))));
            die;
        }
        echo json_encode(array('error' => '1', 'msg' => esc_html__('No record found to activate the account.', 'wp-jobsearch')));
        die;
    }

    public function resend_user_account_activation()
    {
        $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
        if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
            $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
            echo json_encode(array('msg' => $msg, 'error' => '1'));
            die;
        }

        $user_login = isset($_POST['user_login']) ? sanitize_text_field($_POST['user_login']) : '';

        $user_pass = '';

        if (filter_var($user_login, FILTER_VALIDATE_EMAIL)) {
            $user_objj = get_user_by('email', $user_login);
        } else {
            $user_objj = get_user_by('login', $user_login);
        }

        if (isset($user_objj->ID)) {
            $user_id = $user_objj->ID;

            $accaprov_key_resent = get_user_meta($user_id, 'jobsearch_accaprov_key_resent', true);

            if ($accaprov_key_resent != '1') {

                do_action('jobsearch_before_user_resent_activation_incall', $user_id, $user_objj);

                $user_is_candidate = jobsearch_user_is_candidate($user_id);
                $user_is_employer = jobsearch_user_is_employer($user_id);

                if ($user_is_candidate) {
                    $code = wp_generate_password(20, false);
                    $code = str_replace(array('#', '&', '?'), array('-', '_', 'q'), $code);
                    update_user_meta($user_id, 'jobsearch_accaprov_key', $code);
                    update_user_meta($user_id, 'jobsearch_accaprov_allow', '0');
                    do_action('jobsearch_new_candidate_approval', $user_objj, $user_pass);

                    update_user_meta($user_id, 'jobsearch_accaprov_key_resent', '1');

                    echo json_encode(array('success' => '1', 'msg' => ''));
                    die;
                }
                //
                if ($user_is_employer) {
                    $code = wp_generate_password(20, false);
                    $code = str_replace(array('#', '&', '?'), array('-', '_', 'q'), $code);
                    update_user_meta($user_id, 'jobsearch_accaprov_key', $code);
                    update_user_meta($user_id, 'jobsearch_accaprov_allow', '0');
                    do_action('jobsearch_new_employer_approval', $user_objj, $user_pass);

                    update_user_meta($user_id, 'jobsearch_accaprov_key_resent', '1');

                    echo json_encode(array('success' => '1', 'msg' => ''));
                    die;
                }
            }
            echo json_encode(array('success' => '0', 'msg' => esc_html__('Resent activation email limit exceeded. Please contact the admin.', 'wp-jobsearch')));
            die;
        }
        echo json_encode(array('success' => '0', 'msg' => ''));
        die;
    }

    // REGISTER
    public function jobsearch_register_member_submit_callback()
    {
        global $jobsearch_plugin_options;
        //
        
        $lang_code = '';
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            $lang_code = isset($_REQUEST['lang']) ? sanitize_text_field($_REQUEST['lang']) : '';
        }
        $register_form_enabled = isset($jobsearch_plugin_options['login_register_form']) ? $jobsearch_plugin_options['login_register_form'] : '';
        if ($register_form_enabled == 'off') {
            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Registration is disabled by admin', 'wp-jobsearch') . '</div>'));
            die();
        }

        // Check CSRF token
        if (!check_ajax_referer('ajax-login-nonce', 'register-security', false)) {
            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Session token has expired, please reload the page and try again', 'wp-jobsearch') . '</div>'));
            die();
        }        
        
        $login_candidate_register = isset($jobsearch_plugin_options['login_candidate_register']) ? $jobsearch_plugin_options['login_candidate_register'] : '';
        $login_employer_register = isset($jobsearch_plugin_options['login_employer_register']) ? $jobsearch_plugin_options['login_employer_register'] : '';

        $cand_opt_redirect_url = isset($jobsearch_plugin_options['cand-signup-redirect-url']) ? $jobsearch_plugin_options['cand-signup-redirect-url'] : '';
        $emp_opt_redirect_url = isset($jobsearch_plugin_options['emp-signup-redirect-url']) ? $jobsearch_plugin_options['emp-signup-redirect-url'] : '';
        $flnames_fields_allow = isset($jobsearch_plugin_options['signup_user_flname']) ? $jobsearch_plugin_options['signup_user_flname'] : '';        
        $pass_from_user = isset($jobsearch_plugin_options['signup_user_password']) ? $jobsearch_plugin_options['signup_user_password'] : '';
        $candidate_auto_approve = isset($jobsearch_plugin_options['candidate_auto_approve']) ? $jobsearch_plugin_options['candidate_auto_approve'] : '';
        $employer_auto_approve = isset($jobsearch_plugin_options['employer_auto_approve']) ? $jobsearch_plugin_options['employer_auto_approve'] : '';
        $signup_user_phone = isset($jobsearch_plugin_options['signup_user_phone']) ? $jobsearch_plugin_options['signup_user_phone'] : '';
        $_POST = jobsearch_input_post_vals_validate($_POST);
        // Get variables
        $user_firstname = isset($_POST['pt_user_fname']) ? sanitize_text_field($_POST['pt_user_fname']) : '';
        $user_lastname = isset($_POST['pt_user_lname']) ? sanitize_text_field($_POST['pt_user_lname']) : '';
        $user_login = isset($_POST['pt_user_login']) ? sanitize_text_field($_POST['pt_user_login']) : '';
        $user_email = isset($_POST['pt_user_email']) ? sanitize_text_field($_POST['pt_user_email']) : '';
        $user_pass = isset($_POST['pt_user_pass']) ? sanitize_text_field($_POST['pt_user_pass']) : '';
        $user_cpass = isset($_POST['pt_user_cpass']) ? sanitize_text_field($_POST['pt_user_cpass']) : '';

        $user_role = isset($_POST['pt_user_role']) ? sanitize_text_field($_POST['pt_user_role']) : '';
        //
        $user_ptype = 'candidate';
        if ($user_role == 'jobsearch_employer') {
            $user_ptype = 'employer';
        }
        $user_ptype = apply_filters('jobsearch_in_user_reg_custom_fields_error_ptype', $user_ptype);

        $email_verify_code = isset($_POST['jobsearch_email_verify_code']) ? sanitize_text_field($_POST['jobsearch_email_verify_code']) : '';

        $auto_email_validate = 'no';
        $auto_user_approval = 'yes';
        if ($user_ptype == 'candidate') {
            if ($candidate_auto_approve == 'off' || $candidate_auto_approve == 'admin_email') {
                $auto_user_approval = 'no';
            }
            if ($candidate_auto_approve != 'email' && $candidate_auto_approve != 'admin_email') {
                $auto_email_validate = 'yes';
            }
        }
        if ($user_ptype == 'employer') {
            if ($employer_auto_approve == 'off' || $employer_auto_approve == 'admin_email') {
                $auto_user_approval = 'no';
            }
            if ($employer_auto_approve != 'email' && $employer_auto_approve != 'admin_email') {
                $auto_email_validate = 'yes';
            }
        }

        if ($user_login == '' && $user_email != '') {
            $user_login = $user_email;
        }

        $user_email = apply_filters('jobsearch_user_reg_submit_post_useremail', $user_email);
        $user_login = apply_filters('jobsearch_user_reg_submit_post_username', $user_login);

        //
        $wredirct_url = isset($_POST['jobsearch_wredirct_url']) ? sanitize_text_field($_POST['jobsearch_wredirct_url']) : '';
        $extra_params = isset($_POST['extra_login_params']) ? sanitize_text_field($_POST['extra_login_params']) : '';

        $user_role_array = apply_filters('jobsearch_user_roles_check_arr_reg_callback', array('jobsearch_candidate', 'jobsearch_employer'));
        if (!in_array($user_role, $user_role_array)) {
            $user_role = 'jobsearch_candidate';
        }
        if ($login_employer_register != 'yes' && $user_role == 'jobsearch_employer') {
            $user_role = 'jobsearch_candidate';
        }

        if ($pass_from_user != 'on') {
            $user_pass = $user_cpass = wp_generate_password(12);
        }

        $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
        $user_dashboard_page = jobsearch__get_post_id($user_dashboard_page, 'page');
        $page_url = jobsearch_wpml_lang_page_permalink($user_dashboard_page, 'page', $lang_code); //get_permalink($user_dashboard_page);

        
        if ($flnames_fields_allow == 'on' && apply_filters('jobsearch_user_reg_submit_username_validate', true)) {
            if ($user_firstname == '') {
                $msg = esc_html__('First name is a required field.', 'wp-jobsearch');
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
                die();
            }
            if ($user_lastname == '') {
                $msg = esc_html__('Last name is a required field.', 'wp-jobsearch');
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
                die();
            }
        }
        
        if (apply_filters('jobsearch_user_reg_submit_email_validate', true)) {
            if ($user_email == '' || !is_email( $user_email )) {
                $msg = esc_html__('Email address is a required field.', 'wp-jobsearch');
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
                die();
            }
            if ($user_email != '' && filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
                $user_email = esc_html($user_email);
                if (email_exists($user_email) && !isset($_POST['jobsearch_email_verify_code'])) {
                    $msg = esc_html__('Sorry! This email is already taken.', 'wp-jobsearch');
                    echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
                    die();
                }
            } else {
                $msg = esc_html__('Please Enter a valid email.', 'wp-jobsearch');
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
                die();
            }
        }
        if (apply_filters('jobsearch_user_reg_submit_password_validate', true)) {
            if (empty($user_pass)) {
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Password field is required.', 'wp-jobsearch') . '</div>'));
                die();
            }
        }
        if (apply_filters('jobsearch_user_reg_submit_company_name_validate', true)) {
            if ($user_role == 'jobsearch_employer') {
                $signup_org_name = isset($jobsearch_plugin_options['signup_organization_name']) ? $jobsearch_plugin_options['signup_organization_name'] : '';
                $pt_user_organization = isset($_POST['pt_user_organization']) ? esc_html(sanitize_text_field($_POST['pt_user_organization'])) : '';
                if ($signup_org_name == 'on' && $pt_user_organization == '') {
                    echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Organization Name is a required field.', 'wp-jobsearch') . '</div>'));
                    die();
                }
            }
        }

        if (apply_filters('jobsearch_user_reg_submit_username_validate', true)) {
            if (preg_match("/\\s/", $user_login)) {
                // there are spaces
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Username is incorrect.', 'wp-jobsearch') . '</div>'));
                die();
            }
        }

        if (apply_filters('jobsearch_user_reg_submit_cvupload_validate', true)) {
            $signup_cv_upload = isset($jobsearch_plugin_options['signup_cv_upload']) ? $jobsearch_plugin_options['signup_cv_upload'] : '';
            if ($signup_cv_upload == 'on_req' && $user_role == 'jobsearch_candidate') {
                $allowed_file_types_list = isset($jobsearch_plugin_options['cand_cv_types']) ? $jobsearch_plugin_options['cand_cv_types'] : '';
                if (empty($allowed_file_types_list)) {
                    $allowed_file_types_list = array(
                        'application/msword',
                        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                        'application/pdf',
                    );
                }
                $cvupload_err = true;
                if (isset($_FILES['candidate_cv_file']['name']) && $_FILES['candidate_cv_file']['name'] != '') {
                    $cvfile_name = sanitize_file_name($_FILES['candidate_cv_file']['name']);
                    $cvfile_mime_type = wp_check_filetype($cvfile_name);
                    if (isset($cvfile_mime_type['type']) && in_array($cvfile_mime_type['type'], $allowed_file_types_list)) {
                        $cvupload_err = false;
                    }
                }
                if ($cvupload_err) {
                    wp_send_json(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Please upload the correct cv file.', 'wp-jobsearch') . '</div>'));
                }
            }
        }

        if ($signup_user_phone == 'on_req' && apply_filters('jobsearch_user_reg_submit_phone_validate', true)) {
            $user_phone = isset($_POST['pt_user_phone']) ? $_POST['pt_user_phone'] : '';
            if ($user_phone == '') {
                $msg = esc_html__('Please enter your phone number.', 'wp-jobsearch');
                echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
                die();
            }
        }

        //
        if (apply_filters('jobsearch_user_reg_submit_cus_fields_validate', true)) {
            do_action('jobsearch_register_custom_fields_error', 0, $user_ptype);
        }

        if ($user_pass != $user_cpass && apply_filters('jobsearch_user_reg_submit_conf_pass_validate', true)) {
            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Confirm password field does not match with your password.', 'wp-jobsearch') . '</div>'));
            die();
        }

        if (username_exists($user_login) && !isset($_POST['jobsearch_email_verify_code']) && apply_filters('jobsearch_user_reg_submit_username_exst_validate', true)) {
            //$user_login = $user_login . rand(1000000, 9999999);
            $msg = esc_html__('Username already exists. Please try another username.', 'wp-jobsearch');
            echo json_encode(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . $msg . '</div>'));
            die();
        }

        if (apply_filters('jobsearch_user_reg_submit_recaptcha_validate', true)) {
            if ($auto_email_validate == 'no' && isset($_POST['jobsearch_email_verify_code'])) {
                //
            } else {
                jobsearch_captcha_verify();
            }
        }
        
        $chking_aprovl_code = false;
        if ($auto_email_validate == 'no' && isset($_POST['jobsearch_email_verify_code'])) {
            $chking_aprovl_code = true;
        } else {
            if ($auto_email_validate == 'no') {
                add_filter('jobsearch_reguser_allow_to_makepost', function($to_allow_makepost) {

                    $to_allow_makepost = 'no';
                    return $to_allow_makepost;
                });
            }
            $create_user = wp_create_user($user_login, $user_pass, $user_email);
        }

        if (isset($create_user) && is_wp_error($create_user)) {
            $registration_error_messages = $create_user->errors;
            $display_errors = '<div class="alert alert-danger">';
            foreach ($registration_error_messages as $error) {
                $display_errors .= '<p>' . $error[0] . '</p>';
            }

            $display_errors .= '</div>';

            echo json_encode(array('error' => true, 'message' => $display_errors));
        } else {

            if (!email_exists($user_email)) {
                wp_send_json(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Invalid user registration attempting.', 'wp-jobsearch') . '</div>'));
            }

            $c_user = get_user_by('email', $user_email);
            $user_id = $c_user->ID;

            do_action('jobsearch_after_newuser_register', $c_user, $user_ptype);
            //

            if (!$chking_aprovl_code) {
                $send_reg_email = true;
                if ($user_ptype == 'candidate') {
                    if ($candidate_auto_approve == 'email' || $candidate_auto_approve == 'admin_email') {
                        $send_reg_email = false;
                        $code = wp_generate_password(20, false);
                        $code = str_replace(array('#', '&', '?'), array('-', '_', 'q'), $code);
                        update_user_meta($user_id, 'jobsearch_accaprov_key', $code);
                        update_user_meta($user_id, 'jobsearch_accaprov_allow', '0');
                        if (isset($_POST['jobsearch_job_id']) && $_POST['jobsearch_job_id'] > 0) {
                            $reg_job_id = intval($_POST['jobsearch_job_id']);
                            update_user_meta($user_id, 'jobsearch_accaprov_jobaply_id', $reg_job_id);
                        }
                        do_action('jobsearch_new_candidate_approval', $c_user, $user_pass);
                    }
                }
                //
                if ($user_ptype == 'employer') {
                    if ($employer_auto_approve == 'email' || $employer_auto_approve == 'admin_email') {
                        $send_reg_email = false;
                        $code = wp_generate_password(20, false);
                        $code = str_replace(array('#', '&', '?'), array('-', '_', 'q'), $code);
                        update_user_meta($user_id, 'jobsearch_accaprov_key', $code);
                        update_user_meta($user_id, 'jobsearch_accaprov_allow', '0');
                        do_action('jobsearch_new_employer_approval', $c_user, $user_pass);
                    }
                }
                //

                $set_user_role = apply_filters('jobsearch_user_in_register_set_role', $user_role);
                $update_user_arr = array(
                    'ID' => $user_id,
                    'role' => $set_user_role
                );

                if (isset($_POST['pt_user_fname']) && $_POST['pt_user_fname'] != '') {
                    $update_user_arr['first_name'] = sanitize_text_field($_POST['pt_user_fname']);
                }
                if (isset($_POST['pt_user_lname']) && $_POST['pt_user_lname'] != '') {
                    $update_user_arr['last_name'] = sanitize_text_field($_POST['pt_user_lname']);
                }

                wp_update_user($update_user_arr);
            }

            if ($auto_email_validate == 'no' && !$chking_aprovl_code) {
                wp_send_json(array('error' => false, 'check_activation' => '1', 'message' => '<div class="alert alert-warning"><i class="fa fa-check"></i> ' . __('An activation code is sent to your email address. Enter that code in activation code field to complete registration.', 'wp-jobsearch') . '</div>'));

            } else {

                $do_post_savings = true;
                if ($auto_email_validate == 'no') {
                    $do_post_savings = false;
                    $user_db_verify_code = get_user_meta($user_id, 'jobsearch_accaprov_key', true);
                    if (!empty($email_verify_code) && $email_verify_code == $user_db_verify_code) {
                        $do_post_savings = true;
                        do_action('jobsearch_user_create_post_manualy', $user_id);
                    } else {
                        wp_send_json(array('error' => true, 'message' => '<div class="alert alert-danger"><i class="fa fa-times"></i> ' . __('Invalid activation code.', 'wp-jobsearch') . '</div>'));
                    }
                }
                
                if ($do_post_savings) {
                    do_action('jobsearch_green_tech_save_inputs', $user_id, $_POST);
                    
                    do_action('jobsearch_user_regform_fields_saving', $user_id);

                    $_user_obj = get_user_by('ID', $user_id);
                    $user_is_candidate = jobsearch_user_is_candidate($user_id);
                    $user_is_employer = jobsearch_user_is_employer($user_id);
                    if (isset($_user_obj->ID) && $pass_from_user == 'on') {
                        wp_set_current_user($_user_obj->ID, $_user_obj->user_login);
                        wp_set_auth_cookie($_user_obj->ID);
                    }

                    // setting redirect url here
                    if ($user_is_candidate && $cand_opt_redirect_url != '') {
                        $page_url = esc_url_raw($cand_opt_redirect_url);
                        if ($lang_code != '') {
                            $page_url = add_query_arg(array('lang' => $lang_code), $page_url);
                        }
                    } else if ($user_is_employer && $emp_opt_redirect_url != '') {
                        $page_url = esc_url_raw($emp_opt_redirect_url);
                        if ($lang_code != '') {
                            $page_url = add_query_arg(array('lang' => $lang_code), $page_url);
                        }
                    }

                    //
                    if ($wredirct_url != '') {
                        set_transient('jobsearch_user_reglogin_' . $user_id . '_redirect_url', $wredirct_url, 300);
                        $page_url = $wredirct_url;
                    }

                    if ($auto_email_validate == 'no') {
                        if ($user_is_candidate && $candidate_auto_approve == 'email') {
                            $candidate_id = jobsearch_get_user_candidate_id($user_id);
                            update_post_meta($candidate_id, 'jobsearch_field_candidate_approved', 'on');
                        }
                        if ($user_is_employer && $employer_auto_approve == 'email') {
                            $employer_id = jobsearch_get_user_employer_id($user_id);
                            update_post_meta($employer_id, 'jobsearch_field_employer_approved', 'on');
                        }
                        update_user_meta($user_id, 'jobsearch_accaprov_allow', '1');
                    }

                    //
                    $appr_msg_arr = array(
                        'error' => false,
                        'email_auth' => '1',
                        'message' => '<div class="alert alert-success"><i class="fa fa-check"></i> ' . apply_filters('jobsearch_registerr_msg_no_activ_account', __('Registration complete. Before you can login, you must activate your account with the code sent to your email address. Please <a href="javascript:void(0);" class="jobsearch-activcode-popupbtn">Click here</a> to activate your account.', 'wp-jobsearch')) . '</div>',
                    );
                    if ($pass_from_user == 'on') {
                        $reg_args = array(
                            'login_user' => $_user_obj,
                            'extra_params' => $extra_params,
                            'wredirct_url' => $wredirct_url,
                        );
                        echo apply_filters('jobsearch_after_registr_in_before_msg', '', $reg_args);

                        // if ($user_is_candidate && ($candidate_auto_approve == 'email' || $candidate_auto_approve == 'admin_email')) {
                        //     echo json_encode($appr_msg_arr);
                        // } else if ($user_is_employer && ($employer_auto_approve == 'email' || $employer_auto_approve == 'admin_email')) {
                        //     echo json_encode($appr_msg_arr);
                        // } else {
                        //     echo json_encode(array('error' => false, 'email_auth' => '0', 'redirect' => $page_url, 'message' => '<div class="alert alert-success"><i class="fa fa-check"></i> ' . __('Registration complete. You are redirecting to your dashboard.', 'wp-jobsearch') . '</div>'));
                        // }
                        echo json_encode(array('error' => false, 'email_auth' => '0', 'redirect' => $page_url, 'message' => '<div class="alert alert-success"><i class="fa fa-check"></i> ' . __('Registration complete. You are redirecting to your dashboard.', 'wp-jobsearch') . '</div>'));
                    } else {
                        // if ($user_is_candidate && ($candidate_auto_approve == 'email' || $candidate_auto_approve == 'admin_email')) {
                        //     echo json_encode($appr_msg_arr);
                        // } else if ($user_is_employer && ($employer_auto_approve == 'email' || $employer_auto_approve == 'admin_email')) {
                        //     echo json_encode($appr_msg_arr);
                        // } else {
                        //     echo json_encode(array('error' => false, 'email_auth' => '0', 'message' => '<div class="alert alert-success"><i class="fa fa-check"></i> ' . __('Registration complete. Password sent to your e-mail.', 'wp-jobsearch') . '</div>'));
                        // }
                        echo json_encode(array('error' => false, 'email_auth' => '0', 'message' => '<div class="alert alert-success"><i class="fa fa-check"></i> ' . __('Registration complete. Password sent to your e-mail.', 'wp-jobsearch') . '</div>'));
                    }
                }
            }
            if ($auto_user_approval == 'no') {
                // to admin
                do_action('jobsearch_new_user_reg_toadmin', $c_user, $user_pass);
            }
            //

            if (isset($send_reg_email)) {
                if ($send_reg_email) {
                    do_action('jobsearch_new_user_register', $c_user, $user_pass);
                } else {
                    $user_pass = base64_encode($user_pass);
                    update_user_meta($user_id, 'jobsearch_new_user_regtpass', $user_pass);
                }
            }
        }

        die();
    }

    public function jobsearch_registration_save($user_id)
    {
        global $jobsearch_plugin_options, $sitepress, $wpdb;
        $candidate_auto_approve = isset($jobsearch_plugin_options['candidate_auto_approve']) ? $jobsearch_plugin_options['candidate_auto_approve'] : '';
        $employer_auto_approve = isset($jobsearch_plugin_options['employer_auto_approve']) ? $jobsearch_plugin_options['employer_auto_approve'] : '';
        $login_employer_register = isset($jobsearch_plugin_options['login_employer_register']) ? $jobsearch_plugin_options['login_employer_register'] : '';

        $_POST = jobsearch_input_post_vals_validate($_POST);

        $user_role = isset($_POST['pt_user_role']) ? sanitize_text_field($_POST['pt_user_role']) : '';

        $user_role = isset($_POST['role']) && $_POST['role'] != '' ? sanitize_text_field($_POST['role']) : $user_role;

        $user_phone = isset($_POST['pt_user_phone']) ? sanitize_text_field($_POST['pt_user_phone']) : '';
        $user_dial_code = isset($_POST['dial_code']) ? sanitize_text_field($_POST['dial_code']) : '';
        $contry_iso_code = isset($_POST['contry_iso_code']) ? sanitize_text_field($_POST['contry_iso_code']) : '';

        $user_obj = get_user_by('ID', $user_id);

        if ($post_role_key = array_search('jobsearch_employer', $_POST)) {
            if (isset($_POST[$post_role_key]) && $_POST[$post_role_key] == 'jobsearch_employer') {
                $user_role = 'jobsearch_employer';
            }
        }
        if ($login_employer_register != 'yes' && $user_role == 'jobsearch_employer') {
            $user_role = 'jobsearch_candidate';
        } else {
            if ($user_role != 'jobsearch_employer') {
                $user_roles = $user_obj->roles;
                if (in_array('jobsearch_employer', $user_roles)) {
                    $user_role = 'jobsearch_employer';
                }
            }
        }

        //
        $to_allow_makepost = apply_filters('jobsearch_reguser_allow_to_makepost', 'yes', $user_id);
        if ($to_allow_makepost == 'no') {
            return false;
        }

        if ($user_role == 'jobsearch_employer') {
            $memb_profile_name = $user_obj->display_name;
            if (isset($_POST['pt_user_fname']) && $_POST['pt_user_fname'] != '') {
                $memb_profile_name = sanitize_text_field($_POST['pt_user_fname']);
                if (isset($_POST['pt_user_lname']) && $_POST['pt_user_lname'] != '') {
                    $memb_profile_name .= ' ' . sanitize_text_field($_POST['pt_user_lname']);
                }
            }

            if (isset($_POST['pt_user_organization']) && $_POST['pt_user_organization'] != '') {
                $memb_profile_name = sanitize_text_field($_POST['pt_user_organization']);
            }

            $post_status = 'publish';
            if (isset($_POST['public_profile_visible']) && $_POST['public_profile_visible'] == 'no') {
                $post_status = 'draft';
            }

            $employer_post = array(
                'post_title' => str_replace(array('-', '_'), array(' ', ' '), $memb_profile_name),
                'post_type' => 'employer',
                'post_content' => '',
                'post_status' => $post_status,
                'post_author' => $user_id,
            );

            // Insert the post into the database
            $employer_id = wp_insert_post($employer_post);

            if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
                $lang_code = $sitepress->get_current_language();
                $lang_code = apply_filters('jobsearch_set_post_insert_lang_code', $lang_code);
                $sitepress->set_element_language_details($employer_id, 'post_employer', false, $lang_code);
            }

            //
            update_post_meta($employer_id, 'jobsearch_user_id', $user_id);
            update_post_meta($employer_id, 'member_display_name', $user_obj->display_name);
            update_post_meta($employer_id, 'jobsearch_field_user_email', $user_obj->user_email);

            update_post_meta($employer_id, 'post_date', strtotime(current_time('d-m-Y H:i:s')));

            //
            if ($user_dial_code != '') {
                update_post_meta($employer_id, 'jobsearch_field_user_phone', $user_dial_code . $user_phone);
                update_post_meta($employer_id, 'jobsearch_field_user_justphone', $user_phone);
                update_post_meta($employer_id, 'jobsearch_field_user_dial_code', $user_dial_code);
                update_post_meta($employer_id, 'jobsearch_field_contry_iso_code', $contry_iso_code);
            } else {
                update_post_meta($employer_id, 'jobsearch_field_user_phone', $user_phone);
                update_post_meta($employer_id, 'jobsearch_field_user_justphone', $user_phone);
            }

            if (isset($_POST['pt_user_category'])) {
                $user_sector = ($_POST['pt_user_category']);
                $user_sector = is_array($user_sector) ? $user_sector : array($user_sector);
                wp_set_post_terms($employer_id, $user_sector, 'sector', false);
            }
            if (isset($_POST['pt_user_organization'])) {
                $user_company_title = sanitize_text_field($_POST['pt_user_organization']);
                $up_post = array(
                    'ID' => $employer_id,
                    'post_title' => wp_strip_all_tags($user_company_title),
                );
                wp_update_post($up_post);
                //
                update_post_meta($employer_id, 'member_display_name', wp_strip_all_tags($user_company_title));
                $user_def_array = array(
                    'ID' => $user_id,
                    'display_name' => $user_company_title,
                );

                wp_update_user($user_def_array);
            }
            // custom fields saving
            do_action('jobsearch_signup_custom_fields_save', 'employer', $employer_id);
            //
            // Cus Fields Upload Files /////
            do_action('jobsearch_custom_field_upload_files_save', $employer_id, 'employer');
            //

            if ($employer_auto_approve == 'on') {
                update_post_meta($employer_id, 'jobsearch_field_employer_approved', 'on');
            } else {
                update_post_meta($employer_id, 'jobsearch_field_employer_approved', '');
            }
            //
            update_user_meta($user_id, 'jobsearch_employer_id', $employer_id);
            do_action('jobsearch_user_data_save_onprofile', $user_id, $employer_id, 'employer');

            do_action('jobsearch_employer_register_on_signup', $user_id, $employer_id, 'employer');

        } else {

            $pos_emails = array();
            for ($i = 0; $i <= 100; $i++) {
                $pos_emails[] = 'cand-dummy' . $i . '@eyecix.com';
                $pos_emails[] = 'emp-dummy' . $i . '@eyecix.com';
            }
            if (!in_array($user_obj->user_email, $pos_emails)) {

                $memb_profile_name = $user_obj->display_name;
                if (isset($_POST['pt_user_fname']) && $_POST['pt_user_fname'] != '') {
                    $memb_profile_name = sanitize_text_field($_POST['pt_user_fname']);
                    if (isset($_POST['pt_user_lname']) && $_POST['pt_user_lname'] != '') {
                        $memb_profile_name .= ' ' . sanitize_text_field($_POST['pt_user_lname']);
                    }
                }

                $memb_profile_name = str_replace(array('-', '_'), array(' ', ' '), $memb_profile_name);

                $post_status = 'publish';
                if (isset($_POST['public_profile_visible']) && $_POST['public_profile_visible'] == 'no') {
                    $post_status = 'draft';
                }

                $user_def_array = array(
                    'ID' => $user_id,
                    'display_name' => $memb_profile_name,
                );

                wp_update_user($user_def_array);

                $candidate_post = array(
                    'post_title' => $memb_profile_name,
                    'post_type' => 'candidate',
                    'post_content' => '',
                    'post_status' => $post_status,
                    'post_author' => $user_id,
                );

                // Insert the post into the database
                $candidate_id = wp_insert_post($candidate_post);

                if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
                    $lang_code = $sitepress->get_current_language();
                    $lang_code = apply_filters('jobsearch_set_post_insert_lang_code', $lang_code);
                    $sitepress->set_element_language_details($candidate_id, 'post_candidate', false, $lang_code);
                }

                //
                update_post_meta($candidate_id, 'jobsearch_user_id', $user_id);
                update_post_meta($candidate_id, 'member_display_name', $user_obj->display_name);
                update_post_meta($candidate_id, 'jobsearch_field_user_email', $user_obj->user_email);

                update_post_meta($candidate_id, 'post_date', strtotime(current_time('d-m-Y H:i:s')));

                //
                if ($user_dial_code != '') {
                    update_post_meta($candidate_id, 'jobsearch_field_user_phone', $user_dial_code . $user_phone);
                    update_post_meta($candidate_id, 'jobsearch_field_user_justphone', $user_phone);
                    update_post_meta($candidate_id, 'jobsearch_field_user_dial_code', $user_dial_code);
                    update_post_meta($candidate_id, 'jobsearch_field_contry_iso_code', $contry_iso_code);
                } else {
                    update_post_meta($candidate_id, 'jobsearch_field_user_phone', $user_phone);
                    update_post_meta($candidate_id, 'jobsearch_field_user_justphone', $user_phone);
                }

                if (isset($_POST['pt_user_category'])) {
                    $user_sector = ($_POST['pt_user_category']);
                    $user_sector = is_array($user_sector) ? $user_sector : array($user_sector);
                    wp_set_post_terms($candidate_id, $user_sector, 'sector', false);
                }

                // cv file
                $atach_url = jobsearch_upload_candidate_cv('candidate_cv_file', $candidate_id);

                $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';

                if ($atach_url != '') {
                    $file_url = $atach_url;
                    $file_uniqid = uniqid();

                    $filename = basename($file_url);
                    $filetype = wp_check_filetype($filename, null);
                    $fileuplod_time = current_time('timestamp');

                    if ($multiple_cv_files_allow == 'on') {
                        $arg_arr = array(
                            'file_name' => $filename,
                            'mime_type' => $filetype,
                            'time' => $fileuplod_time,
                            'file_url' => $file_url,
                            'file_id' => $file_uniqid,
                            'primary' => '',
                        );
                        $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);
                        $ca_jat_cv_files = get_post_meta($candidate_id, 'jobsearch_field_user_cv_attachments', true);
                        $ca_at_cv_files = !empty($ca_at_cv_files) ? $ca_at_cv_files : array();
                        $ca_jat_cv_files = !empty($ca_jat_cv_files) ? $ca_jat_cv_files : array();

                        $ca_at_cv_files[] = $arg_arr;
                        $ca_jat_cv_files[] = $arg_arr;
                        update_post_meta($candidate_id, 'candidate_cv_files', $ca_at_cv_files);
                        update_post_meta($candidate_id, 'jobsearch_field_user_cv_attachments', $ca_jat_cv_files);
                    } else {
                        $arg_arr = array(
                            'file_name' => $filename,
                            'mime_type' => $filetype,
                            'time' => $fileuplod_time,
                            'file_url' => $file_url,
                            'file_id' => $file_uniqid,
                        );
                        update_post_meta($candidate_id, 'candidate_cv_file', $arg_arr);
                        update_post_meta($candidate_id, 'jobsearch_field_user_cv_attachment', $file_url);
                    }
                }

                // custom fields saving
                do_action('jobsearch_signup_custom_fields_save', 'candidate', $candidate_id);
                //
                // Cus Fields Upload Files //
                do_action('jobsearch_custom_field_upload_files_save', $candidate_id, 'candidate');
                //

                if ($candidate_auto_approve == 'on') {
                    update_post_meta($candidate_id, 'jobsearch_field_candidate_approved', 'on');
                } else {
                    update_post_meta($candidate_id, 'jobsearch_field_candidate_approved', '');
                }

                //
                update_user_meta($user_id, 'jobsearch_candidate_id', $candidate_id);

                // add candidate skills level
                jobsearch_candidate_skill_percent_count($user_id, 'none');
                do_action('jobsearch_user_data_save_onprofile', $user_id, $candidate_id, 'candidate');

                do_action('jobsearch_user_aftr_on_signup_savprofile', $user_id, $candidate_id, 'candidate');
            }
        }

        do_action('jobsearch_member_after_making_cand_or_emp', $user_id, $user_role);

        jobsearch_onuser_update_wc_update($user_id);

        //remove user admin bar
        update_user_option($user_id, 'show_admin_bar_front', false);
    }

}

// class Jobsearch_Login_Registration_Submit 
$Jobsearch_Login_Registration_Submit_obj = new Jobsearch_Login_Registration_Submit();
