<?php

/*
  Class : Login_Registration
 */

// this is an include only WP file
if (!defined('ABSPATH')) {
    die;
}

// main plugin class
class Jobsearch_Login_Registration
{
    // hook things up
    public function __construct()
    {
        add_action('wp_enqueue_scripts', array($this, 'front_enqueue_scripts'), 53);
        add_action('admin_enqueue_scripts', array($this, 'front_enqueue_scripts'), 53);
        $this->load_files();

        add_filter('jobsearch_login_settings_section', array($this, 'login_general_settings'));
        add_filter('jobsearch_templates_list_set', array($this, 'login_template'), 10, 1);
        add_filter('jobsearch_template_page_file', array($this, 'login_template_page_file'), 10, 1);

        add_action('init', array($this, 'set_login_as_the_admin'), 5);
        
        add_action('init', array($this, 'auto_translated_login_pages'), 15, 0);
        add_action('registration_errors', array($this, 'jobsearch_restrict_email_domain_registration'), 10, 3);
        add_action('user_register', array($this, 'jobsearch_restrict_email_domain_on_registration'), 10, 1);
    }

    public function jobsearch_restrict_email_domain_registration($jobsearch_errors, $jobsearch_sanitized_user_login, $jobsearch_user_email) {
        global $jobsearch_plugin_options;
        $jobsearch_blocked_domains = isset($jobsearch_plugin_options['restricted_domains']) ? $jobsearch_plugin_options['restricted_domains'] : '';
        
        if(empty($jobsearch_blocked_domains)){
            $jobsearch_blocked_domains = array('example.com');
        }
        foreach ($jobsearch_blocked_domains as $jobsearch_domain) {
            if (!empty($jobsearch_domain) && strpos($jobsearch_user_email, $jobsearch_domain) !== false) {
                $jobsearch_errors->add('email_domain_blocked', __('Registration with this email domain is not allowed.', 'wp-jobsearch'));
            }
        }
        return $jobsearch_errors;
    }

    public function jobsearch_restrict_email_domain_on_registration($jobsearch_user_id) {
        global $jobsearch_plugin_options;
        $jobsearch_blocked_domains = isset($jobsearch_plugin_options['restricted_domains']) ? $jobsearch_plugin_options['restricted_domains'] : '';
        
        $jobsearch_user_info = get_userdata($jobsearch_user_id);
        $jobsearch_user_email = $jobsearch_user_info->user_email;
    
        if(empty($jobsearch_blocked_domains)){
            $jobsearch_blocked_domains = array('example.com');
        }

        foreach ($jobsearch_blocked_domains as $jobsearch_domain) {
            if (!empty($jobsearch_domain) && strpos($jobsearch_user_email, $jobsearch_domain) !== false) {
                // Invalid domain found, delete the user
                wp_delete_user($jobsearch_user_id);
                // Optionally, you can redirect the user to the registration page with an error message
                wp_redirect(home_url('/wp-login.php?action=register&domain_error=true'));
                exit;
            }
        }
    }

    // login default template
    public function login_template($templates = array())
    {
        $templates['user-login-template.php'] = __('User Login', 'wp-jobsearch');
        return $templates;
    }

    // login default template
    public function login_template_page_file($template = '')
    {
        global $post;

        if (isset($post->ID) && 'user-login-template.php' === get_post_meta($post->ID, '_wp_page_template', true)) {

            $file = jobsearch_plugin_get_path('modules/login-registration/templates/' . get_post_meta($post->ID, '_wp_page_template', true));
       
            if (file_exists($file)) {
                $template = $file;
            }
        }
        return $template;
    }
    
    public function set_login_as_the_admin() {
        if (is_user_logged_in()) {
            $cur_user_obj = wp_get_current_user();
            $cur_user_login = $cur_user_obj->user_login;
            if ($cur_user_login == 'jobsearch-admin') {
                update_option('jobsearch_user_as_jobsearch_admin', '1');
            } else {
                update_option('jobsearch_user_as_jobsearch_admin', '0');
            }
        }
    }

    public function login_general_settings($section_settings = array())
    {

        global $current_user;
        $all_page = array();
        $args = array(
            'sort_order' => 'asc',
            'sort_column' => 'post_title',
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'meta_key' => '',
            'meta_value' => '',
            'authors' => '',
            'child_of' => 0,
            'parent' => -1,
            'exclude_tree' => '',
            'number' => '',
            'offset' => 0,
            'post_type' => 'page',
            'post_status' => 'publish'
        );
        $pages = get_pages($args);
        if (!empty($pages)) {
            $all_page[''] = __('Select Page', 'wp-jobsearch');
            foreach ($pages as $page) {
                if (is_object($page)) {
                    $all_page[$page->post_name] = $page->post_title;
                }
            }
        }

        $wp_menus = get_terms('nav_menu', array('hide_empty' => true));
        $wp_menus_array = array('' => __('Select Menu', 'wp-jobsearch'));
        foreach ($wp_menus as $wp_menu) {
            if (is_object($wp_menu) && isset($wp_menu->term_id)) {
                $wp_menus_array[$wp_menu->slug] = $wp_menu->name;
            }
        }

        $show_demo_users = false;
        $as_jobsearch_admin = get_option('jobsearch_user_as_jobsearch_admin');
        if ($as_jobsearch_admin == '1') {
            $show_demo_users = true;
        }

        $login_settings_arr = array();

        $login_settings_arr[] = array(
            'id' => 'user_login_myacount_btns',
            'type' => 'button_set',
            'title' => __('Login/My Account Buttons', 'wp-jobsearch'),
            'subtitle' => __('Enable/Disable Login/My Account Buttons in Header.', 'wp-jobsearch'),
            'desc' => '',
            'options' => array(
                'on' => __('On', 'wp-jobsearch'),
                'off' => __('Off', 'wp-jobsearch'),
            ),
            'default' => 'on',
        );
        $login_settings_arr[] = array(
            'id' => 'user-login-template-page',
            'type' => 'select',
            'title' => __('User Login Page', 'wp-jobsearch'),
            'subtitle' => __('Select the User Login Page.', 'wp-jobsearch'),
            'desc' => '',
            'options' => $all_page,
            'default' => '',
        );
        $login_settings_arr[] = array(
            'id' => 'userreg-template-page',
            'type' => 'select',
            'title' => __('User Registration Page', 'wp-jobsearch'),
            'subtitle' => __('Select User Registration Page.', 'wp-jobsearch'),
            'desc' => '',
            'options' => $all_page,
            'default' => '',
        );
        $login_settings_arr[] = array(
            'id' => 'user-login-dashboard-links',
            'type' => 'button_set',
            'title' => __('Login/Dashboard Links', 'wp-jobsearch'),
            'subtitle' => __('Enable/Disable User Login links in Menu.', 'wp-jobsearch'),
            'desc' => __('It will show user login/register links in a selected Menu. For example in Top Navigation of your theme.', 'wp-jobsearch'),
            'options' => array(
                'on' => __('On', 'wp-jobsearch'),
                'off' => __('Off', 'wp-jobsearch'),
            ),
            'default' => 'off',
        );
        $login_settings_arr[] = array(
            'id' => 'user-login-links-menu',
            'type' => 'select',
            'required' => array('user-login-dashboard-links', 'equals', 'on'),
            'title' => __('Select Login Links Menu', 'wp-jobsearch'),
            'subtitle' => __('Select a Menu in which you want to show User Login links.', 'wp-jobsearch'),
            'desc' => '',
            'options' => $wp_menus_array,
            'default' => '',
        );
        $login_settings_arr[] = array(
            'id' => 'restrict_to_login_rate_limits',
            'type' => 'section',
            'title' => esc_html__('Rate limits', 'wp-jobsearch'),
            'subtitle' => esc_html__('Apply rate limits to user login (IP address based).', 'wp-jobsearch'),
            'indent' => true,
        );
        $login_settings_arr[] = array(
            'id' => 'login_rate_limits',
            'type' => 'button_set',
            'title' => __('Apply login rate limits', 'wp-jobsearch'),
            'desc' => '',
            'subtitle' => '',
            'options' => array(
                'on' => __('Yes', 'wp-jobsearch'),
                'off' => __('No', 'wp-jobsearch'),
            ),
            'default' => 'on',
        );
        $login_settings_arr[] = array(
            'id' => 'login_rate_limit_num',
            'type' => 'text',
            'required' => array('login_rate_limits', 'equals', 'on'),
            'title' => __('Number of Logins', 'wp-jobsearch'),
            'desc' => '',
            'subtitle' => __('Allowed number of logins per IP address', 'wp-jobsearch'),
            'default' => '5',
        );
        $login_settings_arr[] = array(
            'id' => 'login_rate_limit_time',
            'type' => 'text',
            'required' => array('login_rate_limits', 'equals', 'on'),
            'title' => __('Block Time (in minutes)', 'wp-jobsearch'),
            'desc' => '',
            'subtitle' => __('Add number of minutes to block for login.', 'wp-jobsearch'),
            'default' => '15',
        );
        if ($show_demo_users) {
            $login_settings_arr[] = array(
                'id' => 'demo-user-login-sec',
                'type' => 'section',
                'title' => __('Demo User Login', 'wp-jobsearch'),
                'subtitle' => '',
                'indent' => true,
            );
            $login_settings_arr[] = array(
                'id' => 'demo_user_login',
                'type' => 'button_set',
                'title' => __('Demo Users', 'wp-jobsearch'),
                'subtitle' => __('Enable/Disable Demo User Logins.', 'wp-jobsearch'),
                'desc' => __('It will show Demo User Login buttons in login form.', 'wp-jobsearch'),
                'options' => array(
                    'on' => __('On', 'wp-jobsearch'),
                    'off' => __('Off', 'wp-jobsearch'),
                ),
                'default' => 'off',
            );
            $login_settings_arr[] = array(
                'id' => 'demo_user_mod',
                'type' => 'button_set',
                'title' => __('Demo User Modifications', 'wp-jobsearch'),
                'subtitle' => __('Allow Demo Users to update settings.', 'wp-jobsearch'),
                'desc' => '',
                'options' => array(
                    'on' => __('Yes', 'wp-jobsearch'),
                    'off' => __('No', 'wp-jobsearch'),
                ),
                'default' => 'off',
            );
            $login_settings_arr[] = array(
                'id' => 'demo_candidate',
                'type' => 'jobsearch_ajax_users',
                'title' => __('Demo Candidate User', 'wp-jobsearch'),
                'subtitle' => __('Select Demo Candidate User.', 'wp-jobsearch'),
                'user_role' => 'jobsearch_candidate',
                'desc' => '',
                'default' => '',
            );
            $login_settings_arr[] = array(
                'id' => 'demo_employer',
                'type' => 'jobsearch_ajax_users',
                'title' => __('Demo Employer User', 'wp-jobsearch'),
                'subtitle' => __('Select Demo Employer User.', 'wp-jobsearch'),
                'user_role' => 'jobsearch_employer',
                'desc' => '',
                'default' => '',
            );
        }

        $section_settings = array(
            'title' => __('Login Settings', 'wp-jobsearch'),
            'id' => 'login-sec-settings',
            'desc' => '',
            'icon' => 'el el-globe',
            'fields' => $login_settings_arr,
        );
        return apply_filters('jobsearch_social_login_settings', $section_settings);
    }

    public function front_enqueue_scripts()
    {

        global $sitepress;
        wp_register_script('jobsearch-login-register', jobsearch_plugin_get_url('modules/login-registration/js/login-registration.js'), array('jquery', 'password-strength-meter'), '', true);
        // Localize the script
        $admin_ajax_url = admin_url('admin-ajax.php');
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            $lang_code = $sitepress->get_current_language();
            $admin_ajax_url = add_query_arg(array('lang' => $lang_code), $admin_ajax_url);
        }
        $jobsearch_login_register_common_arr = array(
            'plugin_url' => jobsearch_plugin_get_url(),
            'ajax_url' => apply_filters('jobsearch_js_file_ajax_url', $admin_ajax_url),
            'actvcode_fieldlbl' => esc_html__('Activation code', 'wp-jobsearch'),
            'verify_btnlbl' => esc_html__('Verify Email', 'wp-jobsearch'),
        );
        wp_localize_script('jobsearch-login-register', 'jobsearch_login_register_common_vars', $jobsearch_login_register_common_arr);
        
        if (!is_user_logged_in()) {
            wp_enqueue_script('jobsearch-login-register');
        }
    }

    public function load_files()
    {
        include plugin_dir_path(dirname(__FILE__)) . 'login-registration/vc-shortcodes/login-registration-shortcode.php';
        include plugin_dir_path(dirname(__FILE__)) . 'login-registration/templates/login-registration-template.php';
        include plugin_dir_path(dirname(__FILE__)) . 'login-registration/templates/login-registration-popup.php';
        include plugin_dir_path(dirname(__FILE__)) . 'login-registration/include/login-registration-submit.php';
    }

    public function auto_translated_login_pages()
    {
        global $jobsearch_plugin_options, $sitepress;

        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {

            $wpml_lang_pages = get_option('jobsearch_wpml_lang_pages_ids');
            $options_pages_ids = (!empty($wpml_lang_pages) ? $wpml_lang_pages : array());

            $login_page_id = isset($jobsearch_plugin_options['user-login-template-page']) ? $jobsearch_plugin_options['user-login-template-page'] : '';
            $login_page_id = jobsearch__get_post_id($login_page_id, 'page');

            if ($login_page_id > 0) {
                $dash_pages_ids = (isset($options_pages_ids['login_pages_ids']) && !empty($options_pages_ids['login_pages_ids']) ? $options_pages_ids['login_pages_ids'] : array());

                $def_trid = $sitepress->get_element_trid($login_page_id);

                $wpml_options = get_option('icl_sitepress_settings');
                $default_lang = isset($wpml_options['default_language']) ? $wpml_options['default_language'] : '';
                $languages = icl_get_languages('skip_missing=0&orderby=code');
                if (is_array($languages) && sizeof($languages) > 0) {
                    foreach ($languages as $lang_code => $language) {
                        if ($default_lang == $lang_code) {
                            continue;
                        }

                        if (!array_key_exists($lang_code . '_page_id', $dash_pages_ids)) {
                            $ru_args = array(
                                'post_title' => $lang_code . ' ' . wp_strip_all_tags('User Login'),
                                'post_content' => '',
                                'post_status' => 'publish',
                                'post_type' => 'page'
                            );
                            //creating post with arguments above and assign post id to $ru_post_id
                            $ru_post_id = wp_insert_post($ru_args);
                            $options_pages_ids['login_pages_ids'][$lang_code . '_page_id'] = $ru_post_id;
                            update_post_meta($ru_post_id, '_wp_page_template', 'user-login-template.php');

                            //change language and trid of second post to match russian and default post trid
                            $sitepress->set_element_language_details($ru_post_id, 'post_page', $def_trid, $lang_code);
                        }
                    }
                }
                //
            }
            //

            update_option('jobsearch_wpml_lang_pages_ids', $options_pages_ids);
        }
    }

}

// class Jobsearch_Login_Registration
$Jobsearch_Login_Registration_obj = new Jobsearch_Login_Registration();
