<?php

namespace ProApp\baseClasses;
use ProApp\filters\KCProPaymentFilter;
class KCProActivate  {

    public $warningMessage = '';
    public static function activate() {
        (new KCProGetDependency('kivicare-clinic-management-system', 'kc-lang'))->getPlugin();
        (new self())->migrateDatabase();
        (new self())->addModuleConfig();
        add_option( KIVI_CARE_PRO_PREFIX . 'theme_color','#4874dc');
        add_option( KIVI_CARE_PRO_PREFIX . 'theme_mode','false');
        add_option( KIVI_CARE_PRO_PREFIX . 'admin_lang','en' );
        
        if (!(new KCProHelper)->getOption('woocommerce_payment')) {
			(new KCProHelper)->updateOption('woocommerce_payment', 'off');
		}	
    }

    public function init() {

        add_action( 'plugins_loaded', function (){
            load_plugin_textdomain( 'kiviCare-clinic-&-patient-management-system-pro', false, dirname( KIVI_CARE_PRO_BASE_PATH ) . '/languages' );
        });

        (new self())->migrateTable();

        add_action( 'admin_init', [$this, 'checkPluginActive'] );

        add_action('init', function(){

            if (!function_exists('get_plugins')) {
                include_once ABSPATH . 'wp-admin/includes/plugin.php';
            }
            $kivicare_plugin = 'kivicare-clinic-management-system/kivicare-clinic-management-system.php' ;
            if ( is_plugin_active($kivicare_plugin) ) {
                $plugins = get_plugins();
                if (isset($plugins[$kivicare_plugin]) && !empty($plugins[$kivicare_plugin])) {
                    if ($plugins[$kivicare_plugin]['Version'] >= KIVI_CARE_PRO_REQUIRED_PLUGIN_VERSION) {
                        (new KCProFilterHandler())->init();
                        return;
                    }
                }
            }
            deactivate_plugins(  KIVI_CARE_PRO_BASE_PATH);
        });

        add_action( 'rest_api_init', [$this, 'checkPluginActive'] );
        if (!get_option( 'sms_config_data')) {
            add_action( 'admin_init', [$this, 'backupConfig'] );
        }

    }

	public function backupConfig(){
		$user = wp_get_current_user();
		$roles = (array) $user->roles;
		if( in_array('administrator' , $roles) ){
			$current_user_id = get_current_user_id(); 
			$get_sms_config  = get_user_meta($current_user_id,'sms_config_data',true);
			update_option('sms_config_data',$get_sms_config);
		}
	}
    public function checkPluginActive () {
        $kivicare_plugin = 'kivicare-clinic-management-system/kivicare-clinic-management-system.php' ;
        if ( is_plugin_active($kivicare_plugin) ) {
            $plugins = get_plugins();
            if(isset($plugins[$kivicare_plugin]) && $plugins[$kivicare_plugin] !== '') {
                if(!($plugins[$kivicare_plugin]['Version'] >= KIVI_CARE_PRO_REQUIRED_PLUGIN_VERSION)) {
//                    if (class_exists('\App\baseClasses\KCRoutesHandler')) {
//                        $routes = (new KCProRoutes())->routes();
//                        (new \App\baseClasses\KCRoutesHandler($routes, 'ProApp\\controllers\\'))->init();
//                        (new KCProFilterHandler())->init();
//                    }
                    $p_version = $plugins[$kivicare_plugin]['Version'];
                    $this->warningMessage = esc_html__( 'Warning:','kiviCare-clinic-&-patient-management-system-pro'). '<b><i>' .esc_html__('KiviCare - Clinic & Patient Management System Pro','kiviCare-clinic-&-patient-management-system-pro'). '</i>  </b>'.esc_html__(' Requires Plugin Version :  ','kiviCare-clinic-&-patient-management-system-pro').'<b> <i>'. esc_html__('KiviCare - Clinic & Patient Management System (EHR) V','kiviCare-clinic-&-patient-management-system-pro').KIVI_CARE_PRO_REQUIRED_PLUGIN_VERSION.' </i></b>' .esc_html__('your current plugin version is','kiviCare-clinic-&-patient-management-system-pro'). '<b> '. $p_version .' </b>';
                    add_action( 'admin_notices', [$this, 'pluginWarning'] );
                    if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );
                    deactivate_plugins(  KIVI_CARE_PRO_BASE_PATH);
                }
            } else {
                $this->warningMessage = esc_html__( 'Warning:','kiviCare-clinic-&-patient-management-system-pro'). '<b><i>' .esc_html__('KiviCare - Clinic & Patient Management System Pro','kiviCare-clinic-&-patient-management-system-pro'). '</i>  </b>' .esc_html__('Requires','kiviCare-clinic-&-patient-management-system-pro').' <b> <i>'. esc_html__('KiviCare - Clinic & Patient Management System (EHR)','kiviCare-clinic-&-patient-management-system-pro') .'</i></b>';
                add_action( 'admin_notices', [$this, 'pluginWarning'] );
                if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );
                deactivate_plugins(  KIVI_CARE_PRO_BASE_PATH);
            }
        } else {
            $this->warningMessage = esc_html__( 'Warning: kiviCare-clinic-&-patient-management-system-pro','kiviCare-clinic-&-patient-management-system-pro'). '<b><b>' . esc_html__(' is deactivate Because kivicare-clinic-management-system is not active', 'kiviCare-clinic-&-patient-management-system-pro' ).'</b><br> <strong>'.esc_html__('Note:kivicare-clinic-management-system plugin is active still receiving this message then Make sure that kivicare-clinic-management-system plugin folder is same as " kivicare-clinic-management-system" in wp-content/plugins.' ,'kiviCare-clinic-&-patient-management-system-pro').'</strong>';
            add_action( 'admin_notices', [$this, 'pluginWarning'] );
            if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );
            deactivate_plugins(  KIVI_CARE_PRO_BASE_PATH);
        }
		
		
    }
    public function pluginWarning() {
        $class = 'notice notice-warning';
        $message = $this->warningMessage;
        printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message );
    }
    public function migrateDatabase () {
        require KIVI_CARE_PRO_DIR . 'database/kc-patient-report-db.php';
    }
    public function addModuleConfig(){
        $prefix = KIVI_CARE_PRO_PREFIX;
        $prescription_module =[
			'prescription_module_config' => [
				[
                    'name'=> 'prescription',
                    'label' => 'Prescription',
                     'status' => '1'
				]
			],
		];	
        delete_option($prefix.'prescription_module');
		add_option( $prefix.'prescription_module', json_encode($prescription_module));

        $encounter_modules =[
			'encounter_module_config' => [
				[
					'name' => 'problem',
					'label' => 'Problem',
					'status' => '1'
				],
				[
					'name' => 'observation',
					'label' => 'Observations',
					'status' => '1'
				],
				[
					'name' => 'note',
					'label' => 'Note',
					'status' => '1'
				]
			],
		];	
		delete_option($prefix.'enocunter_modules');
		add_option( $prefix.'enocunter_modules',json_encode($encounter_modules));

        $lang_option = [
			'lang_option' => [
				[
					'label' => 'English',
					'id' => 'en'
				],
				[
					'label' => 'Arabic',
					'id' => 'ar'
				],
                [
					'label' => 'Greek',
					'id' => 'gr'
				],
                [
					'label' => 'Franch',
					'id' => 'fr'
				]
			],
		];	
        delete_option($prefix.'lang_option');
		add_option( $prefix.'lang_option',json_encode($lang_option));
    }

	public function migrateTable(){
		require KIVI_CARE_PRO_DIR . 'database/kcpro-gcal_appointment_mapping-db.php';
	}
}


