<?php

namespace ProApp\filters ;
use App\baseClasses\KCBase;

class KCProCommonFilters extends KCBase {

    public function __construct() {
        add_filter('kcpro_get_module_list', [$this, 'getProModuleList']);
        add_filter('kcpro_patient_clinic_checkin_checkout', [$this, 'patientClinicCheckOut']);
    }
    public function getProModuleList ($data) {

        $modules = kcGetModules();

        if(count($modules->kivicare_pro_feature) > 0) {
            foreach ($modules->kivicare_pro_feature as $module ) {
                if(!isset($module->isProActive)) {
                    $module->isProActive = '1' ;
                }
            }
        }

        return $modules ;
    }

    public function patientClinicCheckOut($request_data){

        $status = false;
        $message = esc_html__("failed to Checkout Clinic",'kiviCare-clinic-&-patient-management-system-pro');
        $notification_send_result = [];
        if(!empty($request_data['data']) && !empty($request_data['data']['id'])){
            $clinic_id = (int)$request_data['data']['id'];
            global $wpdb;
            $user_id = get_current_user_id();
            $new_temp = [
                'patient_id' => $user_id,
                'clinic_id' => $clinic_id,
                'created_at' => current_time('Y-m-d H:i:s')
            ];
            if(!empty($wpdb->get_var("SELECT id FROM {$wpdb->prefix}kc_patient_clinic_mappings WHERE patient_id={$user_id} AND clinic_id={$clinic_id}"))){
                echo json_encode([
                    'status' => true,
                    'message' => esc_html__("Patient Clinic Updated",'kiviCare-clinic-&-patient-management-system-pro'),
                    'notification' => []
                ]);
                die;
            }

            $wpdb->delete($wpdb->prefix.'kc_patient_clinic_mappings',['patient_id' => $user_id]);
            $result =$wpdb->insert($wpdb->prefix.'kc_patient_clinic_mappings',$new_temp);

            $patient_data = get_userdata( $user_id );

            $clinic_detail = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}kc_clinics WHERE id={$clinic_id}");
            $notification_data = [
                'user_email' => !empty($clinic_detail->email) ? $clinic_detail->email : '',
                'patient_name' => !empty($patient_data->display_name) ? $patient_data->display_name : '',
                'patient_email' => !empty($patient_data->user_email) ? $patient_data->user_email : '',
                'current_date' => current_time('Y-m-s'),
                'email_template_type' => 'patient_clinic_check_in_check_out',
                'clinic_number' => !empty($clinic_detail->telephone_no) ? $clinic_detail->telephone_no : '',
            ];
            // send email to clinic.
            $notification_send_result = [
                "email" => kcSendEmail($notification_data),
                'sms/whatsapp' =>   apply_filters('kcpro_send_sms', [
                    'type' => 'patient_clinic_check_in_check_out',
                    'user_data' => $notification_data,
                ])
            ];

            if($result){
                $status = true;
                $message = esc_html__("Patient clinic Update",'kiviCare-clinic-&-patient-management-system-pro');
            }
        }else{
            $message = esc_html__("Clinic Not selected",'kiviCare-clinic-&-patient-management-system-pro');
        }

        return [
            'status' => $status,
            'message' => $message,
            'notification' => $notification_send_result
        ];
    }
}


