<?php 
namespace ProApp\filters ;
use App\baseClasses\KCBase; 
use App\models\KCClinic;
use App\models\KCDoctorClinicMapping;
use App\models\KCReceptionistClinicMapping;
use App\models\KCClinicSession;
use WP_User;

class KCProMultiClinicFilters extends KCBase {

    public function __construct() {
        global $wpdb;
        $this->db = $wpdb;
        add_filter('kcpro_save_clinic', [$this, 'saveClinicData']);
        add_filter('kcpro_edit_clinic', [$this, 'editClinicData']);
        add_filter('kcpro_get_all_clinic', [$this, 'getClinicList']);
        add_filter('kcpro_get_clinic_data', [$this, 'getClinicData']);
    }
    public function saveClinicData($data) {

        $rules=[
            'first_name' => 'required',
            'last_name'   => 'required',
            'user_email' => 'required',
            'mobile_number' => 'required',
            'gender' => 'required',
            'name' => 'required',
            'email' => 'required',
            'telephone_no' => 'required',
        ];

        $errors = kcValidateRequest($rules, array_merge($data['clinicData'],$data['clinicAdminData']));
    
        if (count($errors)) {

            echo json_encode([
                'status' => false,
                'message' => esc_html__($errors[0], 'kiviCare-clinic-&-patient-management-system-pro')
            ]);
            die;

        }

        //check clinic admin email condition
        $email_condition = kcCheckUserEmailAlreadyUsed($data['clinicAdminData']);
        if(empty($email_condition['status'])){
            return $email_condition;
            die;
        }

        //check email condition
        $email_condition = kcCheckUserEmailAlreadyUsed(['user_email' => $data['clinicData']['email'],'ID' => empty($data['clinicAdminData']['ID']) ? '' : $data['clinicAdminData']['ID']],true);
        if(empty($email_condition['status'])){
            return $email_condition;
            die;
        }

        $clinic = new KCClinic;

        if (empty($data['id'])) {

            $clinic_email_exists = $clinic->get_var(['email' => $data['clinicData']['email']],'id');
            $clinic_admin_email_exists = $clinic->get_var(['email' => $data['clinicAdminData']['user_email']],'id');
            if(!empty($clinic_email_exists) || !empty($clinic_admin_email_exists)){
                return [
                    'status' => false,
                    'message' =>  esc_html__('There already exists an clinic or clinic admin registered with this email address,please use other email ID', 'kiviCare-clinic-&-patient-management-system-pro')

                ];
                die;
            }
            $data['clinicData']['created_at'] = current_time('Y-m-d H:i:s');
            $status = $clinic->insert($data['clinicData']);

        }else{


            $clinic_email_exists = $this->db->get_var("SELECT id FROM {$this->db->prefix}kc_clinics WHERE id != {$data['id']} AND email='{$data['clinicData']['email']}'");
            $clinic_admin_email_exists = $this->db->get_var("SELECT id FROM {$this->db->prefix}kc_clinics WHERE id != {$data['id']} AND email='{$data['clinicAdminData']['user_email']}'");
            if(!empty($clinic_email_exists) || !empty($clinic_admin_email_exists)){
                return [
                    'status' => false,
                    'message' =>  esc_html__('There already exists an clinic or clinic admin registered with this email address,please use other email ID', 'kiviCare-clinic-&-patient-management-system-pro')

                ];
                die;
            }

            if(is_string($data['clinicData']['profile_image']) || !is_int($data['clinicData']['profile_image']) || $data['clinicData']['profile_image'] === false) { 
                unset($data['clinicData']['profile_image']);
            }
            $status = $clinic->update($data['clinicData'], array( 'id' => (int)$data['id'] ));
        }

        

        if (!empty($data['clinicData']['id'])) {
            $clinic_id = (int)$data['clinicData']['id'];
        } else {
            $clinic_id = $status;
        }

        
        if (empty( $data['clinicAdminData']['ID']) && empty($data['id'])) {

            $data['clinicAdminData']['username'] = kcGenerateUsername( $data['clinicAdminData']['first_name']) ;
            $data['clinicAdminData']['user_pass'] = kcGenerateString(12);
            $user = wp_create_user( $data['clinicAdminData']['username'],  $data['clinicAdminData']['user_pass'],  $data['clinicAdminData']['user_email']);
            $u    = new WP_User( $user );
            $u->display_name =  $data['clinicAdminData']['first_name'] . ' ' .   $data['clinicAdminData']['last_name'];
            $u->set_role($this->getClinicAdminRole());
            wp_insert_user($u);
            if(!empty($user)) {
                $new_temp = [
                    'clinic_admin_id' => $user,
                    'created_at'=> current_time('Y-m-d H:i:s')
                ];
                $clinic->update($new_temp,array( 'id' => (int)$clinic_id ));
                $user_email_param =  kcCommonNotificationUserData($u->ID,$data['clinicAdminData']['user_pass']);
                kcSendEmail($user_email_param);
                if(kcCheckSmsOptionEnable()){
                    $sms = apply_filters('kcpro_send_sms', [
                        'type' => 'clinic_admin_registration',
                        'user_data' => $user_email_param,
                    ]);
                }
            }
            update_user_meta( $user, 'first_name', $data['clinicAdminData']['first_name'] );
            update_user_meta( $user, 'last_name', $data['clinicAdminData']['last_name'] );
            update_user_meta( $user, 'basic_data', json_encode( $data['clinicAdminData'] ) );

            if(is_int($data['clinicAdminData']['profile_image']) && $data['clinicAdminData']['profile_image'] !== false) {
                update_user_meta( (int)$u->ID, 'clinic_admin_profile_image', $data['clinicAdminData']['profile_image'] );
            }

        }
        else 
        {

            $data['clinicAdminData']['ID'] = (int)$data['clinicAdminData']['ID'];

            wp_update_user(
                array(
                    'ID'         => $data['clinicAdminData']['ID'],
                    'user_email' => $data['clinicAdminData']['user_email'],
                    'display_name' =>  $data['clinicAdminData']['first_name'] . ' ' . $data['clinicAdminData']['last_name']
                )
            );

            update_user_meta( $data['clinicAdminData']['ID'], 'first_name', $data['clinicAdminData']['first_name'] );
            update_user_meta( $data['clinicAdminData']['ID'], 'last_name', $data['clinicAdminData']['last_name'] );
            update_user_meta( $data['clinicAdminData']['ID'], 'basic_data', json_encode( $data['clinicAdminData'] ) );

            if(is_int($data['clinicAdminData']['profile_image']) && $data['clinicAdminData']['profile_image'] !== false) {
                update_user_meta( $data['clinicAdminData']['ID'], 'clinic_admin_profile_image', $data['clinicAdminData']['profile_image'] );
            }

            $status = 1 ;
        }

        if ($status) {
            return [
                'status' => true,
                'message' => esc_html__('Clinic has been saved successfully', 'kiviCare-clinic-&-patient-management-system-pro')
            ];
        } else {
            return [
                'status' => false,
                'message' => esc_html__('Clinic has not been saved successfully', 'kiviCare-clinic-&-patient-management-system-pro')
            ];
        }
    }
    public function editClinicData($data) {

        $id = (int)$data['clinic_id'];
        $clinic = new KCClinic;
        $doctors = $inactive_doctors =[];
        $login_user_role = $this->getLoginUserRole();
        $user_id = get_current_user_id();
        if($login_user_role == $this->getClinicAdminRole()){
            $results = $clinic->get_by(['id' => kcGetClinicIdOfClinicAdmin()], '=',true);
        }else{
            $results = $clinic->get_by(['id' => (int)$id], '=',true);
        }

        if( !empty($results->clinic_admin_id) ){
            $clinicAdmin = WP_User::get_data_by('ID', (int)$results->clinic_admin_id);
            $fname = get_user_meta( (int)$clinicAdmin->ID, 'first_name',true );
            $lname=get_user_meta( (int)$clinicAdmin->ID, 'last_name',true);
            $basic_data = get_user_meta( (int)$clinicAdmin->ID, 'basic_data',true );
            $basic_data = json_decode($basic_data);
        }

        if ($results) {

            $results->specialties = !empty($results->specialties) ?  json_decode($results->specialties) : [];
            if(!empty($results->extra)) {
                $extra = json_decode($results->extra);
                $results->currency_prefix = !empty($extra->currency_prefix) && $extra->currency_prefix !== 'null' ? $extra->currency_prefix : '';
                $results->currency_postfix = !empty($extra->currency_postfix) && $extra->currency_postfix !== 'null' ? $extra->currency_postfix : '';
            }
            $results->first_name = !empty($fname) ? $fname : '';
            $results->last_name = !empty($lname) ? $lname : '';
            $results->user_email = $basic_data->user_email;
            $results->mobile_number = $basic_data->mobile_number;
            $results->dob =$basic_data->dob;
            $results->gender =$basic_data->gender;
            $results->clinic_profile = !empty($results->profile_image) ? wp_get_attachment_url($results->profile_image) : '';
            $results->profile_image = wp_get_attachment_url(get_user_meta((int)$results->clinic_admin_id, 'clinic_admin_profile_image', true));
            $doctor_mapping = collect((new KCDoctorClinicMapping())->get_all())->pluck('doctor_id')->toArray();

            extract(kcClinicSessionDoctor($doctor_mapping));

            if(count($doctors) > 0) {
                $results->doctors = $doctors;
            } else {
                $results->clinic_sessions = [];
                echo json_encode([
                    'status' => true,
                    'message' => esc_html__('Clinic data', 'kiviCare-clinic-&-patient-management-system-pro'),
                    'data' => $results
                ]);
                wp_die();
            }

            if ($login_user_role === 'administrator' ) {
                $clinic_sessions = (new KCClinicSession())->get_all();
            } else {
                $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => (int)$results->id]);
            }

            $results->clinic_sessions = kcClinicSession($clinic_sessions,$inactive_doctors,$doctors);
       

        } else {
            
            // multiclinic session condition
            $doctor_mapping = collect((new KCDoctorClinicMapping())->get_all())->pluck('doctor_id')->toArray();
            extract(kcClinicSessionDoctor($doctor_mapping));
           
            $newvar = new \stdClass();
            $newvar->doctors = $doctors;
            
            switch ($this->getLoginUserRole()) {
                case $this->getDoctorRole():
                    $clinic_sessions = (new KCClinicSession())->get_by(['doctor_id' => (int)$user_id]);
                    break;
                case 'administrator':
                    $clinic_sessions = (new KCClinicSession())->get_all();
                    break;
                case $this->getClinicAdminRole():
                    $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => kcGetClinicIdOfClinicAdmin()]);
                    break;
                case $this->getReceptionistRole():
                    $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => kcGetClinicIdOfReceptionist()]);
                    break;
                default:
                    $clinic_id = kcGetDefaultClinicId();
                    $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => (int)$clinic_id]);
                    break;
            }

            $newvar->clinic_sessions = kcClinicSession($clinic_sessions,$inactive_doctors,$doctors);

            return [
                'status' => true,
                'message' => esc_html__('Clinic data', 'kiviCare-clinic-&-patient-management-system-pro'),
                'data' => $newvar
            ];
            die();

        }

        return [
            'status' => true,
            'message' => esc_html__('Clinic data', 'kiviCare-clinic-&-patient-management-system-pro'),
            'data' => $results
        ];

    }
    public function getClinicList($clinic){
        $data = [];
        $clinics_table           = $this->db->prefix . 'kc_' . 'clinics';
        $table = $this->db->prefix . 'kc_' . 'doctor_clinic_mappings';
        if($this->getLoginUserRole() === 'kiviCare_doctor'){
            $user_id = get_current_user_id();
            $query = "SELECT clinic_id AS id,(SELECT name FROM {$clinics_table} WHERE id= doctor.clinic_id ) as name FROM {$table} as `doctor` 
            WHERE doctor_id =". (int)$user_id;

        }else if($this->getLoginUserRole() === 'kiviCare_patient'){
            $patienttable =  $this->db->prefix . 'kc_' . 'patient_clinic_mappings';
            $user_id = get_current_user_id();
            $clinicCount = $this->db->get_row('select clinic_id from '.$patienttable.' where patient_id='.$user_id);
            if($clinicCount != null){
                $query = "SELECT clinic_id AS id,(SELECT name FROM {$clinics_table} WHERE id= patient.clinic_id ) as name FROM {$patienttable} as patient 
                WHERE patient_id =". (int)$user_id;
            }else{
                $query = "SELECT * FROM {$clinics_table} WHERE status='1'";
            }
        }else{
            $query = "SELECT * FROM {$clinics_table} WHERE status='1'";
        }
        $clinicList = collect( $this->db->get_results( $query, OBJECT ) )->toArray();
        foreach ($clinicList as $clinic) {
            $data[] = [
                'id'    => $clinic->id,
                'label' => $clinic->name
            ];
        }
        return [
            'data'=> $data,
            'status' =>true,
        ];
        
    }
    public function getClinicData($data){
        $clinic_condition = ' ';
        if(!empty($data['data']['props_clinic_id']) && !in_array($data['data']['props_clinic_id'],['0',0]) ){
            $clinic_condition = " AND id={$data['data']['props_clinic_id']} ";
        }
        $clinics_table           = $this->db->prefix . 'kc_' . 'clinics';
        $query = "SELECT * FROM {$clinics_table} WHERE status='1' {$clinic_condition}";
        $clinicList = collect( $this->db->get_results( $query, OBJECT ) );
        $results = [];
        foreach($clinicList as $key=> $clinic){
            $results[$key]['id'] = $clinic->id;
            $results[$key]['name'] = $clinic->name;
            $results[$key]['telephone_no'] = $clinic->telephone_no;
            $results[$key]['specialties'] = !empty($clinic->specialties) ? json_decode($clinic->specialties) : [] ;
            $results[$key]['address'] = $clinic->address;
            $results[$key]['city'] = $clinic->city;
            $results[$key]['postal_code'] = $clinic->postal_code;
            $results[$key]['country'] = $clinic->country;
            $results[$key]['profile_image'] = wp_get_attachment_url($clinic->profile_image);
        }
        return [
            'data'=> $results,
            'status' =>true,
        ];
    }
    
}
