<?php

namespace ProApp\baseClasses;

class KCProBase {

    public $plugin_path;

    public $nameSpace;

    public $plugin_url;

    public $plugin;

    public $dbConfig;

    private $pluginPrefix;

    public function __construct() {

        $this->plugin_path = plugin_dir_path( dirname( __FILE__, 2 ) );
        $this->plugin_url  = plugin_dir_url( dirname( __FILE__, 2 ) );

        if  (defined( 'KIVI_CARE_PRO_NAMESPACE' )) {
            $this->nameSpace    = KIVI_CARE_PRO_NAMESPACE;
        }

        if  (defined( 'KIVI_CARE_PRO_PREFIX' )) {
            $this->pluginPrefix    = KIVI_CARE_PRO_PREFIX;
        }

        $this->plugin = plugin_basename( dirname( __FILE__, 3 ) ) . '/kivicare-clinic-management-system-pro.php';

        $this->dbConfig = [
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db'   => DB_NAME,
            'host' => DB_HOST
        ];

    }

    public function get_namespace() {
        return $this->nameSpace;
    }

    protected function getPrefix() {
        return KIVI_CARE_PRO_PREFIX;
    }

    protected function getClinicAdminRole() {
        return KIVI_CARE_PRO_PREFIX . "clinic_admin";
    }

    protected function getDoctorRole() {
        return KIVI_CARE_PRO_PREFIX . "doctor";
    }

    protected function getPatientRole() {
        return KIVI_CARE_PRO_PREFIX . "patient";
    }

    protected function getReceptionistRole() {
        return KIVI_CARE_PRO_PREFIX . "receptionist";
    }

    protected function getPluginPrefix() {
        return $this->pluginPrefix;
    }
	
}

