<?php

namespace ProApp\filters ;
use App\baseClasses\KCBase;
use DateTime;
use function Clue\StreamFilter\fun;

class KCProCommonFilters extends KCBase {

    public $doctor_time_slot = 0;
    public function __construct() {
        add_filter('kcpro_get_module_list', [$this, 'getProModuleList']);
        add_filter('kcpro_patient_clinic_checkin_checkout', [$this, 'patientClinicCheckOut']);
        add_filter('kcpro_verify_appointment_timeslot', [$this, 'verifySelectTimeslot']);
    }
    public function getProModuleList ($data) {

        $modules = kcGetModules();

        if(count($modules->kivicare_pro_feature) > 0) {
            foreach ($modules->kivicare_pro_feature as $module ) {
                if(!isset($module->isProActive)) {
                    $module->isProActive = '1' ;
                }
            }
        }

        return $modules ;
    }

    public function patientClinicCheckOut($request_data){

        $status = false;
        $message = esc_html__("failed to Checkout Clinic",'kiviCare-clinic-&-patient-management-system-pro');
        $notification_send_result = [];
        if(!empty($request_data['data']) && !empty($request_data['data']['id'])){
            $clinic_id = (int)$request_data['data']['id'];
            global $wpdb;
            $user_id = get_current_user_id();
            $new_temp = [
                'patient_id' => $user_id,
                'clinic_id' => $clinic_id,
                'created_at' => current_time('Y-m-d H:i:s')
            ];
            if(!empty($wpdb->get_var("SELECT id FROM {$wpdb->prefix}kc_patient_clinic_mappings WHERE patient_id={$user_id} AND clinic_id={$clinic_id}"))){
                echo json_encode([
                    'status' => true,
                    'message' => esc_html__("Patient Clinic Updated",'kiviCare-clinic-&-patient-management-system-pro'),
                    'notification' => []
                ]);
                die;
            }

            $wpdb->delete($wpdb->prefix.'kc_patient_clinic_mappings',['patient_id' => $user_id]);
            $result =$wpdb->insert($wpdb->prefix.'kc_patient_clinic_mappings',$new_temp);

            $patient_data = get_userdata( $user_id );

            $clinic_detail = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}kc_clinics WHERE id={$clinic_id}");
            $notification_data = [
                'user_email' => !empty($clinic_detail->email) ? $clinic_detail->email : '',
                'patient_name' => !empty($patient_data->display_name) ? $patient_data->display_name : '',
                'patient_email' => !empty($patient_data->user_email) ? $patient_data->user_email : '',
                'current_date' => current_time('Y-m-s'),
                'email_template_type' => 'patient_clinic_check_in_check_out',
                'clinic_number' => !empty($clinic_detail->telephone_no) ? $clinic_detail->telephone_no : '',
            ];
            // send email to clinic.
            $notification_send_result = [
                "email" => kcSendEmail($notification_data),
                'sms/whatsapp' =>   apply_filters('kcpro_send_sms', [
                    'type' => 'patient_clinic_check_in_check_out',
                    'user_data' => $notification_data,
                ])
            ];

            if($result){
                $status = true;
                $message = esc_html__("Patient clinic updated successfully",'kiviCare-clinic-&-patient-management-system-pro');
            }
        }else{
            $message = esc_html__("Clinic Not selected",'kiviCare-clinic-&-patient-management-system-pro');
        }

        return [
            'status' => $status,
            'message' => $message,
            'notification' => $notification_send_result
        ];
    }

    public function verifySelectTimeslot($request_data){

        global $wpdb;

        $appointment_date = esc_sql(date( 'Y-m-d', strtotime( $request_data['appointment_start_date'])  ));
        $appointment_day = esc_sql(strtolower(date('l', strtotime($request_data['appointment_start_date'])))) ;
        $day_short = esc_sql(substr($appointment_day, 0, 3));

        $request_data['clinic_id']['id'] = (int)$request_data['clinic_id']['id'];
        $request_data['doctor_id']['id'] = (int)$request_data['doctor_id']['id'];

        $doctor_session = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}kc_clinic_sessions WHERE `doctor_id` ={$request_data['doctor_id']['id']} AND `clinic_id` ={$request_data['clinic_id']['id']}  AND ( `day` = '{$day_short}' OR `day` = '{$appointment_day}') ");
        $service_id = collect($request_data['visit_type'])->map(function($v){
            return (int)$v['service_id'];
        })->implode(',');
        $service_duration = 0;
        if(!empty($service_id)){
            $service_duration = $wpdb->get_var("SELECT SUM(duration) FROM {$wpdb->prefix}kc_service_doctor_mapping WHERE service_id IN ({$service_id}) AND doctor_id={$request_data['doctor_id']['id']}");
            if(!empty($service_duration)){
                $this->doctor_time_slot = $doctor_session[0]->time_slot;
//                $service_duration = $this->recursiveAppointmentEndTime($service_duration,$this->doctor_time_slot);
            }
        }
        $service_duration = !empty($service_duration) ? $service_duration  : $doctor_session[0]->time_slot ;
        $end_time             = strtotime( "+" . $service_duration . " minutes", strtotime($request_data['appointment_start_time'])  );

        $time_between_doctor_session = false;
        foreach ($doctor_session as $session){
            $current_time_slot_start = DateTime::createFromFormat('h:i a', date('h:i A', strtotime($request_data['appointment_start_time'])));
            $current_time_slot_end = DateTime::createFromFormat('h:i a',  date('h:i A', $end_time));
            $session_start_time = DateTime::createFromFormat('h:i a', date('h:i A', strtotime($session->start_time)));
            $session_end_time = DateTime::createFromFormat('h:i a', date('h:i A', strtotime($session->end_time)));
            if($current_time_slot_start >= $session_start_time && $current_time_slot_start <= $session_end_time &&
                $current_time_slot_end >= $session_start_time && $current_time_slot_end <= $session_end_time){
                $time_between_doctor_session = true;
            }
        }

        if(!$time_between_doctor_session){
            return [
                'status'  => false,
                'message' => esc_html__("Select service duration not available for doctor","kc-lang")
            ];
        }

        $appointment_id_condition = !empty( $request_data['id'])  ? " AND id != {$request_data['id']} " : ' ';
        $all_appointment_select_doctor = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}kc_appointments  WHERE doctor_id={$request_data['doctor_id']['id']}  {$appointment_id_condition} AND appointment_start_date = '{$appointment_date}' AND status != 0 ");
        $already_book_slot = false;
        if(!empty($all_appointment_select_doctor)){
            foreach ($all_appointment_select_doctor as $doctor_appointment){
                $current_time_slot_start = DateTime::createFromFormat('h:i a', date('h:i A', strtotime($request_data['appointment_start_time'])));
                $current_time_slot_end = DateTime::createFromFormat('h:i a', date('h:i A', $end_time));
                $appointment_start_time_temp = DateTime::createFromFormat('h:i a', date('h:i A', strtotime($doctor_appointment->appointment_start_time)));
                $appointment_end_time_temp = DateTime::createFromFormat('h:i a', date('h:i A', strtotime($doctor_appointment->appointment_end_time)));

                if(($current_time_slot_start >= $appointment_start_time_temp && $current_time_slot_start < $appointment_end_time_temp)
                    ||  ( $current_time_slot_end > $appointment_start_time_temp && $current_time_slot_end < $appointment_end_time_temp)){
                    $already_book_slot = true;
                }
                if($current_time_slot_end > $appointment_start_time_temp && $current_time_slot_start < $appointment_end_time_temp){
                    $already_book_slot = true;
                }
            }
        }

        if($already_book_slot){
            return [
                'status'  => false,
                'message' => esc_html__("Select timeslot is already booked, please select another timeslot","kc-lang")
            ];

        }

        return [
          'status' => true,
            'end_time' =>$end_time
        ];
    }

    public function recursiveAppointmentEndTime($service_duration,$doctor_time_slot){
        if($service_duration <= $doctor_time_slot){
            return $doctor_time_slot;
        }else{
            $doctor_time_slot += $this->doctor_time_slot;
            return $this->recursiveAppointmentEndTime($service_duration,$doctor_time_slot );
        }
    }
}


