var test = {};

(function ($, _) {

	// Local reference to the WordPress media namespace.
	var media = wp.media;

	// Local instance of the Attachment Details TwoColumn used in the edit attachment modal view
	var wpAttachmentDetailsTwoColumn = media.view.Attachment.Details.TwoColumn;
	var l10n = media.view.l10n;

	if (wp.media && leopard_wordpress_offload_media_params.is_plugin_setup == '1') {
		if ($("#woocommerce-product-data").length > 0 || $(".edd_upload_file_button").length > 0) {
			media.view.MediaFrame.Select.prototype.browseRouter = function (routerView) {
				routerView.set({
					upload: {
						text: l10n.uploadFilesTitle,
						priority: 20
					},
					browse: {
						text: l10n.mediaLibraryTitle,
						priority: 40
					},
					my_tab: {
						text: leopard_wordpress_offload_media_params.current_provider,
						priority: 60
					}
				});
			};

			wp.media.view.Modal.prototype.on("open", function () {
				if ($('body').find('.media-frame-router .media-menu-item.active')[0].innerText == leopard_wordpress_offload_media_params.current_provider) {
					do_cloud_tab_contents();
				}
			});

			$(wp.media).on('click', '.media-router .media-menu-item', function (e) {
				if (e.target.innerText == leopard_wordpress_offload_media_params.current_provider) {
					do_cloud_tab_contents();
				}
			});

			function do_cloud_tab_contents() {
				var data = {
					action: 'nou_leopard_offload_media_render_cloud_files',
					_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce
				};
				$.ajax({
					url: leopard_wordpress_offload_media_params.ajax_url,
					type: "POST",
					data: data,
					beforeSend: function () {
						var html = '<div class="attachments-browser"><div class="attachments"><div class="nou_leopard_wom_loading active"></div></div></div>';
						$('body .media-modal-content .media-frame-content')[0].innerHTML = html;
					},
					success: function (result) {
						if (result.data.status == 'success') {
							$('body .media-modal-content .media-frame-content')[0].innerHTML = result.data.html;
						}
					},
					error: function (jqXHR, textStatus, errorThrown) {
						$('body .media-modal-content .media-frame-content')[0].innerHTML = errorThrown;
					}
				});
			}

			function set_permission_object(data) {
				$.ajax({
					url: leopard_wordpress_offload_media_params.ajax_url,
					type: "POST",
					data: data,
					beforeSend: function () {
						var html = '<div class="nou_leopard_wom_loading active"></div>';
						$('body .media-modal-content .media-frame-content #leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID').append(html);
					},
					success: function (result) {
						if (result.data.status == 'success') {
							$('body .media-modal-content .media-frame-content #leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .nou_leopard_wom_loading').removeClass('active');
						} else {
							$('body .media-modal-content .media-frame-content')[0].innerHTML = result.data.message;
						}
					}
				});
			}

			$("body").on("click", "#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID a.select-folder", function (event) {

				event.preventDefault();

				var Region = $(this).data('region');
				var Current_folder = $(this).data('current_folder');

				var data = {
					action: 'nou_leopard_offload_media_render_cloud_files',
					_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce,
					current_region: Region,
					current_folder: Current_folder,
				}

				$.ajax({
					url: leopard_wordpress_offload_media_params.ajax_url,
					type: "POST",
					data: data,
					beforeSend: function () {
						var html = '<div class="attachments-browser"><div class="attachments"><div class="nou_leopard_wom_loading active"></div></div></div>';
						$('body .media-modal-content .media-frame-content')[0].innerHTML = html;
					},
					success: function (result) {
						if (result.data.status == 'success') {
							$('body .media-modal-content .media-frame-content')[0].innerHTML = result.data.html;
						}
					}
				});

			});
			var input_file_url;
			var input_file_name;

			$("body").on("click", ".upload_file_button", function () {

				input_file_url = $(this).parent().prev().find("input");
				input_file_name = $(this).parent().prev().prev().find("input");

				$(input_file_url).val('');
				$(input_file_name).val('');

				$("body").on("click", '#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .nou_leopard_wom_ul_File_Manager_li_File a', function (event) {
					var target = $(event.target);
					var Name = $(this).data('value');
					var Key = $(this).data('key');
					var Original = $(this).data('original');
					var Path = $(this).data('path');
					var type = localStorage.getItem('leopard_wordpress_offload_media_type') || 'url';
					if (target.hasClass('onoffswitch-checkbox')) {
						var data = {
							key: Key,
							path: Path,
							action: 'nou_leopard_offload_media_set_permission_object',
							_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce
						};
						set_permission_object(data);
					} else {
						$(".media-modal-close").trigger("click");
						// if (type == 'url') {
						// 	$(input_file_url).val(Key);
						// } else {
						// 	var shortcode = '[leopard_wordpress_offload_media_storage key="' + Original + '" name="' + Name + '"]';
						// 	$(input_file_url).val(shortcode);
						// }
						var shortcode = '[leopard_wordpress_offload_media_storage key="' + Original + '" name="' + Name + '"]';
						$(input_file_url).val(shortcode);
						$(input_file_name).val(Name);
					}
				});

				input_file_url.on('change', function(){
					let url = input_file_url.val();
					if(url !== '' && !url.includes("leopard_wordpress_offload_media_storage")){
						let key = url.replace(leopard_wordpress_offload_media_params.base_url, '');
						
						try {
							key = url.replace(leopard_wordpress_offload_media_params.cname_url, '');
						} catch (error) {}

						var shortcode = '[leopard_wordpress_offload_media_storage key="' + key + '" name="' + input_file_name.val() + '"]';
						$(input_file_url).val(shortcode);
					}
				});
			});

			$("body").on("click", ".edd_upload_file_button", function () {

				input_file_url = $(this).closest('.edd-repeatable-row-standard-fields').find(".edd_repeatable_upload_field");
				input_file_name = $(this).closest('.edd-repeatable-row-standard-fields').find(".edd_repeatable_name_field");

				$(input_file_url).val('');
				$(input_file_name).val('');

				$("body").on("click", '#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .nou_leopard_wom_ul_File_Manager_li_File a', function (event) {
					var target = $(event.target);
					var Name = $(this).data('value');
					var Key = $(this).data('key');
					var Path = $(this).data('path');
					var Original = $(this).data('original');
					var type = localStorage.getItem('leopard_wordpress_offload_media_type') || 'url';
					if (target.hasClass('onoffswitch-checkbox')) {
						var data = {
							key: Key,
							path: Path,
							action: 'nou_leopard_offload_media_set_permission_object',
							_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce
						};
						set_permission_object(data);
					} else {
						$(".media-modal-close").trigger("click");
						// if (type == 'url') {
						// 	$(input_file_url).val(Key);
						// } else {
						// 	var shortcode = '[leopard_wordpress_offload_media_storage key="' + Original + '" name="' + Name + '"]';
						// 	$(input_file_url).val(shortcode);
						// }
						var shortcode = '[leopard_wordpress_offload_media_storage key="' + Original + '" name="' + Name + '"]';
						$(input_file_url).val(shortcode);
						$(input_file_name).val(Name);
					}
				});

				input_file_url.on('change', function(){
					let url = input_file_url.val();
					if(url !== '' && !url.includes("leopard_wordpress_offload_media_storage")){
						let key = url.replace(leopard_wordpress_offload_media_params.base_url, '');
						
						try {
							key = url.replace(leopard_wordpress_offload_media_params.cname_url, '');
						} catch (error) {}

						var shortcode = '[leopard_wordpress_offload_media_storage key="' + key + '" name="' + input_file_name.val() + '"]';
						$(input_file_url).val(shortcode);
					}
				});
			});

			$("body").on("click", "#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .filemanager-display a.view", function () {
				var type = 'grid';
				if ($(this).hasClass('view-list')) {
					type = 'list';
				}
				var Region = $(this).data('region');
				var Current_folder = $(this).data('current_folder');

				var data = {
					type: type,
					action: 'nou_leopard_offload_media_render_cloud_files',
					_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce,
					current_region: Region,
					current_folder: Current_folder,
				}
				$.ajax({
					url: leopard_wordpress_offload_media_params.ajax_url,
					type: "POST",
					data: data,
					beforeSend: function () {
						var html = '<div class="attachments-browser"><div class="attachments"><div class="nou_leopard_wom_loading active"></div></div></div>';
						$('body .media-modal-content .media-frame-content')[0].innerHTML = html;
					},
					success: function (result) {
						if (result.data.status == 'success') {
							$('body .media-modal-content .media-frame-content')[0].innerHTML = result.data.html;
						}
					}
				});
				return false;
			});

			$("body").on("click", "#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .filemanager-display a.use", function () {
				$('#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .filemanager-display a.use').removeClass('current');
				var type = $(this).data('type');
				localStorage.setItem('leopard_wordpress_offload_media_type', type);
				$(this).addClass('current');
				return false;
			});

			$("body").on("click", "#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID .leopard-load-more-cloud", function (event) {

				event.preventDefault();
				var self = $(this);
				var ulLists = $('body').find('#leopard_wordpress_offload_media_Show_Keys_of_a_Folder_Bucket_Result_ID #nou_leopard_wom_ul_File_Manager_all_files');
				var Region = $(this).data('region');
				var Current_folder = $(this).data('current_folder');
				var continuationToken = $(this).data('next');

				if(continuationToken !== 'no_more'){
					var data = {
						action: 'nou_leopard_offload_media_render_cloud_files_load_more',
						_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce,
						current_region: Region,
						current_folder: Current_folder,
						continuation_token: continuationToken,
					}

					$.ajax({
						url: leopard_wordpress_offload_media_params.ajax_url,
						type: "POST",
						data: data,
						beforeSend: function () {
							self.text(leopard_wordpress_offload_media_params.loadmore.loading);
						},
						success: function (result) {
							if (result.data.status == 'success') {
								self.text(leopard_wordpress_offload_media_params.loadmore.text);
								ulLists.append(result.data.html);

								const newToken = result.data.nextToken ? result.data.nextToken : 'no_more';

								if(newToken !== 'no_more'){
									self.data('next', newToken);
								}else{
									self.hide();
								}
							}
						}
					});
				}else{
					//disabled load more button
					self.hide();
				}
			});
		}
	}
	/**
	 * Add S3 details to attachment.
	 */
	media.view.Attachment.Details.TwoColumn = wpAttachmentDetailsTwoColumn.extend({
		events: function () {
			return _.extend({}, wpAttachmentDetailsTwoColumn.prototype.events, {
				'click .local-warning': 'confirmS3Removal',
			});
		},

		render: function () {
			this.fetchS3Details(this.model.get('id'));
		},

		fetchS3Details: function (id) {
			wp.ajax.send('nou_leopard_offload_media_get_attachment_provider_details', {
				data: {
					_wpnonce: leopard_wordpress_offload_media_params.ajax_nonce,
					id: id
				}
			}).done(_.bind(this.renderView, this));
		},

		renderView: function (response) {
			// Render parent media.view.Attachment.Details
			wpAttachmentDetailsTwoColumn.prototype.render.apply(this);
			
			if (response && response.links && response.links.length > 0) {
				this.renderActionLinks(response);
				this.renderS3Details(response);
			}
		},

		renderActionLinks: function (response) {
			var links = (response && response.links) || [];
			var $actionsHtml = this.$el.find('.actions');
			var $s3Actions = $('<div />', {
				'class': 'nou-actions'
			});

			var s3Links = [];
			_(links).each(function (link) {
				s3Links.push(link);
			});

			$s3Actions.append(s3Links.join(' | '));
			$actionsHtml.append($s3Actions);
		},

		renderS3Details: function (response) {
			if (!response || !response.provider_object) {
				return;
			}
			var $detailsHtml = this.$el.find('.attachment-info .details');
			var html = this.generateDetails(response, ['provider_name', 'region', 'bucket', 'key']);
			$detailsHtml.append(html);
		},

		generateDetails: function (response, keys) {
			var html = '';
			var template = _.template('<div class="<%= key %>"><strong><%= label %>:</strong> <%= value %></div>');

			_(keys).each(function (key) {
				if (response.provider_object[key]) {
					var value = response.provider_object[key];

					html += template({
						key: key,
						label: leopard_wordpress_offload_media_params.strings[key],
						value: value
					});
				}
			});

			return html;
		},

		confirmS3Removal: function (event) {
		},
	});

	media.view.Attachment.Library = media.view.Attachment.Library.extend({
		className: function () { return 'attachment ' + this.model.get('leopard-cloud-class'); }
	});

})(jQuery, _);
