<?php
if (!defined('ABSPATH')) {exit;}

/**
 * Fired during plugin deactivation
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Leopard_Wordpress_Offload_Media
 * @subpackage Leopard_Wordpress_Offload_Media/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Leopard_Wordpress_Offload_Media
 * @subpackage Leopard_Wordpress_Offload_Media/includes
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Leopard_Wordpress_Offload_Media_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		self::unscheduled_background_tasks();
	}

	public static function unscheduled_background_tasks() {
		if ( function_exists( 'leopard_wordpress_offload_media_unschedule_action' ) ) {
			leopard_offload_media_after_action_scheduler_completed();
			leopard_wordpress_offload_media_unschedule_action( 'nou_leopard_offload_media_cronjob_verify_offloaded_files' );
		}
	}
}
