<?php
/* The file has a General Settings Page template
 *
 * @package    VIWCPF_Woocommerce_Product_Filters
 * @subpackage VIWCPF_Woocommerce_Product_Filters/admin/partials
 * */
?>
    <div class="wrap woo-viwcpf">
        <h1><?php esc_html_e( 'WooCommerce Product Filters Settings', 'pofily-woocommerce-product-filters' ) ?></h1>
        <form method="POST" action="" class="vi-ui form">
			<?php
			$VIWCPF_Woocommerce_Product_Filters_Data_default = new VIWCPF_Woocommerce_Product_Filters_Data;
			$viwcpf_setting_params_default                   = $VIWCPF_Woocommerce_Product_Filters_Data_default->get_default();
			$viwcpf_setting_params                           = get_option( 'viwcpf_setting_params' ) ? get_option( 'viwcpf_setting_params' ) : $viwcpf_setting_params_default;

			/* outputs false */
			wp_nonce_field( 'viwcpf_save_filter_setting', '_viwcpf_filter_setting_nonce' );

			?>
            <div class="vi-ui top attached tabular menu">
                <div class="item active" data-tab="general">
                    <label><?php esc_html_e( 'General', 'pofily-woocommerce-product-filters' ) ?></label>
                </div>
                <div class="item" data-tab="style">
                    <label><?php esc_html_e( 'Customize', 'pofily-woocommerce-product-filters' ) ?></label>
                </div>
                <div class="item" data-tab="metadata">
                    <label><?php esc_html_e( 'Metadata', 'pofily-woocommerce-product-filters' ) ?></label>
                </div>
                <div class="item" data-tab="seo-rule">
                    <label><?php esc_html_e( 'SEO rule', 'pofily-woocommerce-product-filters' ) ?></label>
                </div>
                <div class="item" data-tab="update">
                    <label><?php esc_html_e( 'Update', 'pofily-woocommerce-product-filters' ) ?></label>
                </div>
            </div>
            <!--General-->
            <div class="vi-ui bottom attached segment tab active" data-tab="general">
                <h2><?php esc_html_e( 'General setting', 'pofily-woocommerce-product-filters' ) ?></h2>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Filter Ajax', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox"
                                       class="viwcpf_using_ajax"
                                       name="viwcpf_setting[viwcpf_using_ajax]"
                                       id="viwcpf_using_ajax"
									<?php
									if ( isset( $viwcpf_setting_params['viwcpf_using_ajax'] ) ) {
										echo esc_attr( 'checked' );
									}
									?>
                                >
                                <label for="viwcpf_using_ajax"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Enable filter with ajax', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr class="option_select " data-select="viwcpf_using_ajax" data-type_show="true">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Shop loop container', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="field">
                                <div class="vi-ui input">
                                    <input type="text" id="viwcpf_shop_loop_container" class=""
                                           name="viwcpf_setting[shop_loop_product]"
                                           value="<?php echo esc_attr( $viwcpf_setting_params['shop_loop_product'] ?? '.viwcpf-wrap-products' ); ?>"
                                    >
                                </div>
                                <label for="viwcpf_shop_loop_container"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Selector for tag that is holding the shop loop. Most of cases you won\'t need to change this.', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr class="option_select " data-select="viwcpf_using_ajax" data-type_show="true">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Shop pagination container', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="field">
                                <div class="vi-ui input">
                                    <input type="text" id="viwcpf_shop_pagination_container" class=""
                                           name="viwcpf_setting[shop_pagination_product]"
                                           value="<?php echo esc_attr( $viwcpf_setting_params['shop_pagination_product'] ?? '.woocommerce-pagination' ); ?>"
                                    >
                                </div>
                                <label for="viwcpf_shop_pagination_container"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Selector for tag that is holding the shop pagination. Most of cases you won\'t need to change this.', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr class="option_select " data-select="viwcpf_using_ajax" data-type_show="true">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Auto Hide modal', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox"
                                       class="viwcpf_hide_modal_after_ajax"
                                       name="viwcpf_setting[viwcpf_hide_modal_after_ajax]"
                                       id="viwcpf_hide_modal_after_ajax"
									<?php
									if ( isset( $viwcpf_setting_params['viwcpf_hide_modal_after_ajax'] ) ) {
										echo esc_attr( 'checked' );
									}
									?>
                                >
                                <label for="viwcpf_hide_modal_after_ajax"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Auto Hide modal after filter by ajax', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Hide product out-of-stock', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox"
                                       class="viwcpf_hide_out_of_stock"
                                       name="viwcpf_setting[hide_out_of_stock]"
                                       id="viwcpf_filter_hide_out_of_stock"
									<?php
									if ( isset( $viwcpf_setting_params['hide_out_of_stock'] ) ) {
										echo esc_attr( 'checked' );
									}
									?>
                                >
                                <label for="viwcpf_hide_out_of_stock"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( '"Filter by InStock" will be hidden with this option enabled', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Filter Modal', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox"
                                       class="viwcpf_modal"
                                       name="viwcpf_setting[modal][enabled]"
                                       id="viwcpf_filter_modal_enabled"
									<?php
									if ( isset( $viwcpf_setting_params['modal']['enabled'] ) ) {
										echo esc_attr( 'checked' );
									}
									?>
                                >
                                <label for="viwcpf_filter_modal_enabled"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Enable modal for filter', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr class="option_select " data-select="viwcpf_modal" data-type_show="true">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Modal auto open', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox"
                                       name="viwcpf_setting[modal][auto_open]"
									<?php if ( ! empty( $viwcpf_setting_params['modal']['auto_open'] ) ) {
										echo esc_attr( 'checked' );
									} ?>
                                >
                                <label for="show_active_labels"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Auto open filter modal after page load if this was opened before', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Show active filters', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox" class="show_active_labels"
                                       name="viwcpf_setting[show_active_labels]"
                                       id="show_active_labels"
									<?php if ( ! empty( $viwcpf_setting_params['show_active_labels'] ) ) {
										echo esc_attr( 'checked' );
									} ?>
                                >
                                <label for="show_active_labels"></label>
                            </div>
                            <span class="explanatory-text"><?php esc_html_e( 'Show active filters as labels', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr class="option_select hidden" data-select="show_active_labels" data-type_show="true">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Active filters labels position', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <select name="viwcpf_setting[active_position]"
                                    class="vi-ui dropdown  viwcpf_filter_block_select ">
                                <option value="<?php echo esc_attr( 'before_filters' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['active_position'] ) &&
										( $viwcpf_setting_params['active_position'] === 'before_filters' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Before filters (default)', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'after_filters' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['active_position'] ) &&
										( $viwcpf_setting_params['active_position'] === 'after_filters' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'After filters', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'before_products' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['active_position'] ) &&
										( $viwcpf_setting_params['active_position'] === 'before_products' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Above products list', 'pofily-woocommerce-product-filters' ) ?>
                                </option>

                            </select>
                            <span class="explanatory-text"><?php esc_html_e( 'Choose active filters labels position', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <!--Customize-->
            <div class="vi-ui bottom attached segment tab" data-tab="style">
                <h2><?php esc_html_e( 'Customize setting', 'pofily-woocommerce-product-filters' ) ?></h2>
                <table class="form-table option_select " data-select="viwcpf_modal" data-type_show="true">
                    <tbody>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Modal style', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui form">
                                <div class="five fields">
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'filter-offcanvas.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   class="viwcpf_modal_filter_style"
                                                   name="viwcpf_setting[modal][style]"
                                                   id="viwcpf_filter_style1"
                                                   value="off_canvas"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['style'] ) && $viwcpf_setting_params['modal']['style'] == 'off_canvas' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_style1"><?php esc_html_e( 'Off canvas', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'filter-top.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   class="viwcpf_modal_filter_style"
                                                   name="viwcpf_setting[modal][style]"
                                                   id="viwcpf_filter_style2"
                                                   value="top_product_loop"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['style'] ) && $viwcpf_setting_params['modal']['style'] == 'top_product_loop' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_style2"><?php esc_html_e( 'Top product loop', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <span class="explanatory-text"><?php esc_html_e( 'Choose modal style: Off-canvas or Top product loop', 'pofily-woocommerce-product-filters' ); ?></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Icon position', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui form">
                                <div class="six fields">
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'top-left.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   name="viwcpf_setting[modal][icon_position]"
                                                   id="viwcpf_filter_icon_position1"
                                                   value="top_left"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['icon_position'] ) && $viwcpf_setting_params['modal']['icon_position'] == 'top_left' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_icon_position1"><?php esc_html_e( 'Top left', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'bottom-left.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   name="viwcpf_setting[modal][icon_position]"
                                                   id="viwcpf_filter_icon_position2"
                                                   value="bottom_left"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['icon_position'] ) && $viwcpf_setting_params['modal']['icon_position'] == 'bottom_left' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_icon_position2"><?php esc_html_e( 'Bottom left', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'top-right.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   name="viwcpf_setting[modal][icon_position]"
                                                   id="viwcpf_filter_icon_position3"
                                                   value="top_right"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['icon_position'] ) && $viwcpf_setting_params['modal']['icon_position'] == 'top_right' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_icon_position3"><?php esc_html_e( 'Top right', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'bottom-right.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   name="viwcpf_setting[modal][icon_position]"
                                                   id="viwcpf_filter_icon_position4"
                                                   value="bottom_right"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['icon_position'] ) && $viwcpf_setting_params['modal']['icon_position'] == 'bottom_right' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_icon_position4"><?php esc_html_e( 'Bottom right', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field viwcpf_setting_filter_style">
                                        <img src="<?php echo esc_attr( VIWCPF_ADMIN_IMG_URL . 'top-product-loop.png' ); ?>">
                                        <div class="vi-ui toggle checkbox checked center aligned segment ">
                                            <input type="radio"
                                                   name="viwcpf_setting[modal][icon_position]"
                                                   id="viwcpf_filter_icon_position5"
                                                   value="top_product_loop"
												<?php
												if ( isset( $viwcpf_setting_params['modal']['icon_position'] ) && $viwcpf_setting_params['modal']['icon_position'] == 'top_product_loop' ) {
													echo esc_attr( 'checked' );
												}
												?>
                                            >
                                            <label for="viwcpf_filter_icon_position5"><?php esc_html_e( 'Top product loop', 'pofily-woocommerce-product-filters' ); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <span class="explanatory-text"><?php esc_html_e( 'Choose icon open modal position', 'pofily-woocommerce-product-filters' ); ?></span>
                            </div>


                        </td>
                    </tr>
                    <tr class="option_select hidden" data-select="viwcpf_modal_filter_style"
                        data-type_show="off_canvas">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Off canvas Position', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <select name="viwcpf_setting[off_canvas][general][position]"
                                    class="vi-ui dropdown  viwcpf_filter_block_select off_canvas_position">
                                <option value="<?php echo esc_attr( 'top_left' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['off_canvas']['general']['position'] ) &&
										( $viwcpf_setting_params['off_canvas']['general']['position'] === 'top_left' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Left', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'top_right' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['off_canvas']['general']['position'] ) &&
										( $viwcpf_setting_params['off_canvas']['general']['position'] === 'top_right' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Right', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr class="option_select hidden" data-select="viwcpf_modal_filter_style"
                        data-type_show="off_canvas">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Off canvas effect open', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <select name="viwcpf_setting[off_canvas][general][effect_open]"
                                    class="vi-ui dropdown viwcpf_filter_block_select ">
                                <option value="<?php echo esc_attr( 'slide' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['off_canvas']['general']['effect_open'] ) &&
										( $viwcpf_setting_params['off_canvas']['general']['effect_open'] === 'slide' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Slide', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'fade' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['off_canvas']['general']['effect_open'] ) &&
										( $viwcpf_setting_params['off_canvas']['general']['effect_open'] === 'fade' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Fade', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'zoom' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['off_canvas']['general']['effect_open'] ) &&
										( $viwcpf_setting_params['off_canvas']['general']['effect_open'] === 'zoom' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Zoom', 'pofily-woocommerce-product-filters' ) ?>
                                </option>

                            </select>
                        </td>
                    </tr>

                    <tr class="option_select hidden" data-select="viwcpf_modal_filter_style"
                        data-type_show="top_product_loop">
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Column layout', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <select name="viwcpf_setting[modal][top_loop][column]"
                                    class="vi-ui dropdown  viwcpf_filter_block_select ">
                                <option value="<?php echo esc_attr( '1' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['modal']['top_loop']['column'] ) &&
										( $viwcpf_setting_params['modal']['top_loop']['column'] === '1' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( '1', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( '2' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['modal']['top_loop']['column'] ) &&
										( $viwcpf_setting_params['modal']['top_loop']['column'] === '2' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( '2', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( '3' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['modal']['top_loop']['column'] ) &&
										( $viwcpf_setting_params['modal']['top_loop']['column'] === '3' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( '3', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( '4' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['modal']['top_loop']['column'] ) &&
										( $viwcpf_setting_params['modal']['top_loop']['column'] === '4' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( '4', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( '5' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['modal']['top_loop']['column'] ) &&
										( $viwcpf_setting_params['modal']['top_loop']['column'] === '5' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( '5', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Modal icon style', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui vertical segment">
								<?php
								preg_match( '!\d+!', $viwcpf_setting_params['modal']['icon']['horizontal'], $value_horizontal );
								preg_match( '!\d+!', $viwcpf_setting_params['modal']['icon']['vertical'], $value_vertical );
								if (
									! empty( $value_horizontal ) &&
									is_array( $value_horizontal )
								) {
									$horizontal_number            = $value_horizontal[0];
									$modal_icon_symbol_horizontal = str_replace( $horizontal_number, '', $viwcpf_setting_params['modal']['icon']['horizontal'] );
								} else {
									$horizontal_number            = 0;
									$modal_icon_symbol_horizontal = '%';
								}
								if (
									! empty( $value_vertical ) &&
									is_array( $value_vertical )
								) {
									$vertical_number            = $value_vertical[0];
									$modal_icon_symbol_vertical = str_replace( $vertical_number, '', $viwcpf_setting_params['modal']['icon']['vertical'] );
								} else {
									$vertical_number            = 0;
									$modal_icon_symbol_vertical = '%';
								}
								?>
                                <!--Default-->
                                <div class="vi-ui segment">

                                    <label class="vi-ui top attached label"> <?php esc_html_e( 'Default', 'pofily-woocommerce-product-filters' ) ?></label>

                                    <div class="vi-ui basic segment">
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field">
                                                <label><?php esc_html_e( 'Modal icon shadow', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui toggle checkbox">
                                                    <input type="checkbox"
                                                           id="viwcpf_modal_icon_shadown"
                                                           name="viwcpf_setting[modal][icon][box_shadow]" <?php if ( isset( $viwcpf_setting_params['modal']['icon']['box_shadow'] ) ) {
														echo esc_attr( 'checked' );
													} ?>>
                                                    <label for="viwcpf_modal_icon_shadown"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Border radius', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right labeled  input">
                                                    <input type="number" min="0" max="50" class=""
                                                           name="viwcpf_setting[modal][icon][icon_radius]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['icon_radius'] ) ?>">
                                                    <div class="vi-ui label viwcpf-right-input-label"><?php esc_html_e( 'Px', 'pofily-woocommerce-product-filters' ) ?></div>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_modal_icon">
                                                <label> <?php esc_html_e( 'Icon horizontal', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right labeled  input">
                                                    <input type="number"
                                                           placeholder="<?php esc_attr_e( 'Enter number horizontal', 'pofily-woocommerce-product-filters' ); ?>"
                                                           class="modal_number_value"
                                                           name=""
                                                           data-symbol="<?php echo esc_attr( $modal_icon_symbol_horizontal ) ?>"
                                                           value="<?php echo esc_attr( $horizontal_number ) ?>"
                                                    >
                                                    <div class="vi-ui dropdown label symbol">
                                                        <div class="text"><?php echo esc_attr( $modal_icon_symbol_horizontal ) ?></div>
                                                        <input type="hidden"
                                                               class="modal_icon_symbol_horizontal"
                                                               name="modal_icon_symbol_horizontal"
                                                               value="<?php echo esc_attr( $modal_icon_symbol_horizontal ) ?>"
                                                        >
                                                        <i class="dropdown icon"></i>
                                                        <div class="menu">
                                                            <div class="item"
                                                                 data-value="%"><?php echo esc_attr( '%' ) ?></div>
                                                            <div class="item"
                                                                 data-value="px"><?php echo esc_attr( 'px' ) ?></div>
                                                        </div>
                                                    </div>
                                                    <input type="hidden"
                                                           class="modal_hidden_value"
                                                           name="viwcpf_setting[modal][icon][horizontal]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['horizontal'] ) ?>"
                                                    >
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_modal_icon">
                                                <label> <?php esc_html_e( 'Icon vertical', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right labeled input">
                                                    <input type="number"
                                                           placeholder="<?php esc_attr_e( 'Enter number vertical', 'pofily-woocommerce-product-filters' ); ?>"
                                                           class="modal_number_value"
                                                           name=""
                                                           data-symbol="<?php echo esc_attr( $modal_icon_symbol_vertical ) ?>"
                                                           value="<?php echo esc_attr( $vertical_number ) ?>"
                                                    >
                                                    <div class="vi-ui dropdown label symbol">
                                                        <div class="text"><?php echo esc_attr( $modal_icon_symbol_vertical ) ?></div>
                                                        <input type="hidden"
                                                               class="off_canvas_icon_symbol_vertical"
                                                               name="off_canvas_icon_symbol_vertical"
                                                               value="<?php echo esc_attr( $modal_icon_symbol_vertical ); ?>"
                                                        >
                                                        <i class="dropdown icon"></i>
                                                        <div class="menu">
                                                            <div class="item"><?php echo esc_attr( '%' ) ?></div>
                                                            <div class="item"><?php echo esc_attr( 'px' ) ?></div>
                                                        </div>
                                                    </div>
                                                    <input type="hidden"
                                                           class="modal_hidden_value"
                                                           name="viwcpf_setting[modal][icon][vertical]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['vertical'] ); ?>"
                                                    >
                                                </div>
                                            </div>
                                        </div>
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Icon size', 'pofily-woocommerce-product-filters' ); ?></label>
                                                <div class="vi-ui right input">
                                                    <input type="number" min="1" step="0.01" class=""
                                                           name="viwcpf_setting[modal][icon][size]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['size'] ); ?>">
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Color', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon input">
                                                    <span class="color-picker"></span>
                                                    <input type="text" name="viwcpf_setting[modal][icon][color]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#ffffff"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['color'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Background', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon  input">
                                                    <span class="color-picker"></span>
                                                    <input type="text"
                                                           name="viwcpf_setting[modal][icon][background]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#212121"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['background'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--Hover-->
                                <div class="vi-ui segment">

                                    <label class="vi-ui top attached label"> <?php esc_html_e( 'Hover', 'pofily-woocommerce-product-filters' ) ?></label>

                                    <div class="vi-ui basic segment">
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Icon size', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right input">
                                                    <input type="number" min="1" step="0.01" class=""
                                                           name="viwcpf_setting[modal][icon][size_hover]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['size_hover'] ) ?>">
                                                </div>

                                            </div>
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Color', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon  input">
                                                    <span class="color-picker"></span>
                                                    <input type="text"
                                                           name="viwcpf_setting[modal][icon][color_hover]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#212121"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['color_hover'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field">
                                                <label> <?php esc_html_e( 'Background', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon  input">
                                                    <span class="color-picker"></span>
                                                    <input type="text"
                                                           name="viwcpf_setting[modal][icon][background_hover]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#e5e5e5"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['modal']['icon']['background_hover'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>

                    </tbody>
                </table>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Options style', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <select name="viwcpf_setting[option_style]"
                                    class="vi-ui dropdown  viwcpf_filter_block_select ">
                                <option value="<?php echo esc_attr( 'custom_style' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['option_style'] ) &&
										( $viwcpf_setting_params['option_style'] === 'custom_style' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Custom style', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'theme_style' ) ?>"
									<?php
									if (
										isset( $viwcpf_setting_params['option_style'] ) &&
										( $viwcpf_setting_params['option_style'] === 'theme_style' )
									) {
										echo esc_attr( 'selected' );
									}
									?>
                                >
									<?php esc_html_e( 'Theme style', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Filters area colors', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="equal width fields">
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Titles', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui icon fluid input">
                                        <span class="color-picker"></span>
                                        <input type="text" name="viwcpf_setting[area][color][title]" class="color-text"
                                               placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                               data-default-color="#333333"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['area']['color']['title'] ) ?>">
                                        <i class="undo link icon reset_color"></i>
                                    </div>
                                </div>
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Background', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui icon fluid input">
                                        <span class="color-picker"></span>
                                        <input type="text" name="viwcpf_setting[area][color][background]"
                                               class="color-text"
                                               placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                               data-default-color="#333333"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['area']['color']['background'] ) ?>">
                                        <i class="undo link icon reset_color"></i>
                                    </div>
                                </div>
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Accent color', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui icon fluid input">
                                        <span class="color-picker"></span>
                                        <input type="text" name="viwcpf_setting[area][color][accent]" class="color-text"
                                               placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                               data-default-color="#333333"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['area']['color']['accent'] ) ?>">
                                        <i class="undo link icon reset_color"></i>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Color swatches/Image button default size', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="equal width fields">
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Width', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui right labeled fluid input">
                                        <input type="number"
                                               name="viwcpf_setting[color_swatches][btn_style][btn_width]"
                                               id="default-btn_width"
                                               placeholder="<?php esc_attr_e( 'Enter Width', 'pofily-woocommerce-product-filters' ); ?>"
                                               min="0"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['color_swatches']['btn_style']['btn_width'] ); ?>"
                                        >
                                        <div class="vi-ui basic label"><?php esc_html_e( 'px', 'pofily-woocommerce-product-filters' ) ?></div>
                                    </div>
                                </div>
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Height', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui right labeled fluid input">
                                        <input type="number"
                                               name="viwcpf_setting[color_swatches][btn_style][btn_height]"
                                               id="default-btn_height"
                                               placeholder="<?php esc_attr_e( 'Enter Height', 'pofily-woocommerce-product-filters' ); ?>"
                                               min="0"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['color_swatches']['btn_style']['btn_height'] ); ?>"
                                        >
                                        <div class="vi-ui basic label"><?php esc_html_e( 'px', 'pofily-woocommerce-product-filters' ) ?></div>
                                    </div>
                                </div>
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Border radius', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui right fluid input">
                                        <input type="text"
                                               name="viwcpf_setting[color_swatches][btn_style][btn_border_radius]"
                                               id="default-btn_border_radius"
                                               placeholder="<?php esc_attr_e( 'Enter Border Radius', 'pofily-woocommerce-product-filters' ); ?>"
                                               min="0"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['color_swatches']['btn_style']['btn_border_radius'] ); ?>"
                                        >
                                    </div>
                                </div>
                                <div class="field choose_color setting_color_field">
                                    <label> <?php esc_html_e( 'Color separator', 'pofily-woocommerce-product-filters' ) ?></label>
                                    <div class="vi-ui right fluid input">
                                        <select class="vi-ui dropdown  "
                                                name="viwcpf_setting[color_swatches][btn_style][btn_color_separator]"
                                                id="default-color_separator"
                                        >
                                            <option value="1"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '1' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Basic horizontal', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="2"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '2' ) {
													echo esc_attr( 'selected' );
												}
												?>>
												<?php esc_html_e( 'Basic vertical', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="3"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '3' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Basic diagonal left', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="4"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '4' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Basic diagonal right', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="5"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '5' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Hard lines horizontal', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="6"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '6' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Hard lines vertical', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="7"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '7' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Hard lines diagonal left', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                            <option value="8"
												<?php
												if ( $viwcpf_setting_params['color_swatches']['btn_style']['btn_color_separator'] == '8' ) {
													echo esc_attr( 'selected' );
												}
												?>
                                            >
												<?php esc_html_e( 'Hard lines diagonal right', 'pofily-woocommerce-product-filters' ) ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Color swatches default color', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="equal width fields">
                                <div class="field choose_color setting_color_field">
                                    <div class="vi-ui icon fluid input">
                                        <span class="color-picker"></span>
                                        <input type="text" name="viwcpf_setting[color_swatches][color_default]"
                                               class="color-text"
                                               placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                               data-default-color="#fe2740"
                                               value="<?php echo esc_attr( $viwcpf_setting_params['color_swatches']['color_default'] ) ?>">
                                        <i class="undo link icon reset_color"></i>
                                    </div>
                                </div>

                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Label styles', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui vertical segment">
                                <!--Default-->
                                <div class="vi-ui segment">
									<?php
									preg_match( '!\d+!', $viwcpf_setting_params['label']['size']['font_size'], $value_label_font_size );

									if (
										! empty( $value_label_font_size ) &&
										is_array( $value_label_font_size )
									) {
										$value_label_font_size_number = $value_label_font_size[0];
										$value_label_font_size_symbol = str_replace( $value_label_font_size_number, '', $viwcpf_setting_params['label']['size']['font_size'] );
									} else {
										$value_label_font_size_number = $viwcpf_setting_params_default['label']['size']['font_size'];
										$value_label_font_size_symbol = 'px';
									}

									?>
                                    <label class="vi-ui top attached label"> <?php esc_html_e( 'Default', 'pofily-woocommerce-product-filters' ) ?></label>

                                    <div class="vi-ui basic segment">
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Font size', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right labeled fluid input">
                                                    <input type="number" min="0" class="label_number_value"
                                                           data-symbol="<?php echo esc_attr( $value_label_font_size_symbol ) ?>"
                                                           name=""
                                                           value="<?php echo esc_attr( $value_label_font_size_number ) ?>">
                                                    <div class="vi-ui label viwcpf-right-input-label"><?php esc_html_e( 'Px', 'pofily-woocommerce-product-filters' ) ?></div>
                                                    <input type="hidden"
                                                           class="label_hidden_value"
                                                           name="viwcpf_setting[label][size][font_size]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['size']['font_size'] ) ?>">
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Border width', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right labeled fluid input">
                                                    <input type="number" min="0" class=""
                                                           name="viwcpf_setting[label][size][border_width]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['size']['border_width'] ) ?>">
                                                    <div class="vi-ui label viwcpf-right-input-label"><?php esc_html_e( 'Px', 'pofily-woocommerce-product-filters' ) ?></div>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Border radius', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui right labeled fluid input">
                                                    <input type="number" min="0" class=""
                                                           name="viwcpf_setting[label][size][border_radius]"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['size']['border_radius'] ) ?>"">
                                                    <div class="vi-ui label viwcpf-right-input-label"><?php esc_html_e( 'Px', 'pofily-woocommerce-product-filters' ) ?></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Background', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon fluid input">
                                                    <span class="color-picker"></span>
                                                    <input type="text" name="viwcpf_setting[label][color][background]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#333333"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['color']['background'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Text', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon fluid input">
                                                    <span class="color-picker"></span>
                                                    <input type="text" name="viwcpf_setting[label][color][text]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#333333"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['color']['text'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--Hover-->
                                <div class="vi-ui segment">

                                    <label class="vi-ui top attached label"> <?php esc_html_e( 'Hover', 'pofily-woocommerce-product-filters' ) ?></label>

                                    <div class="vi-ui basic segment">
                                        <div class="equal width fields">

                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Background', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon fluid input">
                                                    <span class="color-picker"></span>
                                                    <input type="text"
                                                           name="viwcpf_setting[label][color][background_hover]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#333333"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['color']['background_hover'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Text', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon fluid input">
                                                    <span class="color-picker"></span>
                                                    <input type="text" name="viwcpf_setting[label][color][text_hover]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#333333"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['color']['text_hover'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--Active-->
                                <div class="vi-ui segment">
                                    <label class="vi-ui top attached label"> <?php esc_html_e( 'Active', 'pofily-woocommerce-product-filters' ) ?></label>

                                    <div class="vi-ui basic segment">
                                        <div class="equal width fields">
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Background active', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon fluid input">
                                                    <span class="color-picker"></span>
                                                    <input type="text"
                                                           name="viwcpf_setting[label][color][background_active]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#333333"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['color']['background_active'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                            <div class="field choose_color setting_color_field setting_label_styles">
                                                <label> <?php esc_html_e( 'Text active', 'pofily-woocommerce-product-filters' ) ?></label>
                                                <div class="vi-ui icon fluid input">
                                                    <span class="color-picker"></span>
                                                    <input type="text" name="viwcpf_setting[label][color][text_active]"
                                                           class="color-text"
                                                           placeholder="<?php esc_attr_e( 'Choose color', 'pofily-woocommerce-product-filters' ); ?>"
                                                           data-default-color="#333333"
                                                           value="<?php echo esc_attr( $viwcpf_setting_params['label']['color']['text_active'] ) ?>">
                                                    <i class="undo link icon reset_color"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <!--Metadata-->
            <div class="vi-ui bottom attached segment tab " data-tab="metadata">
                <h2><?php esc_html_e( 'Metadata setting', 'pofily-woocommerce-product-filters' ) ?></h2>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Display metakey', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="equal width fields choose_display_metakey">
                                <div class="field ">
									<?php
									$array_metakey = $this->generate_product_meta_keys( [ 'product', 'product_variation' ] );
									if ( sizeof( $array_metakey ) > 0 ):
										?>
                                        <select name="viwcpf_setting[display_metakey][]" id="viwcpf_display_metakey"
                                                class="viwcpf_filter_block_select" multiple="multiple">
											<?php
											foreach ( $array_metakey as $value_item ):
												if (
													isset( $viwcpf_setting_params['display_metakey'] ) &&
													in_array( $value_item, $viwcpf_setting_params['display_metakey'] )
												) {
													$selected = 'selected';
												} else {
													$selected = '';
												}
												echo '<option value="' . esc_attr( $value_item ) . '" ' . esc_attr( $selected ) . '>' . esc_html( $value_item ) . '</option>';
											endforeach;
											?>
                                        </select>
                                        <label for="viwcpf_display_metakey"></label>
									<?php
									endif;
									?>
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <h3><?php esc_html_e( 'WooCommerce popular metakey:', 'pofily-woocommerce-product-filters' ) ?></h3>
                <table class="vi-ui celled table viwcpf-notes-table">
                    <tbody>
                    <tr>
                        <td class="vi-ui center aligned header">_price</td>
                        <td><?php esc_html_e( 'filter by Product price (Custom Field Num)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_stock_status</td>
                        <td><?php esc_html_e( 'filter by Product Stock status (Custom Field)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_sale_price</td>
                        <td><?php esc_html_e( 'by Sale Price (Custom Field Num) or on Sale Status (Custom Field Exists)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">total_sales</td>
                        <td><?php esc_html_e( 'by Sales Count', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_backorders</td>
                        <td><?php esc_html_e( 'by Backorders Status (Custom Field)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_downloadable</td>
                        <td><?php esc_html_e( 'by Downloadable Status (Custom Field)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_sold_individually</td>
                        <td><?php esc_html_e( 'by Sold Individually status (Custom Field)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_stock</td>
                        <td><?php esc_html_e( 'by Stock Quantity (Custom Field Num)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_virtual</td>
                        <td><?php esc_html_e( 'by Product Virtual status (Custom Field)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_length</td>
                        <td><?php esc_html_e( 'by product Length', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_width</td>
                        <td><?php esc_html_e( 'by product Width', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_height</td>
                        <td><?php esc_html_e( 'by product Height', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">_weight</td>
                        <td><?php esc_html_e( 'by product Weight', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    <tr>
                        <td class="vi-ui center aligned header">attribute_{custom-attribute-slug}</td>
                        <td><?php esc_html_e( 'by custom attribute (For product variable)', 'pofily-woocommerce-product-filters' ) ?></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <!--SEO rule-->
            <div class="vi-ui bottom attached segment tab " data-tab="seo-rule">
                <h2><?php esc_html_e( 'SEO rule', 'pofily-woocommerce-product-filters' ) ?></h2>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Enable', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox"
                                       class="viwcpf_seo_rule"
                                       name="viwcpf_setting[seo_rule]"
                                       id="viwcpf_seo_rule"
									<?php
									if ( isset( $viwcpf_setting_params['seo_rule'] ) ) {
										echo esc_attr( 'checked' );
									}
									?>
                                >
                                <label for="viwcpf_seo_rule"></label>

                                <span class="explanatory-text"><?php esc_html_e( 'Enable SEO rule', 'pofily-woocommerce-product-filters' ); ?></span>
                            </div>
                        </td>

                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'SEO Title', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>

                            <div class="field">
                                <div class="vi-ui input">
                                    <input type="text" id="viwcpf_seo_title" class=""
                                           name="viwcpf_setting[seo_title]"
                                           value="<?php echo esc_attr( isset( $viwcpf_setting_params['seo_title'] ) ? $viwcpf_setting_params['seo_title'] : '' ); ?>"
                                    >
                                </div>
                                <label for="viwcpf_seo_title"></label>
                            </div>

                            <span class="explanatory-text"><?php esc_html_e( 'Appears between <title> and </title>', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{archive_title}</strong> - <?php esc_html_e( 'Archive page title', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{site_title}</strong> - <?php esc_html_e( 'Site title', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{page_number}</strong> - <?php esc_html_e( 'Page number', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{filter_value}</strong> - <?php esc_html_e( 'Filter value', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'Meta Description', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="field">
                                <div class="vi-ui input">
                                    <input type="text" id="viwcpf_seo_description" class=""
                                           name="viwcpf_setting[seo_description]"
                                           value="<?php echo esc_attr( isset( $viwcpf_setting_params['seo_description'] ) ? $viwcpf_setting_params['seo_description'] : '' ); ?>"
                                    >
                                </div>
                                <label for="viwcpf_seo_description"></label>
                            </div>

                            <span class="explanatory-text"><?php esc_html_e( 'Appears between <meta name="description"> and </meta>', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{archive_title}</strong> - <?php esc_html_e( 'Archive page title', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{site_title}</strong> - <?php esc_html_e( 'Site title', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{page_number}</strong> - <?php esc_html_e( 'Page number', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{filter_value}</strong> - <?php esc_html_e( 'Filter value', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="viwcpf_table_th">
								<?php esc_html_e( 'SEO H1 Title', 'pofily-woocommerce-product-filters' ) ?>
                            </div>
                        </th>
                        <td>
                            <div class="field">
                                <div class="vi-ui input">
                                    <input type="text" id="viwcpf_seo_h1_title" class=""
                                           name="viwcpf_setting[seo_h1]"
                                           value="<?php echo esc_attr( isset( $viwcpf_setting_params['seo_h1'] ) ? $viwcpf_setting_params['seo_h1'] : '' ); ?>"
                                    >
                                </div>
                                <label for="viwcpf_seo_h1_title"></label>
                            </div>

                            <span class="explanatory-text"><?php esc_html_e( 'Appears between <h1> and </h1>', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{archive_title}</strong> - <?php esc_html_e( 'Archive page title', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{site_title}</strong> - <?php esc_html_e( 'Site title', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{page_number}</strong> - <?php esc_html_e( 'Page number', 'pofily-woocommerce-product-filters' ); ?></span>
                            <span class="explanatory-text"><strong>{filter_value}</strong> - <?php esc_html_e( 'Filter value', 'pofily-woocommerce-product-filters' ); ?></span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <!--Update-->
            <div class="vi-ui tab attached bottom segment" data-tab="update">
                <table class="optiontable form-table">
                    <tr align="top">
                        <th scope="row"><?php esc_html_e( 'Auto Update Key', 'pofily-woocommerce-product-filters' ) ?></th>
                        <td>
                            <div class="fields">
                                <div class="ten wide field">
                                    <input type="text" name="viwcpf_setting[key]"
                                           id="auto-update-key"
                                           class="villatheme-autoupdate-key-field"
                                           value="<?php echo esc_attr( $viwcpf_setting_params['key'] ); ?>">
                                </div>
                                <div class="six wide field">
                                        <span class="vi-ui button green villatheme-get-key-button"
                                              data-href="https://api.envato.com/authorization?response_type=code&client_id=villatheme-download-keys-6wzzaeue&redirect_uri=https://villatheme.com/update-key"
                                              data-id="34743510"><?php echo esc_html__( 'Get Key', 'pofily-woocommerce-product-filters' ) ?></span>
                                </div>
                            </div>
							<?php do_action( 'pofily-woocommerce-product-filters_key' ) ?>
                            <p class="description"><?php echo wp_kses_post( 'Please fill your key what you get from <a target="_blank" href="https://villatheme.com/my-download">Villatheme</a>. You can automatically update Pofily WooCommerce Product Filters plugin. See guide <a target="_blank" href="https://villatheme.com/knowledge-base/how-to-use-auto-update-feature/">here</a>' ) ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            <p class="<?php echo esc_attr( 'save-settings-container' ); ?>">
                <button type="submit"
                        class="vi-ui button icon left labeled primary save-settings"
                        name="viwcpf-save-settings"
                >
                    <i class="save icon"></i><?php esc_html_e( 'Save Settings', 'pofily-woocommerce-product-filters' ) ?>
                </button>
                <button type="submit" class="vi-ui button labeled icon"
                        name="viwcpf-check_key"><i
                            class="icon save"></i><?php esc_html_e( 'Save & Check Key', 'pofily-woocommerce-product-filters' ); ?>
                </button>
                <button type="submit"
                        class="vi-ui red button icon left labeled reset-default"
                        name="viwcpf-reset-default"
                >
                    <i class="history icon"></i><?php esc_html_e( 'Reset Default', 'pofily-woocommerce-product-filters' ) ?>
                </button>
            </p>
        </form>
		<?php do_action( 'villatheme_support_pofily-woocommerce-product-filters' ); ?>
    </div>
<?php

