<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Exit if accessed directly
/*
 * Class compatible with multi currency by villatheme
 * */

if ( ! class_exists( 'VIWCPF_plugin_multi_currency' ) ) {

	class VIWCPF_plugin_multi_currency {
		protected $settings;
		protected $convert;

		public function __construct() {
			add_action( 'init', array( $this, 'viwcpf_compa_multi_currency_init' ) );

		}

		public function viwcpf_compa_multi_currency_init() {
			if ( is_plugin_active( 'woocommerce-multi-currency/woocommerce-multi-currency.php' ) || is_plugin_active( 'woo-multi-currency/woo-multi-currency.php' ) ) {
				if ( class_exists( 'WOOMULTI_CURRENCY_Data' ) ) {
					$this->settings = WOOMULTI_CURRENCY_Data::get_ins();
					if ( $this->settings->get_enable() ) {
						add_filter( 'viwcpf_localize_args', array(
							$this,
							'add_new_args_localize_compatible'
						), 50, 2 );
					}
				} else if ( class_exists( 'WOOMULTI_CURRENCY_F_Data' ) ) {
					$this->settings = WOOMULTI_CURRENCY_F_Data::get_ins();
					if ( $this->settings->get_enable() ) {
						add_filter( 'viwcpf_localize_args', array(
							$this,
							'add_new_args_localize_compatible'
						), 50, 2 );
					}

				}


			}
		}

		public function add_new_args_localize_compatible( $args ) {
			if ( ! empty( $args ) ) {
				$list_rates = $this->settings->get_list_currencies();
				if ( ! empty( $list_rates ) ) {
					$args['vmc_list_rates'] = $list_rates;

					foreach ( $list_rates as $c_key => $c_value ) {
						$args['vmc_list_symbol'][ $c_key ] = get_woocommerce_currency_symbol( $c_key );

					}
				}
			}

			return $args;
		}
	}

	new VIWCPF_plugin_multi_currency();
}
