<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! class_exists( 'VIWCPF_SEO_RULE' ) ) {
	class VIWCPF_SEO_RULE {
		private $vars;
		private $data;

		public function __construct() {
			$this->data = new VIWCPF_Woocommerce_Product_Filters_Data();

			if ( $this->data->get_params( 'seo_rule' ) ) {

//				$this->set( 'filterRequest', get_query_var( 'viwcpfFilterRequest' ) );
				$this->set( 'allowedFilterPage', '' );

				if ( ! empty( $this->data->get_params( 'seo_title' ) ) ) {
					$this->set( 'seoTitle', $this->data->get_params( 'seo_title' ) );
				}
				if ( ! empty( $this->data->get_params( 'seo_description' ) ) ) {
					$this->set( 'seoDescription', $this->data->get_params( 'seo_description' ) );
				}
				if ( ! empty( $this->data->get_params( 'seo_h1' ) ) ) {
					$this->set( 'seoH1', $this->data->get_params( 'seo_h1' ) );
				}

			}
		}

		/**
		 * Fires only on isFilter pages
		 */
		public function registerHooks() {

			remove_all_filters( 'wp_robots' );

			add_action( 'init', array( $this, 'viwcpf_rewrite_tag_rule' ), 9999, 0 );
			add_action( 'pre_get_posts', array( $this, 'viwcpf_setFilterRequest' ), 1 );
			add_filter( 'query_vars', array( $this, 'viwcpf_seo_add_query_vars' ), 99999 );

			add_action( 'wp_head', array( $this, 'filtersWpHead' ), 2 );
			// Filter the title for compatibility with other plugins and themes.
			add_filter( 'wp_title', array( $this, 'wpTitle' ), 15 );

			remove_action( 'wp_head', 'rel_canonical' );
			remove_action( 'wp_head', 'index_rel_link' );
			remove_action( 'wp_head', 'start_post_rel_link' );
			remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head' );
			remove_action( 'wp_head', 'noindex', 1 );
			remove_action( 'wp_head', '_wp_render_title_tag', 1 );
			remove_action( 'wp_head', 'gutenberg_render_title_tag', 1 );

		}

		public function filtersWpHead() {

			$this->title();
			$this->description();

			// Add related filters
			$this->h1();
			$this->seoText();
		}

		public function isFilterSeo() {
			$permalink_structure = get_option( 'permalink_structure', false );


			if ( $this->data->get_params( 'seo_rule' ) && $permalink_structure && $permalink_structure == '/%postname%/' ) {
				return true;
			}

			return false;
		}

		public function title() {
			if ( ! $this->get( 'seoTitleDisplayed' ) ) {
				$seoTitle = $this->get( 'seoTitle' ) ? $this->get( 'seoTitle' ) : wp_get_document_title();
				$seoTitle = apply_filters( 'viwcpf_seo_title', $this->viwcpf_replaceSeoVariable( $seoTitle ) );
				echo sprintf( '<title>%s</title>', esc_html( $seoTitle ) ) . "\r\n";
			}
		}

		public function description() {
			$description = $this->get( 'seoDescription' );
			$description = apply_filters( 'viwcpf_seo_description', $this->viwcpf_replaceSeoVariable( $description ) );
			if ( $description ) {
				echo sprintf( '<meta name="description" content="%s" />', esc_attr( $description ) ) . "\r\n";
			}

		}

		public function h1() {
			if ( is_product_taxonomy() || is_post_type_archive( 'product' ) ) {
				add_filter( 'woocommerce_page_title', array( $this, 'seoH1' ) );
				add_filter( 'get_the_archive_title', array( $this, 'seoH1' ) );
				add_filter( 'avada_page_title_bar_contents', [ $this, 'seoH1' ] );

				/*todo maybe remove it from get_the_archive_title to avoid duplicates*/
				add_filter( 'post_type_archive_title', [ $this, 'seoH1' ] );
			}

		}

		public function seoH1( $h1, $post_id = 0 ) {
			if ( $filtersH1 = $this->get( 'seoH1' ) ) {

				// For archives
				if ( is_array( $h1 ) ) {
					// Avada title
					$h1[0] = apply_filters( 'viwcpf_seo_h1', esc_html( $this->viwcpf_replaceSeoVariable( $filtersH1 ) ) );

					return $h1;
				} else {
					return apply_filters( 'viwcpf_seo_h1', esc_html( $this->viwcpf_replaceSeoVariable( $filtersH1 ) ) );
				}
			}

			return apply_filters( 'viwcpf_seo_h1', $h1 );
		}

		public function wpTitle( $wp_title ) {
			if ( $seoTitle = $this->get( 'seoTitle' ) ) {
				$this->set( 'seoTitleDisplayed', true );

				return esc_html( $seoTitle );
			}

			return $wp_title;
		}

		public function seoText() {
			if ( class_exists( 'WooCommerce' ) ) {
				add_filter( 'woocommerce_after_shop_loop', array( $this, 'showSeoDescription' ), 5 );
			}
		}

		public function showSeoDescription() {
			if ( $seoText = $this->get( 'seoDescription' ) ) {
				$seoText = apply_filters( 'the_content', wp_kses_post( $seoText ) );
				$seoText = apply_filters( 'viwcpf_seo_text', $seoText );
				echo sprintf( '<div class="viwcpf-page-seo-description">%s</div>', wp_kses_post( $this->viwcpf_replaceSeoVariable( $seoText ) ) ) . "\r\n";
			}
		}

		public function viwcpf_replaceSeoVariable( $content ) {
			global $paged;
			$replace = $content;

			// Site title
			$replace = str_replace( '{site_title}', get_option( 'blogname' ), $replace );
            //archive title
			$replace = str_replace( '{archive_title}', get_the_title(), $replace );

			// Page num
			$pagedReplace = $paged ? sprintf( esc_html( 'page %d' ), $paged ) : '';
			$replace      = str_replace( '{page_number}', $pagedReplace, $replace );

			$arr_filter_value = $this->viwcpf_render_arr_FilterRequest( $this->get( 'filterRequest' ) );
			$string_term_val  = '';
			if ( ! empty( $arr_filter_value ) ) {
				foreach ( $arr_filter_value as $filter_value ) {
					$arr_item_value = $filter_value['value'] ?? [];
					if ( ! empty( $arr_item_value ) && is_array( $arr_item_value ) ) {
						foreach ( $arr_item_value as $item_value ) {
							$string_term_val .= $item_value . ' ';
						}
					}
				}


			}
			$replace = str_replace( '{filter_value}', $string_term_val, $replace );
			// Remove any other {variables} from SEO data.
			$replace = preg_replace( '/\/{[a-zA-Z0-9_\W]+?\/}/m', '', $replace );

			return trim( $replace );
		}

		public function viwcpf_rewrite_tag_rule() {

			$permalink_structure = get_option( 'permalink_structure', false );

			if ( $permalink_structure && $permalink_structure == '/%postname%/' ) {
				flush_rewrite_rules();
				$aUrl                  = get_permalink( wc_get_page_id( 'shop' ) );
				$shopSlug              = basename( $aUrl );
				$woocommerce_permalink = get_option( 'woocommerce_permalinks', array() );
				if ( ! empty( $woocommerce_permalink['category_base'] ) && ! empty( $woocommerce_permalink['tag_base'] ) ) {

					add_rewrite_rule( $woocommerce_permalink['category_base'] . '/(.+?)/(.+?)(?:/([0-9]+))?/?$', 'index.php?product_cat=$matches[1]&viwcpfFilterRequest=$matches[2]', 'top' );
					add_rewrite_rule( $woocommerce_permalink['tag_base'] . '/(.+?)/(.+?)(?:/([0-9]+))?/?$', 'index.php?product_cat=$matches[1]&viwcpfFilterRequest=$matches[2]', 'top' );

				}

//				add_rewrite_rule(  '/page/([0-9]{1,})/?$', 'index.php?post_type=product&page_number=$matches[1]', 'top' );
				add_rewrite_rule( $shopSlug . '/(.+?)?/?$', 'index.php?post_type=product&viwcpfFilterRequest=$matches[1]', 'top' );
//				add_rewrite_rule( $pattern, 'index.php?post_type=product&viwcpfFilterRequest=$matches[1]&paged=$matches[2]', 'top' );
				flush_rewrite_rules();


			}


		}

		public function viwcpf_setFilterRequest( $query ) {
			if (
				( is_product_taxonomy() || is_post_type_archive( 'product' ) ) &&
				$query->is_main_query()
			) {
				$this->set( 'filterRequest', get_query_var( 'viwcpfFilterRequest' ) );
			}
		}

		/*
		 * Render request filter
		 * */
		public function viwcpf_render_arr_FilterRequest( $filterRequest ) {
			$arr_filterRequest = [];
			global $wp_rewrite;
			if ( ! empty( $filterRequest ) ) {

				$arr_Request = explode( '/', $filterRequest );


				$cat_slug               = apply_filters( 'VIWCPF_seo_product_cat_slug', 'product_cat' );
				$tag_slug               = apply_filters( 'VIWCPF_seo_product_tag_slug', 'product_tag' );
				$min_price_slug         = apply_filters( 'VIWCPF_seo_product_min_price_slug', 'minprice' );
				$max_price_slug         = apply_filters( 'VIWCPF_seo_product_max_price_slug', 'maxprice' );
				$onsale_slug            = apply_filters( 'VIWCPF_seo_product_onsale_slug', 'isOnsale' );
				$instock_slug           = apply_filters( 'VIWCPF_seo_product_instock_slug', 'isInstock' );
				$review_slug            = apply_filters( 'VIWCPF_seo_product_review_slug', 'rating' );
				$search_slug            = apply_filters( 'VIWCPF_seo_product_review_slug', 'textsearch' );
				$arr_filter_single_slug = [ 'isOnsale', 'isInstock' ];
				$page_slug              = $wp_rewrite->pagination_base;
				foreach ( $arr_Request as $key => $val ) {
					$new_val = explode( '-', $val );

					if ( $val == $page_slug ) {
						$page_numb = $arr_Request[ $key + 1 ] ?? 1;

						$arr_filterRequest['paged'] = absint( $page_numb );
						unset( $arr_Request[ $key + 1 ] );
					}
					if ( count( $new_val ) > 1 ) {
						$filter_slug = $new_val[0];
						switch ( $filter_slug ) {
							case $cat_slug:
								$val_filter = mb_substr( str_replace( $cat_slug, '', $val ), 1 );
								/*
								 * Check query type "and" or "or"
								 * use "---" is "and"
								 * use "--" is "or"
								 * */
								$arr_val_filter = explode( '---', $val_filter );
								if ( count( $arr_val_filter ) > 1 ) {
									$arr_filterRequest['product_cat']['type'] = 'and';
								} else {
									$arr_val_filter = explode( '--', $arr_val_filter[0] );
									if ( count( $arr_val_filter ) > 1 ) {
										$arr_filterRequest['product_cat']['type'] = 'or';
									}
								}
								$arr_filterRequest['product_cat']['value'] = $arr_val_filter;
								break;
							case $tag_slug:
								$val_filter = mb_substr( str_replace( $tag_slug, '', $val ), 1 );
								/*
								 * Check query type "and" or "or"
								 * use "---" is "and"
								 * use "--" is "or"
								 * */
								$arr_val_filter = explode( '---', $val_filter );
								if ( count( $arr_val_filter ) > 1 ) {
									$arr_filterRequest['product_tag']['type'] = 'and';
								} else {
									$arr_val_filter = explode( '--', $arr_val_filter[0] );
									if ( count( $arr_val_filter ) > 1 ) {
										$arr_filterRequest['product_tag']['type'] = 'or';
									}
								}
								$arr_filterRequest['product_tag']['value'] = $arr_val_filter;
								break;
							case $min_price_slug:
								$val_filter                              = mb_substr( str_replace( $min_price_slug, '', $val ), 1 );
								$arr_filterRequest['min_price']['value'] = [ $val_filter ];
								break;
							case $max_price_slug:
								$val_filter                              = mb_substr( str_replace( $max_price_slug, '', $val ), 1 );
								$arr_filterRequest['max_price']['value'] = [ $val_filter ];
								break;
							case $onsale_slug:
								$arr_filterRequest[ $onsale_slug ]['value'] = true;
								break;
							case $instock_slug:
								$arr_filterRequest[ $instock_slug ]['value'] = true;
								break;
							case $review_slug:
								$val_filter                                  = mb_substr( str_replace( $review_slug, '', $val ), 1 );
								$arr_filterRequest['rating_filter']['value'] = [ $val_filter ];
								break;
							case $search_slug:
								$val_filter                      = mb_substr( str_replace( $search_slug, '', $val ), 1 );
								$arr_filterRequest['s']['value'] = [ urlencode( $val_filter ) ];
								break;
							default :
								$val_filter     = mb_substr( str_replace( $filter_slug, '', $val ), 1 );
								$arr_val_filter = explode( '---', $val_filter );
								if ( count( $arr_val_filter ) > 1 ) {
									$arr_filterRequest[ 'filter_' . $filter_slug ]['type'] = 'and';
								} else {
									$arr_val_filter = explode( '--', $arr_val_filter[0] );
									if ( count( $arr_val_filter ) > 1 ) {
										$arr_filterRequest[ 'filter_' . $filter_slug ]['type'] = 'or';
									}
								}
								$arr_filterRequest[ 'filter_' . $filter_slug ]['value'] = $arr_val_filter;
								break;
						}
					} else {
						if ( in_array( $val, $arr_filter_single_slug ) ) {

							switch ( $val ) {
								case $onsale_slug:
									$arr_filterRequest[ $onsale_slug ]['value'] = true;
									break;
								case $instock_slug:
									$arr_filterRequest[ $instock_slug ]['value'] = true;
									break;
								default :
									break;
							}
						}
					}
				}

			}

			return $arr_filterRequest;
		}

		function viwcpf_seo_add_query_vars( $query_vars ) {
			$query_vars[] = 'viwcpfFilterRequest';

			return $query_vars;
		}

		public function get( $key ) {
			if ( isset( $this->vars[ $key ] ) ) {
				return $this->vars[ $key ];
			}

			return false;
		}

		public function set( $key, $value ) {
			if ( ! isset( $this->vars[ $key ] ) ) {
				$this->vars[ $key ] = $value;
			}

			return true;
		}
	}
}