<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @since      1.0.0
 *
 * @package    Woocommerce_Product_Filters
 * @subpackage Woocommerce_Product_Filters/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Woocommerce_Product_Filters
 * @subpackage Woocommerce_Product_Filters/public
 * @author     Villatheme
 */
class VIWCPF_Woocommerce_Product_Filters_Public {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $viwcpf_woocommerce_product_filters The ID of this plugin.
     */
    private $viwcpf_woocommerce_product_filters;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;
    private $data;
    private $seoFrontend;


    /**
     * Initialize the class and set its properties.
     *
     * @param string $viwcpf_woocommerce_product_filters The name of the plugin.
     * @param string $version The version of this plugin.
     *
     * @since    1.0.0
     */
    public function __construct( $viwcpf_woocommerce_product_filters, $version ) {

        $this->viwcpf_woocommerce_product_filters = $viwcpf_woocommerce_product_filters;
        $this->version                            = $version;
        $this->data                               = new VIWCPF_Woocommerce_Product_Filters_Data();
        $this->seoFrontend                        = new VIWCPF_SEO_RULE();
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles() {
        if ( ! is_shop() && ! is_product_taxonomy() ) {
            return;
        }
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Woocommerce_Product_Filters_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Woocommerce_Product_Filters_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        //		wp_enqueue_style( $this->viwcpf_woocommerce_product_filters . '-select2', VIWCPF_DIR_URL . 'assets/css/select2.min.css', array(), $this->version, 'all' );
        wp_enqueue_style( $this->viwcpf_woocommerce_product_filters . '-vi_dropdown', VIWCPF_DIR_URL . 'assets/css/vi_dropdown.css', array(), $this->version, 'all' );
        wp_enqueue_style( $this->viwcpf_woocommerce_product_filters . '-rangeSlide', VIWCPF_DIR_URL . 'assets/css/ion.rangeSlider.min.css', array(), $this->version, 'all' );
        wp_enqueue_style( $this->viwcpf_woocommerce_product_filters . '-icon-filter', VIWCPF_DIR_URL . 'assets/css/viwcpf-icon-filter.css', array(), $this->version, 'all' );
        if ( WP_DEBUG ) {
            wp_enqueue_style( $this->viwcpf_woocommerce_product_filters . '-off_canvas', VIWCPF_DIR_URL . 'public/css/off_canvas.css', array(), $this->version, 'all' );
            wp_enqueue_style( $this->viwcpf_woocommerce_product_filters, VIWCPF_DIR_URL . 'public/css/woocommerce-product-filters-public.css', array(), $this->version, 'all' );
        } else {
            wp_enqueue_style( $this->viwcpf_woocommerce_product_filters . '-off_canvas', VIWCPF_DIR_URL . 'public/css/off_canvas.min.css', array(), $this->version, 'all' );
            wp_enqueue_style( $this->viwcpf_woocommerce_product_filters, VIWCPF_DIR_URL . 'public/css/woocommerce-product-filters-public.min.css', array(), $this->version, 'all' );
        }

    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts() {
        if ( ! is_shop() && ! is_product_taxonomy() ) {
            return;
        }
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Woocommerce_Product_Filters_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Woocommerce_Product_Filters_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_script( $this->viwcpf_woocommerce_product_filters . '-js-rangeSlide', VIWCPF_DIR_URL . 'assets/js/ion.rangeSlider.min.js', array( 'jquery' ), $this->version, true );
        //		wp_enqueue_script( $this->viwcpf_woocommerce_product_filters . '-select2', VIWCPF_DIR_URL . 'assets/js/select2.js', array( 'jquery' ) , $this->version,true);
        wp_enqueue_script( $this->viwcpf_woocommerce_product_filters . '-vi_dropdown', VIWCPF_DIR_URL . 'assets/js/vi_dropdown.js', array( 'jquery' ), $this->version, true );
        wp_enqueue_script( $this->viwcpf_woocommerce_product_filters . '-off_canvas', VIWCPF_DIR_URL . 'public/js/off_canvas.js', array( 'jquery' ), $this->version, true );
        wp_enqueue_script( $this->viwcpf_woocommerce_product_filters, VIWCPF_DIR_URL . 'public/js/woocommerce-product-filters-public.js', array(
            'jquery',
            'accounting'
        ), $this->version, false );
        $viwcpf_localize_args = array(
            'currency_format'     => array(
                'symbol'    => get_woocommerce_currency_symbol(),
                'decimal'   => esc_attr( wc_get_price_decimal_separator() ),
                'thousand'  => esc_attr( wc_get_price_thousand_separator() ),
                'precision' => wc_get_price_decimals(),
                'format'    => esc_attr( str_replace( array( '%1$s', '%2$s' ), array(
                    '%s',
                    '%v'
                ), get_woocommerce_price_format() ) ),
            ),
            'php_int_max'         => PHP_INT_MAX,
            'seo_rule'            => $this->data->get_params( 'seo_rule' ),
            'shop_loop_container' => $this->data->get_params( 'shop_loop_container' )
        );
        $viwcpf_localize_args = apply_filters( 'viwcpf_localize_args', $viwcpf_localize_args );

        $viwcpf_setting_params_default = $this->data->get_default();
        $viwcpf_setting_params         = get_option( 'viwcpf_setting_params' ) ? get_option( 'viwcpf_setting_params' ) : $viwcpf_setting_params_default;
        if ( isset( $viwcpf_setting_params['modal']['auto_open'] ) ) {
            $viwcpf_localize_args['auto_open_modal'] = 'on';
        }
        if ( isset( $viwcpf_setting_params['modal']['style'] ) ) {
            $viwcpf_localize_args['modal_style'] = $viwcpf_setting_params['modal']['style'];
        }
        if ( $this->data->get_params( 'viwcpf_using_ajax' ) ) {
            $viwcpf_localize_args['shop_loop_container']     = $this->data->get_params( 'shop_loop_product' );
            $viwcpf_localize_args['shop_pagination_product'] = $this->data->get_params( 'shop_pagination_product' );
            $viwcpf_localize_args['using_ajax']              = 'on';
        }
        wp_localize_script( $this->viwcpf_woocommerce_product_filters, 'viwcpf_localize_args', $viwcpf_localize_args );
        $custom_css = $this->viwcpf_custom_css();

        if ( ! empty( $custom_css ) ) {
            wp_add_inline_style( $this->viwcpf_woocommerce_product_filters, $custom_css );
        }
    }

    /**
     * @return void
     */
    public function public_init() {
        if ( is_admin() ) {
            return;
        }
        $this->activate_viwcpf_shortcodes();
        $this->activate_viwcpf_shortcode_modal_icon();

        if ( $this->data->get_params( 'seo_rule' ) ) {

            $this->seoFrontend->registerHooks();
        }
    }

    public function viwcpf_redirect_single_search_result() {
        return false;
    }

    /**
     * Build custom CSS template, to be used in page header
     *
     * @return bool|string Custom CSS template, ro false when no content should be output.
     */
    protected function viwcpf_custom_css() {
        $default_accent_color = apply_filters( 'viwcpf_default_accent_color', '#fe2740' );

        $variables = array();
        $options   = array(
            'area'  => array(
                'color' => array(
                    'title'      => '#434343',
                    'background' => '#ffffff',
                    'accent'     => '#0c0c0c',
                ),
            ),
            'label' => array(
                'size'  => array(
                    'font_size'     => '16px',
                    'border_width'  => '1',
                    'border_radius' => '4',
                ),
                'color' => array(
                    'background'        => '#ffffff',
                    'background_hover'  => '#ebebeb',
                    'background_active' => '#ebebeb',
                    'text'              => '#000000',
                    'text_hover'        => '#000000',
                    'text_active'       => '#000000',
                ),
            ),
            'modal' => array(
                'icon' => array(
                    'size'             => '1',
                    'size_hover'       => '1',
                    'icon_radius'      => '50%',
                    'color'            => '#ffffff',
                    'color_hover'      => '#78a938',
                    'background'       => '#78a938',
                    'background_hover' => '#ffffff',
                    'horizontal'       => '25px',
                    'vertical'         => '35px',
                ),
            ),
        );


        foreach ( $options as $variable => $settings ) {
            $option   = $variable;
            $variable = '--viwcpf-' . $variable;
            $value    = isset( get_option( 'viwcpf_setting_params' )[ $option ] ) ? get_option( 'viwcpf_setting_params' )[ $option ] : array();

            if ( empty( $value ) ) {
                continue;
            }

            if ( is_array( $value ) ) {
                foreach ( $value as $sub_variable => $sub_value ) {
                    if ( is_array( $sub_value ) ) {
                        foreach ( $sub_value as $sub_sub_variable => $sub_sub_value ) {
                            $variables["{$variable}_{$sub_variable}_{$sub_sub_variable}"] = $sub_sub_value;
                        }
                    } else {
                        $variables["{$variable}_{$sub_variable}"] = $sub_value;
                    }

                }
            } else {
                $variables[ $variable ] = $value;
            }
        }

        if ( empty( $variables ) ) {
            return false;
        }

        // start CSS snippet.
        $template = ":root{\n";

        // cycles through variables.
        foreach ( $variables as $variable => $value ) {
            $template .= "\t{$variable}: {$value};\n";
        }

        // close :root directive.
        $template .= '}';

        return $template;
    }

    public function activate_viwcpf_shortcodes() {

        add_shortcode( "VIWCPF_SHORTCODE", array( $this, 'viwcpf_menu_shortcode' ) );

    }

    public function viwcpf_menu_shortcode( $param ) {

        ob_start();
        extract( shortcode_atts( array(
            'id_menu'    => '',
            'column'     => '1',
            'off_canvas' => false,
        ), $param ) );

        if ( $id_menu != '' && $id_menu != 0 ) {
            $viwcpf_filter_menu    = get_post_meta( $id_menu, 'viwcpf_filter_menu', true );
            $viwcpf_setting_params = get_option( 'viwcpf_setting_params' );
            $class_canvas          = '';
            if ( $off_canvas ) {
                $class_canvas = 'viwcpf_filter_canvas';
            }
            if (
                $viwcpf_setting_params &&
                isset( $viwcpf_setting_params['option_style'] )
            ) {
                $option_style = $viwcpf_setting_params['option_style'];
            } else {
                $option_style = '';
            }
            if ( $this->check_conditional_menu( $id_menu ) ) {
                if ( $viwcpf_filter_menu ) {
                    $arr_block_id = explode( ",", $viwcpf_filter_menu['viwcpf_blocks_selected'] );
                    if ( isset( $viwcpf_setting_params['viwcpf_using_ajax'] ) ) {
                        $ajaxClassName = 'with-ajax';
                    } else {
                        $ajaxClassName = 'no-ajax';
                    }
                    if ( $viwcpf_filter_menu['viwcpf_show_button_submit'] ) {
                        $submitBtnClassName = 'has-submit-btn';
                    } else {
                        $submitBtnClassName = '';
                    }

                    global $wp;
                    ?>
                    <div class="viwcpf_wrap_shortcode_menu_filter viwcpf_shortcode_menu_<?php echo esc_attr( $id_menu ) . ' ' . esc_attr( $class_canvas ); ?> viwcpf-grid viwcpf-grid-<?php echo esc_attr( $column ); ?>" data-menu_id="<?php echo esc_attr( $id_menu ); ?>">
                        <?php
                        do_action( 'viwcpf_before_menu_filters' );
                        ?>
                        <form class="viwcpf_form_filter <?php echo esc_attr( $option_style . ' ' . $ajaxClassName . ' ' . $submitBtnClassName ); ?>"
                              method="GET" action="<?php echo esc_url_raw( $this->viwcpf_get_current_page_url() ); ?>">
                            <?php
                            $has_search_product = false;
                            foreach ( $arr_block_id as $item_block_id ) {
                                $viwcpf_filter_block = get_post_meta( $item_block_id, 'viwcpf_filter_block', true );

                                if ( $viwcpf_filter_block && ( get_post_status( $item_block_id ) == 'publish' ) ) {
                                    if ( $viwcpf_filter_block['filter_for'] === 'filter_by_name_product' ) {
                                        $has_search_product = true;
                                    }
                                    $this->viwcpf_get_template_by_type_show( $viwcpf_filter_block );
                                }
                            }
                            if ( $viwcpf_filter_menu['viwcpf_show_button_submit'] ) {
                                echo '<button class="btn btn-primary viwcpf-apply-filters">' . apply_filters( 'pofily_apply_filter_text', esc_html__( 'Apply filters', 'pofily-woocommerce-product-filters' ) ) . '</button>';
                                $arr_exclude = [ 'min_price', 'max_price', 'paged', 'isOnsale', 'isInstock', 'product_cat', 'product_tag', 'rating_filter' ];
                                if ( ! isset( $viwcpf_setting_params['viwcpf_using_ajax'] ) ) {
                                    if ( $has_search_product ) {
                                        $arr_exclude[] = 'post_type';
                                        $arr_exclude[] = 's';
                                    }
                                }
                                //echo wc_query_string_form_fields( null, $arr_exclude, '', true );
                            }
                            ?>
                        </form>
                        <?php
                        do_action( 'viwcpf_after_menu_filters' );
                        ?>
                    </div>
                    <?php
                } else {
                    $viwcpf_filter_menu = array();
                }
            }

        } else {
            esc_html_e( 'Error loading menu filter', 'pofily-woocommerce-product-filters' );
        }

        return ob_get_clean();
    }

    /*
    *
    * Function add custom query Pre get post for filter
    *
    *
    * @param $query
    *
    */
    public function pre_get_post_filter( $query ) {
        if ( is_admin() ) {
            return;
        }

        if (
            $query->is_main_query() && ( is_product_taxonomy() || is_post_type_archive( 'product' ) )
        ) {

            $viwcpfFilterRequest = get_query_var( 'viwcpfFilterRequest' );

            if (
                ! empty( $viwcpfFilterRequest ) &&
                (
                    $this->data->get_params( 'seo_rule' ) !== 'on' &&
                    ! $this->seoFrontend->isFilterSeo()
                )
            ) {
                $viwcpf_render_arr_FilterRequest = $this->seoFrontend->viwcpf_render_arr_FilterRequest( $viwcpfFilterRequest );
                $product_visibility_terms        = wc_get_product_visibility_term_ids();

                $product_visibility_not_in = array( is_search() && $query->is_main_query() ? $product_visibility_terms['exclude-from-search'] : $product_visibility_terms['exclude-from-catalog'] );

                if ( ! empty( $viwcpf_render_arr_FilterRequest ) ) {
                    $page_num               = $viwcpf_render_arr_FilterRequest['paged'] ?? 1;
                    $viwcpf_min_price       = 0;
                    $viwcpf_max_price       = PHP_INT_MAX;
                    $viwcpf_rating          = '';
                    $arr_filter_single_slug = [ 'isOnsale', 'isInstock' ];
                    $viwcpf_text_search     = '';
                    if ( is_numeric( $page_num ) && $page_num > 1 ) {
                        $page_num = (string) $page_num;
                    } else {
                        $page_num = '1';
                    }

                    $viwcpf_tax_query        = $query->get( 'tax_query' );
                    $viwcpf_meta_query       = $query->get( 'meta_query' );
                    $viwcpf_meta_query_price = [];
                    $product_ids_on_sale     = '';
                    foreach ( $viwcpf_render_arr_FilterRequest as $key_filter => $filter_val ) {
                        $term_val     = '';
                        $arr_term_val = $filter_val['value'] ?? [];

                        $relation = 'AND';
                        switch ( $key_filter ) {
                            case 'product_cat':
                            case 'product_tag':

                                if ( isset( $filter_val['type'] ) && $filter_val['type'] == 'or' ) {
                                    $term_val = implode( ',', $arr_term_val );
                                    $relation = 'OR';
                                } else {
                                    $term_val = implode( '+', $arr_term_val );
                                }

                                break;
                            case 'min_price':
                                $viwcpf_min_price = (float) $filter_val['value'][0];
                                continue 2;
                                break;
                            case 'max_price':
                                $viwcpf_max_price = (float) $filter_val['value'][0];
                                continue 2;
                                break;
                            case 'paged':
                                continue 2;
                                break;
                            case 's':
                                $viwcpf_text_search = $filter_val['value'][0];
                                continue 2;
                                break;
                            case 'isOnsale':
                                /*Filter by on sale*/
                                $product_ids_on_sale = wc_get_product_ids_on_sale();

                                continue 2;
                                break;
                            case 'isInstock':
                                /*Filter by Instock */
                                if ( ! $this->data->get_params( 'hide_out_of_stock' ) ) {
                                    $viwcpf_meta_query[] = array(
                                        array(
                                            'key'     => '_stock_status',
                                            'value'   => 'instock',
                                            'compare' => '=',
                                        )
                                    );

                                }
                                continue 2;
                                break;
                            case 'rating_filter':
                                $viwcpf_rating = (float) $filter_val['value'][0];
                                // Set new rating filter.
                                $product_visibility_terms = wc_get_product_visibility_term_ids();
                                $viwcpf_tax_query[]       = array(
                                    'taxonomy'      => 'product_visibility',
                                    'field'         => 'term_taxonomy_id',
                                    'terms'         => $product_visibility_terms[ 'rated-' . $viwcpf_rating ],
                                    'operator'      => 'IN',
                                    'rating_filter' => true,
                                );
                                continue 2;
                                break;
                            default:

                                if ( isset( $filter_val['type'] ) && $filter_val['type'] == 'or' ) {
                                    $tax_name                          = str_replace( 'filter_', '', $key_filter );
                                    $_GET[ 'query_type_' . $tax_name ] = 'or';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                    $relation                          = 'IN';
                                }
                                $key_filter = str_replace( 'filter_', 'pa_', $key_filter );
                                $term_val   = implode( ',', $arr_term_val );
                                break;
                        }
                        $viwcpf_tax_query[] = array(
                            'taxonomy'         => $key_filter,
                            'field'            => 'slug',
                            'terms'            => $arr_term_val,
                            'operator'         => $relation,
                            'include_children' => false,
                        );

                    }
                    if (
                        ( $viwcpf_min_price != 0 && $viwcpf_max_price != PHP_INT_MAX ) ||
                        ( $viwcpf_min_price != 0 ) ||
                        ( $viwcpf_max_price != PHP_INT_MAX )
                    ) {
                        $viwcpf_meta_query_price['relation'] = 'OR';
                        $viwcpf_meta_query_price[]           = array(
                            'key'     => '_regular_price',
                            'value'   => array( $viwcpf_min_price, $viwcpf_max_price ),
                            'compare' => 'BETWEEN',
                            'type'    => 'numeric'
                        );
                        $viwcpf_meta_query_price[]           = array(
                            'key'     => '_price',
                            'value'   => array( $viwcpf_min_price, $viwcpf_max_price ),
                            'compare' => 'BETWEEN',
                            'type'    => 'numeric'
                        );
                        $viwcpf_meta_query[]                 = $viwcpf_meta_query_price;
                    }
                    // phpcs:enable WordPress.Security.NonceVerification.Recommended
                    if ( ! empty( $product_visibility_not_in ) ) {
                        $viwcpf_tax_query[] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => $product_visibility_not_in,
                            'operator' => 'NOT IN',
                        );
                    }
                    if ( ! empty( $product_ids_on_sale ) ) {

                        $query->set( 'post__in', $product_ids_on_sale );
                    }

                    if ( ! empty( $viwcpf_tax_query ) ) {
                        $query->set( 'tax_query', $viwcpf_tax_query );
                    }
                    if ( ! empty( $viwcpf_text_search ) ) {
                        $query->set( 's', $viwcpf_text_search );
                    }


                    if ( ! empty( $viwcpf_meta_query ) ) {
                        $query->set( 'post_type', array( 'product', 'product_variation' ) );
                        $query->set( 'meta_query', $viwcpf_meta_query );
                    }
                    $query->set( 'paged', $page_num );

                }
            } else {
                $get_query = wc_clean( wp_unslash( $_GET ) );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                if ( isset( $get_query['product_cat'] ) || isset( $get_query['product_tag'] ) ) {
                    $viwcpf_tax_query = (array) $query->get( 'tax_query' ) ?? [];

                    $product_visibility_terms  = wc_get_product_visibility_term_ids();
                    $product_visibility_not_in = array( is_search() && $query->is_main_query() ? $product_visibility_terms['exclude-from-search'] : $product_visibility_terms['exclude-from-catalog'] );

                    foreach ( $get_query as $key_get => $value_get ) {
                        /*Product cat*/
                        if ( preg_match( '/product_cat/', $key_get ) || preg_match( '/product_tag/', $key_get ) && ! empty( $get_query[ $key_get ] ) ) {
                            $arr_term_val = [];
                            $taxonomy     = '';
                            $query_type   = '';
                            $query_type   = 'and'; /* Default query type  = and*/

                            if ( strpos( $value_get, ' ' ) ) {
                                $arr_term_val = explode( ' ', $value_get );
                            } else {
                                $arr_term_val = explode( ',', $value_get );
                            }

                            $string_term_val = implode( '+', $arr_term_val );

                            if ( preg_match( '/product_cat/', $key_get ) && ! empty( $get_query[ $key_get ] ) ) {
                                $taxonomy = 'product_cat';

                                if ( isset( $get_query['query_type_product_cat'] ) && ( $get_query['query_type_product_cat'] === 'or' ) ) {
                                    //									$query_type = $get_query['query_type_product_cat'];
                                    $query_type      = 'IN';
                                    $string_term_val = implode( ',', $arr_term_val );
                                }


                            } elseif ( preg_match( '/product_tag/', $key_get ) && ! empty( $get_query[ $key_get ] ) ) {

                                $taxonomy = 'product_tag';


                                if ( isset( $get_query['query_type_product_tag'] ) && ( $get_query['query_type_product_tag'] === 'or' ) ) {
                                    $query_type      = 'IN';
                                    $string_term_val = implode( ',', $arr_term_val );
                                }
                            }

                            /* if ( ! empty( $taxonomy ) && ! empty( $arr_term_val ) && ! empty( $query_type ) ) {
								if ( ! empty( $taxonomy ) && ! empty( $arr_term_val ) && ! empty( $query_type ) ) {
									if ( $query_type == 'and' && is_array( $arr_term_val ) ) {
										foreach ( $arr_term_val as $term_val ) {
											$query->tax_query->queries[] = array(
												'taxonomy'         => $taxonomy,
												'field'            => 'slug',
												'terms'            => [$term_val],
												'operator'         => 'IN',
												'include_children' => true,
											);
										}
									} else {
										$query->tax_query->queries[] = array(
											'taxonomy'         => $taxonomy,
											'field'            => 'slug',
											'terms'            => $arr_term_val,
											'operator'         => $query_type,
											'include_children' => false,
										);
									}

								}
							} */

                        }
                    }


                    /* $query->tax_query->queried_terms[$taxonomy] = array(
						'terms'=>$query->tax_query->queries[0]['terms']??[],
						'field'=>'slug',
					);
					*/
                    $query->query[ $taxonomy ]      = $string_term_val;
                    $query->query_vars[ $taxonomy ] = $string_term_val;

                    if ( ! empty( $product_visibility_not_in ) ) {
                        $has_product_visibility = false;
                        foreach ( $viwcpf_tax_query as $item ) {
                            if ( isset( $item['taxonomy'] ) && $item['taxonomy'] == 'product_visibility' ) {
                                $has_product_visibility = true;
                                break;
                            }
                        }
                        if ( ! $has_product_visibility ) {
                            $viwcpf_tax_query[] = array(
                                'taxonomy' => 'product_visibility',
                                'field'    => 'term_taxonomy_id',
                                'terms'    => $product_visibility_not_in,
                                'operator' => 'NOT IN',
                            );
                        }

                    }

                    /* if ( ! empty( $viwcpf_tax_query ) ) {
						$query->set( 'tax_query', $viwcpf_tax_query );
					} */
                }

            }

            if (
                ( count( (array) $query->get( 'tax_query' ) ) > 2 || count( (array) $query->get( 'meta_query' ) ) >= 0 ) &&
                $this->data->get_params( 'hide_out_of_stock' )
            ) {
                $query->set(
                    'meta_query',
                    array(
                        array(
                            'key'     => '_stock_status',
                            'value'   => 'instock',
                            'compare' => '=',
                        )
                    )
                );
            }
            if (
                isset( $_GET['instock_filter'] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                sanitize_text_field( wp_unslash( $_GET['instock_filter'] ) ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                ! $this->data->get_params( 'hide_out_of_stock' )
            ) {
                $query->set(
                    'meta_query',
                    array(
                        array(
                            'key'     => '_stock_status',
                            'value'   => 'instock',
                            'compare' => '=',
                        )
                    )
                );

            }


            if (
                isset( $_GET['onsale_filter'] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                sanitize_text_field( wp_unslash( $_GET['onsale_filter'] ) )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            ) {
                $product_ids_on_sale = wc_get_product_ids_on_sale();

                $query->set( 'post__in', $product_ids_on_sale );
            }
            if ( isset( $_GET ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $viwcpf_arr_metakey        = array();
                $viwcpf_setting_params     = get_option( 'viwcpf_setting_params' ) ? get_option( 'viwcpf_setting_params' ) : array();
                $viwcpf_arr_metakey_option = isset( $viwcpf_setting_params['display_metakey'] ) ? $viwcpf_setting_params['display_metakey'] : array();
                foreach ( wc_clean( wp_unslash( $_GET ) ) as $key_get => $value_get ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    if ( 0 === strpos( $key_get, 'viwcpf_metakey_type_' ) ) {
                        $name_metakey = str_replace( 'viwcpf_metakey_type_', '', $key_get );
                        array_push( $viwcpf_arr_metakey, $name_metakey );
                    }
                }

                if ( sizeof( $viwcpf_arr_metakey ) > 0 ) {
                    /*Create variable $viwcpf_metavalue_arr_query = array() */
                    $viwcpf_metavalue_arr_query = array();
                    /*If more than 1 metakey then add relation to array query*/
                    if ( sizeof( $viwcpf_arr_metakey ) > 1 ) {
                        $viwcpf_metavalue_arr_query['relation'] = 'AND';
                    }

                    /*For all metakey and add value to array meta query*/
                    foreach ( $viwcpf_arr_metakey as $item_metakey ) {
                        $viwcpf_metakey_filter = sanitize_text_field( $item_metakey );

                        if ( in_array( $item_metakey, $viwcpf_arr_metakey_option ) ) {

                            if (
                                isset( $_GET[ 'viwcpf_metakey_' . $viwcpf_metakey_filter ] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                isset( $_GET[ 'viwcpf_metakey_type_' . $viwcpf_metakey_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            ) {
                                $viwcpf_metakey_type_filter  = sanitize_text_field( wp_unslash( $_GET[ 'viwcpf_metakey_type_' . $viwcpf_metakey_filter ] ) );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                $viwcpf_metakey_value_filter = sanitize_text_field( wp_unslash( $_GET[ 'viwcpf_metakey_' . $viwcpf_metakey_filter ] ) );// phpcs:ignore WordPress.Security.NonceVerification.Recommended

                                /*Check type of metadata*/
                                switch ( $viwcpf_metakey_type_filter ) {
                                    case 'string':
                                        $viwcpf_metavalue_arr_query[] = array(
                                            'key'     => $viwcpf_metakey_filter,
                                            'value'   => $viwcpf_metakey_value_filter,
                                            'type'    => 'char',
                                            'compare' => '=',
                                        );

                                        break;
                                    case 'numberic':
                                        $viwcpf_metavalue_arr = explode( "-", $viwcpf_metakey_value_filter );
                                        if ( sizeof( $viwcpf_metavalue_arr ) == 1 ) {
                                            array_push( $viwcpf_metavalue_arr, PHP_INT_MAX );
                                        }
                                        $viwcpf_metavalue_arr_query[] = array(
                                            'key'     => $viwcpf_metakey_filter,
                                            'value'   => $viwcpf_metavalue_arr,
                                            'type'    => 'numeric',
                                            'compare' => 'BETWEEN'
                                        );
                                        break;
                                    default:
                                        break;
                                }

                            }
                        }
                    }
                    /*Finaly set $viwcpf_metavalue_arr_query to meta query */
                    $query->set( 'post_type', array( 'product', 'product_variation' ) );
                    $query->set( 'meta_query', $viwcpf_metavalue_arr_query );
                }
            }

        }
    }

    /*
    *
    * Function return parent product id
    *
    *
    * @param $posts
    * @param $query
    *
    * @return mixed
    */
    function viwcpf_return_parent_id( $posts, $query ) {
        if (
            $query->is_main_query() &&
            ( is_product_taxonomy() || is_post_type_archive( 'product' ) )
        ) {

            $filtered_posts = array();
            $arr_exist_post = array();
            foreach ( $posts as $post ) {
                if ( $post->post_type === 'product_variation' ) {
                    if ( ! in_array( $post->post_parent, $arr_exist_post ) ) {

                        $filtered_posts[] = get_post( $post->post_parent );
                        $arr_exist_post[] = $post->post_parent;
                    }
                } else {
                    if ( ! in_array( $post->ID, $arr_exist_post ) ) {
                        $filtered_posts[] = get_post( $post->ID );
                        $arr_exist_post[] = $post->ID;
                    }
                }
            }

            return $filtered_posts;
        }

        return $posts;
    }

    /*
    *
    * Function check conditional display for menu filter and return boolean true/false
    *
    *
    * @param  string $menu_id String ids menu filter.
    *
    * @return boolean
    */
    public function check_conditional_menu( $menu_id = '' ) {

        if ( $menu_id === '' ) {
            return false;
        }
        $viwcpf_filter_menu = get_post_meta( $menu_id, 'viwcpf_filter_menu', true );

        $viwcpf_display_conditions = $viwcpf_filter_menu['viwcpf_display_conditions'] ?? [];
        if ( empty( $viwcpf_display_conditions ) ) {
            return true;
        }
        $arr_display_conditions = array(
            'include' => array(),
            'exclude' => array(),// phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude
        );
        $include                = false;
        $exclude                = true;
        foreach ( $viwcpf_display_conditions as $item_condition ) {
            if ( $item_condition['type'] == 'include' ) {

                switch ( $item_condition['archive'] ) {
                    case 'all':

                        $include = $include || is_archive( "product" );
                        break;
                    case 'product_search':

                        $include = $include || is_search( "product" );
                        break;
                    case 'shop_page':

                        $include = $include || is_shop();
                        break;
                    case 'product_cat':
                        if ( empty( $item_condition['archive_id'] ) ) {

                            $include = $include || is_product_category();
                        } else {
                            if ( is_array( $item_condition['archive_id'] ) ) {
                                $arr_term = array();
                                foreach ( $item_condition['archive_id'] as $archive_id ) {
                                    $condition_term = get_term_by( 'id', $archive_id, $item_condition['archive'], OBJECT );

                                    array_push( $arr_term, $condition_term->slug );
                                }

                                $include = $include || is_product_category( $arr_term );

                            }
                        }
                        break;
                    case 'product_tag':
                        if ( empty( $item_condition['archive_id'] ) ) {

                            $include = $include || is_product_tag();

                        } else {
                            if ( is_array( $item_condition['archive_id'] ) ) {

                                $arr_term = array();

                                foreach ( $item_condition['archive_id'] as $archive_id ) {
                                    $condition_term = get_term_by( 'id', $archive_id, $item_condition['archive'], OBJECT );

                                    array_push( $arr_term, $condition_term->slug );
                                }

                                $include = $include || is_product_tag( $arr_term );
                            }
                        }
                        break;
                    default:

                        $include = $include || true;
                        break;
                }
            } else if ( $item_condition['type'] == 'exclude' ) {
                switch ( $item_condition['archive'] ) {
                    case 'all':

                        $exclude = $exclude && ( ! is_archive( "product" ) );
                        break;
                    case 'product_search':

                        $exclude = $exclude && ( ! is_search( "product" ) );
                        break;
                    case 'shop_page':

                        $exclude = $exclude && ( ! is_shop() );
                        break;
                    case 'product_cat':
                        if ( empty( $item_condition['archive_id'] ) ) {

                            $exclude = $exclude && ( ! is_product_category() );
                        } else {
                            if ( is_array( $item_condition['archive_id'] ) ) {

                                $arr_term = array();

                                foreach ( $item_condition['archive_id'] as $archive_id ) {
                                    $condition_term = get_term_by( 'id', $archive_id, $item_condition['archive'], OBJECT );


                                    array_push( $arr_term, $condition_term->slug );
                                }


                                $exclude = $exclude && ( ! is_product_category( $arr_term ) );

                            }
                        }
                        break;
                    case 'product_tag':
                        if ( empty( $item_condition['archive_id'] ) ) {

                            $exclude = $exclude && ( ! is_product_tag() );
                        } else {
                            if ( is_array( $item_condition['archive_id'] ) ) {

                                $arr_term = array();

                                foreach ( $item_condition['archive_id'] as $archive_id ) {
                                    $condition_term = get_term_by( 'id', $archive_id, $item_condition['archive'], OBJECT );

                                    array_push( $arr_term, $condition_term->slug );
                                }

                                $exclude = $exclude && ( ! is_product_tag( $arr_term ) );
                            }
                        }
                        break;
                    default:

                        $exclude = $exclude && false;
                        break;
                }
            }
        }


        return $include && $exclude;
    }

    /*
    *
    * Function get template filter by type show
    *
    *
    * @param  array $viwcpf_filter_block Array save setting of block menu filter.
    *
    */
    public function viwcpf_get_template_by_type_show( $viwcpf_filter_block ) {
        if ( empty( $viwcpf_filter_block ) ) {
            return;
        }
        $filter_name    = $viwcpf_filter_block['name'];
        $filter_for     = $viwcpf_filter_block['filter_for'];
        $type_show      = $viwcpf_filter_block['filter_data']['type_show'];
        $filter_data    = $viwcpf_filter_block['filter_data'];
        $filter_setting = $viwcpf_filter_block['settings'];

        switch ( $type_show ) {
            case 'button':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-button.php';
                break;
            case 'checkbox':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-checkbox.php';
                break;
            case 'select':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-dropdown.php';
                break;
            case 'range_slide':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-range_slider.php';
                break;
            case 'search_field':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-search_field.php';
                break;
            case 'color_swatches':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-color_swatches.php';
                break;
            case 'images':
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-image.php';
                break;

            default:
                require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/template/viwcpf-template-none.php';
                break;
        }
    }

    /*
    *
    * Function render value for block filter
    *
    *
    * @param $filter_name
    * @param $filter_for
    * @param $filter_data    Array save data of block menu filter.
    * @param $filter_setting Array save setting of block menu filter.
    *
    * @return array()
    */
    public function viwcpf_render_value_block_filter( $filter_name, $filter_for, $filter_data, $filter_setting ) {
        if (
            empty( $filter_for ) &&
            empty( $filter_data )
        ) {
            return;
        }
        extract( $filter_data );
        extract( $filter_setting );

        global $wp;
        $render_array       = array(
            'key_filter'      => '',
            'list_value'      => array(),
            'btn_style'       => array(),
            'input_hidden'    => array(),
            'multiselect'     => $multiselect,
            'multi_relation'  => $multi_relation,
            'show_count_item' => $show_count_item,
            'show_clear_btn'  => $show_clear,
            'display_type'    => $display_type,
            'show_view_more'  => $show_view_more,
            'view_more_limit' => $view_more_limit
        );
        $list_label_items   = array();
        $input_hidden       = '';
        $link               = '';
        $base_link          = $this->viwcpf_get_current_page_url();
        $current_url_param  = wc_clean( wp_unslash( $_GET ) );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes();

        $multiselect = isset( $multiselect ) ? $multiselect : false;

        if ( $multiselect ) {
            $query_type = $multi_relation;
        } else {
            $query_type = 'AND';
        }

        switch ( $filter_for ) {
            case 'filter_by_taxonomy':
                $tax = $tax_name;
                /*if (
					( $tax_name == 'product_cat' ) ||
					( $tax_name == 'product_tag' )
				) {
					$tax_name  = str_replace( '_', '-', $tax_name );
					$tax_name  = str_replace( 'product', 'pofily', $tax_name );
					$param_url = '?' . $tax_name . '=';
				} else {
					$tax_name  = str_replace( "pa_", "filter_", $tax_name );
					$param_url = '?filter_' . $tax_name . '=';
				}*/
                if (
                    ( $tax_name !== 'product_cat' ) &&
                    ( $tax_name !== 'product_tag' )
                ) {
                    $tax_name  = str_replace( "pa_", "filter_", $tax_name );
                    $param_url = '?filter_' . $tax_name . '=';
                }
                $current_values = isset( $_chosen_attributes[ $tax ]['terms'] ) ? $_chosen_attributes[ $tax ]['terms'] : array();

                $list_terms   = ! empty( $filter_data['list_terms'] ) ? $filter_data['list_terms'] : array();
                $sorted_terms = $this->get_formatted_terms( $filter_data['tax_name'], $list_terms, $filter_data['order_by'], $filter_data['order_type'] );

                if ( ! empty( $sorted_terms ) ) {
                    foreach ( $sorted_terms as $sorted_term_item ) {
                        $label_item  = $customize_value[ $sorted_term_item ] ?? '';
                        $term_object = get_term_by( 'id', $sorted_term_item, $tax, OBJECT );

                        $option_is_set = in_array( $term_object->slug, $current_values, true );

                        $label = empty( $label_item['new_label'] ) ? $label_item['old_label'] : $label_item['new_label'];
                        /*Fix for wpml*/
                        if ( empty( $label ) ) {
                            $label = $term_object->name;
                        }
                        $tooltip = ! empty( $label_item['tooltip'] ) ? $label_item['tooltip'] : '';
                        if ( $tooltip != '' ) {
                            $data_tooltip = urlencode( $tooltip );
                        } else {
                            $data_tooltip = '';
                        }
                        $id   = $term_object->term_id;
                        $slug = $term_object->slug;

                        $count = $this->get_filtered_term_product_counts( array( $id ), $tax, $multi_relation );

                        if (
                            ! isset( $count[ $id ] ) ||
                            ( $count[ $id ] <= 0 )
                        ) {
                            $hook_show_cat_non_product = apply_filters( 'viwcpf_hook_show_term_non_product', true );
                            if ( $hook_show_cat_non_product ) {
                                continue;
                            }
                        }
                        if ( $this->data->get_params( 'seo_rule' ) ) {
                            $viwcpf_format_link_tax = $this->viwcpf_format_link_tax( $tax_name, $slug, $multiselect, $query_type );
                            $link                   = $viwcpf_format_link_tax['link'];
                            $class_name             = $viwcpf_format_link_tax['class_name'];
                        } else {
                            if ( $multiselect ) {
                                /*Get current tax filter for multiselect=yes */
                                if (
                                    ( $query_type == 'AND' ) &&
                                    (
                                        ( $tax_name == 'product_cat' ) ||
                                        ( $tax_name == 'product_tag' )
                                    )
                                ) {
                                    $current_filter = isset( $_GET[ $tax_name ] ) ? explode( '+', urlencode( wc_clean( wp_unslash( $_GET[ $tax_name ] ) ) ) ) : array();
                                } else {
                                    $current_filter = isset( $_GET[ $tax_name ] ) ? explode( ',', wc_clean( wp_unslash( $_GET[ $tax_name ] ) ) ) : array();// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                }
                                /*Compa Berocket brand and Brand default by WooCommerce */
                                if ( $tax_name == 'berocket_brand' || $this->data->viwcpf_check_woo_brand_is_enabled( $tax_name ) ) {

                                    $check_brand_filter = isset( $_GET[ $tax_name ] ) ? sanitize_text_field( $_GET[ $tax_name ] ) : '';
                                    if ( ! empty( $check_brand_filter ) ) {
                                        $check_brand_filter = urlencode( $check_brand_filter );
                                        /*strpos can be replaced with str_contains but requires php version >8.0 to use (24-02-2025)*/
                                        if ( strpos( $check_brand_filter, ',' ) ) {
                                            $current_filter = explode( '-', $check_brand_filter );

                                        } elseif ( strpos( $check_brand_filter, '+' ) !== false ) {
                                            $current_filter = explode( '+', $check_brand_filter );

                                        }
                                    }

                                }
                                /*Add term value current product taxonomy page*/
                                if ( is_product_taxonomy() ) {
                                    $current_page_query = get_queried_object();
                                    $current_page_tax   = $current_page_query->taxonomy ?? '';
                                    //									$current_page_tax   = str_replace( 'product_', 'pofily-', $current_page_tax );
                                    if ( $current_page_tax == $tax_name ) {
                                        if ( ! empty( $current_page_query->slug ) ) {

                                            $current_filter[] = $current_page_query->slug;
                                        }
                                    }

                                }

                                if ( ! in_array( $slug, $current_filter, true ) ) {
                                    $current_filter[] = $slug;
                                    $class_name       = '';
                                } else {
                                    $class_name = 'viwcpf_chosen';
                                    foreach ( $current_filter as $keyy => $value ) {
                                        // Exclude query arg for current term archive term.
                                        if ( $value === $slug ) {
                                            unset( $current_filter[ $keyy ] );
                                        }

                                        // Exclude self so filter can be unset on click.
                                        if ( $option_is_set && $value === $slug ) {
                                            unset( $current_filter[ $keyy ] );
                                        }
                                    }
                                }

                                $current_filter = array_unique( $current_filter );
                                /*Remove query args current*/
                                $link = remove_query_arg( $tax_name, $base_link );
                                /*Remove current tax value in $current_url_param*/
                                unset( $current_url_param[ $tax_name ] );
                                unset( $current_url_param[ 'query_type_' . wc_attribute_taxonomy_slug( $tax ) ] );

                                $current_filter = array_map( 'sanitize_title', $current_filter );
                                // Add current filters to URL.
                                if ( ! empty( $current_filter ) ) {
                                    asort( $current_filter );
                                    //Check if is product_cat or product_tag query_type_ no need add, replace with "+" or ",". "+" is query_type = and; "," is query_type = or

                                    $link = add_query_arg( $tax_name, implode( ',', $current_filter ), $link );

                                    // Add Query type Arg to URL.
                                    if ( 'OR' === $query_type && ! ( 1 === count( $current_filter ) && $option_is_set ) ) {
                                        $link = add_query_arg( $tax_name, implode( ',', $current_filter ), $link );
                                    } else {
                                        $link = add_query_arg( $tax_name, implode( '+', $current_filter ), $link );
                                    }

                                    $link = str_replace( '%2C', ',', $link );
                                }

                                /*Add other param to url*/
                                if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                                    foreach ( $current_url_param as $key_param => $value_param ) {
                                        $link = add_query_arg( $key_param, $value_param, $link );
                                    }
                                }


                            } else {
                                /*Get current tax filter no multiselect */
                                $current_filter = isset( $_GET[ $tax_name ] ) ? (array) wc_clean( wp_unslash( $_GET[ $tax_name ] ) ) : [];// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                /*Add term value current product taxonomy page*/
                                if ( is_product_taxonomy() ) {
                                    $current_page_query = get_queried_object();
                                    $current_page_tax   = $current_page_query->taxonomy ?? '';
                                    //									$current_page_tax   = str_replace( 'product_', 'pofily-', $current_page_tax );
                                    if ( $current_page_tax == $current_page_tax ) {
                                        if ( ! empty( $current_page_query->slug ) ) {
                                            //
                                            $current_filter[] = $current_page_query->slug;
                                        }
                                    }

                                }
                                /*Remove query args current*/
                                $link = remove_query_arg( $tax_name, $base_link );
                                /*Remove current tax value in $current_url_param*/
                                unset( $current_url_param[ $tax_name ] );
                                /*Update all another param to $link*/
                                if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                                    foreach ( $current_url_param as $key_param => $value_param ) {
                                        $link = add_query_arg( $key_param, $value_param, $link );
                                    }
                                }
                                /*Add new tax param to $link*/
                                if ( in_array( $slug, $current_filter, true ) ) {
                                    $class_name = 'viwcpf_chosen';
                                } else {
                                    $link       = add_query_arg( $tax_name, $slug, $link );
                                    $class_name = '';
                                }
                            }
                        }


                        $list_label_items = array(
                            'label'      => ( $label ),
                            'value'      => ( $slug ),
                            'tooltip'    => ( $data_tooltip ),
                            'link'       => ( $link ),
                            'count'      => ( $count[ $id ] ?? 0 ),
                            'class_name' => ( $class_name ),
                            'data_attr'  => 'data-term-id=' . esc_attr( $id ) . ' data-term-slug=' . esc_attr( $slug ) . ' data-filter_by=' . esc_attr( $filter_for ) . ''
                        );

                        if ( $type_show == 'color_swatches' ) {
                            $color_value               = isset( $label_item['color'] ) ? wc_clean( $label_item['color'] ) : array();
                            $list_label_items['color'] = $color_value;
                        } else if ( $type_show == 'images' ) {
                            $images                     = isset( $label_item['images'] ) ? wc_clean( $label_item['images'] ) : '';
                            $list_label_items['images'] = $images;
                        }
                        array_push( $render_array['list_value'], $list_label_items );
                    }
                }

                $current_filter = isset( $_GET[ $tax_name ] ) ? explode( ',', wc_clean( wp_unslash( $_GET[ $tax_name ] ) ) ) : array();// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $input_hidden   = array(
                    'class' => $filter_for . ' ' . $tax_name . ' ' . 'viwcpf_filter_value',
                    'name'  => $tax_name,
                    'value' => implode( ',', $current_filter ),
                );
                array_push( $render_array['input_hidden'], $input_hidden );
                if (
                    ( ( $tax_name !== 'product_cat' ) || ( $tax_name !== 'product_tag' ) ) && ( $multiselect )
                ) {
                    $input_hidden = array(
                        'class' => 'query_type',
                        'name'  => 'query_type_' . wc_attribute_taxonomy_slug( $tax ),
                        'value' => strtolower( $query_type ),
                    );
                    array_push( $render_array['input_hidden'], $input_hidden );
                }

                $render_array['key_filter']            = $tax_name;
                $render_array['btn_style']             = $btn_style;
                $render_array['tax_show_search_field'] = $show_search_field;
                break;
            case 'filter_by_price':
                $filtered_price   = $this->get_filtered_price();   // WPCS: slow query ok.
                $hidden_min_price = isset( $_GET['min_price'] ) ? wc_clean( wp_unslash( $_GET['min_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $hidden_max_price = isset( $_GET['max_price'] ) ? wc_clean( wp_unslash( $_GET['max_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                foreach ( $customize_value as $key => $label_item ) {
                    $class_name = '';
                    if ( ! isset( $label_item['limitless'] ) ) {
                        $label = wc_price( apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] ) ) . esc_html__( ' to ', 'pofily-woocommerce-product-filters' ) . wc_price( apply_filters( 'wmc_change_3rd_plugin_price', $label_item['max'] ) );
                    } else {
                        $label = wc_price( apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] ) ) . esc_html__( ' to above', 'pofily-woocommerce-product-filters' );
                    }
                    $tooltip = $label;
                    if ( $tooltip != '' ) {
                        //                        $data_tooltip = 'data-tooltip='.esc_attr($tooltip).'';
                        $data_tooltip = '';
                    } else {
                        $data_tooltip = '';
                    }
                    /*
					 * Count don't need to change multi currency
					 * viwcpf_count_product_by_price(min,max)
					 * */
                    $count = $this->viwcpf_count_product_by_price( $label_item['min'], $label_item['max'] );

                    if ( $count <= 0 ) {
                        continue;
                    }
                    if ( $this->data->get_params( 'seo_rule' ) ) {
                        if ( ! empty( $label_item['min'] ) ) {
                            $label_item_min = apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] );

                        } else {
                            $label_item_min = apply_filters( 'wmc_change_3rd_plugin_price', 0 );

                        }
                        if ( ! empty( $label_item['max'] ) ) {
                            $label_item_max = apply_filters( 'wmc_change_3rd_plugin_price', $label_item['max'] );

                        } else {
                            $label_item_max = PHP_INT_MAX;
                        }
                        $viwcpf_format_link_price = $this->viwcpf_format_link_price( apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] ), apply_filters( 'wmc_change_3rd_plugin_price', $label_item['max'] ) );
                        $link                     = $viwcpf_format_link_price['link'];
                        $class_name               = $viwcpf_format_link_price['class_name'];
                        $hidden_min_price         = $viwcpf_format_link_price['current_filter_val']['min_price'] ?? '';
                        $hidden_max_price         = $viwcpf_format_link_price['current_filter_val']['max_price'] ?? '';
                    } else {
                        $current_min_price = isset( $_GET['min_price'] ) ? wc_clean( wp_unslash( $_GET['min_price'] ) ) : 0;// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        $current_max_price = isset( $_GET['max_price'] ) ? wc_clean( wp_unslash( $_GET['max_price'] ) ) : PHP_INT_MAX;// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        $link              = remove_query_arg( 'min_price', $base_link );
                        $link              = remove_query_arg( 'max_price', $link );
                        unset( $current_url_param['min_price'] );
                        unset( $current_url_param['max_price'] );

                        if ( ! empty( $label_item['min'] ) ) {
                            $label_item_min = apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] );
                            $link           = add_query_arg( 'min_price', apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] ), $link );
                        } else {
                            $label_item_min = apply_filters( 'wmc_change_3rd_plugin_price', 0 );
                            $link           = add_query_arg( 'min_price', '0', $link );
                        }
                        if ( ! empty( $label_item['max'] ) ) {
                            $label_item_max = apply_filters( 'wmc_change_3rd_plugin_price', $label_item['max'] );
                            $link           = add_query_arg( 'max_price', apply_filters( 'wmc_change_3rd_plugin_price', $label_item['max'] ), $link );
                        } else {
                            $label_item_max     = PHP_INT_MAX;
                            $filtered_price     = $this->get_filtered_price();
                            $filtered_max_price = apply_filters( 'wmc_change_3rd_plugin_price', $filtered_price->max_price );
                            $link               = add_query_arg( 'max_price', ceil( floatval( $filtered_max_price ) ), $link );
                        }
                        if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                            foreach ( $current_url_param as $key_param => $value_param ) {
                                $link = add_query_arg( $key_param, $value_param, $link );
                            }
                        }

                        if ( $label_item_max == PHP_INT_MAX ) {
                            $label_item_max = $filtered_price->max_price;
                        }
                        if (
                            ( isset( $_GET['min_price'] ) || isset( $_GET['max_price'] ) ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            ( $label_item_min >= $current_min_price ) &&
                            ( $label_item_max <= $current_max_price )
                        ) {

                            $class_name = 'viwcpf_chosen';
                            $link       = remove_query_arg( 'min_price', $base_link );
                            $link       = remove_query_arg( 'max_price', $link );
                        }
                    }


                    $list_label_items = array(
                        'label'      => ( $label ),
                        'value'      => ( $label_item_min . '-' . $label_item_max ),
                        'tooltip'    => ( $data_tooltip ),
                        'link'       => ( $link ),
                        'count'      => ( $count ),
                        'class_name' => $class_name,
                        'data_attr'  => 'data-currency=' . get_woocommerce_currency() . ' data-range-min=' . esc_attr( apply_filters( 'wmc_change_3rd_plugin_price', $label_item['min'] ) ) . ' data-range-max=' . esc_attr( apply_filters( 'wmc_change_3rd_plugin_price', $label_item['max'] ) ) . ' data-filter_by=' . esc_attr( $filter_for ) . ''
                    );
                    array_push( $render_array['list_value'], $list_label_items );
                }

                $input_hidden = array(
                    'class' => $filter_for . ' min_price',
                    'name'  => 'min_price',
                    'value' => $hidden_min_price,
                );
                array_push( $render_array['input_hidden'], $input_hidden );

                $input_hidden = array(
                    'class' => $filter_for . ' max_price',
                    'name'  => 'max_price',
                    'value' => $hidden_max_price,
                );
                array_push( $render_array['input_hidden'], $input_hidden );

                $render_array['key_filter'] = 'min_price,max_price';
                break;
            case 'filter_by_review':
                $rating_filter     = isset( $_GET['rating_filter'] ) ? array_filter( array_map( 'absint', explode( ',', wc_clean( wp_unslash( $_GET['rating_filter'] ) ) ) ) ) : array();// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $new_rating_filter = 0;
                for ( $rating = 1; $rating <= 5; $rating ++ ) {
                    $label   = esc_html( $rating . ' stars' );
                    $tooltip = '';
                    if ( ! empty( $show_tooltip ) ) {
                        $tooltip = $rating . ' stars';
                    }

                    if ( $tooltip != '' ) {
                        $data_tooltip = urlencode( $tooltip );
                    } else {
                        $data_tooltip = '';
                    }
                    $count = $this->get_filtered_product_count( $rating );
                    if ( $count <= 0 ) {
                        continue;
                    }
                    if ( $show_icon_star ) {
                        $width = 100 / 5 * $rating;
                        $label = '<span class="viwcpf_star-rating"><span style="' . esc_attr( 'width:' . $width . '%;' ) . '"></span></span>' . $label;
                    }

                    if ( $this->data->get_params( 'seo_rule' ) ) {
                        $viwcpf_format_link_review = $this->viwcpf_format_link_review( $rating );
                        $link                      = $viwcpf_format_link_review['link'];
                        $class_name                = $viwcpf_format_link_review['class_name'];
                        $new_rating_filter         = $viwcpf_format_link_review['current_filter_val']['rating_filter'] ?? 0;
                    } else {
                        if ( $multiselect ) {
                            if ( in_array( $rating, $rating_filter, true ) ) {
                                $link_ratings = implode( ',', array_diff( $rating_filter, array( $rating ) ) );
                            } else {
                                $link_ratings = implode( ',', array_merge( $rating_filter, array( $rating ) ) );
                            }
                        } else {
                            $link_ratings = $rating;
                        }


                        $class_name = in_array( $rating, $rating_filter, true ) ? 'viwcpf_chosen' : '';
                        $link       = apply_filters( 'viwcpf_rating_filter_link', $link_ratings ? add_query_arg( 'rating_filter', $link_ratings, $base_link ) : remove_query_arg( 'rating_filter' ) );
                        unset( $current_url_param['rating_filter'] );
                        if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                            foreach ( $current_url_param as $key_param => $value_param ) {
                                $link = add_query_arg( $key_param, $value_param, $base_link );
                            }
                        }
                    }
                    $list_label_items = array(
                        'label'      => ( $label ),
                        'value'      => ( $rating ),
                        'tooltip'    => $data_tooltip,
                        'link'       => ( $link ),
                        'count'      => ( $count ),
                        'class_name' => ( $class_name ),
                        'data_attr'  => 'data-filter_by=' . esc_attr( $filter_for ) . ''
                    );
                    array_push( $render_array['list_value'], $list_label_items );

                }
                $rating_filter = isset( $_GET['rating_filter'] ) ? '1' : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                if ( $this->data->get_params( 'seo_rule' ) ) {
                    if ( $new_rating_filter != 0 ) {
                        $rating_filter = $new_rating_filter;
                    }

                }
                $input_hidden = array(
                    'class' => $filter_for . ' rating_filter',
                    'name'  => 'rating_filter',
                    'value' => implode( ',', (array) $rating_filter ),
                );
                array_push( $render_array['input_hidden'], $input_hidden );

                $render_array['key_filter'] = 'rating_filter';

                break;
            case 'filter_by_sale_or_stock':
                foreach ( $customize_value as $key => $label_item ) {

                    if ( $label_item['old_label'] === 'In stock' && $this->data->get_params( 'hide_out_of_stock' ) ) {
                        continue;
                    }

                    $count        = 0;
                    $link         = '';
                    $prefix_param = '';
                    $label        = '';
                    $tooltip      = ! empty( $label_item['tooltip'] ) ? $label_item['tooltip'] : '';
                    if ( $tooltip != '' ) {
                        $data_tooltip = urlencode( $tooltip );
                    } else {
                        $data_tooltip = '';
                    }
                    if ( $label_item['old_label'] === 'On sale' ) {
                        $count        = $this->count_query_relevant_on_sale_products();
                        $label        = esc_html__( 'On sale', 'pofily-woocommerce-product-filters' );
                        $prefix_param = 'onsale';
                    } else if ( $label_item['old_label'] === 'In stock' ) {
                        $count        = $this->count_query_relevant_in_stock_products();
                        $label        = esc_html__( 'In stock', 'pofily-woocommerce-product-filters' );
                        $prefix_param = 'instock';
                    }
                    if ( $count <= 0 ) {
                        continue;
                    }
                    if ( $this->data->get_params( 'seo_rule' ) ) {
                        $viwcpf_format_link_sale_or_stock = $this->viwcpf_format_link_sale_or_stock( $prefix_param );
                        $link                             = $viwcpf_format_link_sale_or_stock['link'];
                        $class_name                       = $viwcpf_format_link_sale_or_stock['class_name'];

                    } else {
                        /*Get link*/
                        $link = isset( $_GET[ $prefix_param . '_filter' ] ) ? remove_query_arg( $prefix_param . '_filter', $base_link ) : add_query_arg( $prefix_param . '_filter', true, $base_link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        unset( $current_url_param[ $prefix_param . '_filter' ] );
                        if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                            foreach ( $current_url_param as $key_param => $value_param ) {
                                $link = add_query_arg( $key_param, $value_param, $link );
                            }
                        }
                        $class_name = isset( $_GET[ $prefix_param . '_filter' ] ) && $_GET[ $prefix_param . '_filter' ] ? 'viwcpf_chosen' : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    }
                    $list_label_items = array(
                        'label'      => ( $label ),
                        'value'      => ( $prefix_param . '_filter' ),
                        'tooltip'    => $data_tooltip,
                        'link'       => ( $link ),
                        'count'      => ( $count ),
                        'class_name' => ( $class_name ),
                        'data_attr'  => 'data-filter_by=' . esc_attr( $filter_for ) . ''
                    );
                    array_push( $render_array['list_value'], $list_label_items );
                }
                $key_filter = array();
                if ( $show_onsale ) {
                    if ( $this->data->get_params( 'seo_rule' ) ) {
                        $viwcpf_format_link_search = $this->viwcpf_format_link_sale_or_stock( 'onsale' );
                        $onsale_value              = $viwcpf_format_link_search['current_filter_val']['onsale_filter'] ?? '';
                    } else {
                        $onsale_value = isset( $_GET['onsale_filter'] ) ? '1' : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    }
                    $input_hidden = array(
                        'class' => $filter_for . ' onsale_filter',
                        'name'  => 'onsale_filter',
                        'value' => $onsale_value,
                    );
                    array_push( $render_array['input_hidden'], $input_hidden );
                    $key_filter[] = 'onsale_filter';
                }
                if ( $show_instock ) {
                    if ( $this->data->get_params( 'seo_rule' ) ) {
                        $viwcpf_format_link_search = $this->viwcpf_format_link_sale_or_stock( 'instock' );
                        $instock_value             = $viwcpf_format_link_search['current_filter_val']['instock_filter'] ?? '';
                    } else {
                        $instock_value = isset( $_GET['instock_filter'] ) ? '1' : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    }
                    $input_hidden = array(
                        'class' => $filter_for . ' instock_filter',
                        'name'  => 'instock_filter',
                        'value' => $instock_value,
                    );
                    array_push( $render_array['input_hidden'], $input_hidden );
                    $key_filter[] = 'instock_filter';
                }
                $render_array['key_filter'] = implode( ',', $key_filter );
                break;
            case 'filter_by_name_product':
                $placeholder_text_field = $placeholder_search ?? '';
                $trending_search        = $trending_search ?? '';
                if ( $this->data->get_params( 'seo_rule' ) ) {
                    $viwcpf_format_link_search = $this->viwcpf_format_link_search();
                    $search_value              = $viwcpf_format_link_search['current_filter_val']['s'] ?? '';
                } else {
                    $search_value = isset( $_GET['s'] ) ? wc_clean( wp_unslash( $_GET['s'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                }
                $list_label_items           = array(
                    'placeholder'     => $placeholder_text_field,
                    'search_value'    => $search_value,
                    'trending_search' => $trending_search
                );
                $render_array['list_value'] = array(
                    'label'      => '',
                    'value'      => $list_label_items,
                    'tooltip'    => '',
                    'link'       => '',
                    'count'      => '',
                    'class_name' => '',
                    'data_attr'  => ''
                );

                $render_array['key_filter'] = 's';
                $input_hidden               = array(
                    'class' => $filter_for . ' s',
                    'name'  => 's',
                    'value' => $search_value,
                );
                array_push( $render_array['input_hidden'], $input_hidden );
                break;
            case 'filter_by_metabox':
                $class_name = '';
                switch ( $meta_type_filter ) {

                    case 'string':
                        foreach ( $customize_value as $key => $label_item ) {
                            $label      = empty( $label_item['new_label'] ) ? $label_item['old_label'] : $label_item['new_label'];
                            $metavalue  = sanitize_text_field( $label_item['old_label'] );
                            $tooltip    = ! empty( $label_item['tooltip'] ) ? $label_item['tooltip'] : '';
                            $class_name = '';
                            if ( $tooltip != '' ) {
                                $data_tooltip = urlencode( $tooltip );
                            } else {
                                $data_tooltip = '';
                            }

                            $count = $this->get_filtered_metadata_product_counts( $meta_key_filter, $metavalue, $meta_type_filter );
                            //							if ( $count <= 0 ) {
                            //								continue;
                            //							}
                            $arr_name_param_url = array(
                                'viwcpf_metakey_type_' . $meta_key_filter,
                                'viwcpf_metakey_' . $meta_key_filter
                            );
                            if (
                                ! empty( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                ! empty( $_GET[ 'viwcpf_metakey_type_' . $meta_key_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            ) {
                                $link = remove_query_arg( $arr_name_param_url );
                            } else {
                                $link = $base_link;
                            }
                            unset( $current_url_param[ 'viwcpf_metakey_' . $meta_key_filter ] );
                            unset( $current_url_param[ 'viwcpf_metakey_type_' . $meta_key_filter ] );
                            if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                                foreach ( $current_url_param as $key_param => $value_param ) {
                                    $link = add_query_arg( $key_param, $value_param, $link );
                                }
                            }

                            if (
                                ! isset( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                ! isset( $_GET[ 'viwcpf_metakey_type_' . $meta_key_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            ) {
                                $arr_add_meta_param_url = array(
                                    'viwcpf_metakey_' . $meta_key_filter      => $label_item['old_label'],
                                    'viwcpf_metakey_type_' . $meta_key_filter => 'string'
                                );
                                $link                   = add_query_arg( $arr_add_meta_param_url, $link );

                            } else {
                                if (
                                    ( $label_item['old_label'] !== $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                ) {
                                    $arr_add_meta_param_url = array(
                                        'viwcpf_metakey_' . $meta_key_filter      => $label_item['old_label'],
                                        'viwcpf_metakey_type_' . $meta_key_filter => 'string'
                                    );
                                    $link                   = add_query_arg( $arr_add_meta_param_url, $link );
                                } else {
                                    $class_name = 'viwcpf_chosen';
                                }
                            }

                            $list_label_items = array(
                                'label'      => ( $label ),
                                'value'      => ( $label_item['old_label'] ),
                                'tooltip'    => $data_tooltip,
                                'link'       => ( $link ),
                                'count'      => ( $count ),
                                'class_name' => $class_name,
                                'data_attr'  => 'data-filter_by=' . esc_attr( $filter_for ) . ''
                            );
                            array_push( $render_array['list_value'], $list_label_items );
                        }
                        break;
                    case 'numberic':
                        foreach ( $customize_value as $key => $label_item ) {
                            if ( ! isset( $label_item['limitless'] ) ) {
                                $label     = sanitize_text_field( $label_item['min'] ) . esc_html( ' - ' ) . sanitize_text_field( $label_item['max'] );
                                $metavalue = sanitize_text_field( $label_item['min'] . '-' . $label_item['max'] );
                            } else {
                                $label     = sanitize_text_field( $label_item['min'] ) . esc_html__( ' - & above', 'pofily-woocommerce-product-filters' );
                                $metavalue = sanitize_text_field( $label_item['min'] );
                            }
                            $tooltip = $label;
                            if ( $tooltip != '' ) {
                                $data_tooltip = urlencode( $tooltip );
                            } else {
                                $data_tooltip = '';
                            }

                            $count = $this->get_filtered_metadata_product_counts( $meta_key_filter, $metavalue, $meta_type_filter );


                            if ( $count <= 0 ) {
                                continue;
                            }
                            $arr_name_param_url = array(
                                'viwcpf_metakey_type_' . $meta_key_filter,
                                'viwcpf_metakey_' . $meta_key_filter
                            );
                            if (
                                ! empty( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                ! empty( $_GET[ 'viwcpf_metakey_type_' . $meta_key_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            ) {
                                $link = remove_query_arg( $arr_name_param_url, $base_link );
                            } else {
                                $link = $base_link;
                            }
                            unset( $current_url_param[ 'viwcpf_metakey_' . $meta_key_filter ] );
                            unset( $current_url_param[ 'viwcpf_metakey_type_' . $meta_key_filter ] );
                            if ( is_array( $current_url_param ) && sizeof( $current_url_param ) > 0 ) {
                                foreach ( $current_url_param as $key_param => $value_param ) {
                                    $link = add_query_arg( $key_param, $value_param, $link );
                                }
                            }
                            if (
                                ! isset( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                ! isset( $_GET[ 'viwcpf_metakey_type_' . $meta_key_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            ) {
                                $arr_add_meta_param_url = array(
                                    'viwcpf_metakey_' . $meta_key_filter      => $metavalue,
                                    'viwcpf_metakey_type_' . $meta_key_filter => 'numberic'
                                );
                                $link                   = add_query_arg( $arr_add_meta_param_url, $link );
                            } else {
                                if (
                                    ( $metavalue !== $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) &&// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                    ( 'numberic' !== $_GET[ 'viwcpf_metakey_type_' . $meta_key_filter ] )// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                                ) {
                                    $arr_add_meta_param_url = array(
                                        'viwcpf_metakey_' . $meta_key_filter      => $metavalue,
                                        'viwcpf_metakey_type_' . $meta_key_filter => 'numberic'
                                    );
                                    $link                   = add_query_arg( $arr_add_meta_param_url, $link );
                                } else {
                                    $class_name = 'viwcpf_chosen';
                                }
                            }
                            $list_label_items = array(
                                'label'      => ( $label ),
                                'value'      => ( $metavalue ),
                                'tooltip'    => $data_tooltip,
                                'link'       => ( $link ),
                                'count'      => ( $count ),
                                'class_name' => $class_name,
                                'data_attr'  => 'data-filter_by=' . esc_attr( $filter_for ) . ''
                            );
                            array_push( $render_array['list_value'], $list_label_items );
                        }
                        break;
                    default:
                        break;
                }

                $input_hidden = array(
                    'class' => $filter_for . ' hidden_meta_value viwcpf_metakey_' . $meta_key_filter,
                    'name'  => 'viwcpf_metakey_' . $meta_key_filter,
                    'value' => isset( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) ? wc_clean( wp_unslash( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) ) : '',// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                );
                array_push( $render_array['input_hidden'], $input_hidden );
                $input_hidden = '<input type="hidden" class="' . esc_attr( $filter_for ) . '" name="' . esc_attr( 'viwcpf_metakey_type_' . $meta_key_filter ) . '" value="' . esc_attr( $meta_type_filter ) . '" disabled>';
                $input_hidden = array(
                    'class' => 'hidden_meta_type viwcpf_metakey_type_' . $meta_key_filter,
                    'name'  => 'viwcpf_metakey_type_' . $meta_key_filter,
                    'value' => $meta_type_filter,
                );
                array_push( $render_array['input_hidden'], $input_hidden );
                $render_array['key_filter'] = 'viwcpf_metakey_' . $meta_key_filter . ',' . 'viwcpf_metakey_type_' . $meta_key_filter;
                break;
            default:
                break;
        }

        return $render_array;
    }

    /*
    *
    * Function render value for block filter type ranger slide
    *
    * @param $filter_name
    * @param $filter_for
    * @param $filter_data    Array save data of block menu filter.
    * @param $filter_setting Array save setting of block menu filter.
    * @var $multiselect
    * return array()
    */
    public function viwcpf_render_value_block_range_slide( $filter_name, $filter_for, $filter_data, $filter_setting ) {
        if (
            empty( $filter_for ) &&
            empty( $filter_data )
        ) {
            return;
        }
        extract( $filter_data );
        extract( $filter_setting );

        global $wp;
        $render_array = array(
            'key_filter'      => '',
            'list_value'      => array(),
            'input_hidden'    => array(),
            'multiselect'     => '',
            'show_clear_btn'  => $show_clear,
            'multi_relation'  => '',
            'show_count_item' => '',
            'display_type'    => '',
            'show_view_more'  => $show_view_more,
            'view_more_limit' => $view_more_limit
        );
        switch ( $filter_for ) {
            case 'filter_by_price':
                $filtered_price = $this->get_filtered_price();
                /*Compatible with multi currency*/
                $filtered_min_price = apply_filters( 'wmc_change_3rd_plugin_price', $filtered_price->min_price );
                $filtered_max_price = apply_filters( 'wmc_change_3rd_plugin_price', $filtered_price->max_price );
                $step_price         = ! empty( $customize_value['step_price'] ) ? $customize_value['step_price'] : 1;
                if ( class_exists( 'WOOMULTI_CURRENCY_Data' ) ) {
                    $wmc = WOOMULTI_CURRENCY_Data::get_ins();

                    $wmc_current_currency = $wmc->get_current_currency();
                    $list_currencies      = $wmc->get_list_currencies();

                    $current_rate = $list_currencies[ $wmc_current_currency ]['rate'];
                    $step_price   = round( floatval( $current_rate ) * $step_price );

                } elseif ( class_exists( 'WOOMULTI_CURRENCY_F_Data' ) ) {
                    $wmc = WOOMULTI_CURRENCY_F_Data::get_ins();

                    $wmc_current_currency = $wmc->get_current_currency();
                    $list_currencies      = $wmc->get_list_currencies();

                    $current_rate = $list_currencies[ $wmc_current_currency ]['rate'];

                    $step_price = round( floatval( $current_rate ) * $step_price );


                }

                $min_price = ( $customize_value['min_price'] != '' ) ? apply_filters( 'wmc_change_3rd_plugin_price', $customize_value['min_price'] ) : $filtered_min_price;
                $max_price = ( $customize_value['max_price'] != '' ) ? apply_filters( 'wmc_change_3rd_plugin_price', $customize_value['max_price'] ) : $filtered_max_price;

                $min_price = floor( $min_price / $step_price ) * $step_price;
                $max_price = ceil( $max_price / $step_price ) * $step_price;

                $list_label_items           = array(
                    'min_range_slide'  => $min_price,
                    'max_range_slide'  => $max_price,
                    'step_range_slide' => $step_price
                );
                $render_array['list_value'] = array(
                    'label'      => '',
                    'value'      => $list_label_items,
                    'tooltip'    => '',
                    'link'       => '',
                    'count'      => '',
                    'class_name' => '',
                    'data_attr'  => 'data-min="' . esc_attr( $customize_value['min_price'] ) . '" data-max="' . esc_attr( $customize_value['max_price'] ) . '" data-step="' . esc_attr( $customize_value['step_price'] ) . '"'
                );

                $input_hidden = array(
                    'class' => $filter_for . ' min_price',
                    'name'  => 'min_price',
                    'value' => isset( $_GET['min_price'] ) ? wc_clean( wp_unslash( $_GET['min_price'] ) ) : '',// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                );
                array_push( $render_array['input_hidden'], $input_hidden );

                $input_hidden = array(
                    'class' => $filter_for . ' max_price',
                    'name'  => 'max_price',
                    'value' => isset( $_GET['max_price'] ) ? wc_clean( wp_unslash( $_GET['max_price'] ) ) : '',// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                );
                array_push( $render_array['input_hidden'], $input_hidden );

                $render_array['key_filter'] = 'min_price,max_price';
                break;
            case 'filter_by_metabox':
                $class_name = '';
                if ( $meta_type_filter == 'numberic' ) {
                    $step_range_slide      = ! empty( $customize_value['meta_range_step'] ) ? $customize_value['meta_range_step'] : 1;
                    $min_default_metavalue = $this->viwcpf_get_min_max_meta_values( $meta_key_filter, 'min' );
                    $max_default_metavalue = $this->viwcpf_get_min_max_meta_values( $meta_key_filter, 'max' );
                    $min_range_slide       = ( $customize_value['meta_range_min'] != '' ) ? $customize_value['meta_range_min'] : $min_default_metavalue;
                    $max_range_slide       = ( $customize_value['meta_range_max'] != '' ) ? $customize_value['meta_range_max'] : $max_default_metavalue;

                    $min_range_slide            = floor( $min_range_slide / $step_range_slide ) * $step_range_slide;
                    $max_range_slide            = ceil( $max_range_slide / $step_range_slide ) * $step_range_slide;
                    $list_label_items           = array(
                        'name_metakey'     => $meta_key_filter,
                        'min_range_slide'  => $min_range_slide,
                        'max_range_slide'  => $max_range_slide,
                        'step_range_slide' => $step_range_slide
                    );
                    $render_array['list_value'] = array(
                        'label'      => '',
                        'value'      => $list_label_items,
                        'tooltip'    => '',
                        'link'       => '',
                        'count'      => '',
                        'class_name' => '',
                        'data_attr'  => 'data-min="' . esc_attr( $customize_value['meta_range_min'] ) . '" data-max="' . esc_attr( $customize_value['meta_range_max'] ) . '" data-step="' . esc_attr( $customize_value['meta_range_step'] ) . '"'
                    );
                }

                $input_hidden = array(
                    'class' => $filter_for . ' hidden_meta_value viwcpf_metakey_' . $meta_key_filter,
                    'name'  => 'viwcpf_metakey_' . $meta_key_filter,
                    'value' => isset( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) ? wc_clean( wp_unslash( $_GET[ 'viwcpf_metakey_' . $meta_key_filter ] ) ) : '',// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                );
                array_push( $render_array['input_hidden'], $input_hidden );
                $input_hidden = array(
                    'class' => 'hidden_meta_type viwcpf_metakey_type_' . $meta_key_filter,
                    'name'  => 'viwcpf_metakey_type_' . $meta_key_filter,
                    'value' => $meta_type_filter,
                );
                array_push( $render_array['input_hidden'], $input_hidden );
                $render_array['key_filter'] = 'viwcpf_metakey_' . $meta_key_filter . ',' . 'viwcpf_metakey_type_' . $meta_key_filter;
                break;
            default:
                break;
        }

        return $render_array;
    }

    public function viwcpf_format_link_tax( $prefix, $filter_val, $multiselect, $query_type = '' ) {
        $class_name         = '';
        $link               = '';
        $current_filter_val = [];
        if ( $this->data->get_params( 'seo_rule' ) && $this->seoFrontend->isFilterSeo() ) {
            global $wp_rewrite;
            $page_slug           = $wp_rewrite->pagination_base;
            $base_link           = $_SERVER['REQUEST_URI'];
            $viwcpfFilterRequest = get_query_var( 'viwcpfFilterRequest' );
            $viwcpfFilterRequest = $this->viwcpf_render_seo_uri_param( $viwcpfFilterRequest );

            /*Change prefix*/
            switch ( $prefix ) {
                case 'product_cat';
                    $prefix = apply_filters( 'VIWCPF_seo_product_cat_slug', 'product_cat' );
                    break;
                case 'product_tag';
                    $prefix = apply_filters( 'VIWCPF_seo_product_tag_slug', 'product_tag' );
                    break;
                default:
                    $prefix = str_replace( 'filter_', '', $prefix );
                    break;
            }

            if ( ! empty( $viwcpfFilterRequest ) ) {
                $parse_url          = wp_parse_url( $base_link );
                $parse_url_path     = $parse_url['path'];
                $parse_url_arr_path = explode( '/', $parse_url_path );
                if ( $multiselect ) {
                    $current_filter_val = isset( $viwcpfFilterRequest[ $prefix ]['value'] ) ? $viwcpfFilterRequest[ $prefix ]['value'] : [];
                    $string_term        = '';

                    if ( ! empty( $current_filter_val ) && is_array( $current_filter_val ) ) {

                        foreach ( $current_filter_val as $item_val ) {

                            if ( $filter_val == $item_val ) {
                                $class_name = 'viwcpf_chosen';
                                continue;
                            }
                            if ( strtolower( $query_type ) == 'or' ) {
                                $string_term .= $item_val . '--';
                            } else {
                                $string_term .= $item_val . '---';
                            }
                        }
                        if ( $class_name == '' ) {
                            $string_term .= $filter_val . '---';
                        }

                        $string_term = rtrim( $string_term, '---' );
                        $string_term = rtrim( $string_term, '--' );
                    } else {
                        $string_term = $filter_val;
                    }

                    $isset_term = false;
                    foreach ( $parse_url_arr_path as $url_path_key => $url_path_value ) {
                        /*remove page and page number from url*/
                        if ( $url_path_value == $page_slug ) {
                            unset( $parse_url_arr_path[ $url_path_key ] );
                            unset( $parse_url_arr_path[ $url_path_key + 1 ] );
                        }
                        if ( strpos( $url_path_value, $prefix ) !== false ) {
                            if ( ! empty( $string_term ) ) {
                                $parse_url_arr_path[ $url_path_key ] = $prefix . '-' . $string_term;

                            } else {
                                unset( $parse_url_arr_path[ $url_path_key ] );
                            }
                            $isset_term = true;
                        }

                    }

                    if ( ! $isset_term ) {
                        $parse_url_arr_path[] = $prefix . '-' . $string_term;
                    }
                    $new_parse_url_path = implode( '/', $parse_url_arr_path );

                    if ( strpos( $base_link, '?' ) !== false ) {
                        $link = $new_parse_url_path . '/?' . $parse_url['query'];
                    } else {
                        $link = $new_parse_url_path;

                    }

                } else {
                    $string_term        = $filter_val;
                    $current_filter_val = isset( $viwcpfFilterRequest[ $prefix ]['value'] ) ? $viwcpfFilterRequest[ $prefix ]['value'] : [];
                    if ( ! empty( $current_filter_val ) ) {
                        foreach ( $current_filter_val as $item_val ) {
                            if ( $filter_val == $item_val ) {
                                $class_name  = 'viwcpf_chosen';
                                $string_term = '';
                            }
                        }
                    }
                    $isset_term = false;
                    foreach ( $parse_url_arr_path as $url_path_key => $url_path_value ) {
                        /*remove page and page number from url*/
                        if ( $url_path_value == $page_slug ) {
                            unset( $parse_url_arr_path[ $url_path_key ] );
                            unset( $parse_url_arr_path[ $url_path_key + 1 ] );
                        }
                        if ( strpos( $url_path_value, $prefix ) !== false ) {
                            if ( ! empty( $string_term ) ) {
                                $parse_url_arr_path[ $url_path_key ] = $prefix . '-' . $string_term;
                            } else {
                                unset( $parse_url_arr_path[ $url_path_key ] );
                            }
                            $isset_term = true;
                        }
                    }
                    if ( ! $isset_term ) {
                        $parse_url_arr_path[] = $prefix . '-' . $string_term;
                    }
                    $new_parse_url_path = implode( '/', $parse_url_arr_path );
                    if ( strpos( $base_link, '?' ) !== false ) {
                        $link = $new_parse_url_path . '/?' . $parse_url['query'];
                    } else {
                        $link = $new_parse_url_path;

                    }
                }

            } else {
                $string_term    = $filter_val;
                $base_link      = $this->viwcpf_get_current_page_url();
                $parse_url      = wp_parse_url( $base_link );
                $parse_url_path = $parse_url['path'];
                if ( strpos( $base_link, '?' ) !== false ) {

                    $link = $parse_url_path . $prefix . '-' . $string_term . '/?' . $parse_url['query'];
                } else {
                    $link = $parse_url_path . '/' . $prefix . '-' . $string_term . '/';
                }
            }

        }

        return [
            'link'               => str_replace( '//', '/', $link ),
            'class_name'         => $class_name,
            'current_filter_val' => $current_filter_val
        ];
    }

    public function viwcpf_format_link_price( $min_price, $max_price ) {
        $class_name         = '';
        $link               = '';
        $current_filter_val = [];
        if ( $this->data->get_params( 'seo_rule' ) && $this->seoFrontend->isFilterSeo() ) {
            global $wp_rewrite;
            $page_slug           = $wp_rewrite->pagination_base;
            $base_link           = $_SERVER['REQUEST_URI'];
            $viwcpfFilterRequest = get_query_var( 'viwcpfFilterRequest' );
            $viwcpfFilterRequest = $this->viwcpf_render_seo_uri_param( $viwcpfFilterRequest );

            /*Change prefix*/

            $prefix_min     = apply_filters( 'VIWCPF_seo_product_min_price_slug', 'minprice' );
            $prefix_max     = apply_filters( 'VIWCPF_seo_product_max_price_slug', 'maxprice' );
            $min_price_item = $min_price;
            $max_price_item = $max_price;

            if ( ! empty( $viwcpfFilterRequest ) ) {
                $parse_url          = wp_parse_url( $base_link );
                $parse_url_path     = $parse_url['path'];
                $parse_url_arr_path = explode( '/', $parse_url_path );


                $current_min                     = $viwcpfFilterRequest[ $prefix_min ]['value'][0] ?? '';
                $current_max                     = $viwcpfFilterRequest[ $prefix_max ]['value'][0] ?? '';
                $current_filter_val['min_price'] = $current_min;
                $current_filter_val['max_price'] = $current_max;
                $isset_min_price                 = false;
                $isset_max_price                 = false;
                foreach ( $parse_url_arr_path as $url_path_key => $url_path_value ) {
                    /*remove page and page number from url*/
                    if ( $url_path_value == $page_slug ) {
                        unset( $parse_url_arr_path[ $url_path_key ] );
                        unset( $parse_url_arr_path[ $url_path_key + 1 ] );
                    }
                    if (
                        ( strpos( $url_path_value, $prefix_min ) !== false ) || ( strpos( $url_path_value, $prefix_max ) !== false )
                    ) {
                        if ( strpos( $url_path_value, $prefix_min ) !== false ) {
                            if ( $current_min == $min_price_item ) {
                                $isset_min_price = true;
                            }
                        }
                        if ( strpos( $url_path_value, $prefix_max ) !== false ) {
                            if ( $current_max == $max_price_item ) {
                                $isset_max_price = true;
                            }
                        }
                        unset( $parse_url_arr_path[ $url_path_key ] );
                    }
                }

                if ( ! empty( $min_price_item ) ) {
                    $parse_url_arr_path[] = $prefix_min . '-' . $min_price_item;
                }

                if ( ! empty( $max_price_item ) ) {
                    $parse_url_arr_path[] = $prefix_max . '-' . $max_price_item;
                }

                if ( $isset_min_price && $isset_max_price ) {
                    $class_name = 'viwcpf_chosen';
                }
                $new_parse_url_path = implode( '/', $parse_url_arr_path );
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link = $new_parse_url_path . '/?' . $parse_url['query'];
                } else {
                    $link = $new_parse_url_path;

                }

            } else {

                $base_link      = $this->viwcpf_get_current_page_url();
                $parse_url      = wp_parse_url( $base_link );
                $parse_url_path = $parse_url['path'];
                $link           = $parse_url_path;
                if ( ! empty( $min_price_item ) ) {
                    $link .= '/' . $prefix_min . '-' . $min_price_item;
                }
                if ( ! empty( $max_price_item ) ) {
                    $link .= '/' . $prefix_max . '-' . $max_price_item;
                }
                $link .= '/';
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link .= '?' . $parse_url['query'];
                }
            }

        }
        /*Remove filter price by param*/
        $link = remove_query_arg( 'min_price', $link );
        $link = remove_query_arg( 'max_price', $link );

        return [
            'link'               => str_replace( '//', '/', $link ),
            'class_name'         => $class_name,
            'current_filter_val' => $current_filter_val
        ];
    }

    public function viwcpf_format_link_sale_or_stock( $type ) {
        $class_name         = '';
        $link               = '';
        $current_filter_val = [];
        if ( $this->data->get_params( 'seo_rule' ) && $this->seoFrontend->isFilterSeo() ) {
            global $wp_rewrite;
            $page_slug           = $wp_rewrite->pagination_base;
            $base_link           = $_SERVER['REQUEST_URI'];
            $viwcpfFilterRequest = get_query_var( 'viwcpfFilterRequest' );
            $viwcpfFilterRequest = $this->viwcpf_render_seo_uri_param( $viwcpfFilterRequest );

            /*Change prefix*/

            $prefix_onsale  = apply_filters( 'VIWCPF_seo_product_onsale_slug', 'isOnsale' );
            $prefix_instock = apply_filters( 'VIWCPF_seo_product_instock_slug', 'isInstock' );

            if ( ! empty( $viwcpfFilterRequest ) ) {
                $parse_url          = wp_parse_url( $base_link );
                $parse_url_path     = $parse_url['path'];
                $parse_url_arr_path = explode( '/', $parse_url_path );
                $is_onsale          = false;
                $is_instock         = false;
                foreach ( $parse_url_arr_path as $url_path_key => $url_path_value ) {
                    /*remove page and page number from url*/
                    if ( $url_path_value == $page_slug ) {
                        unset( $parse_url_arr_path[ $url_path_key ] );
                        unset( $parse_url_arr_path[ $url_path_key + 1 ] );
                    }

                    if ( ( strpos( $url_path_value, $prefix_onsale ) !== false ) && ( $type == 'onsale' ) ) {
                        $class_name = 'viwcpf_chosen';
                        unset( $parse_url_arr_path[ $url_path_key ] );
                        $is_onsale                           = true;
                        $current_filter_val['onsale_filter'] = 1;
                    }

                    if ( ( strpos( $url_path_value, $prefix_instock ) !== false ) && ( $type == 'instock' ) ) {
                        $class_name = 'viwcpf_chosen';
                        unset( $parse_url_arr_path[ $url_path_key ] );
                        $is_instock                           = true;
                        $current_filter_val['instock_filter'] = 1;
                    }

                }
                if ( ! $is_onsale && ( $type == 'onsale' ) ) {
                    $parse_url_arr_path[] = $prefix_onsale;
                }
                if ( ! $is_instock && ( $type == 'instock' ) ) {
                    $parse_url_arr_path[] = $prefix_instock;
                }

                $new_parse_url_path = implode( '/', $parse_url_arr_path );
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link = $new_parse_url_path . '/?' . $parse_url['query'];
                } else {
                    $link = $new_parse_url_path;

                }

            } else {

                $base_link      = $this->viwcpf_get_current_page_url();
                $parse_url      = wp_parse_url( $base_link );
                $parse_url_path = $parse_url['path'];
                $link           = $parse_url_path;
                if ( $type == 'onsale' ) {
                    $link .= '/' . $prefix_onsale;
                }
                if ( $type == 'instock' ) {
                    $link .= '/' . $prefix_instock;
                }
                $link .= '/';
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link .= '?' . $parse_url['query'];
                }
            }

        }

        return [
            'link'               => str_replace( '//', '/', $link ),
            'class_name'         => $class_name,
            'current_filter_val' => $current_filter_val,
        ];
    }

    public function viwcpf_format_link_review( $rate ) {
        $class_name         = '';
        $link               = '';
        $current_filter_val = [];
        if ( $this->data->get_params( 'seo_rule' ) && $this->seoFrontend->isFilterSeo() ) {
            global $wp_rewrite;
            $page_slug           = $wp_rewrite->pagination_base;
            $base_link           = $_SERVER['REQUEST_URI'];
            $viwcpfFilterRequest = get_query_var( 'viwcpfFilterRequest' );
            $viwcpfFilterRequest = $this->viwcpf_render_seo_uri_param( $viwcpfFilterRequest );

            /*Change prefix*/

            $prefix_rating      = apply_filters( 'VIWCPF_seo_product_review_slug', 'rating' );
            $rating_number_item = $rate;

            if ( ! empty( $viwcpfFilterRequest ) ) {
                $parse_url          = wp_parse_url( $base_link );
                $parse_url_path     = $parse_url['path'];
                $parse_url_arr_path = explode( '/', $parse_url_path );


                $current_rating_number = $viwcpfFilterRequest[ $prefix_rating ]['value'][0] ?? '';

                $isset_rating_number = false;
                foreach ( $parse_url_arr_path as $url_path_key => $url_path_value ) {
                    /*remove page and page number from url*/
                    if ( $url_path_value == $page_slug ) {
                        unset( $parse_url_arr_path[ $url_path_key ] );
                        unset( $parse_url_arr_path[ $url_path_key + 1 ] );
                    }
                    if ( strpos( $url_path_value, $prefix_rating ) !== false ) {

                        if ( $rating_number_item == $current_rating_number ) {
                            $isset_rating_number = true;

                        }

                        unset( $parse_url_arr_path[ $url_path_key ] );
                    }
                }

                if ( ! empty( $rating_number_item ) ) {
                    $parse_url_arr_path[] = $prefix_rating . '-' . $rating_number_item;
                }

                if ( $isset_rating_number ) {
                    $class_name                          = 'viwcpf_chosen';
                    $current_filter_val['rating_filter'] = $rating_number_item;
                }
                $new_parse_url_path = implode( '/', $parse_url_arr_path );
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link = $new_parse_url_path . '/?' . $parse_url['query'];
                } else {
                    $link = $new_parse_url_path;

                }

            } else {

                $base_link      = $this->viwcpf_get_current_page_url();
                $parse_url      = wp_parse_url( $base_link );
                $parse_url_path = $parse_url['path'];
                $link           = $parse_url_path;
                if ( ! empty( $rating_number_item ) ) {
                    $link .= '/' . $prefix_rating . '-' . $rating_number_item;
                }
                $link .= '/';
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link .= '?' . $parse_url['query'];
                }
            }

        }


        return [
            'link'               => str_replace( '//', '/', $link ),
            'class_name'         => $class_name,
            'current_filter_val' => $current_filter_val,
        ];
    }

    public function viwcpf_format_link_search() {
        $class_name         = '';
        $link               = '';
        $current_filter_val = [];
        if ( $this->data->get_params( 'seo_rule' ) && $this->seoFrontend->isFilterSeo() ) {
            global $wp_rewrite;
            $page_slug           = $wp_rewrite->pagination_base;
            $base_link           = $_SERVER['REQUEST_URI'];
            $viwcpfFilterRequest = get_query_var( 'viwcpfFilterRequest' );
            $viwcpfFilterRequest = $this->viwcpf_render_seo_uri_param( $viwcpfFilterRequest );

            /*Change prefix*/

            $prefix_search = apply_filters( 'VIWCPF_seo_product_search_slug', 'textsearch' );


            if ( ! empty( $viwcpfFilterRequest ) ) {
                $parse_url          = wp_parse_url( $base_link );
                $parse_url_path     = $parse_url['path'];
                $parse_url_arr_path = explode( '/', $parse_url_path );

                $current_text_search = $viwcpfFilterRequest[ $prefix_search ]['value'][0] ?? '';

                foreach ( $parse_url_arr_path as $url_path_key => $url_path_value ) {
                    /*remove page and page number from url*/
                    if ( $url_path_value == $page_slug ) {
                        unset( $parse_url_arr_path[ $url_path_key ] );
                        unset( $parse_url_arr_path[ $url_path_key + 1 ] );
                    }
                    if ( strpos( $url_path_value, $prefix_search ) !== false ) {
                        $current_filter_val['s'] = $current_text_search;
                        unset( $parse_url_arr_path[ $url_path_key ] );
                    }
                }

                if ( ! empty( $current_text_search ) ) {
                    $parse_url_arr_path[] = $prefix_search . '-' . $current_text_search;
                }


                $new_parse_url_path = implode( '/', $parse_url_arr_path );
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link = $new_parse_url_path . '/?' . $parse_url['query'];
                } else {
                    $link = $new_parse_url_path;

                }

            } else {

                $base_link      = $this->viwcpf_get_current_page_url();
                $parse_url      = wp_parse_url( $base_link );
                $parse_url_path = $parse_url['path'];
                $link           = $parse_url_path;
                if ( ! empty( $current_text_search ) ) {
                    $parse_url_arr_path[] = $prefix_search . '-' . $current_text_search;
                }
                $link .= '/';
                if ( strpos( $base_link, '?' ) !== false ) {
                    $link .= '?' . $parse_url['query'];
                }
            }

        }


        return [
            'link'               => str_replace( '//', '/', $link ),
            'class_name'         => $class_name,
            'current_filter_val' => $current_filter_val,
        ];
    }


    public function viwcpf_render_seo_uri_param( $viwcpfFilterRequest ) {
        $arr_filterRequest      = [];
        $arr_filter_single_slug = [ 'isOnsale', 'isInstock' ];
        if ( ! empty( $viwcpfFilterRequest ) ) {

            $arr_viwcpfFilterRequest = explode( '/', $viwcpfFilterRequest );

            foreach ( $arr_viwcpfFilterRequest as $val ) {
                $new_val = explode( '-', $val );

                if ( count( $new_val ) > 1 ) {
                    $filter_slug = $new_val[0];
                    $val_filter  = mb_substr( str_replace( $filter_slug, '', $val ), 1 );

                    $arr_val_filter = explode( '---', $val_filter );
                    if ( count( $arr_val_filter ) <= 1 ) {
                        $arr_val_filter = explode( '--', $arr_val_filter[0] );
                    }
                    $arr_filterRequest[ $filter_slug ]['value'] = $arr_val_filter;

                } else {
                    if ( in_array( $val, $arr_filter_single_slug ) ) {
                        $arr_filterRequest[ $val ]['value'] = [ true ];
                    }
                }
            }

        }

        return $arr_filterRequest;
    }

    /**
     * Returns a formatted list of terms, matching current selection and according to hierarchy options
     *
     * @return array term_id
     */
    public function get_formatted_terms( $tax_name, $arr_terms, $order_by, $order_type ) {
        if (
            empty( $tax_name ) ||
            empty( $arr_terms ) ||
            empty( $order_by ) ||
            empty( $order_type )
        ) {
            return;
        }

        $result = array();

        $sorted_terms = get_terms(
            array(
                'taxonomy' => $tax_name,
                'include'  => $arr_terms,
                'orderby'  => $order_by,
                'order'    => strtoupper( $order_type ),
                'fields'   => 'ids',
            )
        );

        if ( ! is_a( $sorted_terms, 'WP_Error' ) ) {
            if ( ! empty( $sorted_terms ) ) {
                foreach ( $sorted_terms as $item_sorted_term ) {
                    array_push( $result, $item_sorted_term );
                }
            }
        }

        return $result;
    }

    /**
     * Get current page URL with various filtering props supported by WC.
     *
     * @return string
     */
    protected function viwcpf_get_current_page_url() {
        if ( is_admin() ) {
            return '';
        }
        $link = '';
        if ( is_shop() ) {
            $link = get_the_permalink( wc_get_page_id( 'shop' ) );
        } elseif ( is_product_category() ) {
            $link = get_term_link( get_query_var( 'product_cat' ), 'product_cat' );
        } elseif ( is_product_tag() ) {
            $link = get_term_link( get_query_var( 'product_tag' ), 'product_tag' );
        } else {
            $queried_object = get_queried_object();
            if ( isset( $queried_object->slug ) && isset( $queried_object->taxonomy ) ) {
                $link = get_term_link( $queried_object->slug, $queried_object->taxonomy );
            }
            /*Compa with perfect brand*/
            if ( is_plugin_active( 'perfect-woocommerce-brands/perfect-woocommerce-brands.php' ) ) {
                global $wp;
                $link = add_query_arg( $wp->query_vars, home_url( $wp->request ) );
            }
        }

        if ( is_wp_error( $link ) ) {
            return '';
        }

        // Min/Max.
        if ( isset( $_GET['min_price'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'min_price', wc_clean( wp_unslash( $_GET['min_price'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        }

        if ( isset( $_GET['max_price'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'max_price', wc_clean( wp_unslash( $_GET['max_price'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        }
        // Order by.
        if ( isset( $_GET['orderby'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'orderby', wc_clean( wp_unslash( $_GET['orderby'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        }

        /**
         * Search Arg.
         * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
         */
        if ( get_search_query() ) {
            $link = add_query_arg( 's', rawurlencode( htmlspecialchars_decode( get_search_query() ) ), $link );
        }

        // Post Type Arg.
        if ( isset( $_GET['post_type'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'post_type', wc_clean( wp_unslash( $_GET['post_type'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended

            // Prevent post type and page id when pretty permalinks are disabled.
            if ( is_shop() ) {
                $link = remove_query_arg( 'page_id', $link );
            }
        }

        // Min Rating Arg.
        if ( isset( $_GET['rating_filter'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'rating_filter', wc_clean( wp_unslash( $_GET['rating_filter'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        }

        // onsale
        if ( isset( $_GET['onsale_filter'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'onsale_filter', wc_clean( wp_unslash( $_GET['onsale_filter'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        }
        // instock
        if ( isset( $_GET['instock_filter'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $link = add_query_arg( 'instock_filter', wc_clean( wp_unslash( $_GET['instock_filter'] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        }


        // All current filters.
        if ( $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes() ) { // phpcs:ignore Squiz.PHP.DisallowMultipleAssignments.Found, WordPress.CodeAnalysis.AssignmentInCondition.Found
            foreach ( $_chosen_attributes as $name => $data ) {
                $filter_name = wc_attribute_taxonomy_slug( $name );
                if ( ! empty( $data['terms'] ) ) {
                    $link = add_query_arg( 'filter_' . $filter_name, implode( ',', $data['terms'] ), $link );
                }
                if ( 'or' === $data['query_type'] ) {
                    $link = add_query_arg( 'query_type_' . $filter_name, 'or', $link );
                }
                if ( $filter_name == 'berocket_brand' ) {
                    $link = remove_query_arg( 'query_type_berocket_brand', $link );
                }
            }
        }


        $exclude_taxonomy_name = 'product_visibility';
        if ( $_chosen_tax_query = WC_Query::get_main_tax_query() ) { // phpcs:ignore Squiz.PHP.DisallowMultipleAssignments.Found, WordPress.CodeAnalysis.AssignmentInCondition.Found

            foreach ( $_chosen_tax_query as $data_tax_query ) {

                if (
                    isset( $data_tax_query['taxonomy'] ) &&
                    ( $data_tax_query['taxonomy'] !== $exclude_taxonomy_name )
                ) {
                    $filter_name         = $data_tax_query['taxonomy'];
                    $filter_name_replace = str_replace( 'product_', 'pofily-', $filter_name );
                    if ( isset( $_GET[ $filter_name_replace ] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        $link = add_query_arg( $filter_name_replace, wc_clean( wp_unslash( $_GET[ $filter_name_replace ] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        if ( isset( $_GET[ 'query_type_' . $filter_name ] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            $link = add_query_arg( 'query_type_' . $filter_name, wc_clean( wp_unslash( $_GET[ 'query_type_' . $filter_name ] ) ), $link );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        }
                    }
                }
            }

        }
        $_chosen_meta = [];
        if ( did_action( 'wp' ) && function_exists('WC')
            && WC()->query instanceof WC_Query && WC_Query::get_main_query()) {
            $_chosen_meta = WC_Query::get_main_meta_query();
        }

        if ( $_chosen_meta ) {
            foreach ( $_chosen_meta as $meta_data ) {
                if ( isset( $_GET['instock_filter'] ) || $this->data->get_params( 'hide_out_of_stock' ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    continue;
                }
                if ( ! empty( $meta_data['value'] ) ) {
                    $metakey_name = $meta_data['key'];
                    if ( isset( $meta_data['type'] ) && $meta_data['type'] == 'numeric' ) {
                        $meta_value = $meta_data['value'][0] . '-' . $meta_data['value'][1];
                        $meta_type  = 'numberic';
                    } else {
                        $meta_value = $meta_data['value'];
                        $meta_type  = 'string';
                    }
                    $link = add_query_arg( 'viwcpf_metakey_' . $metakey_name, $meta_value, $link );
                    $link = add_query_arg( 'viwcpf_metakey_type_' . $metakey_name, $meta_type, $link );
                }
            }
        }

        return apply_filters( 'viwcpf_get_current_page_url', $link, $this );
    }

    /**
     * Get clear link by $key_filter.
     *
     * @return string
     */
    public function viwcpf_get_clear_url( $key_filters ) {
        if ( empty( $key_filters ) ) {
            return;
        }
        $base_link       = $link = $this->viwcpf_get_current_page_url();
        $arr_key_filters = explode( ',', $key_filters );
        $has_filter      = false;

        if ( sizeof( $arr_key_filters ) > 0 ) {
            foreach ( $arr_key_filters as $key_filter ) {
                if ( array_key_exists( $key_filter, wc_clean( wp_unslash( $_GET ) ) ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    $has_filter = true;
                }
            }
            if ( $has_filter ) {
                $link = remove_query_arg( $arr_key_filters, $base_link );
            } else {
                $link = '';
            }

        } else {
            $link = '';
        }

        return apply_filters( 'viwcpf_get_clear_url', $link, $this );
    }

    /**
     * Get current query filtered active.
     *
     * @return string html
     */
    public function viwcpf_get_active_filter() {
        if ( ! is_shop() && ! is_product_taxonomy() ) {
            return;
        }

        $template              = '';
        $viwcpf_setting_params = get_option( 'viwcpf_setting_params' );
        if (
            $viwcpf_setting_params &&
            isset( $viwcpf_setting_params['option_style'] )
        ) {
            $option_style = $viwcpf_setting_params['option_style'];
        } else {
            $option_style = '';
        }
        $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes();
        $_chosen_meta       = WC_Query::get_main_meta_query();
        if ( ! empty( $_chosen_meta ) && is_array( $_chosen_meta ) ) {
            foreach ( $_chosen_meta as $key => $meta_data ) {
                if (
                    $this->data->get_params( 'hide_out_of_stock' ) &&
                    is_array( $meta_data ) &&
                    isset( $meta_data['key'] ) &&
                    $meta_data['key'] == '_stock_status'
                ) {
                    unset( $_chosen_meta[ $key ] );
                }
            }
        }
        $min_price      = isset( $_GET['min_price'] ) ? wc_clean( wp_unslash( $_GET['min_price'] ) ) : 0;// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $max_price      = isset( $_GET['max_price'] ) ? wc_clean( wp_unslash( $_GET['max_price'] ) ) : 0;// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $rating_filter  = isset( $_GET['rating_filter'] ) ? array_filter( array_map( 'absint', explode( ',', wc_clean( wp_unslash( $_GET['rating_filter'] ) ) ) ) ) : array(); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $onsale_filter  = isset( $_GET['onsale_filter'] ) ? wc_clean( wp_unslash( $_GET['onsale_filter'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $instock_filter = isset( $_GET['instock_filter'] ) ? wc_clean( wp_unslash( $_GET['instock_filter'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        if ( $this->data->get_params( 'hide_out_of_stock' ) ) {
            $instock_filter = '';
        }
        $search_filter = isset( $_GET['s'] ) ? wc_clean( wp_unslash( $_GET['s'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $base_link     = $this->viwcpf_get_current_page_url();

        $get_main_tax_query = WC_Query::get_main_tax_query();
        $_chosen_cat_or_tag = array(
            'product_cat'    => array(),
            'product_tag'    => array(),
            'colecciones'    => array(),
            'pwb-brand'      => array(),
            'berocket_brand' => array(),
            'product_brand'  => array(),
        );

        $arr_tax = apply_filters( 'pofily_arr_tax_active_filter', array( 'product_cat', 'product_tag', 'colecciones', 'pwb-brand', 'berocket_brand', 'product_brand' ) );
        foreach ( $get_main_tax_query as $tax_item ) {
            if ( is_array( $tax_item ) ) {
                if ( in_array( $tax_item['taxonomy'], $arr_tax ) ) {
                    $arr_tax_query = array(
                        'terms' => $tax_item['terms']
                    );
                    switch ( $tax_item['taxonomy'] ) {
                        case 'product_cat':
                            array_push( $_chosen_cat_or_tag['product_cat'], $arr_tax_query );
                            break;
                        case 'product_tag':
                            array_push( $_chosen_cat_or_tag['product_tag'], $arr_tax_query );
                            break;
                        case 'pwb-brand':
                            array_push( $_chosen_cat_or_tag['pwb-brand'], $arr_tax_query );
                            break;
                        case 'berocket_brand':
                            $_chosen_cat_or_tag['berocket_brand'][] = $arr_tax_query;
                            break;
                        default:
                            array_push( $_chosen_cat_or_tag[ $tax_item['taxonomy'] ], $arr_tax_query );
                            break;
                    }
                }
                if ( $this->data->get_params( 'seo_rule' ) ) {
                    $arr_tax[] = 'product_visibility';
                    /*Add active attribue tax query*/
                    if ( ! in_array( $tax_item['taxonomy'], $arr_tax ) ) {
                        $key_attribute = $tax_item['taxonomy'];
                        /*Check if exist query current attribute*/
                        if ( key_exists( $key_attribute, $_chosen_attributes ) ) {
                            $_chosen_attributes[ $key_attribute ]['terms'] = array_unique( wp_parse_args( $tax_item['terms'], $_chosen_attributes[ $key_attribute ]['terms'] ) );
                        } else {
                            $_chosen_attributes[ $key_attribute ]['terms']      = $tax_item['terms'];
                            $_chosen_attributes[ $key_attribute ]['query_type'] = strtolower( $tax_item['operator'] );
                        }
                    }
                }
            }

        }
        /*Condition for $_chosen_cat_or_tag*/
        $condition_chosen = false;
        foreach ( $_chosen_cat_or_tag as $key_chosen => $value_chosen ) {
            if ( count( $value_chosen ) > 0 ) {
                $condition_chosen = true;
                break;
            }
        }
        if (
            0 < count( $_chosen_attributes ) ||
            $condition_chosen ||
            0 < count( $_chosen_meta ) ||
            0 < $min_price ||
            0 < $max_price ||
            ! empty( $rating_filter ) ||
            ! empty( $onsale_filter ) ||
            ! empty( $instock_filter ) ||
            ! empty( $search_filter )
        ) {
            global $wp;
            $url               = explode( '?', esc_url_raw( add_query_arg( array(), $this->viwcpf_get_current_page_url() ) ) );
            $clear_filter_link = $url[0];
            if ( is_product_taxonomy() && ! is_shop() ) {
                $show_clear_all = true;
                /**/
                $condition_chosen_queried = false;
                foreach ( $_chosen_cat_or_tag as $key_chosen => $value_chosen ) {
                    if (
                        ! empty( $value_chosen ) &&
                        count( $value_chosen ) == 1 &&
                        count( $value_chosen[0]['terms'] ) == 1 &&
                        ( $value_chosen[0]['terms'][0] == get_queried_object()->slug )
                    ) {
                        $condition_chosen_queried = true;
                        break;
                    }
                }
                if (
                    (
                    $condition_chosen_queried
                    ) &&
                    (
                        empty( $_chosen_attributes ) &&
                        empty( $_chosen_meta ) &&
                        0 >= $min_price &&
                        0 >= $max_price &&
                        empty( $rating_filter ) &&
                        empty( $onsale_filter ) &&
                        empty( $instock_filter ) &&
                        empty( $search_filter )
                    )
                ) {
                    $show_clear_all = false;
                    if ( is_plugin_active( 'perfect-woocommerce-brands/perfect-woocommerce-brands.php' ) ) {
                        global $wp;

                        if ( strpos( $wp->request, 'product-category/' ) >= 0 && ! empty( $_chosen_cat_or_tag['pwb-brand'] ) ) {
                            $show_clear_all = true;
                        }
                    }
                }

                if ( $show_clear_all ) {
                    $template .= '<div class="viwcpf_active_filters ' . esc_attr( $option_style ) . '"><h4>' . esc_html__( 'Active filters', 'pofily-woocommerce-product-filters' ) . '</h4><ul class="active_filter">';

                    $template .= sprintf( '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="%s" href="%s">%s</a></li>', esc_attr__( 'Remove filter', 'woocommerce' ), esc_url( $clear_filter_link ), esc_html__( 'Clear Filters', 'pofily-woocommerce-product-filters' ) );

                } else {
                    $template .= '<div class="viwcpf_active_filters ' . esc_attr( $option_style ) . '"><ul class="active_filter">';

                }
            } else {
                $template .= '<div class="viwcpf_active_filters ' . esc_attr( $option_style ) . '"><h4>' . esc_html__( 'Active filters', 'pofily-woocommerce-product-filters' ) . '</h4><ul class="active_filter">';

                $template .= sprintf( '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="%s" href="%s">%s</a></li>', esc_attr__( 'Remove filter', 'woocommerce' ), esc_url( $clear_filter_link ), esc_html__( 'Clear Filters', 'pofily-woocommerce-product-filters' ) );

            }
            foreach ( $_chosen_cat_or_tag as $key_chosen => $value_chosen ) {
                if ( ! empty( $value_chosen ) ) {
                    foreach ( $value_chosen as $data ) {

                        foreach ( $data['terms'] as $term_slug ) {

                            /*Check if is page cats*/
                            if ( is_product_taxonomy() && ! is_shop() && $term_slug === get_queried_object()->slug ) {
                                continue;
                            }
                            $term = get_term_by( 'slug', $term_slug, $key_chosen );

                            if ( ! $term ) {
                                continue;
                            }

                            $filter_name = $key_chosen;
                            /*if ( count( $_chosen_cat_or_tag['product_cat'] ) > 1 ) {

                                $current_filter = isset( $_GET[ $filter_name ] ) ? explode( '+', urlencode( wc_clean( wp_unslash( $_GET[ $filter_name ] ) ) ) ) : array(); //phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            } else {

                            }*/
                            $current_filter = isset( $_GET[ $filter_name ] ) ? explode( ',', wc_clean( wp_unslash( $_GET[ $filter_name ] ) ) ) : array(); //phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            /*Compa Berocket brand and Brand default by WooCommerce */
                            if ( $key_chosen == 'berocket_brand' || $this->data->viwcpf_check_woo_brand_is_enabled( $key_chosen ) ) {

                                $check_brand_filter = isset( $_GET[ $key_chosen ] ) ? sanitize_text_field( $_GET[ $key_chosen ] ) : '';
                                if ( ! empty( $check_brand_filter ) ) {
                                    $check_brand_filter = urlencode( $check_brand_filter );
                                    if ( strpos( $check_brand_filter, ',' ) !== false ) {
                                        $current_filter = explode( '-', $check_brand_filter );

                                    } elseif ( strpos( $check_brand_filter, '+' ) !== false ) {
                                        $current_filter = explode( '+', $check_brand_filter );

                                    }
                                }
                                $current_filter_type = '';
                            }
                            $current_filter = array_map( 'sanitize_title', $current_filter );
                            /*$current_filter_type = isset( $_GET['query_type_product_cat'] ) ? explode( ',', wc_clean( wp_unslash( $_GET['query_type_product_cat'] ) ) ) : [];// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            $current_filter_type = array_map( 'sanitize_title', $current_filter_type );*/
                            $new_filter = array_diff( $current_filter, array( $term_slug ) );

                            $link = remove_query_arg( array( 'add-to-cart', $filter_name ), $base_link );

                            if ( count( $new_filter ) > 0 ) {
                                $link = add_query_arg( $filter_name, implode( ',', $new_filter ), $link );

                            }
                            if ( ! empty( $current_filter_type ) ) {
                                $link = add_query_arg( 'query_type_' + $key_chosen, implode( '', $current_filter_type ), $link );
                            }
                            $slug_display_name = $key_chosen;
                            switch ( $key_chosen ) {
                                case 'product_cat':
                                    $slug_name         = 'cat';
                                    $slug_display_name = 'Category';
                                    break;
                                case 'product_tag':
                                    $slug_name         = 'tag';
                                    $slug_display_name = 'Tag';
                                    break;
                                case 'colecciones':
                                    $slug_name         = 'colecciones';
                                    $slug_display_name = 'Colecciones';
                                    break;
                                case 'pwb-brand':
                                    $slug_name         = 'pwb-brand';
                                    $slug_display_name = 'Brand';
                                    break;
                                case 'berocket_brand':
                                    $slug_name         = 'berocket_brand';
                                    $slug_display_name = 'Brand';
                                case 'product_brand':
                                    $slug_name         = 'product_brand';
                                    $slug_display_name = 'Brand';
                                    break;
                                default:
                                    $slug_name = $key_chosen;
                                    break;
                            }
                            if ( $this->data->get_params( 'seo_rule' ) ) {

                                $viwcpf_format_link_tax = $this->viwcpf_format_link_tax( 'pofily-' . $slug_name, $term_slug, true );
                                $link                   = $viwcpf_format_link_tax['link'];
                            }
                            //$template .= '<li class="' . esc_attr( 'viwcpf_chosen' ) . '"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '">' . esc_html__( 'Product cat: ' . $term->name, 'pofily-woocommerce-product-filters' ) . '</a></li>';
                            $template .= sprintf( '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow"  href="%s">%s %s: %s</a></li>', esc_url( $link ), esc_html__( 'Product ', 'pofily-woocommerce-product-filters' ), esc_html( $slug_display_name ), esc_html( $term->name ) );
                        }
                    }
                }
            }

            // Attributes.
            if ( ! empty( $_chosen_attributes ) ) {
                foreach ( $_chosen_attributes as $taxonomy => $data ) {
                    $tax_slug_name      = str_replace( 'pa_', '', $taxonomy );
                    $current_query_type = isset( $_GET[ 'query_type_' . $tax_slug_name ] ) ? sanitize_text_field( $_GET[ 'query_type_' . $tax_slug_name ] ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended

                    foreach ( $data['terms'] as $term_slug ) {
                        $term = get_term_by( 'slug', $term_slug, $taxonomy );
                        if ( ! $term ) {
                            continue;
                        }

                        $filter_name    = 'filter_' . wc_attribute_taxonomy_slug( $taxonomy );
                        $current_filter = isset( $_GET[ $filter_name ] ) ? explode( ',', wc_clean( wp_unslash( $_GET[ $filter_name ] ) ) ) : array(); //phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        $current_filter = array_map( 'sanitize_title', $current_filter );
                        $new_filter     = array_diff( $current_filter, array( $term_slug ) );

                        $link = remove_query_arg( array( 'add-to-cart', $filter_name ), $base_link );
                        $link = remove_query_arg( 'filter_' . $tax_slug_name, $link );
                        $link = remove_query_arg( 'query_type_' . $tax_slug_name, $link );

                        $separator_url = ',';

                        if ( count( $new_filter ) > 0 ) {
                            $link = add_query_arg( $filter_name, implode( urlencode( $separator_url ), $new_filter ), $link );
                            $link = add_query_arg( 'query_type_' . $tax_slug_name, $current_query_type, $link );
                        }

                        if ( $this->data->get_params( 'seo_rule' ) ) {
                            $viwcpf_format_link_tax = $this->viwcpf_format_link_tax( $tax_slug_name, $term_slug, true, $data['query_type'] );
                            $link                   = $viwcpf_format_link_tax['link'];
                        }
                        $filter_classes = array(
                            'viwcpf_chosen',
                            'viwcpf_chosen-' . sanitize_html_class( $tax_slug_name ),
                            'viwcpf_chosen-' . sanitize_html_class( $tax_slug_name . '-' . $term_slug )
                        );

                        $template .= '<li class="' . esc_attr( implode( ' ', $filter_classes ) ) . '"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '">' . esc_html( $term->name ) . '</a></li>';
                    }
                }
            }


            if ( ! empty( $_chosen_meta ) ) {
                foreach ( $_chosen_meta as $meta_data ) {
                    if ( $instock_filter || $this->data->get_params( 'hide_out_of_stock' ) ) {
                        continue;
                    }
                    if ( ! empty( $meta_data['value'] ) ) {
                        $metakey_name = $meta_data['key'];
                        if ( isset( $meta_data['type'] ) && $meta_data['type'] == 'numeric' ) {
                            $meta_max_value = $meta_data['value'][1];
                            if ( $meta_max_value == PHP_INT_MAX ) {
                                $meta_max_value = 'max';
                            }
                            $meta_value = $meta_data['value'][0] . ' - ' . $meta_max_value;
                        } else {
                            $meta_value = $meta_data['value'];
                        }

                        $link = remove_query_arg( array(
                            'viwcpf_metakey_' . $metakey_name,
                            'viwcpf_metakey_type_' . $metakey_name
                        ), $base_link );

                        $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr( 'Remove filter' ) . '" href="' . esc_url( $link ) . '">' . esc_html( $metakey_name . ':' . $meta_value ) . '</a></li>';
                    }
                }
            }

            if ( $min_price ) {
                $link = remove_query_arg( 'min_price', $base_link );
                if ( ! $max_price ) {
                    $link = remove_query_arg( 'max_price', $link );
                }
                /* translators: %s: minimum price */
                $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr( 'Remove filter' ) . '" href="' . esc_url( $link ) . '">' . sprintf( wp_kses_post( '%1$s %2$s' ), esc_html__( 'Min', 'pofily-woocommerce-product-filters' ), ( wc_price( $min_price ) ) ) . '</a></li>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            }

            if ( $max_price ) {
                $link = remove_query_arg( 'max_price', $base_link );
                if ( ! $min_price ) {
                    $link = remove_query_arg( 'min_price', $link );
                }
                /* translators: %s: maximum price */
                $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '">' . sprintf( wp_kses_post( '%1$s %2$s' ), esc_html__( 'Max', 'pofily-woocommerce-product-filters' ), wc_price( $max_price ) ) . '</a></li>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            }

            if ( ! empty( $rating_filter ) ) {
                foreach ( $rating_filter as $rating ) {
                    $link_ratings = implode( ',', array_diff( $rating_filter, array( $rating ) ) );
                    $link         = $link_ratings ? add_query_arg( 'rating_filter', $link_ratings ) : remove_query_arg( 'rating_filter', $base_link );
                    $width        = 100 / 5 * $rating;
                    /* translators: %s: rating */
                    $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '"><div class="viwcpf_star-rating" aria-label="' . sprintf( wp_kses_post( 'Rated %1$s out of 5' ), esc_html( $rating ) ) . '"><span style="' . esc_attr( 'width:' . $width . '%;' ) . '">' . sprintf( esc_html( 'Rated %s out of 5' ), esc_html( $rating ) ) . '</span></div></a></li>';
                }
            }

            if ( ! empty( $onsale_filter ) ) {
                $link_onsale = $onsale_filter;
                $link        = empty( $link_onsale ) ? add_query_arg( 'onsale_filter', '1' ) : remove_query_arg( 'onsale_filter', $base_link );

                /* translators: %s: rating */
                $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '">' . esc_html__( 'Onsale', 'pofily-woocommerce-product-filters' ) . '</a></li>';

            }


            if ( ! empty( $instock_filter ) ) {

                $link_instock = $instock_filter;
                $link         = empty( $link_instock ) ? add_query_arg( 'instock_filter', '1' ) : remove_query_arg( 'instock_filter', $base_link );

                /* translators: %s: rating */
                $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '">' . esc_html__( 'Instock', 'pofily-woocommerce-product-filters' ) . '</a></li>';

            }


            if ( ! empty( $search_filter ) ) {

                $link = remove_query_arg( 's', $base_link );

                /* translators: %s: $search_filter */
                $template .= '<li class="viwcpf_chosen"><a class="active_filter_label" rel="nofollow" aria-label="' . esc_attr__( 'Remove filter', 'woocommerce' ) . '" href="' . esc_url( $link ) . '">' . sprintf( wp_kses_post( '%1$s: %2$s' ), esc_html__( 'Key search', 'pofily-woocommerce-product-filters' ), esc_html( $search_filter ) ) . '</a></li>';

            }


            $template .= '</ul></div>';

        }

        echo wp_kses_post( $template );
    }

    /**
     * General textarea to array
     *
     * @param string $text
     * @param int $limit
     *
     * @return array|mixed|void
     */
    public function viwcpf_explode_textarea( $text, $limit = 0 ) {

        if ( ! empty( $text ) ) {
            $text = explode( "\n", $text );
            $text = array_filter( $text, 'trim' );
            if ( $limit ) {
                if ( count( $text ) > $limit ) {
                    shuffle( $text );

                    return array_slice( $text, 0, $limit );
                }
            }
            $text = array_map( 'trim', $text );
        }

        return $text;
    }

    /**
     * Returns an array of locations where items shown "Before products" should be hooked
     *
     * @param int $offset Integer used to offset hook priority.
     *                    It is used when multiple templates are hooked to the same location, and you want to define a clear order.
     *
     * @return array Array of locations.
     */
    public function get_before_product_locations( $offset = 0 ) {
        return apply_filters(
            'viwcpf_before_product_locations',
            array(
                // before shop.
                array(
                    'hook'     => 'woocommerce_before_shop_loop',
                    'priority' => 20 + $offset,
                ),
                // before products shortcode.
                array(
                    'hook'     => 'woocommerce_shortcode_before_products_loop',
                    'priority' => 20 + $offset,
                ),
                // before no_products template.
                array(
                    'hook'     => 'woocommerce_no_products_found',
                    'priority' => 15 + $offset,
                ),
            )
        );
    }

    /**
     * Hooks callback that will print list fo active filters
     *
     * @return void
     */
    public function add_active_filters_list() {
        $viwcpf_setting_params   = get_option( 'viwcpf_setting_params' );
        $show_active_filters     = ! empty( $viwcpf_setting_params['show_active_labels'] ) ? 'yes' : 'no';
        $active_filters_position = isset( $viwcpf_setting_params['active_position'] ) ? $viwcpf_setting_params['active_position'] : 'before_filters';

        if ( $show_active_filters != 'yes' ) {
            return;
        }

        switch ( $active_filters_position ) {
            case 'before_filters':

                add_action( 'viwcpf_before_menu_filters', array( $this, 'viwcpf_get_active_filter' ) );
                break;
            case 'after_filters':
                add_action( 'viwcpf_after_menu_filters', array( $this, 'viwcpf_get_active_filter' ) );
                break;
            case 'before_products':
                $locations = $this->get_before_product_locations();

                if ( ! $locations ) {
                    return;
                }

                foreach ( $locations as $location ) {
                    add_action( $location['hook'], array( $this, 'viwcpf_get_active_filter' ), $location['priority'] );
                }
                break;
        }
    }

    /**
     * Count product with current query filtered by price
     *
     * @param $min_price
     * @param $max_price
     *
     * @return string|void
     */
    public function viwcpf_count_product_by_price( $min_price, $max_price ) {
        if ( ( $min_price === '' ) && ( $max_price === '' ) ) {
            return;
        }
        global $wpdb;
        $tax_query  = $this->get_main_tax_query();
        $meta_query = $this->get_main_meta_query();

        $current_min_price = $min_price ? $min_price : 0;
        $current_max_price = $max_price ? $max_price : PHP_INT_MAX;

        $price_query_sql = array();


        $price_query_sql['join'] = " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";


        $price_query_sql['where'] = $wpdb->prepare(
            ' AND NOT (( %f < wc_product_meta_lookup.min_price  )  OR ( %f > wc_product_meta_lookup.max_price  ))',
            $current_max_price,
            $current_min_price
        );


        $meta_query     = new WP_Meta_Query( $meta_query );
        $tax_query      = new WP_Tax_Query( $tax_query );
        $meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

        $sql = "SELECT COUNT( DISTINCT {$wpdb->posts}.ID ) FROM {$wpdb->posts} ";
        $sql .= $tax_query_sql['join'] . $meta_query_sql['join'] . $price_query_sql['join'];
        $sql .= " WHERE {$wpdb->posts}.post_type = 'product' AND ( {$wpdb->posts}.post_status = 'publish' )";
        $sql .= $tax_query_sql['where'] . $meta_query_sql['where'] . $price_query_sql['where'];

        $search = WC_Query::get_main_search_query_sql();
        if ( $search ) {
            $sql .= ' AND ' . $search;
        }

        return absint( $wpdb->get_var( $sql ) );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
    }

    /**
     * Count products within certain terms, taking the main WP query into consideration.
     *
     * This query allows counts to be generated based on the viewed products, not all products.
     *
     * @param array $term_ids Term IDs.
     * @param string $taxonomy Taxonomy.
     * @param string $query_type Query Type.
     *
     * @return array
     */
    protected function get_filtered_term_product_counts( $term_ids, $taxonomy, $query_type ) {
        global $wpdb;

        $tax_query  = $this->get_main_tax_query();
        $meta_query = $this->get_main_meta_query();

        $min_price = isset( $_GET['min_price'] ) ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $max_price = isset( $_GET['max_price'] ) ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended

        $current_min_price = $min_price ? $min_price : 0;
        $current_max_price = $max_price ? $max_price : PHP_INT_MAX;

        $price_query_sql = array();


        $price_query_sql['join'] = " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";

        $price_query_sql['where'] = $wpdb->prepare(
            ' AND NOT (( %f < wc_product_meta_lookup.min_price  )  OR ( %f > wc_product_meta_lookup.max_price  ))',
            $current_max_price,
            $current_min_price
        );

        if ( 'or' === $query_type ) {
            foreach ( $tax_query as $key => $query ) {
                if ( is_array( $query ) && $taxonomy === $query['taxonomy'] ) {
                    unset( $tax_query[ $key ] );
                }
            }
        }

        $meta_query     = new WP_Meta_Query( $meta_query );
        $tax_query      = new WP_Tax_Query( $tax_query );
        $meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );
        $term_ids_sql   = '(' . implode( ',', array_map( 'absint', $term_ids ) ) . ')';

        // Generate query.
        $query           = array();
        $query['select'] = "SELECT COUNT( DISTINCT {$wpdb->posts}.ID ) AS term_count, terms.term_id AS term_count_id";
        $query['from']   = "FROM {$wpdb->posts}";
        $query['join']   = "
			INNER JOIN {$wpdb->term_relationships} AS term_relationships ON {$wpdb->posts}.ID = term_relationships.object_id
			INNER JOIN {$wpdb->term_taxonomy} AS term_taxonomy USING( term_taxonomy_id )
			INNER JOIN {$wpdb->terms} AS terms USING( term_id )
			" . $tax_query_sql['join'] . $meta_query_sql['join'] . $price_query_sql['join'];

        $query['where'] = "
			WHERE {$wpdb->posts}.post_type IN ( 'product' )
			AND {$wpdb->posts}.post_status = 'publish'
			{$tax_query_sql['where']} {$meta_query_sql['where']} {$price_query_sql['where']}
			AND terms.term_id IN $term_ids_sql";

        $search = $this->get_main_search_query_sql();
        if ( $search ) {
            $query['where'] .= ' AND ' . $search;
        }

        $query['group_by'] = 'GROUP BY terms.term_id';
        $query             = apply_filters( 'woocommerce_get_filtered_term_product_counts_query', $query );
        $query_sql         = implode( ' ', $query );

        // We have a query - let's see if cached results of this query already exist.
        $query_hash = md5( $query_sql );

        // Maybe store a transient of the count values.
        $cache = apply_filters( 'woocommerce_layered_nav_count_maybe_cache', true );
        if ( true === $cache ) {
            $cached_counts = (array) get_transient( 'wc_layered_nav_counts_' . sanitize_title( $taxonomy ) );
        } else {
            $cached_counts = array();
        }

        if ( ! isset( $cached_counts[ $query_hash ] ) ) {
            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
            $results                      = $wpdb->get_results( $query_sql, ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
            $counts                       = array_map( 'absint', wp_list_pluck( $results, 'term_count', 'term_count_id' ) );
            $cached_counts[ $query_hash ] = $counts;

        }

        return array_map( 'absint', (array) $cached_counts[ $query_hash ] );
    }

    /**
     * Count products after other filters have occurred by adjusting the main query.
     *
     * @param int $rating Rating.
     *
     * @return int
     */
    protected function get_filtered_product_count( $rating ) {
        global $wpdb;
        $tax_query         = WC_Query::get_main_tax_query();
        $meta_query        = WC_Query::get_main_meta_query();
        $min_price         = isset( $_GET['min_price'] ) ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $max_price         = isset( $_GET['max_price'] ) ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $current_min_price = $min_price ? $min_price : 0;
        $current_max_price = $max_price ? $max_price : PHP_INT_MAX;

        $price_query_sql = array();

        $price_query_sql['join'] = " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";

        $price_query_sql['where'] = $wpdb->prepare(
            ' AND NOT (( %f < wc_product_meta_lookup.min_price  )  OR ( %f > wc_product_meta_lookup.max_price  ))',
            $current_max_price,
            $current_min_price
        );


        // Unset current rating filter.
        foreach ( $tax_query as $key => $query ) {
            if ( ! empty( $query['rating_filter'] ) ) {
                unset( $tax_query[ $key ] );
                break;
            }
        }

        // Set new rating filter.
        $product_visibility_terms = wc_get_product_visibility_term_ids();
        $tax_query[]              = array(
            'taxonomy'      => 'product_visibility',
            'field'         => 'term_taxonomy_id',
            'terms'         => $product_visibility_terms[ 'rated-' . $rating ],
            'operator'      => 'IN',
            'rating_filter' => true,
        );

        $meta_query     = new WP_Meta_Query( $meta_query );
        $tax_query      = new WP_Tax_Query( $tax_query );
        $meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

        $sql = "SELECT COUNT( DISTINCT {$wpdb->posts}.ID ) FROM {$wpdb->posts} ";
        $sql .= $tax_query_sql['join'] . $meta_query_sql['join'] . $price_query_sql['join'];
        $sql .= " WHERE {$wpdb->posts}.post_type = 'product' AND {$wpdb->posts}.post_status = 'publish' ";
        $sql .= $tax_query_sql['where'] . $meta_query_sql['where'] . $price_query_sql['where'];

        $search = WC_Query::get_main_search_query_sql();
        if ( $search ) {
            $sql .= ' AND ' . $search;
        }

        return absint( $wpdb->get_var( $sql ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
    }

    /**
     * Wrapper for WC_Query::get_main_search_query_sql() to ease unit testing.
     *
     * @return string
     * @since 4.4.0
     */
    protected function get_main_search_query_sql() {
        if ( did_action( 'wp' ) && function_exists('WC')
            && WC()->query instanceof WC_Query && WC_Query::get_main_query()) {
            return WC_Query::get_main_search_query_sql();
        }
        return [];
    }

    /**
     * Wrapper for WC_Query::get_main_search_queryget_main_meta_query to ease unit testing.
     *
     * @return array
     * @since 4.4.0
     */
    protected function get_main_meta_query() {
        if ( did_action( 'wp' ) && function_exists('WC')
            && WC()->query instanceof WC_Query && WC_Query::get_main_query()) {
            return WC_Query::get_main_meta_query();
        }
        return [];
    }

    /**
     * Wrapper for WC_Query::get_main_tax_query() to ease unit testing.
     *
     * @return array
     * @since 4.4.0
     */
    protected function get_main_tax_query() {
        return WC_Query::get_main_tax_query();
    }

    /**
     * Get filtered min price for current products.
     *
     * @return int|array|object|void
     */
    protected function get_filtered_price() {
        global $wpdb;
        if ( is_admin() ) {
            return;
        }
        $args = [];
        if ( function_exists( 'WC' ) && WC()->query && WC()->query->get_main_query() && WC()->query->get_main_query()->query_vars ) {
            $args = WC()->query->get_main_query()->query_vars;
        }
        $tax_query  = isset( $args['tax_query'] ) ? $args['tax_query'] : array();
        $meta_query = isset( $args['meta_query'] ) ? $args['meta_query'] : array();

        if ( ! is_post_type_archive( 'product' ) && ! empty( $args['taxonomy'] ) && ! empty( $args['term'] ) ) {
            $tax_query[] = WC()->query->get_main_tax_query();
        }

        foreach ( $meta_query + $tax_query as $key => $query ) {
            if ( ! empty( $query['price_filter'] ) || ! empty( $query['rating_filter'] ) ) {
                unset( $meta_query[ $key ] );
            }
        }

        $meta_query = new WP_Meta_Query( $meta_query );
        $tax_query  = new WP_Tax_Query( $tax_query );
        $search = [];
        if ( did_action( 'wp' ) && function_exists('WC')
            && WC()->query instanceof WC_Query && WC_Query::get_main_query()) {
            $search     = WC_Query::get_main_search_query_sql();
        }
        $meta_query_sql   = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql    = $tax_query->get_sql( $wpdb->posts, 'ID' );
        $search_query_sql = $search ? ' AND ' . $search : '';

        $sql = "
			SELECT min( min_price ) as min_price, MAX( max_price ) as max_price
			FROM {$wpdb->wc_product_meta_lookup}
			WHERE product_id IN (
				SELECT ID FROM {$wpdb->posts}
				" . $tax_query_sql['join'] . $meta_query_sql['join'] . "
				WHERE {$wpdb->posts}.post_type IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_post_type', array( 'product' ) ) ) ) . "')
				AND {$wpdb->posts}.post_status = 'publish'
				" . $tax_query_sql['where'] . $meta_query_sql['where'] . $search_query_sql . '
			)';

        $sql = apply_filters( 'woocommerce_price_filter_sql', $sql, $meta_query_sql, $tax_query_sql );

        return $wpdb->get_row( $sql ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
    }

    /**
     * Function get maximum and minimum metavalue type numeric by metakey
     *
     * @param    $meta_key : meta_key -- Default ''
     * @param    $end : min or max -- Default 'max'
     *
     * @return int|array|object|void
     * @since    1.0.0
     */
    public function viwcpf_get_min_max_meta_values( $meta_key = '', $end = 'max' ) {

        global $wpdb;

        if ( empty( $meta_key ) ) {
            return;
        }
        if (
            empty( $end ) &&
            ( $end != 'max' ) &&
            ( $end != 'min' )
        ) {
            return;
        }
        if ( $end == 'max' ) {
            $query_value = $wpdb->prepare( "SELECT max(cast( meta_value as unsigned)) FROM {$wpdb->postmeta} WHERE meta_key = '%s'", $meta_key );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared,WordPress.DB.PreparedSQLPlaceholders.QuotedSimplePlaceholder
        } else if ( $end == 'min' ) {
            $query_value = $wpdb->prepare( "SELECT min(cast( meta_value as unsigned)) FROM {$wpdb->postmeta} WHERE meta_key = '%s'", $meta_key );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared,WordPress.DB.PreparedSQLPlaceholders.QuotedSimplePlaceholder
        }

        $result_value = $wpdb->get_var( $query_value );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared

        return $result_value;
    }

    /**
     * Count how many on sale products match current filter
     *
     * @return int Count of matching products
     */
    public function count_query_relevant_on_sale_products() {
        global $wpdb;
        $tax_query         = WC_Query::get_main_tax_query();
        $meta_query        = WC_Query::get_main_meta_query();
        $min_price         = isset( $_GET['min_price'] ) ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $max_price         = isset( $_GET['max_price'] ) ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $current_min_price = $min_price ? $min_price : 0;
        $current_max_price = $max_price ? $max_price : PHP_INT_MAX;

        $price_query_sql = array();

        $price_query_sql['join'] = " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";

        $price_query_sql['where'] = $wpdb->prepare(
            ' AND NOT (( %f < wc_product_meta_lookup.min_price  )  OR ( %f > wc_product_meta_lookup.max_price  ))',
            $current_max_price,
            $current_min_price
        );


        $meta_query[] = array(
            'relation' => 'OR',
            array(// Simple products type
                'key'     => '_sale_price',
                'value'   => 0,
                'compare' => '>',
                'type'    => 'numeric'
            ),
            array(// Variable products type
                'key'     => '_min_variation_sale_price',
                'value'   => 0,
                'compare' => '>',
                'type'    => 'numeric'
            )
        );

        $meta_query     = new WP_Meta_Query( $meta_query );
        $tax_query      = new WP_Tax_Query( $tax_query );
        $meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

        $sql = "SELECT COUNT( DISTINCT {$wpdb->posts}.ID ) FROM {$wpdb->posts} ";
        $sql .= $tax_query_sql['join'] . $meta_query_sql['join'] . $price_query_sql['join'];
        $sql .= " WHERE {$wpdb->posts}.post_type = 'product' AND {$wpdb->posts}.post_status = 'publish' ";
        $sql .= $tax_query_sql['where'] . $meta_query_sql['where'] . $price_query_sql['where'];

        $search = WC_Query::get_main_search_query_sql();
        if ( $search ) {
            $sql .= ' AND ' . $search;
        }

        return absint( $wpdb->get_var( $sql ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
    }

    /**
     * Count how many in stock products match current filter
     *
     * @return int Count of matching products
     */
    public function count_query_relevant_in_stock_products() {
        global $wpdb;
        $tax_query         = WC_Query::get_main_tax_query();
        $meta_query        = WC_Query::get_main_meta_query();
        $min_price         = isset( $_GET['min_price'] ) ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $max_price         = isset( $_GET['max_price'] ) ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $current_min_price = $min_price ? $min_price : 0;
        $current_max_price = $max_price ? $max_price : PHP_INT_MAX;

        $price_query_sql = array();

        $price_query_sql['join'] = " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";

        $price_query_sql['where'] = $wpdb->prepare(
            ' AND NOT (( %f < wc_product_meta_lookup.min_price  )  OR ( %f > wc_product_meta_lookup.max_price  ))',
            $current_max_price,
            $current_min_price
        );


        $meta_query[] = array(
            array(
                'key'     => '_stock_status',
                'value'   => 'instock',
                'compare' => '=',
            )
        );

        $meta_query     = new WP_Meta_Query( $meta_query );
        $tax_query      = new WP_Tax_Query( $tax_query );
        $meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

        $sql = "SELECT COUNT( DISTINCT {$wpdb->posts}.ID ) FROM {$wpdb->posts} ";
        $sql .= $tax_query_sql['join'] . $meta_query_sql['join'] . $price_query_sql['join'];
        $sql .= " WHERE {$wpdb->posts}.post_type = 'product' AND {$wpdb->posts}.post_status = 'publish' ";
        $sql .= $tax_query_sql['where'] . $meta_query_sql['where'] . $price_query_sql['where'];

        $search = WC_Query::get_main_search_query_sql();
        if ( $search ) {
            $sql .= ' AND ' . $search;
        }

        return absint( $wpdb->get_var( $sql ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
    }

    /**
     * Count products by metadata current filter
     *
     * @param $metakey
     * @param $metavalue
     * @param $metatype
     *
     * @return int Count of matching products
     */
    public function get_filtered_metadata_product_counts( $metakey, $metavalue, $metatype ) {
        global $wpdb;
        if (
            empty( $metakey ) &&
            empty( $metavalue ) &&
            empty( $metatype )
        ) {
            return;
        }
        $tax_query       = WC_Query::get_main_tax_query();
        $meta_query      = WC_Query::get_main_meta_query();
        $min_price       = isset( $_GET['min_price'] ) ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $max_price       = isset( $_GET['max_price'] ) ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $price_query_sql = array();
        if ( isset( $_GET['min_price'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended

            $current_min_price = $min_price ? $min_price : 0;
            $current_max_price = $max_price ? $max_price : PHP_INT_MAX;

            $price_query_sql['join'] = " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";

            $price_query_sql['where'] = $wpdb->prepare(
                ' AND NOT (( %f < wc_product_meta_lookup.min_price  )  OR ( %f > wc_product_meta_lookup.max_price  ))',
                $current_max_price,
                $current_min_price
            );

        } else {
            $price_query_sql['join'] = "";

            $price_query_sql['where'] = "";
        }


        /*Check type of metadata*/
        switch ( $metatype ) {
            case 'string':
                $meta_query[] = array(
                    'key'     => $metakey,
                    'value'   => $metavalue,
                    'compare' => '=',
                );

                break;
            case 'numberic':

                $viwcpf_metavalue_arr = explode( "-", $metavalue );
                if ( sizeof( $viwcpf_metavalue_arr ) == 1 ) {
                    array_push( $viwcpf_metavalue_arr, PHP_INT_MAX );
                }
                $meta_query[] = array(
                    'key'     => $metakey,
                    'value'   => $viwcpf_metavalue_arr,
                    'compare' => 'BETWEEN'
                );
                break;
            default:
                break;
        }


        $meta_query     = new WP_Meta_Query( $meta_query );
        $tax_query      = new WP_Tax_Query( $tax_query );
        $meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
        $tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

        $sql = "SELECT COUNT( DISTINCT {$wpdb->posts}.ID ) FROM {$wpdb->posts} ";
        $sql .= $tax_query_sql['join'] . $meta_query_sql['join'] . $price_query_sql['join'];
        $sql .= " WHERE {$wpdb->posts}.post_type = 'product' AND {$wpdb->posts}.post_status = 'publish' ";
        $sql .= $tax_query_sql['where'] . $meta_query_sql['where'] . $price_query_sql['where'];

        $search = WC_Query::get_main_search_query_sql();
        if ( $search ) {
            $sql .= ' AND ' . $search;
        }

        return absint( $wpdb->get_var( $sql ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
    }

    /**
     * Generator gradient color from color separator
     *
     * @param $colors
     * @param $color_separator
     *
     * @return string value of background
     */
    public function get_gradient_color( $colors = array(), $color_separator = '1' ) {
        $viwcpf_setting_params = get_option( 'viwcpf_setting_params' );
        $color_swatches        = $viwcpf_setting_params['color_swatches'];
        $color_default         = $color_swatches['color_default'];
        if ( empty( $colors ) ) {
            $result = $color_default;
        } else {
            if ( ( $count_colors = count( $colors ) ) === 1 ) {
                $result = $colors[0];
                $result = $result ?: $color_default;
            } else {
                $temp = (int) floor( 100 / $count_colors );
                switch ( $color_separator ) {
                    case '2':
                        $result = 'linear-gradient( ' . implode( ',', $colors ) . ' )';
                        break;
                    case '3':
                        $result = 'linear-gradient(to bottom left, ' . implode( ',', $colors ) . ' )';
                        break;
                    case '4':
                        $result = 'linear-gradient( to bottom right, ' . implode( ',', $colors ) . ' )';
                        break;
                    case '5':
                        $result = 'linear-gradient(to right,' . $colors[0] . ' ' . $temp . '%';
                        for ( $i = 1; $i < $count_colors; $i ++ ) {
                            $result .= ' , ' . $colors[ $i ] . ' ' . ( $i * $temp ) . '% ' . ( ( $i + 1 ) * $temp ) . '%';
                        }
                        $result .= ' )';
                        break;
                    case '6':
                        $result = 'linear-gradient(' . $colors[0] . ' ' . $temp . '%';
                        for ( $i = 1; $i < $count_colors; $i ++ ) {
                            $result .= ' , ' . $colors[ $i ] . ' ' . ( $i * $temp ) . '% ' . ( ( $i + 1 ) * $temp ) . '%';
                        }
                        $result .= ' )';
                        break;
                    case '7':
                        $result = 'linear-gradient(to bottom left, ' . $colors[0] . ' ' . $temp . '%';
                        for ( $i = 1; $i < $count_colors; $i ++ ) {
                            $result .= ' , ' . $colors[ $i ] . ' ' . ( $i * $temp ) . '% ' . ( ( $i + 1 ) * $temp ) . '%';
                        }
                        $result .= ' )';
                        break;
                    case '8':
                        $result = 'linear-gradient(to bottom right, ' . $colors[0] . ' ' . $temp . '%';
                        for ( $i = 1; $i < $count_colors; $i ++ ) {
                            $result .= ' , ' . $colors[ $i ] . ' ' . ( $i * $temp ) . '% ' . ( ( $i + 1 ) * $temp ) . '%';
                        }
                        $result .= ' )';
                        break;
                    default:
                        $result = 'linear-gradient( to right, ' . implode( ',', $colors ) . ' )';
                }
            }
        }

        return $result;
    }

    /*
	*
	* Generator class name show as toggle block filter
	*
	* @param array $filter_setting
	* @return string class name
	*/

    public function class_show_as_toggle( $filter_setting ) {
        $class_name = '';
        if (
            empty( $filter_setting ) ||
            empty( $filter_setting['show_as_toggle'] )
        ) {
            return;
        }
        if ( $filter_setting['show_as_toggle'] ) {
            $class_name .= ' collapsable  ';
            if ( $filter_setting['toggle_style'] == 'toggle_style-opened' ) {
                $class_name .= 'opened';
            } else {
                $class_name .= 'closed';
            }
        }

        return $class_name;
    }

    /**
     * Register shortcode show modal open icon
     *
     * @return void
     */
    public function activate_viwcpf_shortcode_modal_icon() {

        add_shortcode( "VIWCPF_SHORTCODE_MODAL_ICON", array( $this, 'shortcode_off_canvas_icon' ) );

    }

    /*
	*
	* Shortcode show modal open icon
	*
    *
	* @return void
	*/
    public function shortcode_off_canvas_icon( $param ) {
        ob_start();
        extract( shortcode_atts( array(
            'link' => '',
        ), $param ) );
        global $wpdb;
        $off_canvas_data   = isset( get_option( 'viwcpf_setting_params' )['off_canvas'] ) ? get_option( 'viwcpf_setting_params' )['off_canvas'] : array();
        $modal_data        = isset( get_option( 'viwcpf_setting_params' )['modal'] ) ? get_option( 'viwcpf_setting_params' )['modal'] : array();
        $modal_menu_arr_id = array();
        $modal_conditional = false;
        if ( isset( $modal_data['icon']['box_shadow'] ) ) {
            $box_shadow_class = 'viwcpf-off_canvas-icon-border-box';
        } else {
            $box_shadow_class = '';
        }
        /*Get all menu filter id*/
        $args_menu_filter = array(
            'post_type'      => 'viwcpf_filter_menu',
            'post_status'    => array( 'publish' ),
            'posts_per_page' => - 1,
            'order'          => 'ASC',
            'orderby'        => 'menu_order',
            'fields'         => 'ids'
        );
        /*remove search query in request custom wp_query when isset $_GET['s']*/
        if ( isset( $_GET['s'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            unset( $_GET['s'] );
        }
        $menu_filter_query = get_posts( $args_menu_filter );
        if ( $menu_filter_query ) {
            foreach ( $menu_filter_query as $child ) {
                $filter_menu_meta = get_post_meta( $child, 'viwcpf_filter_menu', true );
                if ( $filter_menu_meta ) {

                    if ( $filter_menu_meta['viwcpf_show_in_modal'] ) {

                        $modal_menu_arr_id[] = $child;

                    }

                }

            }
        }

        wp_reset_postdata();
        /*Check conditional display of all menu filter*/
        if ( ! empty( $modal_menu_arr_id ) ) {
            foreach ( $modal_menu_arr_id as $menu_id ) {
                if ( $this->check_conditional_menu( $menu_id ) ) {
                    $modal_conditional = true;
                }
            }
        }
        if (
            isset( $modal_data['enabled'] ) &&
            ( $modal_data['icon_position'] !== 'top_product_loop' ) &&
            $modal_conditional
        ) {
            ?>
            <div class="viwcpf-off_canvas-icon-wrap viwcpf-shortcode-off_canvas-icon viwcpf-off_canvas-icon-wrap-click viwcpf-off_canvas-icon-wrap-open <?php echo esc_attr( $box_shadow_class ); ?>"
                 data-trigger="click">
                <div class="viwcpf-off_canvas-icon viwcpf-off_canvas-icon-1 " data-display_style="1">
                    <i class="viwcpf-icon-filter-3"></i>
                </div>
            </div>
            <?php
        } else {
            if ( empty( $link ) ) {
                $shortcode_link = get_permalink( wc_get_page_id( 'shop' ) );
            } else {
                $shortcode_link = $link;
            }
            ?>
            <div class="viwcpf-off_canvas-icon-wrap viwcpf-shortcode-off_canvas-icon viwcpf-off_canvas-icon-wrap-click viwcpf-off_canvas-icon-wrap-open <?php
            echo esc_attr( $box_shadow_class ); ?>" data-trigger="click"
            >
                <div class="viwcpf-off_canvas-icon viwcpf-off_canvas-icon-1 viwcpf-off_canvas-icon-other-page "
                     data-link="<?php echo esc_url( $shortcode_link ); ?>" data-display_style="1">
                    <i class="viwcpf-icon-filter-3"></i>
                </div>
            </div>
            <?php
        }

        return ob_get_clean();
    }

    public function template_off_canvas() {
        global $wpdb;
        $off_canvas_data   = isset( get_option( 'viwcpf_setting_params' )['off_canvas'] ) ? get_option( 'viwcpf_setting_params' )['off_canvas'] : array();
        $modal_data        = isset( get_option( 'viwcpf_setting_params' )['modal'] ) ? get_option( 'viwcpf_setting_params' )['modal'] : array();
        $modal_menu_arr_id = array();
        $modal_conditional = false;
        if ( isset( $modal_data['icon']['box_shadow'] ) ) {
            $box_shadow_class = 'viwcpf-off_canvas-icon-border-box';
        } else {
            $box_shadow_class = '';
        }
        /*Get all menu filter id*/
        $args_menu_filter = array(
            'post_type'      => 'viwcpf_filter_menu',
            'post_status'    => array( 'publish' ),
            'posts_per_page' => - 1,
            'order'          => 'ASC',
            'orderby'        => 'menu_order',
            'fields'         => 'ids'
        );
        /*remove search query in request custom wp_query when isset $_GET['s']*/
        if ( isset( $_GET['s'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            unset( $_GET['s'] );
        }
        $menu_filter_query = get_posts( $args_menu_filter );
        if ( $menu_filter_query ) {
            foreach ( $menu_filter_query as $child ) {
                $filter_menu_meta = get_post_meta( $child, 'viwcpf_filter_menu', true );
                if ( $filter_menu_meta ) {

                    if ( $filter_menu_meta['viwcpf_show_in_modal'] ) {

                        $modal_menu_arr_id[] = $child;

                    }

                }

            }
        }

        wp_reset_postdata();
        /*Check conditional display of all menu filter*/
        if ( ! empty( $modal_menu_arr_id ) ) {
            foreach ( $modal_menu_arr_id as $menu_id ) {
                if ( $this->check_conditional_menu( $menu_id ) ) {
                    $modal_conditional = true;
                }
            }
        }
        if (
            isset( $modal_data['enabled'] ) &&
            ( $modal_data['icon_position'] !== 'top_product_loop' ) &&
            $modal_conditional
        ) {
            ?>
            <div class="viwcpf-off_canvas-icon-wrap viwcpf-off_canvas-<?php echo esc_attr( $modal_data['icon_position'] ); ?> viwcpf-off_canvas-icon-wrap-click viwcpf-off_canvas-icon-wrap-open <?php echo esc_attr( $box_shadow_class ); ?>"
                 data-trigger="click">
                <div class="viwcpf-off_canvas-icon viwcpf-off_canvas-icon-1 " data-display_style="1">
                    <i class="viwcpf-icon-filter-3"></i>
                </div>
            </div>
            <?php
        }
        if (
            isset( $modal_data['enabled'] ) &&
            isset( $modal_data['style'] ) &&
            ( $modal_data['style'] === 'off_canvas' ) &&
            $modal_conditional
        ) {
            ?>

            <div class="viwcpf-off_canvas-wrap">
                <div class="viwcpf-off_canvas-overlay viwcpf-disabled"></div>
                <div class="viwcpf-off_canvas viwcpf-off_canvas-icon-2 viwcpf-off_canvas-<?php echo esc_attr( $off_canvas_data['general']['position'] ); ?>"
                     data-position="<?php echo esc_attr( $off_canvas_data['general']['position'] ); ?>"
                     data-effect="<?php echo esc_attr( $off_canvas_data['general']['effect_open'] ); ?>"
                >
                    <div class="viwcpf-off_canvas-content-wrap viwcpf-off_canvas-content-close ">
                        <div class="viwcpf-off_canvas-header-wrap">
                            <h6 class="viwcpf-off_canvas-header-title-wrap"><?php esc_html_e( 'Filters', 'pofily-woocommerce-product-filters' ); ?></h6>
                            <div class="viwcpf-off_canvas-close-wrap">
                                <i class="viwcpf-icon-filter-close"></i>
                            </div>
                        </div>
                        <div class="viwcpf-off_canvas-content-wrap1">
                            <?php
                            foreach ( $modal_menu_arr_id as $menu_id ) {
                                if ( $menu_id && count( shortcode_parse_atts( $menu_id ) ) > 1 ) {
                                    $menu_id = '';
                                    continue;
                                }

                                echo do_shortcode( '[VIWCPF_SHORTCODE id_menu="' . $menu_id . '" off_canvas="true"]' );
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
    }

    public function show_filter_icon_woocommerce_before_shop_loop( $template_name ) {

        if ( $template_name === 'loop/orderby.php' ) {
            global $wpdb;
            $modal_data        = isset( get_option( 'viwcpf_setting_params' )['modal'] ) ? get_option( 'viwcpf_setting_params' )['modal'] : array();
            $modal_conditional = false;
            $modal_menu_arr_id = array();
            /*Get all menu filter id*/
            $args_menu_filter = array(
                'post_type'      => 'viwcpf_filter_menu',
                'post_status'    => array( 'publish' ),
                'posts_per_page' => - 1,
                'order'          => 'ASC',
                'orderby'        => 'menu_order',
                'fields'         => 'ids'
            );
            /*remove search query in request custom wp_query when isset $_GET['s']*/
            if ( isset( $_GET['s'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                unset( $_GET['s'] );
            }
            $menu_filter_query = get_posts( $args_menu_filter );
            if ( $menu_filter_query ) {
                foreach ( $menu_filter_query as $child ) {
                    $filter_menu_meta = get_post_meta( $child, 'viwcpf_filter_menu', true );
                    if ( $filter_menu_meta ) {

                        if ( $filter_menu_meta['viwcpf_show_in_modal'] ) {

                            $modal_menu_arr_id[] = $child;

                        }

                    }

                }
            }

            wp_reset_postdata();
            /*Check conditional display of all menu filter*/
            if ( ! empty( $modal_menu_arr_id ) ) {
                foreach ( $modal_menu_arr_id as $menu_id ) {
                    if ( $this->check_conditional_menu( $menu_id ) ) {
                        $modal_conditional = true;
                    }
                }
            }

            if (
                isset( $modal_data['enabled'] ) &&
                isset( $modal_data['icon_position'] ) &&
                ( $modal_data['icon_position'] === 'top_product_loop' ) &&
                $modal_conditional
            ) {
                echo '<!--Open wrapp shop filter-->
            
                <div class="viwcpf-filter-trigger-box">
                    <button id="viwcpf-shop-filters" class="viwcpf-filter-trigger viwcpf-trigger-off_canvas-open ">
                        <span class="icon-filter">
                             <i class="viwcpf-icon-filter-3"></i>
                        </span> ' . esc_html__( 'Filters', 'pofily-woocommerce-product-filters' ) . '
                    </button>
                </div>';
            }
        }

    }

    public function show_filter_area_woocommerce_before_shop_loop( $template_name ) {

        if ( $template_name === 'loop/loop-start.php' ) {
            global $wpdb;
            $modal_data        = isset( get_option( 'viwcpf_setting_params' )['modal'] ) ? get_option( 'viwcpf_setting_params' )['modal'] : array();
            $modal_conditional = false;
            $modal_menu_arr_id = array();
            if ( isset( $modal_data['icon']['box_shadow'] ) ) {
                $box_shadow_class = 'viwcpf-off_canvas-icon-border-box';
            } else {
                $box_shadow_class = '';
            }
            /*Get all menu filter id*/
            $args_menu_filter = array(
                'post_type'      => 'viwcpf_filter_menu',
                'post_status'    => array( 'publish' ),
                'posts_per_page' => - 1,
                'order'          => 'ASC',
                'orderby'        => 'menu_order',
                'fields'         => 'ids'
            );
            /*remove search query in request custom wp_query when isset $_GET['s']*/
            if ( isset( $_GET['s'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                unset( $_GET['s'] );
            }
            $menu_filter_query = get_posts( $args_menu_filter );
            if ( $menu_filter_query ) {
                foreach ( $menu_filter_query as $child ) {
                    $filter_menu_meta = get_post_meta( $child, 'viwcpf_filter_menu', true );
                    if ( $filter_menu_meta ) {

                        if ( $filter_menu_meta['viwcpf_show_in_modal'] ) {

                            $modal_menu_arr_id[] = $child;

                        }

                    }

                }
            }

            wp_reset_postdata();
            /*Check conditional display of all menu filter*/
            if ( ! empty( $modal_menu_arr_id ) ) {
                foreach ( $modal_menu_arr_id as $menu_id ) {
                    if ( $this->check_conditional_menu( $menu_id ) ) {
                        $modal_conditional = true;
                    }
                }
            }
            if (
                isset( $modal_data['enabled'] ) &&
                isset( $modal_data['style'] ) &&
                ( $modal_data['style'] === 'top_product_loop' ) &&
                $modal_conditional
            ) {
                $class_grid = isset( $modal_data['top_loop']['column'] ) ? $modal_data['top_loop']['column'] : '';

                ?>

                <div id="viwcpf-side-filters-top">
                    <div class="viwcpf-side-panel">
                        <header>
                            <h6 class="viwcpf-modal-header-title-wrap"><?php esc_html_e( 'Filters', 'pofily-woocommerce-product-filters' ); ?></h6>
                            <div class="viwcpf-modal-close-wrap">
                                <i class="viwcpf-icon-filter-close"></i>
                            </div>
                        </header>
                        <div class="viwcpf-side-panel-content viwcpf-grid <?php echo esc_attr( 'viwcpf-grid-' . $class_grid ); ?>">
                            <?php
                            foreach ( $modal_menu_arr_id as $menu_id ) {
                                if ( $menu_id && count( shortcode_parse_atts( $menu_id ) ) > 1 ) {
                                    $menu_id = '';
                                    continue;
                                }
                                echo do_shortcode( '[VIWCPF_SHORTCODE id_menu="' . $menu_id . '"]' );
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
    }


    /**
     * Add custom class too wrap product loop
     *
     * @param string $html_loop_start
     *
     * @return string|void
     */
    public static function viwcpfAddClassWrapProducts( $html_loop_start ) {

        if ( preg_match( '/class="(.*?(?="))"/', $html_loop_start, $match ) ) {
            preg_match( '/class="(.*?(?="))"/', $html_loop_start, $match );
            $old_class       = $match[1] ?? '';
            $html_loop_start = str_replace( $old_class, $old_class . ' viwcpf-wrap-products', $html_loop_start );
        }

        return $html_loop_start;
    }

    /**
     * HTML wrapper to insert before the not found product loops.
     *
     * @param string $template_name
     *
     * @return void
     */
    public static function viwcpfBeforeNotFoundProducts( $template_name = '' ) {
        if ( $template_name == 'loop/no-products-found.php' ) {
            echo '<div class="viwcpf-wrap-products">';
        }
    }

    /**
     * HTML wrapper to insert after the not found product loops.
     *
     * @param string $template_name
     *
     * @return void
     */
    public static function viwcpfAfterNotFoundProducts( $template_name = '' ) {
        if ( $template_name == 'loop/no-products-found.php' ) {
            echo '</div>';
        }
    }

}

