/*
Author: DubleyNguyen
Author URI: http://villatheme.com
Copyright 2021 villatheme.com. All rights reserved.
*/
jQuery(document).ready(function ($) {
    "use strict";
    /* global  jQuery, viwcpf_localize_args, accounting */
    let woo_currency_symbol = viwcpf_localize_args.currency_format.symbol;
    if ($('body.archive').hasClass('woocommerce-page')) {
        $('body.archive').append(`<div class="viwcpf_filter_loading"><div class="viwcpf_filter_loading_effect"></div></div>`);
    }

    _submit_filter_with_btn();
    _viwcpf_tooltip($('.viwcpf_filter-items'));
    _displayToggle($('.viwcpf_filter-title.collapsable'));
    _viwcpf_init();

    /*Redirect when click on input checkbox filter */
    $('.viwcpf_filter-items .viwcpf_filter-item.viwcpf_checkbox .viwcpf_checkbox_checkmark').on('click', function (e) {
        let $this = $(this),
            $thisClosest = $this.closest('.viwcpf_filter-item.viwcpf_checkbox'),
            $thisWrap = $this.closest('.viwcpf_wrap_checkbox'),
            alinkFilter = $thisClosest.find('a.viwcpf_link_checkbox').attr('href'),
            aFilter = $thisClosest.find('a.viwcpf_link_checkbox'),
            formFilter = $thisClosest.closest('.viwcpf_form_filter');

        if (formFilter.hasClass('has-submit-btn')) {
            aFilter.trigger('click');
            e.preventDefault();

        } else {
            _viwcpf_effect_loading('show');

            window.location.replace(alinkFilter);
        }

    });


    function _viwcpf_init() {
        $('.viwcpf_wrap_filter-content').each(function () {
            let $this = $(this),
                $thisDropdown = $this.find('.viwcpf_wrap_dropdown'),
                $thisRangeSlide = $this.find('.viwcpf_filter.viwcpf_range_slider'),
                $thisSearchField = $this.find('.viwcpf_filter.viwcpf_search_field');

            if ($thisDropdown.length > 0) {
                _viwcpf_dropdown($thisDropdown);
            }
            if ($thisRangeSlide.length > 0) {
                _filterRangeSlider($thisRangeSlide);
            }
            if ($thisSearchField.length > 0) {
                _filterTextSearch($thisSearchField);
            }
            _displayViewmore($this.find('.viwcpf_filter-items.has_view_more'));
        });
    }

    jQuery(document.body).on('wmc_cache_compatible_finish', function (e, xhr) {
        let current_currency = xhr.current_currency,
            vmc_list_rates = viwcpf_localize_args.vmc_list_rates,
            vmc_list_symbol = viwcpf_localize_args.vmc_list_symbol,
            current_rate_data = vmc_list_rates[current_currency],
            current_rate = current_rate_data.rate;


        $('.viwcpf_wrap_filter-content').each(function () {
            let $this = $(this),
                content_type = $this.attr('data-filter_by');

            if (content_type == 'filter_by_price') {
                /*For price range slider*/
                let $thisRangeSlide = $this.find('.viwcpf_filter.viwcpf_range_slider');
                if ($thisRangeSlide.length > 0) {
                    $thisRangeSlide.map(function () {
                        let th = $(this);
                        let cache_currency = th.attr('data-currency'),
                            cache_rate_data = vmc_list_rates[cache_currency],
                            cache_rate = cache_rate_data.rate,
                            current_data_min = th.attr('data-min'),
                            current_data_max = th.attr('data-max'),
                            current_step = th.attr('data-step');
                        let new_data_min = current_data_min / cache_rate * current_rate;
                        let new_data_max = current_data_max / cache_rate * current_rate;
                        let new_step = current_step / cache_rate * current_rate;
                        woo_currency_symbol = vmc_list_symbol[current_currency];
                        th.attr('data-min', new_data_min);
                        th.attr('data-max', new_data_max);
                        th.attr('data-step', new_step);
                        th.attr('data-currency', current_currency);

                        _filterRangeSlider(th, 'update');
                    });
                }
                /*Fore price range*/
                let viwcpf_filter_items = $this.find('.viwcpf_filter-items');

                if (viwcpf_filter_items.length > 0) {
                    viwcpf_filter_items.map(function () {
                        let th = $(this);
                        let th_cache_currency = th.attr('data-currency'),
                            th_cache_rate_data = vmc_list_rates[th_cache_currency],
                            th_cache_rate = th_cache_rate_data.rate,
                            woo_currency_symbol = vmc_list_symbol[current_currency];

                        if (th.hasClass('viwcpf_dropdown')) {

                            let th_select_option = th.find('option');
                            th_select_option.each(function () {
                                let th_option = $(this),
                                    old_option_value = th_option.val(),
                                    old_option_text = th_option.text(),
                                    old_option_filter_url = th_option.attr('data-filter_url');

                                if (old_option_value.length > 0) {
                                    let arr_old_option_value = old_option_value.split("-");
                                    let new_data_min = arr_old_option_value[0] / th_cache_rate * current_rate;
                                    let new_data_max = '';
                                    if (arr_old_option_value[1] == viwcpf_localize_args.php_int_max) {
                                        new_data_max = viwcpf_localize_args.php_int_max;
                                        th_option.text(woo_currency_symbol + new_data_min + ' to above');
                                    } else {
                                        new_data_max = arr_old_option_value[1] / th_cache_rate * current_rate;
                                        th_option.text(woo_currency_symbol + new_data_min + ' to ' + woo_currency_symbol + new_data_max);
                                    }
                                    th_option.val(new_data_min + '-' + new_data_max);
                                }
                            });
                            th.attr('data-currency', current_currency);

                            /* _viwcpf_dropdown(th, 'update');*/
                        } else {
                            let th_select_values = th.find('.viwcpf_filter-item');
                            th_select_values.each(function () {
                                let th_li = $(this),
                                    th_li_a = th_li.find('a'),
                                    old_value = th_li_a.attr('data-value'),
                                    new_text = '',
                                    old_filter_url = th_li_a.attr('href');

                                if (old_value.length > 0) {
                                    let arr_old_value = old_value.split("-");
                                    let new_data_min = arr_old_value[0] / th_cache_rate * current_rate;
                                    let new_data_max = 0;
                                    let url = new URL(old_filter_url),
                                        paramsUrl = url.searchParams;
                                    if (arr_old_value[1] === viwcpf_localize_args.php_int_max) {
                                        new_data_max = viwcpf_localize_args.php_int_max;
                                        new_text = `<span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">${woo_currency_symbol}</span>${new_data_min}</span> to above`;
                                    } else {
                                        new_data_max = arr_old_value[1] / th_cache_rate * current_rate;
                                        new_text = `<span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">${woo_currency_symbol}</span>${new_data_min}</span> to <span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">${woo_currency_symbol}</span>${new_data_max}</span> `;
                                    }

                                    th_li_a.html(new_text);
                                    th_li_a.attr('data-value', new_data_min + '-' + new_data_max);
                                    paramsUrl.set('min_price', new_data_min.toString());
                                    paramsUrl.set('max_price', new_data_max.toString());
                                    url.search = paramsUrl.toString();
                                    th_li_a.attr('href', decodeURIComponent(url.toString()));
                                }
                            });
                        }
                    });
                }
            }


        });
    });

    $(document).on('click', '.viwcpf-modal-close-wrap .viwcpf-icon-filter-close', function () {
        if ((typeof viwcpf_localize_args.modal_style !== 'undefined')) {
            let sidebar_top = $('#viwcpf-side-filters-top'),
                is_visible = sidebar_top.is(':visible');
            if (viwcpf_localize_args.modal_style === 'top_product_loop') {
                sidebar_top.slideToggle(200, function () {
                    is_visible ? sidebar_top.removeClass('fade-in') : sidebar_top.addClass('fade-in');
                });
            }
        }
        return false;
    });

    function _submit_filter_with_btn() {
        $('.viwcpf_form_filter').each(function () {
            let $thisForm = $(this);
            if ($thisForm.hasClass('has-submit-btn')) {
                $thisForm.find('.viwcpf_wrap_filter-content').each(function () {
                    let $this = $(this);
                    $(this).find('.input_filter_hidden').each(function () {
                        let th = $(this),
                            th_value = th.val();
                        if (th_value != '') {
                            if (th.hasClass('query_type')) {
                                let th_query_type_closest = th.closest('.viwcpf_wrap_filter-content'),
                                    th_query_type_tax = th_query_type_closest.find('.filter_by_taxonomy'),
                                    th_query_type_tax_val = th_query_type_tax.val();
                                if (th_query_type_tax_val !== '') {
                                    th.prop('disabled', false);
                                } else {
                                    th.prop('disabled', true);
                                }
                            } else if (th.hasClass('hidden_meta_type')) {
                            } else {
                                th.prop('disabled', false);
                            }
                        } else {
                            th.prop('disabled', true);
                        }
                    });
                });

                $thisForm.find('.input_filter_hidden').on('change', function () {
                    let th = $(this),
                        $this_closest = th.closest('.viwcpf_wrap_filter-content'),
                        hiden_query_type = $this_closest.find('.input_filter_hidden.query_type'),
                        hiden_meta_type = $this_closest.find('.input_filter_hidden.hidden_meta_type'),
                        th_value = th.val();

                    if (th_value !== '') {

                        hiden_query_type.prop('disabled', false);
                        hiden_meta_type.prop('disabled', false);
                        th.prop('disabled', false);

                    } else {

                        hiden_query_type.prop('disabled', true);
                        hiden_meta_type.prop('disabled', true);
                        th.prop('disabled', true);

                    }
                });

                $thisForm.find('.viwcpf_filter-items a').on('click', function () {
                    let th = $(this),
                        $this_checkbox = th.closest('.viwcpf_filter-item.viwcpf_checkbox').find('input.viwcpf_checkbox'),
                        $this_closest = th.closest('.viwcpf_wrap_filter-content'),
                        $this_filter_multiple = $this_closest.data('filter_multiple'),
                        $this_filter_by = $this_closest.data('filter_by'),
                        $this_filter_type = $this_closest.data('filter_type'),
                        $this_filter_relation = $this_closest.data('filter_relation'),
                        th_value = th.data('value'),
                        input_hidden = $this_closest.find('.input_filter_hidden.' + $this_filter_by),
                        input_hidden_val = input_hidden.val(),
                        new_arr_val = [];

                    if ($this_filter_multiple === 'yes') {
                        th.toggleClass('viwcpf_chosen');
                    } else {
                        $this_closest.find('.viwcpf_filter-items a').not(this).removeClass('viwcpf_chosen');
                        th.toggleClass('viwcpf_chosen');
                    }

                    switch ($this_filter_by) {
                        case 'filter_by_taxonomy':
                            $this_closest.find('.viwcpf_filter-items .viwcpf_chosen').each(function () {
                                let viwcpf_chosen = $(this),
                                    chosen_val = viwcpf_chosen.data('value');
                                if (typeof chosen_val !== 'undefined') {
                                    new_arr_val.push(chosen_val);
                                }
                            });
                            if (
                                ($this_filter_type === 'pofily-cat') ||
                                ($this_filter_type === 'pofily-tag')
                            ) {
                                /* if ($this_filter_relation.toLowerCase() === 'and') {
                                     input_hidden.val(new_arr_val.join(" ")).trigger('change');
                                 } else {
                                 }*/
                                input_hidden.val(new_arr_val.join(",")).trigger('change');
                                /*Disable query type when filter cat or tag*/
                                /*if (typeof viwcpf_localize_args.seo_rule === 'undefined' || viwcpf_localize_args.seo_rule === '') {
                                    $this_closest.find('.input_filter_hidden.query_type').prop('disabled', true);
                                }*/
                            } else {
                                input_hidden.val(new_arr_val.join(",")).trigger('change');
                            }

                            break;
                        case 'filter_by_price':
                            let chosen_val = '';
                            $this_closest.find('.viwcpf_filter-items .viwcpf_chosen').each(function () {
                                let viwcpf_chosen = $(this);
                                chosen_val = viwcpf_chosen.data('value');
                            });
                            new_arr_val = chosen_val.split("-");
                            $this_closest.find('.input_filter_hidden.min_price').val(new_arr_val[0]).trigger('change');
                            $this_closest.find('.input_filter_hidden.max_price').val(new_arr_val[1] == viwcpf_localize_args.php_int_max ? '' : new_arr_val[1]).trigger('change');
                            break;
                        case 'filter_by_review':
                            $this_closest.find('.viwcpf_filter-items .viwcpf_chosen').each(function () {
                                let viwcpf_chosen = $(this),
                                    chosen_val = viwcpf_chosen.data('value');
                                new_arr_val.push(chosen_val);
                            });
                            input_hidden.val(new_arr_val.join(",")).trigger('change');
                            break;
                        case 'filter_by_sale_or_stock':
                            let arr_chosen = [];
                            $this_closest.find('.viwcpf_filter-items .viwcpf_chosen').each(function () {
                                let viwcpf_chosen = $(this),
                                    chosen_val = viwcpf_chosen.data('value');
                                new_arr_val[chosen_val] = '1';
                            });
                            $this_closest.find('.input_filter_hidden').val('').trigger('change');
                            for (let item_chosen in new_arr_val) {
                                $this_closest.find('.input_filter_hidden.' + item_chosen).val(new_arr_val[item_chosen]).trigger('change');
                            }
                            break;
                        case 'filter_by_metabox':
                            if ($this_closest.find('.input_filter_hidden.hidden_meta_type').val() === 'string') {
                                $this_closest.find('.viwcpf_filter-items .viwcpf_chosen').each(function () {
                                    let viwcpf_chosen = $(this),
                                        chosen_val = viwcpf_chosen.data('value');
                                    new_arr_val.push(chosen_val);
                                });
                                input_hidden.val(new_arr_val.join(",")).trigger('change');
                            } else if ($this_closest.find('.input_filter_hidden.hidden_meta_type').val() === 'numberic') {
                                let chosen_val = '';
                                $this_closest.find('.viwcpf_filter-items .viwcpf_chosen').each(function () {
                                    let viwcpf_chosen = $(this);
                                    chosen_val = viwcpf_chosen.data('value');
                                });
                                input_hidden.val(chosen_val).trigger('change');

                            }
                            break;
                        default:
                            break;
                    }

                    if (th.hasClass('viwcpf_chosen')) {
                        $this_checkbox.prop('checked', true).trigger('change');
                    } else {
                        $this_checkbox.prop('checked', false).trigger('change');
                    }

                    return false;
                });

                $thisForm.find('.viwcpf-apply-filters').on('click', function () {
                    _viwcpf_effect_loading('show');
                });


                if ($thisForm.hasClass('with-ajax')) {
                    $thisForm.on('submit', function () {
                        if (typeof viwcpf_localize_args.seo_rule !== 'undefined' && viwcpf_localize_args.seo_rule !== '') {
                            _viwcpf_ajaxFilterProducts(_viwcpfRenderSeoUrl($thisForm.attr('action'), $thisForm.serializeArray()));

                        } else {
                            let url = new URL($thisForm.attr('action') || location.href), data = $thisForm.serialize();
                            url = url.href.replace(url.search, '') + (data ? `?${data}` : '');
                            _viwcpf_ajaxFilterProducts(url);
                           /*  let search_params = window.location.search;
                             if (search_params && search_params.length > 0) {
                                 _viwcpf_ajaxFilterProducts($thisForm.attr('action') + '&' + $thisForm.serialize());
                             } else {
                                 _viwcpf_ajaxFilterProducts($thisForm.attr('action') + '?' + $thisForm.serialize());
                             }*/
                        }
                        return false;
                    });
                } else {
                    $thisForm.on('submit', function () {

                        if (typeof viwcpf_localize_args.seo_rule !== 'undefined' && viwcpf_localize_args.seo_rule !== '') {

                            window.location.replace(_viwcpfRenderSeoUrl($thisForm.attr('action'), $thisForm.serializeArray()));
                            return false;
                        }

                        return true;
                    });
                }
            } else {
                $thisForm.find('.viwcpf_filter-items a').on('click', function () {
                    _viwcpf_effect_loading('show');
                });
                $thisForm.on('submit', function () {
                    return false;
                });
            }
        });
        $('a.active_filter_label, a.viwcpf_clear_block_filter_btn').on('click', function () {
            if (typeof viwcpf_localize_args.using_ajax != 'undefined') {
                let href = $(this).attr('href');
                _viwcpf_ajaxFilterProducts(href);
                return false;
            } else {
                _viwcpf_effect_loading('show');
            }
        });
    }

    function _viwcpf_tooltip($filter) {
        let position = '';
        $filter.find('[data-tooltip]').each(function () {
            const t = $(this);
            if (t.hasClass('viwcpf_tooltip-added') || !t.data('tooltip')) {
                return;
            }

            t.on('mouseenter', function () {
                let th = $(this),
                    tooltip = null,
                    wrapperWidth = th.outerWidth(),
                    left = 0,
                    width = 0;

                const container = th.closest('.viwcpf_filter-item');
                position = container.is('.viwcpf_label, .viwcpf_images, .viwcpf_color_swatches') ? 'top' : 'right';

                tooltip = $('<span>', {
                    class: 'viwcpf-tooltip',
                    html: th.data('tooltip'),
                });
                th.append(tooltip);
                width = tooltip.outerWidth() + 6;
                tooltip.outerWidth(width);

                if ('top' === position) {
                    left = (wrapperWidth - width) / 2;
                } else {
                    left = wrapperWidth + 15;
                }
                tooltip.css({
                    left: left.toFixed(0) + 'px'
                }).fadeIn(200);
                th.addClass('with-tooltip');
            }).on('mouseleave', function () {
                const th = $(this);
                th.find('.viwcpf-tooltip').fadeOut(200, function () {
                    th.removeClass('with-tooltip').find('.viwcpf-tooltip').remove();
                });
            });
            t.addClass('viwcpf_tooltip-added');
        });
    }

    function _viwcpf_dropdown(selector, type = '') {

        let show_search = selector.find('select').data('show_search'),
            multiple = selector.find('select').data('filter_multiple'),
            arr_val = [],
            is_show_search_field,
            wrap_selector = selector.closest('.viwcpf_filter-wrap-items'),
            wrap_selector_content = selector.closest('.viwcpf_wrap_filter-content'),
            wrap_form_filter = selector.closest('.viwcpf_form_filter');

        if (show_search) {
            is_show_search_field = true;
        } else {
            is_show_search_field = false;
        }

        let viwcpf_dropdown = selector.vi_dropdown({
            searchable: is_show_search_field,
            extendProps: ['filter_url', 'count'],
            choice: function (e) {
                let current_choice = this.$select.val();
                let choice_target = $(e.target);
                if (selector.closest('.viwcpf_form_filter').hasClass('has-submit-btn')) {
                    arr_val = [];
                    let ObjVal;
                    if (Array.isArray(current_choice)) {
                        ObjVal = current_choice;
                    } else {
                        ObjVal = [current_choice];
                    }

                    for (let item of ObjVal) {
                        arr_val.push(item);
                    }
                    _update_hide_input_dropdown(selector, arr_val);

                } else {
                    _viwcpf_effect_loading('show');
                    let paramsUrl = new URLSearchParams(window.location.search),
                        urlOrigin = window.location.origin,
                        urlPathName = window.location.pathname,
                        data_filter_by = wrap_selector_content.attr('data-filter_by');
                    if (current_choice.length === 0) {

                       /*  let linkFilter = this.$select.find('option:selected').data('filter_url');*/

                        if (data_filter_by === 'filter_by_price') {
                            paramsUrl.delete('min_price');
                            paramsUrl.delete('max_price');
                        } else {
                            let name_param = wrap_selector.find('input.viwcpf_filter_value').attr('name');
                            let query_type = wrap_selector.find('input.query_type').attr('name');
                            paramsUrl.delete(name_param);
                            paramsUrl.delete(query_type);
                        }

                        let arrParamUrl = [];
                        for (const [key, value] of paramsUrl) {
                            arrParamUrl[key] = value;
                        }
                        let objectParamUrl = Object.assign({}, arrParamUrl); /*Convert array to object*/
                        let convertParamUrl = jQuery.param(objectParamUrl);

                        if (wrap_form_filter.hasClass('with-ajax')) {

                            if (convertParamUrl !== '') {
                                _viwcpf_ajaxFilterProducts(urlOrigin + urlPathName + '?' + convertParamUrl);
                            } else {
                                _viwcpf_ajaxFilterProducts(urlOrigin + urlPathName);
                            }
                        } else {
                            if (convertParamUrl !== '') {
                                window.location.replace(urlOrigin + urlPathName + '?' + convertParamUrl);

                            } else {
                                window.location.replace(urlOrigin + urlPathName);
                            }
                        }

                    } else {
                        if (choice_target.hasClass('del')) {

                            if (data_filter_by === 'filter_by_price') {
                                paramsUrl.delete('min_price');
                                paramsUrl.delete('max_price');
                            } else {
                                let name_param = wrap_selector.find('input.viwcpf_filter_value').attr('name');
                                let query_type = wrap_selector.find('input.query_type').attr('name');
                                paramsUrl.delete(name_param);
                                paramsUrl.delete(query_type);
                            }

                            let arrParamUrl = [];
                            for (const [key, value] of paramsUrl) {
                                arrParamUrl[key] = value;
                            }
                            let objectParamUrl = Object.assign({}, arrParamUrl); /*Convert array to object*/
                            let convertParamUrl = jQuery.param(objectParamUrl);
                            if (wrap_form_filter.hasClass('with-ajax')) {
                                if (convertParamUrl !== '') {

                                    _viwcpf_ajaxFilterProducts(urlOrigin + urlPathName + '?' + convertParamUrl);
                                } else {

                                    _viwcpf_ajaxFilterProducts(urlOrigin + urlPathName);
                                }
                            } else {
                                if (convertParamUrl !== '') {
                                    window.location.replace(urlOrigin + urlPathName + '?' + convertParamUrl);

                                } else {
                                    window.location.replace(urlOrigin + urlPathName);
                                }
                            }

                        } else {

                            let linkFilter = choice_target.data('filter_url');
                            if (wrap_form_filter.hasClass('with-ajax')) {
                                _viwcpf_ajaxFilterProducts(linkFilter);
                            } else {
                                window.location.replace(linkFilter);
                            }
                        }

                    }
                }
            }
        });
        if (type === 'update') {
            let viwcpf_dropdown_data = viwcpf_dropdown.data("vi_dropdown");
            viwcpf_dropdown_data.update({});
        }


        return selector;
    }

    function _update_hide_input_dropdown(selector, arr_val) {
        let th = selector,
            $this_closest = th.closest('.viwcpf_wrap_filter-content'),
            $this_filter_multiple = th.data('filter_multiple'),
            $this_filter_by = $this_closest.data('filter_by'),
            $this_filter_type = $this_closest.data('filter_type'),
            $this_filter_relation = $this_closest.data('filter_relation'),
            input_hidden = $this_closest.find('.input_filter_hidden.' + $this_filter_by),
            input_hidden_val = input_hidden.val(),
            new_arr_val = [];

        switch ($this_filter_by) {
            case 'filter_by_taxonomy':

                if (
                    ($this_filter_type === 'pofily-cat') ||
                    ($this_filter_type === 'pofily-tag')
                ) {
                    if ($this_filter_relation === 'AND') {
                        input_hidden.val(arr_val.join("+")).trigger('change');
                    } else {
                        input_hidden.val(arr_val.join(",")).trigger('change');
                    }
                } else {
                    input_hidden.val(arr_val.join(",")).trigger('change');
                }

                break;
            case 'filter_by_price':

                new_arr_val = arr_val[0].split("-");
                $this_closest.find('.input_filter_hidden.min_price').val(new_arr_val[0]).trigger('change');
                $this_closest.find('.input_filter_hidden.max_price').val(new_arr_val[1] == viwcpf_localize_args.php_int_max ? '' : new_arr_val[1]).trigger('change');
                break;
            case 'filter_by_review':

                input_hidden.val(arr_val.join(",")).trigger('change');
                break;

            case 'filter_by_metabox':
                if ($this_closest.find('.input_filter_hidden.hidden_meta_type').val() === 'string') {

                    input_hidden.val(arr_val.join(",")).trigger('change');
                } else if ($this_closest.find('.input_filter_hidden.hidden_meta_type').val() === 'numberic') {

                    input_hidden.val(arr_val[0]).trigger('change');

                }
                break;
            default:
                break;
        }
    }

    function _dropdown_check_multiple(multiple) {
        return multiple === 'yes';
    }

    function _dropdown_placeholder(multiple) {
        if (multiple === 'yes') {
            return 'Choose / Search...';
        } else {
            return {
                id: '-1',/*  the value of the option*/
                text: 'All'
            };
        }
    }

    function _filterRangeSlider(selector, type = '') {
        if (!selector.hasClass('viwcpf_range_slider')) {
            return;
        }

        let $container = selector,
            $wrapContainer = selector.closest('.viwcpf_wrap_filter-content'),
            filter_type = String($wrapContainer.data('filter_type')),
            $minInput = selector.find('.range-slider-min'),
            $maxInput = selector.find('.range-slider-max'),
            $minHiddenInput = $wrapContainer.find('input[name=min_price]'),
            $maxHiddenInput = $wrapContainer.find('input[name=max_price]'),
            $metaHiddenInput = $wrapContainer.find('.hidden_meta_value'),
            min = parseFloat($container.data('min')),
            max = parseFloat($container.data('max')),
            urlBase = $container.data('link'),
            currentMin = parseFloat($minInput.val()),
            currentMax = parseFloat($maxInput.val()),
            step = parseFloat($container.data('step')),
            filter_for = String($container.data('filter_for')),
            number_symbol = '',
            wrap_form_filter = selector.closest('.viwcpf_form_filter');

        if (filter_for === 'filter_by_price') {
            number_symbol = String('price');
        }
        let viwcpf_range_slider_ui = selector.find('.viwcpf-range-slider-ui');
        viwcpf_range_slider_ui.ionRangeSlider({
            skin: 'round',
            type: 'double',
            min: min,
            max: max,
            step: step,
            from: currentMin,
            to: currentMax,
            min_interval: step,
            values_separator: ' - ',
            prettify: (v) => __viwcpfFormatNumber(v, number_symbol),
            onChange: (data) => {
                $minInput.val(data.from);
                $maxInput.val(data.to);
            },
            onFinish: (data) => {
                if ($container.closest('.viwcpf_form_filter').hasClass('has-submit-btn')) {
                    if (
                        (data.from === min) &&
                        (data.to === max)
                    ) {

                        if (filter_for === 'filter_by_price') {
                            $minHiddenInput.val('').trigger('change');
                            $maxHiddenInput.val('').trigger('change');
                        } else {
                            $metaHiddenInput.val('').trigger('change');

                        }
                    } else {
                        if (filter_for === 'filter_by_price') {
                            $minHiddenInput.val(data.from).trigger('change');
                            $maxHiddenInput.val(data.to).trigger('change');
                        } else {
                            $metaHiddenInput.val(data.from + '-' + data.to).trigger('change');
                        }
                    }

                } else {
                    _viwcpf_effect_loading('show');

                    if ($(this).sliderTimeout) {
                        clearTimeout($(this).sliderTimeout);
                    }

                    $(this).sliderTimeout = setTimeout(function () {
                        let paramsUrl = new URLSearchParams(window.location.search);
                        if (
                            (data.from === min) &&
                            (data.to === max)
                        ) {

                            if (filter_for === 'filter_by_price') {
                                paramsUrl.delete("min_price");
                                paramsUrl.delete("max_price");
                            } else {
                                let arr_filter_type = filter_type.split(",");

                                for (let paramUrlDel of arr_filter_type) {
                                    paramsUrl.delete(paramUrlDel);
                                }
                            }

                            let arrParamUrl = [];
                            for (const [key, value] of paramsUrl) {
                                arrParamUrl[key] = value;
                            }
                            let objectParamUrl = Object.assign({}, arrParamUrl); /*Convert array to object*/
                            let convertParamUrl = jQuery.param(objectParamUrl);
                            if (wrap_form_filter.hasClass('with-ajax')) {
                                _viwcpf_ajaxFilterProducts(urlBase + '?' + convertParamUrl);
                            } else {
                                window.location.replace(urlBase + '?' + convertParamUrl);
                            }
                        } else {
                            if (filter_for === 'filter_by_price') {
                                paramsUrl.set("min_price", data.from);
                                paramsUrl.set("max_price", data.to);
                            } else {
                                let arr_filter_type = filter_type.split(",");

                                paramsUrl.set(arr_filter_type[0], data.from + '-' + data.to);
                                paramsUrl.set(arr_filter_type[1], 'numberic');
                            }

                            let arrParamUrl = [];
                            for (const [key, value] of paramsUrl) {
                                arrParamUrl[key] = value;
                            }
                            let objectParamUrl = Object.assign({}, arrParamUrl); /*Convert array to object*/
                            let convertParamUrl = jQuery.param(objectParamUrl);

                            if (wrap_form_filter.hasClass('with-ajax')) {
                                _viwcpf_ajaxFilterProducts(urlBase + '?' + convertParamUrl);
                            } else {

                                window.location.replace(urlBase + '?' + convertParamUrl);
                            }
                        }

                    }, 200);
                }

            },
        });
        if (type === 'update') {
            let $container = selector,
                new_min = parseFloat($container.attr('data-min')),
                new_max = parseFloat($container.attr('data-max')),
                new_step = parseFloat($container.attr('data-step')),
                $minInput = selector.find('.range-slider-min'),
                $maxInput = selector.find('.range-slider-max'),
                currentMin = parseFloat($minInput.val()),
                currentMax = parseFloat($maxInput.val()),
                number_symbol = 'price';
            let viwcpf_range_slider_ui_data = viwcpf_range_slider_ui.data("ionRangeSlider");
            viwcpf_range_slider_ui_data.update({
                min: new_min,
                max: new_max,
                step: new_step,
                from: new_min,
                to: new_max,
                prettify: (v) => __viwcpfFormatNumber(v, number_symbol),
            });
        }
    }

    function _filterTextSearch(selector) {
        if (!selector.hasClass('viwcpf_search_field')) {
            return;
        }
        let $container = selector,
            $wrapContainer = selector.closest('.viwcpf_wrap_filter-content'),
            filter_type = String($wrapContainer.data('filter_type')),
            $searchField = selector.find('input.viwcpf_text_search'),
            $searchFieldValue = $searchField.val(),
            $resetField = selector.find('.viwcpf_search_reset'),
            filter_for = String($container.data('filter_for')),
            wrap_form_filter = selector.closest('.viwcpf_form_filter'),
            trending_searches = $wrapContainer.find('.trending-searches .popular-keyword');

        if ($searchFieldValue != '') {
            $resetField.show();
        }

        $($searchField).on('change', function (e) {
            let $searchVal = $(e.target).val(),
                paramsUrl = new URLSearchParams(window.location.search),
                urlOrigin = window.location.origin,
                urlPathName = window.location.pathname;
            if ($searchVal !== '') {
                paramsUrl.set("s", $searchVal);
                $resetField.show();
            } else {
                paramsUrl.delete("s");
                $resetField.hide();
            }

            if ($container.closest('.viwcpf_form_filter').hasClass('has-submit-btn')) {
                $('.input_filter_hidden.filter_by_name_product').val($searchVal).trigger('change');
            } else {
                _viwcpf_effect_loading('show');

                let arrParamUrl = [];
                for (const [key, value] of paramsUrl) {
                    arrParamUrl[key] = value;
                }
                let objectParamUrl = Object.assign({}, arrParamUrl); /*Convert array to object*/
                let convertParamUrl = jQuery.param(objectParamUrl);
                if (wrap_form_filter.hasClass('with-ajax')) {
                    _viwcpf_ajaxFilterProducts(urlOrigin + urlPathName + '?' + convertParamUrl);
                } else {
                    window.location.replace(urlOrigin + urlPathName + '?' + convertParamUrl);
                }
            }


        });
        $resetField.on('click', function (e) {
            let $thisWrap = $(e.target).closest('.viwcpf_filter'),
                $thisField = $thisWrap.find('.viwcpf_text_search');
            $thisField.val('').trigger('change');
            return false;
        });
        trending_searches.on('click', function (e) {
            let t = $(e.target),
                $thisWrap = t.closest('.viwcpf_filter-wrap-items'),
                $thisField = $thisWrap.find('.viwcpf_text_search'),
                trending_key_search = t.attr('data-key_search');
            $thisField.val(trending_key_search).trigger('change');
            return false;
        });
    }

    /*
    * var number - (int)numberic (Maybe is Price or Number)
    * var num_symbol - price
    */
    function __viwcpfFormatNumber(num, number_symbol) {
        if ('undefined' !== typeof accounting) {
            if (number_symbol === 'price') {
                num = accounting.formatMoney(num, {
                    symbol: woo_currency_symbol,
                    decimal: viwcpf_localize_args.currency_format.decimal,
                    thousand: viwcpf_localize_args.currency_format.thousand,
                    precision: 0,
                    format: viwcpf_localize_args.currency_format.format,
                });
            } else {
                num = accounting.formatMoney(num, {
                    symbol: '',
                    decimal: viwcpf_localize_args.currency_format.decimal,
                    thousand: viwcpf_localize_args.currency_format.thousand,
                    precision: 0,
                    format: viwcpf_localize_args.currency_format.format,
                });
            }
        }
        return num;
    }

    function _displayToggle(selector) {

        selector.off("click").on("click", function (event) {
            event.stopPropagation();
            let t = $(this);
            let wrap_items = t.closest('.viwcpf_wrap_filter-content').find('.viwcpf_filter-wrap-items');
            if (t.hasClass("closed")) {
                wrap_items.hide();
            }
            t.toggleClass("opened").toggleClass("closed");
            wrap_items.slideToggle().toggleClass('closed');
        });
    }

    function _displayViewmore(selector) {
        let wrap = selector.closest('.viwcpf_wrap_filter-content'),
            number_limit = selector.data('view_more'),
            size_li = selector.find('li.viwcpf_filter-item').length,
            toggle_status = false;
        selector.find('li.viwcpf_filter-item:lt(' + number_limit + ')').show();

        if (size_li <= number_limit) {
            wrap.find('.viwcpf_view_more_btn').hide();
        }
        $('.viwcpf_view_more_btn').on('click', function () {
            let $this = $(this),
                wrapList = $(this).closest('.viwcpf_wrap_filter-content');
            if (!toggle_status) {
                wrapList.find('li.viwcpf_filter-item').show();
                toggle_status = true;
            } else {
                if (typeof number_limit !== 'undefined') {
                    wrapList.find('li.viwcpf_filter-item').hide();
                    wrapList.find('li.viwcpf_filter-item:lt(' + (number_limit) + ')').show();
                }
                toggle_status = false;
            }
           /* $(this).hide();*/
            return false;
        });
    }

    /*Function delete duplicate elements in array */
    function _viwcpf_unique_arr(arr) {
        let newArr = [];
        if (Array.isArray(arr)) {
            for (let i = 0; i < arr.length; i++) {
                if (newArr.indexOf(arr[i]) === -1) {
                    newArr.push(arr[i])
                }
            }
        } else {
            newArr = arr;
        }

        return newArr
    }

    /*Function show/hide filter loading*/
    function _viwcpf_effect_loading(type = '') {
        if (type.length <= 0) {
            return '';
        }
        if (type.toString() === 'show') {
            $('.viwcpf_filter_loading').addClass('loading');
        } else if (type.toString() === 'hide') {
            $('.viwcpf_filter_loading').removeClass('loading');
        }
    }


    /*Update query string for categories, meta etc..*/
    function _viwcpfRenderSeoUrl(urlAction, formData) {

        if (typeof urlAction === 'undefined') {
            return;
        }
        if (typeof formData === 'undefined') {
            return;
        }

        let new_url = '',
            urlVars = {},
            newUrlVars = {},
            catSlug = 'product_cat',
            tagSlug = 'product_tag',
            minPriceSlug = 'min_price',
            maxPriceSlug = 'max_price',
            isOnsale = 'isOnsale',
            isOnsaleSlug = 'onsale_filter',
            isInstock = 'isInstock',
            isInstockSlug = 'instock_filter',
            searchSlug = 's',
            rating = 'rating_filter',
            pa_filter = 'filter_',
            query_type = '',
            query_string = '',
            query_arr = [],
            prefix = '',
            excludeRegex = /viwcpf_metakey_/i;

        for (let i = 0; i < formData.length; i++) {
            if (formData[i]['name'].match(excludeRegex)) {
                query_arr.push(formData[i]);
                continue;
            }
            urlVars[formData[i]['name']] = formData[i]['value'];
        }


        for (const [key, value] of Object.entries(urlVars)) {
            let new_value;
            switch (key) {
                case catSlug :
                    query_type = 'query_type_' + catSlug;
                    prefix = 'pofily-cat';
                    console.log(urlVars[query_type]);
                    if (urlVars[query_type] === 'and') {
                        new_value = value.split(' ').join('---');
                    } else {
                        new_value = value.split(',').join('--');
                    }
                    break;
                case tagSlug:
                    query_type = 'query_type_' + tagSlug;
                    prefix = 'pofily-tag';
                    if (urlVars[query_type].toLowerCase() === 'and') {
                        new_value = value.split(' ').join('---');
                    } else {

                        new_value = value.split(',').join('--');
                    }
                    break;
                case minPriceSlug:
                    prefix = 'minprice';
                    new_value = value;

                    break;
                case maxPriceSlug:
                    prefix = 'maxprice';
                    new_value = value;

                    break;
                case isOnsaleSlug:
                    prefix = 'isOnsale';
                    new_value = '';
                    break;
                case isInstockSlug:
                    prefix = 'isInstock';
                    new_value = '';
                    break;
                case searchSlug:
                    prefix = 'textsearch';
                    new_value = value;
                    break;
                case rating:
                    prefix = 'rating';
                    new_value = value;
                    break;
                default:
                    if (key.match(pa_filter)) {
                        let prefix_filter = key.replace(pa_filter, '');
                        prefix = prefix_filter;
                        query_type = 'query_type_' + prefix_filter;

                        new_value = value.split(',').join('--');
                    }
                    break
            }
            if (key === query_type) {
                continue;
            }

            newUrlVars[prefix] = new_value;
        }

        for (const [key, value] of Object.entries(newUrlVars)) {
            if (key === isOnsale || key === isInstock) {
                new_url += key + '/';
            } else {
                new_url += key + '-' + value + '/';
            }
        }
        if (arrayToSerialize(query_arr).length) {
            query_string = '?' + arrayToSerialize(query_arr);
        }
        return urlAction + new_url + query_string;
    }

    /*serializeObject*/
    function arrayToSerialize(obj) {
        let jsn = '';
        $.each(obj, function () {
            jsn += encodeURI(this.name) + '=' + encodeURI(this.value) + '&';

        });
        return jsn.slice(0, -1);
    }

    /*----------------AJAX-----------------*/
    function _viwcpf_beforeUpdateProducts() {
        /* run before update function: show a loading*/
        _viwcpf_effect_loading('show');
    }

    // scripts to run after updating shop loop
    function _viwcpf_afterUpdateProducts() {
       /* Hidden loading*/
        _viwcpf_effect_loading('hide');

        _viwcpf_compatibility();

        let body = $("html, body");
        body.stop().animate({scrollTop: 0}, 500, 'swing', function () {});

    }


    $(document).on('click', '.with-ajax .viwcpf_filter-item a', function () {
        let href = $(this).attr('href');
        _viwcpf_ajaxFilterProducts(href);
        return false;
    });

    function _viwcpf_ajaxFilterProducts(link, dataRequest = {}) {
        let requestParams = {};
        if (dataRequest.length) {

        }
        requestParams.viwcpf_ajax_link = link;
        requestParams.action = 'ajax_filter';

        let targetPostsContainer = '.viwcpf-wrap-products';
        let paginationContainer = '.woocommerce-pagination';
        let resultCountContainer = '.woocommerce-result-count';

        if (typeof viwcpf_localize_args.shop_loop_container !== "undefined") {
            targetPostsContainer = viwcpf_localize_args.shop_loop_container;
        }
        if (typeof viwcpf_localize_args.shop_pagination_product !== "undefined") {
            paginationContainer = viwcpf_localize_args.shop_pagination_product;
        }

        $.ajax({
            'method': 'POST',
            'data': requestParams,
            'url': link,
            'dataType': 'html',
            beforeSend: function () {
                _viwcpf_beforeUpdateProducts();
            },
            complete: function () {
              /*  After update*/
                _viwcpf_afterUpdateProducts();
            },
            success: function (response) {
                if (typeof response !== 'undefined') {

                   /* Products --  Wrap response to allow .find method search inner elements.*/
                    response = '<div class="viwcpfAjaxResponseWrapper">' + response + '</div>';
                    let $response = $(response);
                    let responseTitle = $response.find('title').text();
                    let responseCanonical = $response.find('link[rel="canonical"]').attr('href');
                    /*Replace wrap product list*/
                    if ($response.find(targetPostsContainer).length > 0) {
                       /* Replace result product*/
                        let templ_replace_content = {};
                        $response.find(targetPostsContainer).each(function (i, e) {
                            templ_replace_content[i] = $response.find(e).html();
                        });

                        $('body').find(targetPostsContainer).each(function (i, e) {
                            let html_filter_result = templ_replace_content[i];
                            if (html_filter_result === '') {
                                html_filter_result = `<div class="type_message">No results found</div>`;
                            }
                            $(e).html(html_filter_result);
                        });

                    } else {
                       /* Replace not found product*/
                        $('body').find(targetPostsContainer).each(function (i, e) {
                            $(e).html(`<div class="type_message">No results found</div>`);
                        });
                    }

                    /*Replace new active filter*/
                    let viwcpfActiveFiltersClass = '.viwcpf_active_filters',
                        newActiveFilters = $response.find(viwcpfActiveFiltersClass).html();

                    if ((typeof newActiveFilters !== 'undefined') && (newActiveFilters.length > 0) && ($(newActiveFilters).length > 0)) {
                        $(viwcpfActiveFiltersClass).html(newActiveFilters);
                    } else {
                        $(viwcpfActiveFiltersClass).html('');
                    }
                    /*For page shop Flatsome*/
                    let category_filtering = '.category-filtering .inline-block';
                    if ((typeof newActiveFilters !== 'undefined') && (newActiveFilters.length > 0) && ($(newActiveFilters).length > 0)) {
                        $(category_filtering).html('<div class="viwcpf_active_filters custom_style">' + newActiveFilters + '</div>').find('h4').remove();
                    } else {
                        $(category_filtering).html('');
                    }
                    /*Replace new pagination*/
                    let newPagination = $response.find(paginationContainer);
                    if (newPagination.length > 0) {
                       /* Replace result product pagination*/
                        let template_replace_pagination = {};
                        newPagination.each(function (i, e) {
                            template_replace_pagination[i] = {
                                class:$response.find(e).attr('class'),/*get class name in case pagination is hidden by css if product not found*/
                                html:$response.find(e).html()
                            };
                        });

                        $('body').find(paginationContainer).each(function (i, e) {
                            let html_filter_result_pagination = template_replace_pagination[i];
                            if (html_filter_result_pagination.html === '') {
                                html_filter_result_pagination = ``;
                            }
                            console.log($(e));
                            console.log(html_filter_result_pagination);
                            $(e).attr('class',html_filter_result_pagination.class);
                            $(e).html(html_filter_result_pagination.html);
                        });

                    } else {
                        /*Replace not found product*/
                        $('body').find(paginationContainer).each(function (i, e) {
                            $(e).html(``);
                        });
                    }
                    /*
                    let newPagination = $response.find(paginationContainer).html();

                    if ((typeof newPagination !== 'undefined') && (newPagination.length > 0) && ($(newPagination).length > 0)) {
                        $(paginationContainer).html(newPagination);
                    } else {
                        $(paginationContainer).html('');
                    }
                    /!*Replace new result count*!/
                    let newResultCount = $response.find(resultCountContainer).html();

                    if ((typeof newResultCount !== 'undefined') && (newResultCount.length > 0)) {
                        $(resultCountContainer).html(newResultCount);
                    }
                    */

                    /*Replace new content canvas filter*/
                    let canvasClass = '.viwcpf-off_canvas-content-wrap1',
                        newCanvas = $response.find(canvasClass);
                    if ((newCanvas.length > 0) && ($(canvasClass).length > 0)) {
                        $(canvasClass).replaceWith(newCanvas);
                    }

                   /* Replace new content  menu filter*/
                    let shortcodeMenuClass = '.viwcpf_wrap_shortcode_menu_filter';
                    $(shortcodeMenuClass).each(function () {
                        let t = $(this),
                            t_id = t.attr('data-menu_id'),
                            thClass = '.viwcpf_shortcode_menu_' + t_id + ':not(.viwcpf_filter_canvas)',
                            newWidgetMenu = $response.find(thClass);
                        if ((newWidgetMenu.length > 0) && ($(newWidgetMenu).length > 0)) {
                            $(thClass).replaceWith(newWidgetMenu);
                        }

                    });

                    /*Replace new content description*/
                    let viwcpfSeoDescription = '.viwcpf-page-seo-description',
                        newSeoDescription = $response.find(viwcpfSeoDescription);
                    if ((newSeoDescription.length > 0) && ($(newSeoDescription).length > 0)) {
                        $(viwcpfSeoDescription).replaceWith(newSeoDescription);
                    }

                    window.history.pushState(response, responseTitle, link);

                }
            },

            error: function (response) {
                _viwcpf_effect_loading('hide');
            }
        });

        /* window.addEventListener( 'popstate', function ( e ) {
             window.location.reload( true );
         } );*/
    }

    /*Compatibility*/
    function _viwcpf_compatibility() {

        let viwcpf_compatibility_error = {};
        /*trigger events*/
        $(document).trigger('ready');

        /* Compatibility with YITH Wishlist Pro*/
        setTimeout(function () {
            $(document).trigger('yith_infs_added_elem');
        }, 1000);

        $('.woocommerce-ordering').on('change', 'select.orderby', function () {
            $(this).closest('form').submit();
        });

        _submit_filter_with_btn();
        _viwcpf_tooltip($('.viwcpf_filter-items'));
        _displayToggle($('.viwcpf_filter-title.collapsable'));
        _viwcpf_init();


        /*UNCODE theme*/
        try {
            if ((typeof (UNCODE) == 'object' && typeof (UNCODE.init) == 'function')) {
                UNCODE.init();
            }
        } catch (e) {
            viwcpf_compatibility_error['uncode_theme_compatibility'] = e;
        }
        /*Flatsome theme*/
        try {
            if ((typeof (Flatsome) == 'object' && typeof (Flatsome.attach) == 'function' && jQuery('.products').length)) {
                Flatsome.attach(jQuery('.products'));
            }
        } catch (e) {

            viwcpf_compatibility_error['flatsome_theme_compatibility'] = e;
        }
        /*Woodmart theme*/
        try {
            if (typeof (woodmartThemeModule) == 'object') {

                if (typeof (woodmartThemeModule.wooInit) == 'function') {
                    woodmartThemeModule.wooInit();
                }
                if (typeof (woodmartThemeModule.lazyLoading) == 'function') {
                    woodmartThemeModule.lazyLoading();
                }
                woodmartThemeModule.productsLoadMore();
                woodmartThemeModule.productHover();
            }
        } catch (e) {

            viwcpf_compatibility_error['woodmart_theme_compatibility'] = e;
        }
        /*Divi theme*/
        try {
            if (typeof (et_reinit_waypoint_modules) == 'function') {
                et_reinit_waypoint_modules();
            }
        } catch (e) {
            viwcpf_compatibility_error['divi_theme_compatibility'] = e;
        }

        try {
            if (typeof (InfiniteScroll) == 'function') {
                var infScroll = InfiniteScroll.data('.shop-container .products');
                if (typeof (infScroll) == 'object' && infScroll.options) {
                    var infOptionsStore = infScroll.options;
                    infScroll.destroy();
                    jQuery('.shop-container .products').data('infiniteScroll', '').infiniteScroll(infOptionsStore);
                }
            }
        } catch (e) {

            viwcpf_compatibility_error['flatsome_infinitescroll'] = e;
        }
        try {
            if (jQuery('.shop-container .products').length && typeof (jQuery('.shop-container .products').data('packery')) == 'object') {
                jQuery('.shop-container .products').packery('reloadItems').packery('layout');
            }
        } catch (e) {
            viwcpf_compatibility_error['flatsome_packery'] = e;
        }
        /*Elementor animation*/
        try {
            if (typeof (elementorFrontend) == 'object' && typeof (elementorFrontend.init) == 'function') {
                setTimeout(function (){
                    elementorFrontend.init();
                },1000);
            }
        } catch (e) {
            viwcpf_compatibility_error['elementor_animation'] = e;
        }
        $(window).trigger('scroll');
        $(window).trigger('resize');

        console.log(viwcpf_compatibility_error)

    }
});
