<?php

namespace QuadLayers\QuadMenu_PRO;

final class Plugin {

	protected static $instance;

	private function __construct() {

		if ( ! class_exists( 'QuadLayers\\QuadMenu\\Plugin', false ) ) {
			return;
		}

		add_filter( 'admin_body_class', array( $this, 'add_body_class' ), 99 );
		add_action( 'add_meta_boxes', array( $this, 'add_menu_meta_box' ) );
		add_action( 'save_post', array( $this, 'save_menu_meta_box' ) );
		add_filter( 'quadmenu_get_nav_menu_args', array( $this, 'add_meta_box_parameters' ), 15 );

		if ( defined( 'QUADMENU_DB_OPTIONS' ) ) {
			add_action( 'redux/extensions/' . QUADMENU_DB_OPTIONS . '/before', array( $this, 'add_customizer' ), 0 );
		}

		Frontend\Load::instance();
		Backend\Load::instance();
		Integrations\WooCommerce\Load::instance();
		Integrations\Divi\Load::instance();
	}

	function add_body_class( $classes ) {

		$screen = get_current_screen();

		$classes .= ' quadmenu-pro';

		return $classes;
	}

	function add_customizer( $ReduxFramework ) {
		if ( is_admin() || is_customize_preview() ) {
			new Customizer\Load( $ReduxFramework );
		}
	}

	function save_menu_meta_box( $post_id ) {

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( current_user_can( 'manage_options' ) ) {
			if ( array_key_exists( 'quadmenu', $_POST ) ) {
				if ( $quadmenu = array_filter( $_POST['quadmenu'] ) ) {
					update_post_meta( $post_id, QUADMENU_PRO_DB_KEY, $quadmenu );
				} else {
					delete_post_meta( $post_id, QUADMENU_PRO_DB_KEY );
				}
			}
		}
	}

	function menu_meta_box( $post ) {

		$quadmenu = wp_parse_args(
			get_post_meta( $post->ID, QUADMENU_PRO_DB_KEY, true ),
			array(
				'menu'   => '',
				'layout' => '',
				'theme'  => '',
			)
		);

		$widget = new \QuadLayers\QuadMenu\Widget();
		?>
		<p>
			<label for="quadmenu_menu"><?php esc_html_e( 'Menu', 'quadmenu-pro' ); ?></label>
			<select id="quadmenu_menu" name="quadmenu[menu]" class="widefat">
				<option value=""><?php esc_html_e( 'Default', 'quadmenu-pro' ); ?></option>
				<?php echo $widget->menus( $quadmenu['menu'] ); ?>
			</select>
		</p>
		<p>
			<label for="quadmenu_theme"><?php esc_html_e( 'Theme', 'quadmenu-pro' ); ?></label>
			<select id="quadmenu_theme" name="quadmenu[theme]" class="widefat">
				<option value=""><?php esc_html_e( 'Default', 'quadmenu-pro' ); ?></option>
				<?php echo $widget->themes( $quadmenu['theme'] ); ?>
			</select>
		</p>
		<p>
			<label for="quadmenu_layout"><?php esc_html_e( 'Layout', 'quadmenu-pro' ); ?></label>
			<select id="quadmenu_layout" name="quadmenu[layout]" class="widefat">
				<option value=""><?php esc_html_e( 'Default', 'quadmenu-pro' ); ?></option>
				<?php echo $widget->layouts( $quadmenu['layout'] ); ?>
			</select>
		</p>
		<?php
		wp_nonce_field( QUADMENU_DOMAIN, 'nonce' );
	}

	function add_menu_meta_box() {
		if ( current_user_can( 'manage_options' ) ) {
			add_meta_box( QUADMENU_DOMAIN, esc_html( QUADMENU_PRO_PLUGIN_NAME ), array( $this, 'menu_meta_box' ), '', 'side', 'high' );
		}
	}

	function add_meta_box_parameters( $args ) {

		if ( ! empty( $args['theme_location'] ) ) {

			if ( function_exists( 'is_shop' ) && is_shop() ) {
				if ( $quadmenu = get_post_meta( wc_get_page_id( 'shop' ), QUADMENU_PRO_DB_KEY, true ) ) {
					$args = wp_parse_args( $quadmenu, $args );
				}
			} elseif ( ! is_archive() ) {
				if ( $quadmenu = get_post_meta( get_queried_object_id(), QUADMENU_PRO_DB_KEY, true ) ) {
					$args = wp_parse_args( $quadmenu, $args );
				}
			}
		}

		return $args;
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}

add_action(
	'plugins_loaded',
	function () {
	Plugin::instance();
	}
);
