<?php

namespace QuadLayers\QuadMenu_PRO\Frontend;

use QuadLayers\QuadMenu\Plugin;

class Load {

	protected static $instance;

	private function __construct() {

		add_action( 'wp_ajax_quadmenu_register_user', array( $this, 'register_user' ) );
		add_action( 'wp_ajax_nopriv_quadmenu_register_user', array( $this, 'register_user' ) );
		add_action( 'wp_ajax_quadmenu_login_user', array( $this, 'login_user' ) );
		add_action( 'wp_ajax_nopriv_quadmenu_login_user', array( $this, 'login_user' ) );
		add_filter( 'quadmenu_item_object_class', array( $this, 'item_object_class' ), 10, 4 );
	}

	public function item_object_class( $class, $item, $id, $auto_child = '' ) {

		if ( ! isset( $item->quadmenu ) ) {
			return $class;
		}

		switch ( $item->quadmenu ) {

			case 'post_type_archive';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Archive';
				break;

			case 'taxonomy';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Taxonomy';
				break;

			case 'carousel';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Carousel';
				break;

			case 'panel';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Carousel_Panel';
				break;

			case 'tabs';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Tabs';
				break;

			case 'tab';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Tab';
				break;

			case 'login';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Login';
				break;

			case 'social':
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Social';
				break;

			case 'button';
				$class = '\\QuadLayers\\QuadMenu_PRO\\Frontend\\Walker\\QuadMenu_Item_Button';
				break;
		}

		return $class;
	}

	public function login_user() {

		add_filter( 'nonce_life', array( __CLASS__, 'nonce_life' ) );

		if ( /* (!defined('WP_CACHE') || !WP_CACHE) &&  */ ! check_ajax_referer( 'quadmenu_login_user', 'nonce', false ) ) {
			Plugin::send_json_error( esc_html__( 'Please reload the page.', 'quadmenu-pro' ) );
		}

		$user = $pass = '';

		extract( $_POST );

		if ( empty( $user ) ) {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', esc_html__( 'Please provide an username.', 'quadmenu-pro' ) ) );
		}

		if ( empty( $pass ) ) {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', esc_html__( 'Please provide a password.', 'quadmenu-pro' ) ) );
		}

		$user_id = wp_signon(
			array(
				'user_login'    => sanitize_user( $user ),
				'user_password' => $pass,
			)
		);

		if ( ! is_wp_error( $user_id ) ) {
			Plugin::send_json_success( sprintf( '<div class="quadmenu-alert alert-success">%s</div>', esc_html__( 'Login successful, redirecting...', 'quadmenu-pro' ) ) );
		} else {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', $user_id->get_error_message() ) );
		}

		remove_filter( 'nonce_life', array( __CLASS__, 'nonce_life' ) );

		wp_die();
	}

	public function register_user( $output ) {

		add_filter( 'nonce_life', array( __CLASS__, 'nonce_life' ) );

		if ( /* (!defined('WP_CACHE') || !WP_CACHE) && */ ! check_ajax_referer( 'quadmenu_register_user', 'nonce', false ) ) {
			Plugin::send_json_error( esc_html__( 'Please reload the page.', 'quadmenu-pro' ) );
		}

		if ( ! get_option( 'users_can_register' ) ) {
			Plugin::send_json_error( esc_html__( 'Please allow user registration in your dashboard settings.', 'quadmenu-pro' ) );
		}

		extract( $_POST );

		if ( empty( $user ) ) {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', esc_html__( 'Please provide an username.', 'quadmenu-pro' ) ) );
		}

		if ( empty( $mail ) || ! is_email( $mail ) ) {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', esc_html__( 'Please provide a valid email address.', 'quadmenu-pro' ) ) );
		}

		if ( empty( $pass ) ) {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', esc_html__( 'Please provide a password.', 'quadmenu-pro' ) ) );
		}

		$userdata = array(
			'user_login' => $user,
			'user_email' => $mail,
			'user_pass'  => $pass,
		);

		$user_id = wp_insert_user( $userdata );

		if ( ! is_wp_error( $user_id ) ) {

			$user = get_user_by( 'id', $user_id );

			if ( $user ) {
				wp_set_current_user( $user_id, $user->user_login );
				wp_set_auth_cookie( $user_id );
				do_action( 'wp_login', $user->user_login, $user );
			}

			Plugin::send_json_success( sprintf( '<div class="quadmenu-alert alert-success">%s</div>', esc_html__( 'Welcome! Your user have been created.', 'quadmenu-pro' ) ) );
		} else {
			Plugin::send_json_error( sprintf( '<div class="quadmenu-alert alert-danger">%s</div>', $user_id->get_error_message() ) );
		}

		remove_filter( 'nonce_life', array( __CLASS__, 'nonce_life' ) );

		wp_die();
	}

	public static function nonce_life( $DAY_IN_SECONDS ) {
		return $DAY_IN_SECONDS * 4;
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
