<?php

namespace QuadLayers\QuadMenu_PRO\Integrations\WooCommerce;

class Load {

	protected static $instance;

	private function __construct() {
		add_filter( 'quadmenu_item_object_class', array( $this, 'item_object_class' ), 10, 4 );
		add_filter( 'quadmenu_custom_nav_menu_items', array( $this, 'nav_menu_items' ) );
		add_filter( 'quadmenu_nav_menu_item_fields', array( $this, 'nav_menu_item_fields' ), 20, 2 );
	}

	public function nav_menu_items( $items ) {

		$items['product'] = array(
			'label'  => esc_html__( 'Product', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Product', 'quadmenu-pro' ),
			'panels' => array(
				'general' => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'hidden', 'dropdown' ),
				),
				'icon'    => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'product' => array(
					'title'    => esc_html__( 'Product', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-cart',
					'settings' => array( 'thumb', 'price', 'rating', 'excerpt', 'add_to_cart', 'variation_id' ),
				),
			),
			'parent' => array( 'main', 'column', 'custom', 'post_type', 'post_type_archive', 'taxonomy' ),
		);

		$items['product_cat'] = array(
			'label'  => esc_html__( 'Product Category', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Product Category', 'quadmenu-pro' ),
			'panels' => array(
				'general'          => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'hidden', 'dropdown' ),
				),
				'icon'             => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'query'            => array(
					'title'    => esc_html__( 'Query', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-update',
					'settings' => array( 'limit', 'orderby', 'order' ),
				),
				'archive_carousel' => array(
					'title'    => esc_html__( 'Carousel', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-image-flip-horizontal',
					'settings' => array( 'items', 'speed', 'autoplay', 'autoplay_speed', 'dots', 'pagination', 'navigation' ),
				),
				'content'          => array(
					'title'    => esc_html__( 'Products', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-cart',
					'settings' => array( 'thumb', 'price', 'rating', 'excerpt', 'add_to_cart' ),
				),
			),
			'parent' => array( 'main', 'column', 'custom', 'post_type', 'post_type_archive', 'taxonomy' ),
		);

		$items['product_archive'] = array(
			'label'  => esc_html__( 'Products', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Products', 'quadmenu-pro' ),
			'panels' => array(
				'general'          => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'hidden', 'dropdown' ),
				),
				'icon'             => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'query'            => array(
					'title'    => esc_html__( 'Query', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-update',
					'settings' => array( 'limit', 'orderby', 'order' ),
				),
				'archive_carousel' => array(
					'title'    => esc_html__( 'Carousel', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-image-flip-horizontal',
					'settings' => array( 'items', 'speed', 'autoplay', 'autoplay_speed', 'dots', 'pagination', 'navigation' ),
				),
				'content'          => array(
					'title'    => esc_html__( 'Products', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-cart',
					'settings' => array( 'thumb', 'price', 'rating', 'excerpt', 'add_to_cart' ),
				),
			),
			'parent' => array( 'main', 'column', 'custom', 'post_type', 'post_type_archive', 'taxonomy' ),
		);

		return $items;
	}

	public function nav_menu_item_fields( $settings, $menu_obj ) {

		$settings['category'] = array(
			'id'          => 'quadmenu-settings[category]',
			'db'          => 'category',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Category', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Show category', 'quadmenu-pro' ),
			'default'     => 'off',
		);

		$settings['rating'] = array(
			'id'          => 'quadmenu-settings[rating]',
			'db'          => 'rating',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Rating', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Show product rating', 'quadmenu-pro' ),
			'default'     => 'on',
		);

		$settings['price'] = array(
			'id'          => 'quadmenu-settings[price]',
			'db'          => 'price',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Price', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Show product price', 'quadmenu-pro' ),
			'default'     => 'on',
		);

		$variations = isset( $menu_obj->object_id ) ? $this->get_product_variations( $menu_obj->object_id ) : false;

		if ( $variations ) {
			$settings['variation_id'] = array(
				'id'      => 'quadmenu-settings[variation_id]',
				'db'      => 'variation_id',
				'title'   => esc_html__( 'Variation', 'quadmenu-pro' ),
				'type'    => 'select',
				'default' => '',
				'depth'   => array( 1, 2, 3, 4 ),
				'ops'     => $variations,
			);
		}

		$settings['add_to_cart'] = array(
			'id'          => 'quadmenu-settings[add_to_cart]',
			'db'          => 'add_to_cart',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Add To Cart', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Show add to cart button', 'quadmenu-pro' ),
			'default'     => 'on',
		);

		if ( isset( $menu_obj->quadmenu ) && in_array( $menu_obj->quadmenu, array( 'product_archive', 'product_cat' ) ) ) {
			$settings['orderby']['ops'] = array(
				'date'                  => esc_html__( 'Date', 'quadmenu-pro' ),
				'featured_products'     => esc_html__( 'Featured products', 'quadmenu-pro' ),
				'top_rated_products'    => esc_html__( 'Top rated products', 'quadmenu-pro' ),
				'best_selling_products' => esc_html__( 'Best selling products', 'quadmenu-pro' ),
				'sale_products'         => esc_html__( 'Sale products', 'quadmenu-pro' ),
				'popularity'            => esc_html__( 'Popularity', 'quadmenu-pro' ),
			);
		}

		return $settings;
	}

	public function item_object_class( $class, $item, $id, $auto_child = '' ) {

		if ( ! isset( $item->quadmenu ) ) {
			return $class;
		}

		switch ( $item->quadmenu ) {

			case 'product';
				$class = 'QuadLayers\QuadMenu_PRO\Integrations\WooCommerce\QuadMenu_Item_Product';
			break;

			case 'product_cat':
				$class = 'QuadLayers\QuadMenu_PRO\Integrations\WooCommerce\QuadMenu_Item_Product_Category';
				break;

			case 'product_archive':
				$class = 'QuadLayers\QuadMenu_PRO\Integrations\WooCommerce\QuadMenu_Item_Product_Archive';
				break;
		}

		return $class;
	}

	private function get_product_variations( $product_id ) {
		// Check if WooCommerce is active
		if ( ! function_exists( 'wc_get_product' ) ) {
			return false;
		}

		$product = wc_get_product( $product_id );

		if ( ! $product ) {
			return false;
		}

		// Check if product is variable
		if ( ! $product->is_type( 'variable' ) ) {
			return false;
		}

		$variation_ids   = $product->get_children();
		$variation_array = array();

		foreach ( $variation_ids as $variation_id ) {
			$variation = wc_get_product( $variation_id );

			// Get variation name and include ID
			$variation_title = $variation->get_title() . ' (ID: ' . $variation_id . ')';

			// Add to array
			$variation_array[ $variation_id ] = $variation_title;
		}

		return $variation_array;
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
