/* global fp_email_template_ajax_obj, ajaxurl, fp_rac_admin_params */

jQuery( function ( $ ) {
	'use strict' ;

	var EmailTemplate = {
		init : function () {
			$( document ).on( 'change' , '#rac_load_mail' , this.load_email_template ) ;
			$( document ).on( 'click' , '#rac_send_cart_list' , this.send_email_template ) ;
			$( document ).on( 'click' , '#rac_send_template_preview' , this.send_email_template ) ;
			$( document ).on( 'click' , '.rac_mail_active' , this.toggle_email_template_status ) ;
		} ,
		load_email_template : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			var new_post_id = $( $this ).val() ;
			var old_post_id = $( '#post_ID' ).val() ;
			var url = location.href.replace( "post=" + old_post_id , "post=" + new_post_id ) ;
			window.location.href = url ;
		} ,
		send_email_template : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			var sendby = $( $this ).data( 'sendby' ) ;
			var bool = ( sendby == 'test_mail' ) ? EmailTemplate.validate_email() : true ;
			var rac_mail_row_ids = ( sendby == 'test_mail' ) ? '' : $( '#rac_cart_row_ids' ).val() ;
			if ( bool ) {
				EmailTemplate.block($('body'));
				var j = 1 ;
				var i , j , temparray , chunk = parseInt( fp_rac_admin_params.rac_chunk_count ) ;
				var chunkarray = rac_mail_row_ids.split( ',' ) ;
				for ( i = 0 , j = chunkarray.length ; i < j ; i += chunk ) {
					temparray = chunkarray.slice( i , i + chunk ) ;
					var data = $( '#post' ).serialize() ;
					var content = EmailTemplate.get_tinymce_content() ;
					if ( sendby == 'test_mail' ) {
						var email = $( '.rac_send_test_email_for_this_template' ).val() ;
						data += "&action=rac_send_template_preview_email&rac_to=" + encodeURIComponent( email ) + "&rac_content=" + encodeURIComponent( content ) + "&rac_security=" + encodeURIComponent( fp_email_template_ajax_obj.manual_send_email_template ) ;
					} else {
						data += "&action=rac_send_manual_mail&rac_email_row_ids=" + encodeURIComponent( temparray ) + "&rac_content=" + encodeURIComponent( content ) + "&rac_security=" + encodeURIComponent( fp_email_template_ajax_obj.manual_send_email_template ) ;
					}

					$.post(ajaxurl, data, function (res) {
						if (true === res.success) {
							$( '#rac_email_sent_message' ).text( res.data.message ) ;	
						} else {					
							alert(res.data.error);
						}

						EmailTemplate.unblock($('body'));
					});
				}
			}
		} , get_tinymce_content : function () {
			if ( $( '#wp-rac_email_template_timce-wrap' ).hasClass( 'tmce-active' ) ) {
				//rac_email_template_new
				return tinyMCE.get( 'rac_email_template_timce' ).getContent() ;
			} else {
				return $( "#rac_email_template_timce" ).val() ;
			}
		} ,
		validate_email : function () {
			var rac_to_email = $( '.rac_send_test_email_for_this_template' ).val() ;
			var atpos = rac_to_email.indexOf( "@" ) ;
			var dotpos = rac_to_email.lastIndexOf( "." ) ;
			if ( rac_to_email !== '' ) {
				if ( atpos < 1 || dotpos < atpos + 2 || dotpos + 2 >= rac_to_email.length ) {
					alert( fp_email_template_ajax_obj.rac_valid_email_id_msg ) ;
					return false ;
				}
			} else {
				alert( fp_email_template_ajax_obj.rac_valid_email_id_msg ) ;
				return false ;
			}
			return rac_to_email ;
		} ,
		toggle_email_template_status : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;

			EmailTemplate.block($this.closest('table'));

			var data = {
				action : 'rac_toggle_email_template_status' ,
				email_template_id : $( $this ).data( 'email_template_id' ) ,
				status : $( $this ).data( 'status' ) ,
				rac_security : fp_email_template_ajax_obj.email_template_nonce
			}

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					window.location.reload() ;						
				} else {
					EmailTemplate.unblock($this.closest('table'));
					alert(res.data.error);
				}
				
			});

		}, block: function (id) {
			if (!EmailTemplate.is_blocked(id)) {
				$(id).addClass('processing').block({
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.7
					}
				});
			}
		}, unblock: function (id) {
			$(id).removeClass('processing').unblock();
		}, is_blocked: function (id) {
			return $(id).is('.processing') || $(id).parents('.processing').length;
		}
	} ;
	EmailTemplate.init() ;
} ) ;
