/* global fp_rac_cartlist_tab_obj, ajaxurl */

jQuery( function ( $ ) {
	'use strict' ;

	if ( typeof fp_rac_cartlist_tab_obj === 'undefined' ) {
		return false ;
	}

	var CartList = {
		init : function () {
			
			$( document ).on( 'click' , '.rac_manual_recovered' , this.recover_cart_list ) ;
			$( document ).on( 'click' , '.rac-cartlist-email-toggle' , this.toggle_cartlist_email_sending_status ) ;
			$( document ).on( 'change' , '.rac_mail_status_checkboxes' , this.select_current_email_sending_status_checkbox ) ;
			
			$( document ).on( 'click' , '.rac_cartlist_email_status_info' , this.render_cartlist_details_popup ) ;
			$( document ).on( 'click' , '.rac_cartlist_manual_recover_popup_link' , this.render_cartlist_recover_popup ) ;
			$( document ).on( 'click' , '.rac_manual_order_entry_btn' , this.add_cartlist_recovered_order_id ) ;
			$( document ).on( 'click' , '.rac_popup_close' , this.manual_recover_popup_close_function ) ;
			$( document ).on( 'click' , '.rac_email_info_popup_close_btn' , this.manual_recover_popup_close_function ) ;

			$( document ).on( 'dblclick' , '.rac_edit_option' , this.update_guest_email ) ;
			$( document ).on( 'click' , '.rac_customer_email_subscribe' , this.toggle_customer_email_subscription ) ;
			
		} ,
		select_current_email_sending_status_checkbox : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			
			if ( $( $this ).is( ':checked' ) ) {
				$( $this ).nextAll( '.rac-cartlist-email-toggle' ).removeAttr( 'disabled' ) ;
			} else {
				$( $this ).nextAll( '.rac-cartlist-email-toggle' ).attr( 'disabled' , 'disabled' ) ;
			}
		} ,
		recover_cart_list : function ( event ) {
			event.preventDefault() ;
			
			var message = confirm( fp_rac_cartlist_tab_obj.recover_cart_list_confirm_msg ) ;
			if ( !message ) {
				return false;
			}
			
			var $this = $( event.currentTarget ) ;
			CartList.block($this.closest('table'));

			var data = ({
				action: 'rac_recover_cart_list',
				cart_list_id: $this.data('cart_list_id'),
				rac_security: fp_rac_cartlist_tab_obj.cartlist_nonce,
			});

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					window.location.reload() ;						
				} else {
					CartList.unblock($this.closest('table'));
					alert(res.data.error);
				}
			});
		} ,
		toggle_customer_email_subscription : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;

			CartList.block($this.closest('table'));

			var data = {
				action : 'rac_toggle_customer_email_subscription' ,
				user_id : $( $this ).data( 'user_id' ) ,
				email : $( $this ).data( 'email_id' ) ,
				unsubscribe : $( $this ).data( 'unsubscribe' ) ,
				rac_security : fp_rac_cartlist_tab_obj.rac_unsubcribe_nonce
			} ;

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					alert(res.data.message);
					window.location.reload() ;					
				} else {
					alert(res.data.error);
					CartList.unblock($this.closest('table'));
				}
			});		
		} ,
		render_cartlist_details_popup : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;

			CartList.block($this);

			var data = {
				action : 'rac_get_cartlist_popup_content' ,
				cart_list_id : $( $this ).data( 'rac_cart_list_id' ) ,
				rac_security : fp_rac_cartlist_tab_obj.cartlist_nonce ,
			} ;

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					$( res.data.content ).appendTo( 'body' ) ;
					$( document ).on( 'click' , 'body' , CartList.manual_recover_popup_outside_close_function ) ;					
				} else {
					alert(res.data.error);
				}

				CartList.unblock($this);
			});			
		} ,
		render_cartlist_recover_popup : function ( event ) {
			event.preventDefault() ;

			var $this = $( event.currentTarget ) ;

			CartList.block($this.closest('table'));

			 var data = {
				action : 'rac_get_cartlist_recover_popup_content' ,
				cart_list_id : $( $this ).data( 'rac_cart_list_id' ) ,
				rac_security : fp_rac_cartlist_tab_obj.cartlist_nonce ,
			} ;

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					$( res.data.content ).appendTo( 'body' ) ;
					$( document ).on( 'click' , 'body' , CartList.manual_recover_popup_outside_close_function ) ;					
				} else {
					alert(res.data.error);
				}

				CartList.unblock($this.closest('table'));
			});
		} ,
		manual_recover_popup_close_function : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			$( $this ).closest( 'div.fp_rac_popup_wrapper' ).remove() ;
		} ,
		manual_recover_popup_outside_close_function : function ( event ) {
			if ( $( event.target ).attr( 'class' ) == "fp_rac_popup_wrapper" ) {
				$( '.fp_rac_popup_content' ).parent().remove() ;
				$( '.fp_rac_email_info_popup_content' ).parent().remove() ;
			}
		} ,
		add_cartlist_recovered_order_id : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;

			CartList.block($this.closest('.fp_rac_popup_content'));

			var data = {
				action : 'rac_add_cartlist_recovered_order_id' ,
				cart_list_id : $( '.rac_cart_list_id' ).val() ,
				order_id : $( '.rac_manual_order_id_num' ).val() ,
				rac_security : fp_rac_cartlist_tab_obj.cartlist_nonce ,
			} ;

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					alert( res.data.content ) ;
					window.location.reload()					
				} else {
					alert(res.data.error);
				}

				CartList.unblock($this.closest('.fp_rac_popup_content'));
			});
		} ,
		toggle_cartlist_email_sending_status : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			
			CartList.block($this.closest('table'));

			var data = {
				action : 'rac_toggle_cartlist_email_sending_status' ,
				cart_list_id : $( $this ).data( 'cart_list_id' ) ,
				status : $( $this ).data( 'status' )  ,
				rac_security : fp_rac_cartlist_tab_obj.cartlist_nonce
			}

			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					$($this).data( 'status' , res.data.status ) ;
					$($this).text(res.data.button_text) ;
					$( '.rac_mail_status_checkboxes' ).attr( 'checked' , false ) ;				
				} else {					
					alert(res.data.error);
				}

				CartList.unblock($this.closest('table'));
			});

		} ,
		update_guest_email : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			$( $this ).next().remove() ;
			$( $this ).parent().removeAttr( 'class' ) ;
			var p = $( $this ).text() ;
			var value = $( '<div class="raceditemail"><textarea class="rac_content_get" name="one" style="width:200px;height:100px;">' + p + '</textarea></br><input class="rac_save" type="button" value="' + fp_rac_cartlist_tab_obj.rac_save_label + '"/></div>' ) ;
			var one = $( '.rac_content_get' ).val() ;
			var id = $( $this ).attr( 'data-id' ) ;
			$( '.rac_content_get' ).parent().html( one ) ;
			$( $this ).empty() ;
			$( $this ).append( value ) ;

			$( '.rac_save' ).click( function () {
				$( '.rac_save' ).prop( 'disabled' , true ) ;
				var email = $( '.rac_content_get' ).val() ;
				var data = {
					action : 'rac_update_guest_cartlist_email' ,
					email : email ,
					cart_list_id : id ,
					rac_security : fp_rac_cartlist_tab_obj.cartlist_nonce
				}

				$.post(ajaxurl, data, function (res) {
					$( '.rac_save' ).prop( 'disabled' , false ) ;
					if (true === res.success) {
						var p = $( $this ).text() ;
						var value = $( '<div class="raceditemail"><textarea class="rac_content_get" name="one" style="width:200px;height:100px;">' + p + '</textarea></br><input class="rac_save" type="button" value="' + fp_rac_cartlist_tab_obj.rac_save_label + '"/></div>' ) ;
						var one = $( '.rac_content_get' ).val() ;
						var id = $( $this ).attr( 'data-id' ) ;
						$( '.rac_content_get' ).parent().html( one ) ;
						$( $this ).parent().parent().parent().addClass( 'rac_tool_info' ) ;		
					} else {					
						alert(res.data.error);
					}
				});
			} ) ;
		},
		block: function (id) {
			if (!CartList.is_blocked(id)) {
				$(id).addClass('processing').block({
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.7
					}
				});
			}
		}, unblock: function (id) {
			$(id).removeClass('processing').unblock();
		}, is_blocked: function (id) {
			return $(id).is('.processing') || $(id).parents('.processing').length;
		}
	} ;
	CartList.init() ;
} ) ;
