/* global fp_rac_troubleshoot_tab_obj, ajaxurl */

jQuery( function ( $ ) {
	'use strict' ;

	if ( typeof fp_rac_troubleshoot_tab_obj === 'undefined' ) {
		return false ;
	}

	var Troubleshoot_Tab = {
		init : function () {

			this.get_troubleshoot_webmaster_option( '#rac_webmaster_mail' ) ;

			$( document ).on( 'change' , '#rac_webmaster_mail' , this.toggle_troubleshoot_webmaster_option ) ;
			$( document ).on( 'click' , '#senttestmail' , this.send_test_mail ) ;
			$( document ).on( 'click' , '#rac-update-data' , this.update_user_data_in_old_order_cart_lists ) ;

			if ( fp_rac_admin_params.rac_wc_version > parseFloat( '2.2.0' ) ) {
				this.get_troubleshoot_mail_function_option( '#rac_trouble_mail' ) ;
				$( document ).on( 'change' , '#rac_trouble_mail' , this.toggle_troubleshoot_mail_function_option ) ;
			}
		} ,
		toggle_troubleshoot_mail_function_option : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			Troubleshoot_Tab.get_troubleshoot_mail_function_option( $this ) ;
		} ,
		toggle_troubleshoot_webmaster_option : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			Troubleshoot_Tab.get_troubleshoot_webmaster_option( $this ) ;
		} ,
		get_troubleshoot_webmaster_option : function ( $this ) {
			if ( $( $this ).val() == 'webmaster1' ) {
				$( '#rac_textarea_mail' ).closest( 'tr' ).show() ;
			} else {
				$( '#rac_textarea_mail' ).closest( 'tr' ).hide() ;
			}
		} ,
		get_troubleshoot_mail_function_option : function ( $this ) {
			var troubleemail = $( $this ).val() ;
			$( '.prependedrc' ).remove() ;
			if ( troubleemail === 'mail' ) {
				$( '#rac_trouble_mail' ).parent().append( '<span class="prependedrc">' + fp_rac_troubleshoot_tab_obj.rac_email_function_msg + '</span>' ) ;
			}
		} ,
		send_test_mail : function ( event ) {
			event.preventDefault() ;
			var $this = $( event.currentTarget ) ;
			
			var data = {
				action : 'rac_send_test_mail' ,
				rac_test_mail_to : $( '#testemailto' ).val() ,
				rac_plain_or_html : $( '#rac_test_mail_format' ).val() ,
				rac_security : fp_rac_troubleshoot_tab_obj.test_email
			} ;

			Troubleshoot_Tab.block($this.closest('table'));
			
			$.post(ajaxurl, data, function (res) {
				if (true === res.success) {
					$( '#rac_email_sent_message' ).html(res.data.message) ;
				} else {					
					alert(res.data.error);
				}

				Troubleshoot_Tab.unblock($this.closest('table'));
			});
		} ,
		update_user_data_in_old_order_cart_lists : function ( event ) {
			event.preventDefault() ;
			if ( !confirm( fp_rac_troubleshoot_tab_obj.rac_alert_message ) ) {
				return false ;
			}

			$( '#rac_update_data_img' ).show() ;
			$( "#rac-update-data" ).prop( 'disabled' , true ) ;
			var data = ( {
				action : 'rac_get_old_order_cart_list_data' ,
				rac_security : fp_rac_troubleshoot_tab_obj.update_data
			} ) ;

			$.post( ajaxurl , data ,function ( res ) {
				if ( true === res.success ) {
					var j = 1 ;
					var i , j , temp_array , chunk = parseFloat( fp_rac_troubleshoot_tab_obj.rac_chunk_count ) ;
					for ( i = 0 , j = res.data.ids.length ; i < j ; i += chunk ) {
						temp_array = res.data.ids.slice( i , i + chunk ) ;
						Troubleshoot_Tab.update_user_data_old_order_cart_list( temp_array ) ;
					}

					$.when( Troubleshoot_Tab.update_user_data_old_order_cart_list( 'none' ) ).done( function ( eve ) {
						$( '#rac-update-data' ).prop( 'disabled' , false ) ;
					} ) ;

				}else{
					alert(res.data.error);
				}
			} , 'json' ) ;
		} ,
		update_user_data_old_order_cart_list : function ( ids ) {
			return $.ajax( {
				type : 'POST' ,
				url : ajaxurl ,
				data : ( {
					action : 'rac_update_user_data_old_order_cart_list' ,
					ids : ids ,
					rac_security : fp_rac_troubleshoot_tab_obj.update_data
				} ) ,
			success : function ( res ) {
				if ( true===res.success ) {
					if('none'===ids){
						$( '#rac_update_data_img' ).hide() ;
						$( '#rac-update-data-msg' ).append( fp_rac_troubleshoot_tab_obj.rac_update_success_message ) ;
						setTimeout( function () {
							location.reload()
						} , '3500' ) ;
					}
				}else{
					alert(res.data.error);
				}
			} ,
				dataType : 'json' ,
				async : false
			} ) ;
		}, block: function (id) {
			if (!Troubleshoot_Tab.is_blocked(id)) {
				$(id).addClass('processing').block({
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.7
					}
				});
			}
		}, unblock: function (id) {
			$(id).removeClass('processing').unblock();
		}, is_blocked: function (id) {
			return $(id).is('.processing') || $(id).parents('.processing').length;
		}
	} ;
	Troubleshoot_Tab.init() ;
} ) ;
