<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('FP_RAC_Segmentation')) {

	/**
	 * FP_RAC_Segmentation Class.
	 */
	class FP_RAC_Segmentation {

		/**
		 * Check if corresponding product is there in selected products.
		 */
		public static function check_selected_products_there( $product_id, $selected_products ) {

			if (is_array($selected_products)) {
				$selected_products = $selected_products;
			} else {
				$selected_products = explode(',', $selected_products);
			}

			$whole_product = fp_rac_get_product($product_id);
			if (is_object($whole_product)) {
				if ('simple' === fp_rac_get_product_obj_data($whole_product, 'product_type')) {
					if (in_array($product_id, $selected_products)) {
						return true;
					} else {
						return false;
					}
				} else if ('variation' === fp_rac_get_product_obj_data($whole_product, 'product_type')) {
					$variation_id = $product_id;
					$productid = fp_rac_get_product_obj_data($whole_product, 'id');
					if (in_array($variation_id, $selected_products)) {
						return true;
					} else if (( in_array($productid, $selected_products) )) {
						return true;
					} else {
						return false;
					}
				}
			}
		}

		/**
		 * Check if corresponding category is there in selected category.
		 */
		public static function check_selected_category_there( $product_id, $selected_category ) {
			if (is_array($selected_category)) {
				$selected_category = $selected_category;
			} else {
				$selected_category = explode(',', $selected_category);
			}

			$whole_product = fp_rac_get_product($product_id);
			if (is_object($whole_product)) {
				$terms = get_the_terms($product_id, 'product_cat');
				if (rac_check_is_array($terms)) {
					foreach ($terms as $key => $term) {
						if (is_object($term)) {
							if (in_array($term->term_id, $selected_category)) {
								return true;
							}
						}
					}
				}
				return false;
			}
		}

		/**
		 * Check if corresponding user role is there in selected user roles.
		 */
		public static function check_user_roles( $user_id, $selected_user_roles ) {
			if ('0' != $user_id) {
				$role = implode(get_userdata($user_id)->roles);
			} elseif ('0' == $user_id) {
					$role = 'rac_guest';
			}
			if (in_array($role, $selected_user_roles)) {
				return true;
			} else {
				return false;
			}
		}

		/**
		 * Get the no of orders placed by customer.
		 * 
		 * @return int
		 */
		public static function get_no_of_orders_placed( $user_id, $email_id ) {
			return ( 0 != $user_id ) ? wc_get_customer_order_count($user_id) : wc_get_guest_order_count($email_id);
		}

		/**
		 * Get the overall amount placed by customer.
		 * 
		 * @return float
		 */
		public static function get_amount_spent_by_user( $user_id, $email_id ) {
			return ( 0 != $user_id ) ? wc_get_customer_total_spent($user_id) : wc_get_guest_total_spent($email_id);
		}

		/**
		 * Check minimum and maximum value
		 */
		public static function check_status_of_min_max( $total, $minimum, $maximum ) {
			if ('*' == $minimum && '*' != $maximum) {
				if ($total <= $maximum) {
					return true;
				} else {
					return false;
				}
			} elseif ('*' != $minimum && '*' == $maximum) {
				if ($total >= $minimum) {
					return true;
				} else {
					return false;
				}
			} elseif ($total <= $maximum && $total >= $minimum) {
					return true;
			} else {
				return false;
			}
		}

		/**
		 * Check minimum and maximum date
		 */
		public static function check_status_of_from_to_date( $time, $from, $to ) {
			if ('' == $from && '' == $to) {
				return true;
			} else if ('' != $from && '' == $to) {
				if ($time > $from) {
					return true;
				} else {
					return false;
				}
			} else if ('' == $from && '' != $to) {
				if ($time < $to) {
					return true;
				} else {
					return false;
				}
			} elseif (( $time > $from ) && ( $time < $to )) {
					return true;
			} else {
				return false;
			}
		}
	}

}
