<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'FP_RAC_test_mail' ) ) {

	/**
	 * FP_RAC_Install Class.
	 */
	class FP_RAC_Test_Mail {

		public static function init() {
			add_action( 'wp_ajax_rac_send_test_mail' , array( __CLASS__, 'rac_send_test_mail' ) ) ;
		}

		/**
		 * Send the test email.
		 *
		 * @since 1.0.0
		 */
		public static function rac_send_test_mail() {
			check_ajax_referer( 'test-email' , 'rac_security' ) ;

			try {
				$email = isset($_POST['rac_test_mail_to']) ? wc_clean(wp_unslash($_POST['rac_test_mail_to'])) : '';
				if (!$email) {
					throw new exception(__('Please enter the email ID', 'recoverabandoncart'));
				}

				if (sanitize_email($email) !== $email) {
					throw new exception(__('Please enter a valid email address.', 'recoverabandoncart'));
				}

				// Return if the current user does not have permission.
				if (!current_user_can('manage_options')) {
					throw new exception(__("You don't have permission to do this action", 'recoverabandoncart'));
				}
					
				$subject       = 'Test E-Mail' ;
				$plain_or_html = isset( $_POST[ 'rac_plain_or_html' ] ) ? wc_clean( wp_unslash( $_POST[ 'rac_plain_or_html' ] ) ) : '' ;
				$plain_or_html = '1' == $plain_or_html ? 'PLAIN' : 'HTML' ;
				$message       = 'This is a test E-Mail to Make sure E-Mail are sent successfully from your site.' ;
				$message       = rac_email_woocommerce_html( $plain_or_html , $subject , $message ) ;
				$headers       = rac_format_email_headers() ;

				if ( !rac_send_mail( $email , $subject , $message , $headers , $plain_or_html ) ) {
					throw new exception(__('Email sending failed.', 'recoverabandoncart'));
				}

				wp_send_json_success(array( 'message'   => __( "Email has been Sent, but this doesn't mean mail will be delivered Successfully. Check Wordpress Codex for More info on Email", 'recoverabandoncart' ) ));
			} catch (Exception $ex) {
				wp_send_json_error(array( 'error' => $ex->getMessage() ));
			}

		
			exit() ;
		}
	}

	FP_RAC_Test_Mail::init() ;
}
