"use strict";
var RevyColor = {};

(function ($) {
    RevyColor.init = function () {
        RevyMain.initField($('.fat-semantic-container'));
        RevyColor.loadColor();
        RevyMain.registerEventProcess($('.fat-sb-color-container .toolbox-action-group'));
        RevyMain.initPopupToolTip();
    };

    RevyColor.initButtonToolTip = function () {
        $('.fat-item-bt-inline[data-title]', '.fat-semantic-container').each(function () {
            var position = $(this).attr('data-position'),
                option = {
                    title: '',
                    content: $(this).attr('data-title'),
                    inline: true
                };
            if (typeof position != 'undefined') {
                option['position'] = position;
            }
            $(this).popup(option);
        });
    };

    RevyColor.loadColor = function (page, callback) {
        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'GET',
            data: ({
                action: 'get_color',
                page: typeof page!='undefined' && page!='' ? page: 1
            }),
            success: function (data) {
                data = $.parseJSON(data);
                var total = data.total,
                    colors = data.colors;

                var template = wp.template('fat-sb-color-item-template'),
                    items = $(template(colors)),
                    elm_color = $('.fat-sb-list-color');

                $('tbody tr', elm_color).remove();
                $('.fat-tr-not-found', elm_color).remove();
                if (colors.length > 0) {
                    elm_color.append(items);
                    RevyMain.registerEventProcess($('.fat-sb-list-color'));
                    RevyColor.initButtonToolTip();
                } else {
                    RevyMain.showNotFoundMessage(elm_color,'<tr class="fat-tr-not-found"><td colspan="3">','</td></tr>');
                }

                RevyMain.initPaging(total, page, $('.fat-sb-pagination'));
                RevyMain.initCheckAll();
                if (typeof callback == 'function') {
                    callback();
                }
            },
            error: function () {
                if (typeof callback == 'function') {
                    callback();
                }
            }
        })
    };

    RevyColor.processEditColor = function(elm){
        var rc_id = typeof elm.attr('data-id') != 'undefined' ? elm.attr('data-id') : 0,
            popup_title = typeof rc_id != 'undefined' ? RevyMain.data.modal_title.edit_color : '';
        RevyColor.showPopupColor(elm, rc_id, popup_title);
    };

    RevyColor.processAddColor = function (elm){
        RevyColor.showPopupColor(elm, 0, '');
    };

    RevyColor.showPopupColor = function (elm, rc_id, popup_title, callback) {
        RevyMain.showProcess(elm);
        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'POST',
            data: ({
                action: 'get_color_by_id',
                rc_id: rc_id
            }),
            success: function (response) {
                RevyMain.closeProcess(elm);
                response = $.parseJSON(response);

                RevyMain.showPopup('fat-sb-services-color-template', popup_title, response, function () {
                    RevyMain.registerEventProcess($('.fat-sb-color-form'));
                    if(callback){
                        callback();
                    }

                });
            },
            error: function () {
            }
        });
    };

    RevyColor.processSubmitColor = function (self) {
        if (RevyMain.isFormValid) {
            var form = $('.fat-sb-color-form'),
                image_url = $('#rc_image_id img').attr('src'),
                data = {};

            if (typeof self.attr('data-id') != 'undefined' && self.attr('data-id') != '') {
                data.rc_id = self.attr('data-id');
            } else {
                data.rc_id = '';
            }

            data.rc_image_url = image_url;
            data.rc_image_id = $('#rc_image_id',form).attr('data-image-id');
            data.rc_name = $('#rc_name', form).val();

            if (typeof self.attr('data-id') != 'undefined' && self.attr('data-id') != '') {
                data.rc_id = self.attr('data-id');
                RevyMain.showProcess(self);
                RevyColor.submitColor(self, data);
            } else {
                RevyMain.showProcess(self);
                RevyColor.submitColor(self, data);
            }
        }
    };

    RevyColor.submitColor = function (self, data) {

        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'POST',
            data: ({
                action: 'save_color',
                data: data
            }),
            success: function (response) {
                RevyMain.closeProcess(self);
                self.closest('.ui.modal').suimodal('hide');
                response = $.parseJSON(response);

                if (response.result >= 0) {
                    RevyMain.showMessage(self.attr('data-success-message'));
                    $('.fat-sb-list-color .fat-sb-not-found').remove();

                    //update back to list
                    var item = $('.fat-sb-list-color .item[data-id="' + data.rc_id + '"]');

                    if (item.length == 0) {
                        data.rc_id = response.result;
                        var template = wp.template('fat-sb-color-item-template'),
                            item = $(template([data]));
                        $('.fat-sb-list-color').append(item);
                        RevyMain.registerEventProcess(item);

                    } else {
                        $('.fat-c-name', item).html(data.c_name);
                        $('.fat-c-image', item).attr('src', data.c_image_url);
                    }

                } else {
                    if (typeof response.message != 'undefined') {
                        RevyMain.showMessage(response.message, 3);
                    } else {
                        RevyMain.showMessage(RevyMain.data.error_message, 2);
                    }
                }
            },
            error: function () {
                RevyMain.closeProcess(self);
                RevyMain.showMessage(RevyMain.data.error_message, 2);
            }
        });
    };

    RevyColor.processDeleteColor = function(self){
        var btDelete = self;
        RevyMain.showConfirmPopup(RevyMain.data.confirm_delete_title, RevyMain.data.confirm_delete_message, function (result, popup) {
            if (result == 1) {
                var self = $('.fat-sb-bt-confirm.yes', popup),
                    rc_id = btDelete.attr('data-id');


                RevyMain.showProcess(self);
                $.ajax({
                    url: RevyMain.data.ajax_url,
                    type: 'POST',
                    data: ({
                        action: 'delete_color',
                        rc_id: rc_id
                    }),
                    success: function (response) {
                        try {
                            RevyMain.closeProcess(self);
                            self.closest('.ui.modal').suimodal('hide');
                            response = $.parseJSON(response);
                            if (response.result > 0) {
                                $('tr[data-id="'+ rc_id +'"]','.fat-sb-list-color').remove();
                                if ($('.fat-sb-list-color .item').length == 0) {
                                    RevyMain.showNotFoundMessage($('.fat-sb-list-color'),'<tr class="fat-tr-not-found"><td colspan="2">','</td></tr>');
                                }
                            } else {
                                if(typeof response.message!='undefined'){
                                    RevyMain.showMessage(response.message, 3);
                                }else{
                                    RevyMain.showMessage(RevyMain.data.error_message, 2);
                                }
                            }
                        } catch (err) {
                            RevyMain.closeProcess(self);
                            RevyMain.showMessage(RevyMain.data.error_message);
                        }
                    },
                    error: function () {
                        FatSbMain.closeProcess(self);
                        FatSbMain.showMessage(FatSbMain.data.error_message);
                    }
                });
            }
        });
    };

    RevyColor.openImport = function (self){
        $('.fat-semantic-container .content.color').fadeOut(function(){
            $('.fat-semantic-container .content.fat-sb-import-section').fadeIn();
        })
    };

    RevyColor.closeImport = function (self){
        $('.fat-semantic-container .content.fat-sb-import-section').fadeOut(function(){
            $('.fat-semantic-container .content.color').fadeIn();
        })
    };

    $(document).ready(function () {
        if ($('.fat-sb-color-container').length > 0) {
            RevyColor.init();
        }
    });

})(jQuery)