"use strict";
var RevyQuoteForm = {
    is_attribute_change: 0,
    weekly_timeslot: [],
    b_date: '',
    b_time: 0,
    device_name: '',
    brand_name: '',
    model_name: '',
    device_id: 0,
    brand_id: 0,
    model_id: 0,
    garage_id: 0,
    garage_title: '',
    garage_address: '',
    garage_desc: '',
    services_selected: [],
    garage_near_me: [],
    b_total_pay: 0,
    delivery_method: 3 //default mail in ; 1: FixItHome, 2:Carry In, 3: Mail in
};

(function ($) {
    RevyQuoteForm.init = function () {
        RevyQuoteForm.initField();
        RevyMain_FE.registerOnClick($('.fat-quote-form-container'));
        RevyMain_FE.registerOnChange($('.fat-quote-form-container'));
        RevyQuoteForm.initDragDropImage();
    };

    RevyQuoteForm.initField = function () {
        $('.fat-quote-form-container').each(function () {
            var container = $(this);

            //dropdown
            $('.ui.dropdown', container).each(function () {
                var self = $(this);
                self.suidropdown({
                    clearable: self.hasClass('clearable')
                });
            });
            container.addClass('has-init');

            RevyMain_FE.initNumberField(container);
        });
    };

    RevyQuoteForm.resetValidateField = function (self) {
        if (self.val() != '') {
            self.closest('.field').removeClass('field-error');
        }
    };

    RevyQuoteForm.submitQuote = function (elm) {
        var container = $(elm).closest('.fat-quote-form-container'),
            form = $('.ui.form', container),
            payment_method = $('.fat-list-gateway .gateway-item.selected', container).attr('data-value');

        $('.fat-sb-error-message').html('');
        if($('#term_condition').length > 0 && !$('#term_condition').is(':checked')){
            $('.fat-sb-error-message').html(RevyMain_FE.data.term_condition_message);
            return;
        }

        RevyMain_FE.addLoading(container, elm);

        $('.repair-summary  .fat-sb-error-message', container).html('').addClass('fat-sb-hidden');

        $('#c_postal_code, #c_address, #c_city, #c_country', form).removeAttr('required');

        if (RevyQuoteForm.delivery_method == 1 || RevyQuoteForm.delivery_method == 3) {
            $('#c_postal_code, #c_address, #c_city, #c_country', form).prop('required', true);
        }
        if (RevyMain_FE.validateForm(form)) {
            var data = {
                q_first_name : $('#c_first_name', form).val(),
                q_last_name : $('#c_last_name', form).val(),
                q_email : $('#c_email', form).val(),
                q_phone_code : $('#phone_code', form).val(),
                q_phone : $('#c_phone', form).val(),
                q_address : $('#c_address', form).val(),
                q_device_type: $('#q_device_type',form).val(),
                q_brand_name: $('#q_brand_name',form).val(),
                q_model: $('#q_model',form).val(),
                q_color: $('#q_color',form).val(),
                q_serial_number: $('#b_serial_number', form).val(),
                q_detail_problem: $('#q_detail_problem', form).val(),
                media_data : $('.media-field', form).length > 0 ? $('.media-field', form).attr('data-media-data') : '',
                media_type : $('.media-field', form).length > 0 ? $('.media-field', form).attr('data-type') : '',
                media_mime : $('.media-field', form).length > 0 ? $('.media-field', form).attr('data-mime') : ''
            };

            try {
                $.ajax({
                    url: revy_data.ajax_url,
                    type: 'POST',
                    data: ({
                        action: 'save_quote_fe',
                        s_field: revy_data.ajax_s_field,
                        data: data
                    }),
                    success: function (response) {
                        response = $.parseJSON(response);
                        RevyMain_FE.removeLoading(container, elm);
                        if (response.result > 0) {
                            RevyMain_FE.showMessage(response.message);

                            $('#c_first_name', form).val('');
                            $('#c_last_name', form).val('');
                            $('#c_email', form).val('');
                            $('#c_phone', form).val('');
                            $('#c_address', form).val('');
                            $('#q_device_type',form).val('');
                            $('#q_brand_name',form).val('');
                            $('#q_model',form).val('');
                            $('#q_color',form).val('');
                            $('#b_serial_number', form).val('');
                            $('#q_detail_problem', form).val('');
                            if( $('.media-field', form).length > 0){
                                $('.media-field', form).attr('data-media-data','').attr('data-type','').attr('data-mime','');
                            }

                            $.ajax({
                                url: revy_data.ajax_url,
                                type: 'POST',
                                data: ({
                                    action: 'send_quote_mail',
                                    s_field: revy_data.ajax_s_field,
                                    q_id: response.result,
                                })
                            });

                        } else {
                            RevyMain_FE.showMessage(response.message,3);
                        }
                    },
                    error: function (response) {
                        RevyMain_FE.removeLoading(container, elm);
                    }
                });
            } catch (err) {
            }

        }else{
            RevyMain_FE.removeLoading(container, elm);
            var top = $('.quote-form-title',container).offset().top - 100;
            $("html, body").animate({scrollTop: top}, "slow");
        }
    };

    RevyQuoteForm.chooseImage = function(elm){
        var media_field = elm.closest('.media-field');

        $('.file-upload', media_field).remove();
        media_field.append("<div class='file-upload'><input id='media_file_upload' type='file' accept='image/jpeg, image/png, image/jpg\" id=\"file_image' ></div>");
        $('input#media_file_upload', media_field).on('change', function(e){
            if( e.currentTarget.files.length > 0){
                RevyQuoteForm.bindChooseMedia(e.currentTarget.files,  media_field);
            }
        })
        $('input#media_file_upload', media_field).trigger('click');
    }

    RevyQuoteForm.initDragDropImage = function(){
        $('.media-field').on('dragover drop', function (event) {
            event.stopPropagation();
            event.preventDefault();
            if (event.type == 'drop') {
                var files = event.originalEvent.dataTransfer.files;
                RevyQuoteForm.bindChooseMedia(files,  $(this));
            }
        });
    }

    RevyQuoteForm.bindChooseMedia = function(files,  media_wrap){
        var filesize = ((files[0].size/1024)/1024).toFixed(4), // MB
            mime = files[0].type,
            type = mime.split('/')[0],
            name = files[0].name,
            max_file_size = media_wrap.attr('data-file-size');

        max_file_size = typeof max_file_size!='undefined' && !isNaN(max_file_size) ? parseInt(max_file_size) : 2;

        if(filesize > max_file_size){
            FAT_Timeline.showMessage(fat_timeline_data.file_size_message, 2);
            return;
        }

        $('.file-name', media_wrap).html('');
        media_wrap.removeClass('media-selected');

        var reader = new FileReader();
        reader.onloadend = function() {
            media_wrap.attr('data-media-data', reader.result.split(',')[1]);
            media_wrap.attr('data-mime',mime);
            media_wrap.attr('data-type',type);
            media_wrap.attr('data-name', name);
            media_wrap.append('<div class="list-images"><div class="img-item"><img src="' + reader.result +'"></div></div>');
        }
        reader.readAsDataURL(files[0]);

        media_wrap.addClass('media-selected');
        $(media_wrap).append('<a class="clear"><i class="times circle outline icon"></i></a>');

        $('a.clear',media_wrap).on('click', function(event){
            $('.list-images',media_wrap).remove();
            media_wrap.removeClass('media-selected');
            $(this).remove();
            event.preventDefault();
            $('.file-name',media_wrap).html($('.file-name',media_wrap).attr('data-label'));
            return false;
        })

    }

    $(document).ready(function () {
        RevyQuoteForm.init();
    });

})(jQuery)