<?php

if (!class_exists('Revy_DB_Table')) {
    class Revy_DB_Table
    {
        private static $instance = NULL;

        public static function instance()
        {
            if (!self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        function create_tables()
        {
            global $wpdb;
            $result = 0;
            $charset_collate = $wpdb->get_charset_collate();
            require_once ABSPATH . 'wp-admin/includes/upgrade.php';

            //devices table
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_devices(
                      rd_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      rd_order int(1) NOT NULL DEFAULT 1,
                      rd_image_id int(6) NOT NULL DEFAULT 0,
                      rd_icon varchar(50),
                      rd_name text,
                      rd_create_date datetime NOT NULL,
                      rd_active int(1) NOT NULL DEFAULT 1,
                      PRIMARY KEY  (rd_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            // brand
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_brands(
                      rb_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      rb_order int(1) NOT NULL DEFAULT 1,
                      rb_image_id int(6) NOT NULL DEFAULT 0,
                      rb_name text,
                      rb_device_ids text,
                      rb_create_date datetime NOT NULL,
                      rb_active int(1) NOT NULL DEFAULT 1,
                      PRIMARY KEY  (rb_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            // models
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_models(
                      rm_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      rm_order int(1) NOT NULL DEFAULT 1,
                      rm_image_id int(6) NOT NULL DEFAULT 0,
                      rm_name text,
                      rm_device_id int,
                      rm_brand_id int,
                      rm_cat_id int,
                      rm_colors varchar(200),
                      rm_group varchar(200),
                      rm_create_date datetime NOT NULL,
                      rm_active int(1) NOT NULL DEFAULT 1,
                      PRIMARY KEY  (rm_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_color(
                      rc_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      rc_image_id int(6) NOT NULL DEFAULT 0,
                      rc_name text,
                      PRIMARY KEY  (rc_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);


            // garages
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_garages(
                      rg_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      rg_image_id int(6) NOT NULL DEFAULT 0,
                      rg_order int(1) NOT NULL DEFAULT 1,
                      rg_name varchar(200),
                      rg_email varchar(200),
                      rg_phone varchar(200),
                      rg_address varchar(200),
                      rg_map varchar(50),
                      rg_latitude varchar(50),
                      rg_longitude varchar(50),
                      rg_description text,
                      rg_active int(1) NOT NULL DEFAULT 1,
                      rg_create_date datetime NOT NULL,
                      PRIMARY KEY  (rg_id)
                    ) $charset_collate;";
            dbDelta($tables);

            // services
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_services(
                      s_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      s_order int(1) NOT NULL DEFAULT 1,
                      s_image_id int(6) NOT NULL DEFAULT 0,
                      s_name text,
                      s_description text,
                      s_model_id int(6) NOT NULL DEFAULT 0,
                      s_cat_id int(6) NOT NULL DEFAULT 0,
                      s_tax decimal(10,2),
                      s_min_price decimal(10,2),
                      s_duration int(6),
                      s_break_time int(6),
                      s_maximum_slot int(6),     
                      s_garage_ids text,
                      s_types varchar(500),
                      s_allow_booking_online int(1) NOT NULL DEFAULT 1,
                      s_create_date datetime NOT NULL,
                      PRIMARY KEY  (s_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_category(
                      c_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      c_name varchar(500),
                      c_brand_id int NOT NULL DEFAULT 0,
                      c_device_id int NOT NULL DEFAULT 0,
                      c_image_id int(6) NOT NULL DEFAULT 0,
                      PRIMARY KEY  (c_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_services_garage(
                      s_garage_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      s_id int(6) NOT NULL DEFAULT 0,
                      rg_id int(6) NOT NULL DEFAULT 0,
                      PRIMARY KEY  (s_garage_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            // services price
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_services_price(
                      sp_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      s_id int,
                      s_attr_code varchar(100),
                      s_attr_title varchar(200),
                      s_attr_value varchar(200),
                      s_price decimal(10,2),  
                      PRIMARY KEY  (sp_id)      
                    ) $charset_collate;";
            $result = dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_services_schedule(
                      ss_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      s_id int(6) NOT NULL DEFAULT 0,
                      ss_day int(1),
                      ss_work_hour_start varchar(4),
                      ss_work_hour_end varchar(4),
                      ss_enable int(1) NOT NULL DEFAULT 1,
                      ss_create_date datetime NOT NULL,
                      PRIMARY KEY  (ss_id)
                    ) $charset_collate;";
            dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_services_day_off(
                      dof_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      s_id int(6),
                      dof_name varchar(200),
                      dof_start date,
                      dof_end date,
                      dof_create_date datetime NOT NULL,
                      PRIMARY KEY  (dof_id)
                    ) $charset_collate;";
            dbDelta($tables);

            // customer
            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_customers(
                      c_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      c_first_name varchar(200),
                      c_last_name varchar(200),
                      c_gender int(1) NOT NULL DEFAULT 0, /* 0: Male, 1: Female */ 
                      c_phone_code varchar(200),
                      c_phone varchar(200),
                      c_email varchar(200),
                      c_address varchar(500),
                      c_postal_code varchar(200),
                      c_city varchar(200),
                      c_country varchar(200),
                      c_dob date,
                      c_user_id int(6), /* ID of wordpress user */
                      c_description text,
                      c_last_booking datetime DEFAULT NULL,
                      c_create_date datetime NOT NULL,
                      c_code varchar(200),
                      PRIMARY KEY  (c_id)
                    ) $charset_collate;";
            dbDelta($tables);

            // Coupon
            $tables = " CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_coupons(
                      cp_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      cp_code varchar(200),
                      cp_description text,
                      cp_discount_type int(1),  
                      cp_amount decimal(10,2),
                      cp_start_date datetime,
                      cp_expire datetime,
                      cp_apply_to varchar(500),
                      cp_exclude varchar(500),
                      cp_times_use int(6),
                      cp_use_count int(6) NOT NULL DEFAULT 0,
                      cp_create_date datetime NOT NULL,
                      PRIMARY KEY  (cp_id)
                    ) $charset_collate;";

            // cp_discount_type: 1 -> percent, 2: fix discount
            dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_coupon_logs(
                      cp_log_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      cp_id int,
                      c_email varchar(200),
                      s_id int(6),
                      cp_log_create_date datetime NOT NULL,
                      PRIMARY KEY  (cp_log_id) 
                    ) $charset_collate;";
            dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_booking(
                      b_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      b_order_code varchar(50),
                      b_customer_id int(6),
                      b_customer_address varchar(500),
                      b_customer_city varchar(500),
                      b_customer_postal_code varchar(100),
                      b_customer_country varchar(100),
                      b_garage_id int(6),
                      b_device_id int(6),
                      b_brand_id int(6),
                      b_model_id int(6),
                      b_group_name varchar(500),
                      b_date date,
                      b_time int(6),
                      b_delivery_fee decimal(10,2),
                      b_total_amount decimal(10,2), 
                      b_coupon_id int(6),
                      b_coupon_code text,
                      b_discount decimal(10,2) NOT NULL DEFAULT 0,
                      b_total_tax decimal(10,2) NOT NULL DEFAULT 0,
                      b_total_pay decimal(10,2) NOT NULL DEFAULT 0,
                      b_gateway_type varchar(50),
                      b_gateway_status varchar(100), 
                      b_gateway_id varchar(100), 
                      b_gateway_response varchar(500), 
                      b_gateway_execute_url varchar(200), 
                      b_description text,
                      b_pay_now int(1) NOT NULL DEFAULT 0,
                      b_process_status int(1),
                      b_create_date datetime NOT NULL,
                      b_send_notify int(1) NOT NULL DEFAULT 0,
                      b_status_note text,
                      b_canceled_by_client int(1) DEFAULT 0,
                      b_delivery_method int(6),
                      b_serial_number varchar(100),
                      b_notes text,
                      PRIMARY KEY  (b_id)
                    ) $charset_collate;";
            dbDelta($tables);
            //b_process_status : 0 -> Pending, 1 -> Approved, 2 -> Cancel, 3 -> Reject, -1 -> Pending for payment gateway
            //b_gateway_status : 0 -> Pending, 1 -> Payment, 2 -> Cancel, 3 -> Reject
            //b_delivery_method : 1-> FixItHome, 2: Carry In , 3: Mail-in Repair

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_booking_detail(
                      bd_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      b_id int(6),
                      b_service_id int(6),
                      b_service_duration int(6),
                      b_service_break_time int(6),
                      b_attr_title varchar(100),
                      b_attr_value varchar(100),
                      b_model_id int(6),
                      b_model_name varchar(100),
                      b_model_color varchar(100),
                      b_quantity int(6),
                      b_price decimal(10,2),
                      b_service_tax int(6) NOT NULL DEFAULT 0,
                      b_service_tax_amount decimal(10,2) NOT NULL DEFAULT 0,
                      PRIMARY KEY  (bd_id)
                    ) $charset_collate;";
            dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_quote_form(
                      q_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      q_first_name varchar(50),
                      q_last_name varchar(50),
                      q_email varchar(100),
                      q_phone_code varchar(100),
                      q_phone varchar(100),
                      q_address varchar(500),
                      q_device_type varchar(100),
                      q_brand_name varchar(100),
                      q_model varchar(100),
                      q_color varchar(100),
                      q_serial_number varchar(100),
                      q_detail_problem varchar(500),
                      q_image_id int,
                      q_image_url varchar(200),
                      q_delivery_method int(1),
                      q_admin_notes text,
                      q_status int(1),
                      q_create_date datetime,
                      PRIMARY KEY  (q_id)
                    ) $charset_collate;";
            dbDelta($tables);
            //q_status: 0 -> Pending, 1: Approved, -1: Cancel

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_services_product(
                      sp_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      service_id int,
                      product_id int,
                      PRIMARY KEY  (sp_id) 
                    ) $charset_collate;";
            dbDelta($tables);

            $tables = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}rp_wc_order_service(
                      wc_id int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                      b_id int,
                      service_id int,
                      PRIMARY KEY  (wc_id) 
                    ) $charset_collate;";
            dbDelta($tables);

        }

        public function update_tables()
        {
            global $wpdb;
            $charset_collate = $wpdb->get_charset_collate();
            require_once ABSPATH . 'wp-admin/includes/upgrade.php';


            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking' AND column_name = 'b_serial_number'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking ADD b_serial_number varchar(100)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking' AND column_name = 'b_order_code'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking ADD b_order_code varchar(50)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking' AND column_name = 'b_notes'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking ADD b_notes text";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking' AND column_name = 'b_group_name'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking ADD b_group_name varchar(500)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking' AND column_name = 'b_custom_field'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking ADD b_custom_field text";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking' AND column_name = 'b_delivery_fee'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking ADD b_delivery_fee decimal(10,2)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking_detail' AND column_name = 'b_model_id'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking_detail ADD b_model_id int(6)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking_detail' AND column_name = 'b_model_name'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking_detail ADD b_model_name varchar(100)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_booking_detail' AND column_name = 'b_model_color'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_booking_detail ADD b_model_color varchar(100)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_coupon_logs' AND column_name = 'booking_id'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_coupon_logs ADD booking_id int(6)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_services' AND column_name = 's_types'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_services ADD s_types varchar(500)";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_services' AND column_name = 's_do_together'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_services ADD s_do_together varchar(500)";
                $wpdb->query($sql);
            }


            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_models' AND column_name = 'rm_cat_id'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_models ADD rm_cat_id int(6) NOT NULL DEFAULT 0";
                $wpdb->query($sql);
            }

            $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '{$wpdb->dbname}' AND table_name = '{$wpdb->prefix}rp_models' AND column_name = 'rm_colors'";
            $row = $wpdb->get_results($sql);
            if (empty($row)) {
                $sql = "ALTER TABLE {$wpdb->prefix}rp_models ADD rm_colors varchar(200)";
                $wpdb->query($sql);
            }

        }

        public function syn_model_group(){
            global $wpdb;
            $sql = "SELECT rm_group FROM {$wpdb->prefix}rp_models";
            $models = $wpdb->get_results($sql);
            $groups = [];
            $new_groups = [];
            foreach ($models as $md){
                if($md->rm_group!=''){
                    $groups = explode(',',$md->rm_group);
                    foreach($groups as $gr){
                        $gr = trim($gr);
                        if(!in_array($gr, $new_groups)){
                            $new_groups[] = $gr;
                        }
                    }
                }
            }

            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();
            $model_groups = isset($setting['model_groups']) && $setting['model_groups'] ? explode(',', $setting['model_groups']) : array();
            foreach($model_groups as $mg){
                $mg = trim($mg);
                if(!in_array($mg, $new_groups)){
                    $new_groups[] = $mg;
                }
            }

            $setting['model_groups'] = implode(', ',$new_groups);
            update_option('rp_settings', $setting);


        }

    }
}
