<?php
/**
 * Created by PhpStorm.
 * User: roniwp
 * Date: 6/25/2020
 * Time: 8:23 AM
 */
if (!class_exists('Revy_Shortcodes')) {
    class Revy_Shortcodes{
        private static $instance = NULL;

        public static function instance()
        {
            if (!self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        public function revy_shortcode($atts){
            $atts = $this->atts_filter($atts);
            $this->flow_enqueue_script($atts);
            ob_start();
            $template = REVY_DIR_PATH.'/templates/shortcodes/flow.php';
            if(is_readable($template)){
                include $template;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        public function revy_quote_form_shortcode($atts){
            $atts = array();
            $this->quote_enqueue_script();
            ob_start();
            $template = REVY_DIR_PATH.'/templates/shortcodes/quote_form.php';
            if(is_readable($template)){
                include $template;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        public function history_shortcode(){
            $atts = array();

            $this->history_enqueue_script();
            ob_start();
            $template = REVY_DIR_PATH.'/templates/shortcodes/history.php';
            if(is_readable($template)){
                require $template;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        private function flow_enqueue_script($atts){
            wp_dequeue_script('jquery-ui-datepicker');
            wp_deregister_script( 'jquery-ui-datepicker' );


            wp_enqueue_style('semantic', REVY_ASSET_URL . 'plugins/semantic/semantic.min.css', array(), '2.4.1');
            wp_enqueue_style('semantic-extra', REVY_ASSET_URL . 'plugins/semantic/semantic-extra.css', array(), '1.0.0');
            wp_enqueue_script('semantic', REVY_ASSET_URL . 'plugins/semantic/semantic.min.js', array('jquery'), '2.4.1', true);

            wp_enqueue_style('font-awesome', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', '4.7.0');
            wp_enqueue_style('revy', REVY_ASSET_URL . 'css/frontend/style.css', array(), '1.0.0');
            wp_enqueue_style('revy-flow', REVY_ASSET_URL . 'css/frontend/flow.css', array(), '1.0.0');

            wp_dequeue_script('moment');
            wp_deregister_script('moment');

            wp_enqueue_script('moment', REVY_ASSET_URL . 'plugins/date-ranger/moment.min.js', array('jquery'), '1.0.0', true);
            // air datepicker
            wp_enqueue_style('air-date-picker', REVY_ASSET_URL . 'plugins/air-datepicker/css/datepicker.min.css', array(), '2.2.3');
            wp_enqueue_script('air-date-picker', REVY_ASSET_URL . 'plugins/air-datepicker/js/datepicker.min.js', array('jquery', 'moment'), '2.3.3', true);
            $locale = get_locale();
            $locale = explode('_',$locale)[0];
            $locale_file = REVY_ASSET_URL . 'plugins/air-datepicker/js/i18n/datepicker.'.$locale.'.js';
            wp_enqueue_script('air-date-picker-lang', REVY_ASSET_URL . 'plugins/air-datepicker/js/i18n/datepicker.en.js', array('jquery','moment', 'air-date-picker'), '2.3.3', true);
            if($locale!='en'){
                wp_enqueue_script('air-date-picker-lang-'.$locale, $locale_file, array('jquery','moment', 'air-date-picker'), '2.3.3', true);
            }

            $now = current_time( 'mysql', 0);

            $revy_setting = Revy_DB_Setting::instance();
            $currency = $revy_setting->get_currency_setting();
            $setting =  $revy_setting->get_setting();
            $disable_current_date = isset($setting['disable_current_date']) && $setting['disable_current_date']=='1' ? 1 : 0;
            $disable_date = DateTime::createFromFormat('Y-m-d H:i:s', $now)->format('Y-m-d');
            $enable_multiple_device = isset($setting['enable_multiple_device']) ? $setting['enable_multiple_device'] : 0;

            $working_hour = $revy_setting->get_working_hour_setting();

            $day_off = isset($working_hour['day_off']) && is_array($working_hour['day_off']) ? $working_hour['day_off'] : [];
            $dof_start = '';
            $diff_day = 0;
            $wk_dof = [];
            foreach($day_off as  $dof){
                $diff_day = Revy_Utils::getDateDiffInDays( $dof['dof_start'], $dof['dof_end']);
                $wk_dof[] = $dof['dof_start'];
                $dof_start = DateTime::createFromFormat('Y-m-d', $dof['dof_start']);
                for($i=1; $i<= $diff_day; $i++){
                    $wk_dof[] = $dof_start->modify('+1 days')->format('Y-m-d');
                }

            }
            if($disable_current_date){
                $wk_dof[] = $disable_date;
            }

            $person_label = isset($setting['person_label']) && $setting['person_label'] ? $setting['person_label'] : esc_html__('person(s)','revy');
            $mapbox_api_key = isset($setting['mapbox_api_key']) ? $setting['mapbox_api_key'] : '';

            $loc_id = isset($atts['location']) ? $atts['location'] : 0;

            $db = Revy_DB_Brands::instance();
            $brands = $db->get_brands(1, 'medium');

            $db = Revy_DB_Services::instance();
            $services = $db->get_services_filter($loc_id, 'medium');
            $categories =  $db->get_category();
            $categories = isset($categories['categories']) ? $categories['categories'] : array();

            $db = Revy_DB_Models::instance();
            $models = $db->get_models_dic('full');
            $groups = $db->get_models_group_drop();
            $colors = $db->get_color();

            $db = Revy_DB_Garages::instance();
            $garages = $db->get_garages_dic();

            $revy_data = array(
                'ajax_url' => admin_url('admin-ajax.php'),
                'ajax_s_field' =>  wp_create_nonce("apoint-security-field" ),
                'error_message' => esc_html__('An error occurred during execution','revy'),
                'time_step' => isset($setting['time_step']) && $setting['time_step'] ? $setting['time_step'] : 15,
                'limit_booking_before' => isset($setting['limit_booking_before']) && $setting['limit_booking_before'] ? $setting['limit_booking_before'] : 0,
                'bt_no_label' => esc_html__('No','revy'),
                'bt_yes_label' => esc_html__('Yes','revy'),
                'loading_label' => esc_html__('Loading','revy'),
                'person_label' => $person_label,
                'change_location_label' => esc_html__('Change Location','revy'),
                'change_delivery_label' => esc_html__('Change Delivery Method','revy'),
                'coupon_validate' => esc_html__('Please select service and input coupon code','revy'),
                'empty_time_slot' => esc_html__('The appointments are fully booked. Please check again later or browse other day!','revy'),
                'empty_services' => esc_html__('Service not found.<br\/> You can select other type','revy'),
                'empty_payment_method' => esc_html__('You need to choose a payment method','revy'),
                'select_duration_message' => esc_html__('Please select duration','revy'),
                'now' => $now,
                'date_format' => get_option('date_format'),
                'time_format' => get_option('time_format'),
                'mon' => esc_html__('Mon','revy'),
                'tue' => esc_html__('Tue','revy'),
                'wed' => esc_html__('Wed','revy'),
                'thu' => esc_html__('Thu','revy'),
                'fri' => esc_html__('Fri','revy'),
                'sat' => esc_html__('Sat','revy'),
                'sun' => esc_html__('Sun','revy'),
                'durations' => Revy_Utils::getDurations(0,'duration_step'),
                'currency' => $currency['currency'],
                'number_of_decimals' => isset($setting['number_of_decimals']) && $setting['number_of_decimals']!='' ? $setting['number_of_decimals'] : 2,
                'symbol' => $currency['symbol'],
                'symbol_prefix' => $currency['symbol_position'] === 'before' ? $currency['symbol'] : '',
                'symbol_suffix' => $currency['symbol_position'] === 'after' ?  $currency['symbol'] : '',
                'symbol_position' => $currency['symbol_position'],
                'working_hour' => $working_hour,
                'day_off' => [],
                'slots' => Revy_Utils::getWorkHours(5),
                'select_date_message' => esc_html__('Please select a date to display free times','revy'),
                'model_not_found' => esc_html__('Model not found','revy'),
                'service_not_found' => esc_html__('Service not found','revy'),
                'garage_not_found' => esc_html__('Garages not found','revy'),
                'pickup_success_message' => esc_html__('Thank you! Your booking is complete. We will contact you as soon as possible.', 'revy'),
                'item_per_page' => 18,
                'map_api_key' => $mapbox_api_key,
                'distance_near_me' => isset($setting['distance_near_me']) && $setting['distance_near_me'] ? $setting['distance_near_me'] : 10,
                'distance_unit' => isset($setting['distance_unit']) && $setting['distance_unit'] ? $setting['distance_unit'] : 'kilometers',
                'disable_scroll' => isset($setting['disable_scroll_top']) ? $setting['disable_scroll_top'] : 0,
                'term_condition_message' => esc_html__('Please check accept term and conditions before submit', 'revy'),
                'enable_multiple_device' => $enable_multiple_device

            );

            $revy_flow_data = array(
                'brands' => $brands,
                'services' => $services,
                'categories' => $categories,
                'models' => $models,
                'colors' => $colors,
                'groups' => $groups,
                'garages' => $garages,
                'working_hour' => $working_hour['schedules'],
                'day_off' => $wk_dof
            );
          
            if(isset($setting['stripe_enable']) && $setting['stripe_enable']=='1'){
                wp_enqueue_script('stripe', 'https://js.stripe.com/v3/', array('jquery'), false, false);
            }

            if($mapbox_api_key){
                wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css', array(), '2.3.1');
                wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.7.0/mapbox-gl-geocoder.css', array(), '4.7.0');
                wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js', array(), '1.3.0', true);
                wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.7.0/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.7.0', true);
            }

            $ver = uniqid();

            wp_enqueue_script('revy-turf', REVY_ASSET_URL . '/plugins/turf/turf.min.js', array('jquery'), REVY_PLUGIN_VERSION, false);
            wp_enqueue_script('revy-match-media', REVY_ASSET_URL . 'plugins/match-media/match-media.js', array('jquery'), false, true);
            wp_enqueue_script('revy-main-fe', REVY_ASSET_URL . 'js/frontend/main.js', array('jquery'), false, true);
            wp_localize_script('revy-main-fe', 'revy_data', $revy_data);
            wp_enqueue_script('revy-flow-fe', REVY_ASSET_URL . 'js/frontend/flow.js', array('jquery','wp-util','revy-main-fe','revy-turf'), $ver, true);
            wp_localize_script('revy-flow-fe', 'revy_flow_data', $revy_flow_data);
            do_action('revy_frontend_enqueue');
        }

        private function quote_enqueue_script(){
            wp_dequeue_script('jquery-ui-datepicker');
            wp_deregister_script( 'jquery-ui-datepicker' );
            wp_dequeue_script('bootstrap');
            wp_deregister_script('bootstrap');


            wp_enqueue_style('semantic', REVY_ASSET_URL . 'plugins/semantic/semantic.min.css', array(), '2.4.1');
            wp_enqueue_style('semantic-extra', REVY_ASSET_URL . 'plugins/semantic/semantic-extra.css', array(), '1.0.0');
            wp_enqueue_script('semantic', REVY_ASSET_URL . 'plugins/semantic/semantic.min.js', array('jquery'), '2.4.1', true);

            wp_enqueue_style('font-awesome', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', '4.7.0');
            wp_enqueue_style('revy', REVY_ASSET_URL . 'css/frontend/style.css', array(), '1.0.0');

            wp_dequeue_script('moment');
            wp_deregister_script('moment');

            // air datepicker
            wp_enqueue_style('air-date-picker', REVY_ASSET_URL . 'plugins/air-datepicker/css/datepicker.min.css', array(), '2.2.3');
            wp_enqueue_script('moment', REVY_ASSET_URL . 'plugins/date-ranger/moment.min.js', array('jquery'), '1.0.0', true);
            wp_enqueue_script('air-date-picker', REVY_ASSET_URL . 'plugins/air-datepicker/js/datepicker.min.js', array('jquery', 'moment'), '2.3.3', true);
            $locale = get_locale();
            $locale = explode('_',$locale)[0];
            $locale_file = REVY_ASSET_URL . 'plugins/air-datepicker/js/i18n/datepicker.'.$locale.'.js';
            wp_enqueue_script('air-date-picker-lang', REVY_ASSET_URL . 'plugins/air-datepicker/js/i18n/datepicker.en.js', array('jquery', 'air-date-picker'), '2.3.3', true);
            if($locale!='en'){
                wp_enqueue_script('air-date-picker-lang-'.$locale, $locale_file, array('jquery', 'air-date-picker'), '2.3.3', true);
            }

            $revy_setting = Revy_DB_Setting::instance();
            $currency = $revy_setting->get_currency_setting();
            $setting =  $revy_setting->get_setting();
            $working_hour = $revy_setting->get_working_hour_setting();
            $now = current_time( 'mysql', 0);
            $person_label = isset($setting['person_label']) && $setting['person_label'] ? $setting['person_label'] : esc_html__('person(s)','revy');
            $mapbox_api_key = isset($setting['mapbox_api_key']) ? $setting['mapbox_api_key'] : '';


            $revy_data = array(
                'ajax_url' => admin_url('admin-ajax.php'),
                'ajax_s_field' =>  wp_create_nonce("apoint-security-field" ),
                'error_message' => esc_html__('An error occurred during execution','revy'),
                'time_step' => isset($setting['time_step']) && $setting['time_step'] ? $setting['time_step'] : 15,
                'limit_booking_before' => isset($setting['limit_booking_before']) && $setting['limit_booking_before'] ? $setting['limit_booking_before'] : 0,
                'bt_no_label' => esc_html__('No','revy'),
                'bt_yes_label' => esc_html__('Yes','revy'),
                'loading_label' => esc_html__('Loading','revy'),
                'person_label' => $person_label,
                'change_location_label' => esc_html__('Change Location','revy'),
                'change_delivery_label' => esc_html__('Change Delivery Method','revy'),
                'coupon_validate' => esc_html__('Please select service and input coupon code','revy'),
                'empty_time_slot' => esc_html__('The appointments are fully booked. Please check again later or browse other day!','revy'),
                'empty_services' => esc_html__('Service not found.<br\/> You can select other location or category','revy'),
                'empty_payment_method' => esc_html__('You need to choose a payment method','revy'),
                'select_duration_message' => esc_html__('Please select duration','revy'),
                'now' => $now,
                'date_format' => get_option('date_format'),
                'time_format' => get_option('time_format'),
                'mon' => esc_html__('Mon','revy'),
                'tue' => esc_html__('Tue','revy'),
                'wed' => esc_html__('Wed','revy'),
                'thu' => esc_html__('Thu','revy'),
                'fri' => esc_html__('Fri','revy'),
                'sat' => esc_html__('Sat','revy'),
                'sun' => esc_html__('Sun','revy'),
                'durations' => Revy_Utils::getDurations(0,'duration_step'),
                'currency' => $currency['currency'],
                'number_of_decimals' => isset($setting['number_of_decimals']) && $setting['number_of_decimals']!='' ? $setting['number_of_decimals'] : 2,
                'symbol' => $currency['symbol'],
                'symbol_prefix' => $currency['symbol_position'] === 'before' ? $currency['symbol'] : '',
                'symbol_suffix' => $currency['symbol_position'] === 'after' ?  $currency['symbol'] : '',
                'symbol_position' => $currency['symbol_position'],
                'working_hour' => $working_hour,
                'slots' => Revy_Utils::getWorkHours(5),
                'select_date_message' => esc_html__('Please select a date to display free times','revy'),
                'model_not_found' => esc_html__('Model not found','revy'),
                'service_not_found' => esc_html__('Service not found','revy'),
                'garage_not_found' => esc_html__('Garages not found','revy'),
                'pickup_success_message' => esc_html__('Thank you! Your booking is complete. We will contact you as soon as possible.', 'revy'),
                'item_per_page' => 18,
                'map_api_key' => $mapbox_api_key,
                'distance_near_me' => isset($setting['distance_near_me']) && $setting['distance_near_me'] ? $setting['distance_near_me'] : 10,
                'distance_unit' => isset($setting['distance_unit']) && $setting['distance_unit'] ? $setting['distance_unit'] : 'kilometers',
                'disable_scroll' => isset($setting['disable_scroll_top']) ? $setting['disable_scroll_top'] : 0,
                'term_condition_message' => esc_html__('Please check accept term and conditions before submit', 'revy'),
                'file_size_message' => esc_html__('The file size is too large, please choose another file < ', 'revy'). $setting['image_file_size'].'Mb',

            );

            wp_enqueue_script('revy-match-media', REVY_ASSET_URL . 'plugins/match-media/match-media.js', array('jquery'), false, true);
            wp_enqueue_script('revy-main-fe', REVY_ASSET_URL . 'js/frontend/main.js', array('jquery'), false, true);
            wp_localize_script('revy-main-fe', 'revy_data', $revy_data);
            wp_enqueue_script('revy-quote-fe', REVY_ASSET_URL . 'js/frontend/quote-form.js', array('jquery','wp-util','revy-main-fe'), REVY_PLUGIN_VERSION, true);
            do_action('revy_frontend_enqueue');
        }

        private function history_enqueue_script(){
            wp_dequeue_script('bootstrap');
            wp_deregister_script('bootstrap');

            wp_enqueue_style('semantic', REVY_ASSET_URL . 'plugins/semantic/semantic.min.css', array(), '2.4.1');
            wp_enqueue_style('semantic-extra', REVY_ASSET_URL . 'plugins/semantic/semantic-extra.css', array(), '1.0.0');
            wp_enqueue_script('semantic', REVY_ASSET_URL . 'plugins/semantic/semantic.min.js', array('jquery'), '2.4.1', false);

            wp_enqueue_style('font-awesome', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', '4.7.0');
            wp_enqueue_style('fat-sb', REVY_ASSET_URL . 'css/frontend/style.css', array(), REVY_PLUGIN_VERSION);

            $db_setting = Revy_DB_Setting::instance();
            $currency = $db_setting->get_currency_setting();
            $setting =  $db_setting->get_setting();
            $revy_data = array(
                'ajax_url' => admin_url('admin-ajax.php'),
                'ajax_s_field' =>  wp_create_nonce("fat-sb-security-field" ),
                'error_message' => esc_html__('An error occurred during execution','revy'),
                'not_found_message' => esc_html__('No records found','revy'),
                'not_edit_message' => esc_html__('You cannot cancel bookings in the past or after the booking is approved','revy'),
                'pending_label' => esc_html__('Pending','revy'),
                'approved_label' => esc_html__('Approved','revy'),
                'canceled_label' => esc_html__('Canceled','revy'),
                'rejected_label' => esc_html__('Rejected','revy'),
                'currency' => $currency['currency'],
                'symbol' => $currency['symbol'],
                'symbol_prefix' => $currency['symbol_position'] === 'before' ? $currency['symbol'] : '',
                'symbol_suffix' => $currency['symbol_position'] === 'after' ?  $currency['symbol'] : '',
                'symbol_position' => $currency['symbol_position'],
                'item_per_page' => isset($setting['item_per_page']) ? $setting['item_per_page'] : 10,
                'date_format' => get_option('date_format'),
                'apply_title' => esc_html__('Apply', 'revy'),
                'cancel_title' => esc_html__('Cancel', 'revy'),
                'from_title' => esc_html__('From', 'revy'),
                'to_title' => esc_html__('To', 'revy'),

            );

            wp_enqueue_style('revy-data-ranger-picker', REVY_ASSET_URL . 'plugins/date-ranger/daterangepicker.css', array(), '1.0.0');
            wp_enqueue_script('revy-data-ranger-picker', REVY_ASSET_URL . 'plugins/date-ranger/daterangepicker.js', array('jquery', 'moment'), '1.0.0', true);

            wp_enqueue_script('revy-main-fe', REVY_ASSET_URL . 'js/frontend/main.js', array('jquery'), false, true);
            wp_localize_script('revy-main-fe', 'revy_data', $revy_data);
            wp_enqueue_script('revy-history', REVY_ASSET_URL . 'js/frontend/history.js', array('jquery','wp-util','revy-main-fe'), false, true);

        }

        private function atts_filter($atts){
            $atts_filter = array();
            if(isset($atts['location'])){
                $atts_filter['location'] = $atts['location'];
            }
            if(isset($atts['group_filter'])){
                $atts_filter['group_filter'] = $atts['group_filter'];
            }
            if(isset($atts['service_type_filter'])){
                $atts_filter['service_type_filter'] = $atts['service_type_filter'];
            }
            if(isset($atts['layout'])){
                $atts_filter['layout'] = $atts['layout'];
            }
            if(isset($atts['hide_last_name'])){
                $atts_filter['hide_last_name'] = $atts['hide_last_name'];
            }
            if(isset($atts['hide_postal_code'])){
                $atts_filter['hide_postal_code'] = $atts['hide_postal_code'];
            }
            if(isset($atts['hide_address'])){
                $atts_filter['hide_address'] = $atts['hide_address'];
            }
            if(isset($atts['hide_city'])){
                $atts_filter['hide_city'] = $atts['hide_city'];
            }
            if(isset($atts['hide_country'])){
                $atts_filter['hide_country'] = $atts['hide_country'];
            }
            if(isset($atts['hide_serial_number'])){
                $atts_filter['hide_serial_number'] = $atts['hide_serial_number'];
            }
            if(isset($atts['hide_notes'])){
                $atts_filter['hide_notes'] = $atts['hide_notes'];
            }
            if(isset($atts['hide_garage'])){
                $atts_filter['hide_garage'] = $atts['hide_garage'];
            }
            if(isset($atts['hide_delivery_method'])){
                $atts_filter['hide_delivery_method'] = $atts['hide_delivery_method'];
            }
            if(isset($atts['hide_head'])){
                $atts_filter['hide_head'] = $atts['hide_head'];
            }
            if(isset($atts['hide_progress_bar_mobile'])){
                $atts_filter['hide_progress_bar_mobile'] = $atts['hide_progress_bar_mobile'];
            }
            if(isset($atts['show_search_box'])){
                $atts_filter['show_search_box'] = $atts['show_search_box'];
            }
            if(isset($atts['hide_progress_bar'])){
                $atts_filter['hide_progress_bar'] = $atts['hide_progress_bar'];
            }
            if(isset($atts['hide_model_category'])){
                $atts_filter['hide_model_category'] = $atts['hide_model_category'];
            }
            if(isset($atts['device'])){
                $atts_filter['device'] = $atts['device'];
            }
            if(isset($atts['brand'])){
                $atts_filter['brand'] = $atts['brand'];
            }
            if(isset($atts['model_cat'])){
                $atts_filter['model_cat'] = $atts['model_cat'];
            }
            if(isset($atts['model'])){
                $atts_filter['model'] = $atts['model'];
            }
            if(isset($atts['service_layout'])){
                $atts_filter['service_layout'] = $atts['service_layout'];
            }
            return $atts_filter;
        }
    }
}